<?php

namespace Drupal\alt_text_validation\Plugin\views\filter;

use Drupal\alt_text_validation\AtvCommonTools;
use Drupal\Core\Database\Connection;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\views\Attribute\ViewsFilter;
use Drupal\views\Plugin\views\filter\InOperator;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Filter handler for my custom field.
 *
 * @ingroup views_filter_handlers
 */
#[ViewsFilter("atv_column_field_filter")]
class AtvColumnFieldFilter extends InOperator implements ContainerFactoryPluginInterface {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected Connection $dataBase;

  /**
   * Constructs a new YourCustomFilter object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Database\Connection $connection
   *   The injected service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, Connection $connection) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->dataBase = $connection;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('database')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getValueOptions() {
    // Define your dropdown options here.
    $distinct_values = $this->getDistinctValues($this->realField);
    $this->valueOptions = (!empty($distinct_values) ? $distinct_values : []);

    return $this->valueOptions;
  }

  /**
   * Get distinct values for a given column from the audit table.
   *
   * @param string $column
   *   The column name to fetch distinct values for.
   *
   * @return array
   *   An associative array of distinct values.
   */
  protected function getDistinctValues($column): array {
    $query = $this->dataBase->select(AtvCommonTools::AUDIT_TABLE_NAME, 't')
      ->fields('t', [$column])
      ->distinct();
    $result = $query->execute()->fetchAll();
    $values = [];
    foreach ($result as $record) {
      if (!empty($record->{$column})) {
        $values[$record->{$column}] = $record->{$column};
      }
    }

    asort($values);
    return $values;
  }

}
