<?php

namespace src\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the Alt-Text Rule UI.
 */
class AltTextRuleUITest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'user',
    'field',
    'views',
    'views_data_export',
    'alt_text_validation',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * A test user with administrative privileges.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->adminUser = $this->drupalCreateUser([
      'administer alt text validation',
    ]);
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Tests adding a Alt-Text Rule through the UI.
   */
  public function testAddAltTextRule() {
    $this->drupalGet('/admin/config/content/alt-text-validation/rules/add');
    $this->assertSession()->statusCodeEquals(200);

    $edit = [
      'label' => 'Character Length Limit Test',
      'id' => 'char_length_limit_test',
      'rule_type' => 'length_limit',
      'content_char_limit' => 150,
      'violation_action' => 'warn',
      'violation_message' => 'Some message.',
    ];
    $this->submitForm($edit, 'Save');
    $this->assertSession()->pageTextContains('Saved the Character Length Limit Test Text Rule.');
  }

}
