<?php

namespace Drupal\Tests\alt_text_validation\Unit;

use Drupal\Tests\UnitTestCase;
use Drupal\alt_text_validation\Service\ValidationTools;

/**
 * Simple test to ensure that asserts pass.
 *
 * @group phpunit_example
 */
class ImageTextExtractionTest extends UnitTestCase {

  /**
   * @covers Drupal\alt_text_validation\Service\ValidationTools::extractImageTags
   */
  public function testImageExtractionFromText() {
    foreach ($this->getSampleHtml() as $case => $sample) {
      $images = ValidationTools::extractImageTags($sample['source']);
      $this->assertIsArray($images, "For case '{$case}' validator->extractImageTags() must return an array.");
      $this->assertEquals($images, $sample['result'], "For case '{$case}' validator->extractImageTags() did not return the expected values.");
    }

  }

  /**
   * Gets an array of test content and the matching image extractions.
   *
   * @return array
   *   Keyed array of source html and array of result that should come from it.
   */
  protected function getSampleHtml(): array {
    $strings = [];
    $strings['no_html']['source'] = 'I am just a string with no img tags in me or anything else.';
    $strings['no_html']['result'] = [];
    $strings['no_img']['source'] = '<p>I am a string with some <strong>basic</strong> markup.</p>';
    $strings['no_img']['result'] = [];
    $strings['empty_img']['source'] = '<p>I am a string with some <strong>basic</strong> markup and empty <img>.</p>';
    $strings['empty_img']['result'] = [
      [
        'src' => '',
        'alt' => '',
        'title' => '',
      ],
    ];
    $strings['only_img']['source'] = '<img alt="My alt text" title="My title" src="https://example.com/the-image.jpg">';
    $strings['only_img']['result'] = [
      [
        'src' => 'https://example.com/the-image.jpg',
        'alt' => 'My alt text',
        'title' => 'My title',
      ],
    ];
    $strings['one_img']['source'] = '<p> Some of our greatest hits came from this. <img alt="My alt text" title="My title" src="https://example.com/the-image.jpg"> Bozo the clown.</p>';
    $strings['one_img']['result'] = [
      [
        'src' => 'https://example.com/the-image.jpg',
        'alt' => 'My alt text',
        'title' => 'My title',
      ],
    ];
    $strings['three_img']['source'] = '<div> Image this.<img src="./this.jpg" alt=""> here we go <img alt="My alt text" title="My title" src="https://example.com/the-image.jpg"> Bozo the clown.<img src="../../that.jpg" alt=" " title=" "></div>';
    $strings['three_img']['result'] = [
      [
        'src' => './this.jpg',
        'alt' => '',
        'title' => '',
      ],
      [
        'src' => 'https://example.com/the-image.jpg',
        'alt' => 'My alt text',
        'title' => 'My title',
      ],
      [
        'src' => '../../that.jpg',
        'alt' => ' ',
        'title' => ' ',
      ],
    ];
    return $strings;
  }

}
