<?php

namespace Drupal\Tests\altcha_obfuscate\FunctionalJavascript;

use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;
use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Base class for obfuscate formatter tests.
 */
abstract class ObfuscateFormatterTestBase extends WebDriverTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'entity_test',
    'field',
    'user',
    'system',
    'telephone',
    'altcha',
    'altcha_obfuscate',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->drupalLogin($this->drupalCreateUser(['view test entity']));
  }

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test the obfuscate widget with default formatter settings.
   */
  abstract public function testDefaultSettings(): void;

  /**
   * Test the obfuscate widget with different text override settings.
   */
  abstract public function testTextOverrideSettings(): void;

  /**
   * Helper function to validate the obfuscate widget on the page.
   */
  protected function validateObfuscateWidgetOnPage(): void {
    $element = $this->xpath('//altcha-widget[@plugins="obfuscation"]');
    $this->assertNotEmpty($element, 'Obfuscation widget should be found.');
  }

  /**
   * Helper function to create a field with specific formatter settings.
   *
   * @return \Drupal\field\Entity\FieldConfig
   *   The configured field instance.
   */
  protected function createField($field_type, $formatter, $formatter_settings = []): FieldConfig {
    FieldStorageConfig::create([
      'entity_type' => 'entity_test',
      'field_name' => 'field_test',
      'type' => $field_type,
      'cardinality' => 1,
    ])->save();

    $field_config = FieldConfig::create([
      'entity_type' => 'entity_test',
      'field_name' => 'field_test',
      'bundle' => 'entity_test',
      'settings' => [],
    ]);
    $field_config->save();

    $this->container->get('entity_display.repository')
      ->getViewDisplay('entity_test', 'entity_test', 'full')
      ->setComponent('field_test', [
        'type' => $formatter,
        'settings' => $formatter_settings,
      ])
      ->save();

    return $field_config;
  }

  /**
   * Helper function to update a field with specific formatter settings.
   */
  protected function updateField($formatter, $formatter_settings = []): void {
    $this->container->get('entity_display.repository')
      ->getViewDisplay('entity_test', 'entity_test', 'full')
      ->setComponent('field_test', [
        'type' => $formatter,
        'settings' => $formatter_settings,
      ])
      ->save();
  }

}
