<?php

/**
 * @file
 * Hooks provided by the Alternative color module.
 */

use Drupal\Core\Cache\CacheableMetadata;

/**
 * Allows themes and other modules to alter supported theme colors.
 *
 * This hook allows the theme or other modules to alter the colors that are
 * passed to the page. For example, to conditionally change the site colors, or
 * to calculate derived colors. A precondition is that the theme provides
 * colors in the THEME.colors.yml file.
 * Please note that this hook does not check the validity of the color. It is up
 * to the implementer of this hook to ensure that the color is valid.
 *
 * This hook is called after the configured colors from the theme have been
 * retrieved.
 *
 * @code
 *  function HOOK_altcolor_alter_colors($theme, &$variables) {
 *    $colors['base-primary-color-light'] =
 *  }
 * @endcode
 *
 * When the goal is to create derived colors, theme designers are encouraged to
 * also consider the CSS relative color syntax, which is part of the CSS Color
 * Module Level 5 specification. This allows relative colors (with shifted hue,
 * brightness, etc.) to be defined in pure CSS.
 * https://drafts.csswg.org/css-color-5/#relative-colors
 *
 * @param string $theme
 *   The theme system name to determine the colors for.
 * @param array $colors
 *   An array of colors. The key is the color variable name, and the value is
 *   the hex code of the color.
 * @param Drupal\Core\Cache\CacheableMetadata $cacheableMetadata
 *   The cacheable metadata object.
 */
function hook_altcolor_alter_colors($theme, &$colors, CacheableMetadata &$cacheableMetadata): void {
  // Add additional colors to the array.
  if ($theme == 'olivero') {
    $colors['base-secondary-color'] = '#8f45a8';
  }
}
