<?php

namespace Drupal\altcolor\Plugin;

use Drupal\Core\Plugin\PluginBase;

/**
 * Default object used for Alternative color ThemeColors plugins.
 *
 * @see \Drupal\altcolor\\Plugin\AltColorPluginManager
 * @see plugin_api
 */
class ThemeColors extends PluginBase implements ThemeColorsInterface {

  /**
   * {@inheritdoc}
   */
  public function getColors(): array {
    return $this->pluginDefinition['colors'] ?? [];
  }

  /**
   * {@inheritdoc}
   */
  public function getSchemes(): array {
    return $this->pluginDefinition['schemes'] ?? [];
  }

}
