# amazee.io CKEditor Widgets recipe

This recipe will build a custom filter format you can use on the WYSIWYG fields that has three custom CKEditor widgets powered by the AI Automators.

1. Image Alt Text - adds image alt text in ckeditor.
2. Summary - summarizes text nicely
3. Style Guide - makes sure that the tone of what you are writing is professional.

## How to use
1. After you login, you create a Page
2. On the content choose the filter format "Content with AI"
3. In the top right corner of the ckeditor you can use the three different widgets.

## Adding to an existing project

#### Requirements
1. Either a Drupal CMS project, or the Drupal CMS Page recipe. Note that the Drupal CMS Page recipe doesn't blend very well in with the Standard installation profile.
2. An AI provider with chat capabilities and a default model configured for _Chat with complex JSON_. Try the [amazee.io AI provider](https://www.drupal.org/project/ai_provider_amazeeio) for an easy setup without the privacy trade-offs.

#### Installation
```shell
composer require drupal/amazeeio_ckeditor_widgets
drush recipe ../recipes/amazeeio_ckeditor_widgets
drush cr
```

## Quick start project with the amazee.io AI provider
```shell
composer create-project drupal/cms
composer config minimum-stability dev
composer require drupal/ai_provider_amazeeio drupal/amazeeio_ckeditor_widgets

drush site:install
drush en ai_provider_amazeeio
drush recipe ../recipes/amazeeio_ckeditor_widgets
drush cr
```

You can login to or register with the amazee.io AI provider at /admin/config/ai/providers/amazeeio.