<?php

namespace Drupal\amazing_forms\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\OpenModalDialogCommand;
use Drupal\Core\Ajax\ReplaceCommand;

/**
 * AmazingForm class.
 */
class AmazingForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'amazing_forms_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $options = NULL) {
    $form['#prefix'] = '<div id="amazing_form_example">';
    $form['#suffix'] = '</div>';

    // The status messages that will contain any form errors.
    $form['status_messages'] = [
        '#type' => 'status_messages',
        '#weight' => -10,
    ];

    $form['name'] = [
        '#type' => 'textfield',
        '#title' => t('Name'),
        '#default_value' => 'Sunil Kumar',
        '#required' => TRUE,
    ];

    $form['email'] = [
        '#type' => 'email',
        '#title' => t('Email'),
        '#attributes' => [
            'class' => ['row', 'expanded'],
            'id' => ['login-page-block'],
            'placeholder' => t('sunil.kumar@gmail.com'),
        ],
        '#required' => TRUE,
    ];
    $form['dob'] = [
        '#type' => 'date',
        '#title' => t('DOB'),
        '#required' => TRUE,
    ];

    $form['continent'] = [
        '#type' => 'select',
        '#title' => t('Continent'),
        '#options' => array(
            '0' => t('Select Continent'),
            'africa' => t('Africa'),
            'antarctica' => t('Antarctica'),
            'asia' => t('Asia'),
            'australia' => t('Australia/Oceania'),
            'europe' => t('Europe'),
            'north_america' => t('North America'),
            'south_america' => t('South America'),
        ),
    ];

    $form['gender'] = [
        '#type' => 'radios',
        '#title' => t('Gender'),
        '#options' => array(
            'Female' => t('Female'),
            'male' => t('Male'),
        ),
    ];

    $form['our_checkbox'] = [
        '#type' => 'checkbox',
        '#title' => $this->t('I Agree: to this form is useful!'),
        '#required' => TRUE,
    ];

    $form['actions'] = array('#type' => 'actions');
    $form['actions']['send'] = [
        '#type' => 'submit',
        '#value' => $this->t('Submit'),
        '#attributes' => [
            'class' => [
                'use-ajax',
            ],
        ],
        '#ajax' => [
            'callback' => [$this, 'submitModalFormAjax'],
            'event' => 'click',
        ],
    ];

    $form['#attached']['library'][] = 'core/drupal.dialog.ajax';

    return $form;
  }

  /**
   * AJAX callback handler that displays any errors or a success message.
   */
  public function submitModalFormAjax(array $form, FormStateInterface $form_state) {
    $response = new AjaxResponse();

    // If there are any form errors, re-display the form.
    if ($form_state->hasAnyErrors()) {
      $response->addCommand(new ReplaceCommand('#amazing_form_example', $form));
    } else {
      $response->addCommand(new OpenModalDialogCommand("Request sent!", 'Your request has been submitted, contact you soon...', ['width' => 800]));
    }
    return $response;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    return $data;
  }

}
