<?php

namespace Drupal\tigo_amazon\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\tigo_amazon\S3;
use Symfony\Component\HttpFoundation\Response;

/**
 * Controlador de administracion herramientas basket.
 *
 * @package tigo_amazon
 * @version 25-01-2022
 * @access private
 */
class LoadS3 extends ControllerBase {

  /**
   * Amazon load files service.
   *
   * @var \Drupal\tigo_amazon\S3
   */
  protected $amazonFile;

  /**
   * Constructor de la clase Evidences.
   */
  public function __construct(S3 $amazon) {
    $this->amazonFile = $amazon;
  }

  /**
   * {@inheritdoc}
   *
   * @codeCoverageIgnore
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('tigo_amazon.s3')
    );
  }

  /**
   * Controlador para ver el registro de evidencias.
   *
   * Para poder ingresar al formulario se require que primero pase por el
   * sistema de repudio. Se puede ver si el usuario respondio correctamente
   * las preguntas de seguridad o paso por el otp. tambien se ve cuando el
   * asesor valida las evidencias subidas por el usuario.
   *
   * @param int $id_data
   *   Id de la orden.
   *
   * @return array
   *   Retorna tabla con registro de evidencias.
   */
  public function view($s3_file) {
    $s3_url = parse_url(base64_decode($s3_file));
    $file = $this->amazonFile->loadFile(substr($s3_url['path'], 1));
    try {
      if (is_array($file) && array_key_exists('error', $file)) {
        throw new \Exception('error de lectura', 400);
      }
      $response = new Response();
      $response->headers->set('Content-Type', "{$file['ContentType']}");
      $response->setContent($file['Body']);
      return $response;
    }
    catch (\Exception $e) {

    }

    return [];
  }

}
