<?php

namespace Drupal\amazon_image_id_scan\Form;

use Drupal\Core\Form\ConfigFormBase;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines a form that configures forms module settings.
 * @codeCoverageIgnore
 */
class ConfigurationForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'amazon_image_id_scan_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'amazon_image_id_scan.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, Request $request = NULL) {

    $config = $this->config('amazon_image_id_scan.settings');

    $form['#attached'] = [
      'library' => [
        'amazon_image_id_scan/amazon_image_id_scan.main',
      ],
    ];
    $form['#tree'] = TRUE;

    $form['bootstrap'] = [
      '#type' => 'vertical_tabs',
      '#prefix' => '<h2><small>' . $this->t('Amazon rekognition') . '</small></h2>',
      '#weight' => -10,
      '#default_tab' => 'rekognition_tab',
    ];

    $config_rekognition = $config->get('rekognition_tab');
    $form['rekognition_tab'] = [
      '#type' => 'details',
      '#title' => $this->t('Configuración credenciales Rekognition'),
      '#group' => 'bootstrap',
    ];

    $form['rekognition_tab']['key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('key'),
      '#default_value' => $config_rekognition['key'] ?? FALSE,
      '#required' => 1,
    ];

    $form['rekognition_tab']['secret'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Secret'),
      '#default_value' => $config_rekognition['secret'] ?? NULL,
      '#required' => 1,
    ];
    $config_selfie = $config->get('selfie_tab');
    $form['selfie_tab'] = [
      '#type' => 'details',
      '#title' => $this->t('Configuración reconocimiento facial'),
      '#group' => 'bootstrap',
    ];

    $form['selfie_tab']['active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación de la foto'),
      '#default_value' => $config_selfie['active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el reconocimiento facial.'),
    ];

    $form['selfie_tab']['test'] = [
      '#type' => 'markup',
      '#markup' => 'Puede ver los diferentes las etiquetas, en el siguiente <a href="https://us-east-2.console.aws.amazon.com/rekognition/home?region=us-east-2#/label-detection" target="_blank">link</a>',
    ];

    $form['selfie_tab']['multiuser'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación de numero de personas en la selfie'),
      '#default_value' => $config_selfie['multiuser'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara que no halla mas de 1 persona en la selfie.'),
    ];

    $form['selfie_tab']['allowed_number'] = [
      '#type' => 'number',
      '#title' => 'Cantidad de etiquetas a validar en evidencias',
      '#default_value' => $config_selfie['allowed_number'] ?? FALSE,
      '#max' => '100',
      '#size' => 10,
      '#attributes' => [
        'class' => ['field-percent'],
      ],
    ];

    $form['selfie_tab']['title_label_positivos'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas de validación para la selfie</h3>',
    ];

    $form['selfie_tab']['container_positivos'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'container_positivos',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $default_positivos = $config_selfie['container_positivos'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['selfie_tab']['container_positivos'], $default_positivos, 'containerPositivos', 'container_positivos');

    $form['selfie_tab']['title_label_negativos'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas de que no debe tener la validación de la selfie</h3>',
    ];

    $form['selfie_tab']['container_negativos'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'container_negativos',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $default_negativos = $config_selfie['container_negativos'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['selfie_tab']['container_negativos'], $default_negativos, 'containerNegativos', 'container_negativos');

    $config_identification = $config->get('identification_tab');
    $form['identification_tab'] = [
      '#type' => 'details',
      '#title' => $this->t('Configuración documento de identidad (CC)'),
      '#group' => 'bootstrap',
    ];

    $form['identification_tab']['front_active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación documento de identidad cara frontal'),
      '#default_value' => $config_identification['front_active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el documento contra la base de datos cara frontal.'),
    ];

    $form['identification_tab']['title_cedula_frontal_positivo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab']['cedula_frontal_positivo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_positivo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_positivo = $config_identification['cedula_frontal_positivo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab']['cedula_frontal_positivo'], $cedula_frontal_positivo, 'containerPositivos', 'cedula_frontal_positivo');

    $form['identification_tab']['title_cedula_frontal_negativo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que NO debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab']['cedula_frontal_negativo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_negativo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_negativo = $config_identification['cedula_frontal_negativo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab']['cedula_frontal_negativo'], $cedula_frontal_negativo, 'containerNegativos', 'cedula_frontal_negativo');

    $form['identification_tab']['title_cedula_frontal_regular_expresion'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Expresiones regulares cédula frontal</h3>',
    ];

    $form['identification_tab']['cedula_frontal_regular_expresion'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_regular_expresion',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_regular_expresion = $config_identification['cedula_frontal_regular_expresion'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab']['cedula_frontal_regular_expresion'], $cedula_frontal_regular_expresion, 'containerRegularExpresion', 'cedula_frontal_regular_expresion');

    $form['identification_tab']['back_active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación documento de identidad cara posterior'),
      '#default_value' => $config_identification['back_active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el documento contra la base de datos cara posterior.'),
    ];

    $form['identification_tab']['regular_expresion_year'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar expresion regular para el año de expedicion de la cédula'),
      '#default_value' => $config_identification['regular_expresion_year'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara la fecha de expecion de la cédula con el siguiente formato 11-JUL-2007'),
    ];

    $form['identification_tab']['title_cedula_posterior_positivo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que debe tener la validación de la cédula posterior</h3>',
    ];

    $form['identification_tab']['cedula_posterior_positivo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_positivo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_positivo = $config_identification['cedula_posterior_positivo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab']['cedula_posterior_positivo'], $cedula_posterior_positivo, 'containerPositivos', 'cedula_posterior_positivo');

    $form['identification_tab']['title_cedula_posterior_negativo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que NO debe tener la validación de la cédula posterior</h3>',
    ];

    $form['identification_tab']['cedula_posterior_negativo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_negativo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_negativo = $config_identification['cedula_posterior_negativo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab']['cedula_posterior_negativo'], $cedula_posterior_negativo, 'containerNegativos', 'cedula_posterior_negativo');

    $form['identification_tab']['title_cedula_posterior_regular_expresion'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Expresiones regulares cédula posterior</h3>',
    ];

    $form['identification_tab']['cedula_posterior_regular_expresion'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_regular_expresion',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_regular_expresion = $config_identification['cedula_posterior_regular_expresion'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab']['cedula_posterior_regular_expresion'], $cedula_posterior_regular_expresion, 'containerRegularExpresion', 'cedula_posterior_regular_expresion');

    // Cédula de extranjeria.
    $config_identification_ce = $config->get('identification_tab_ce');
    $form['identification_tab_ce'] = [
      '#type' => 'details',
      '#title' => $this->t('Configuración documento de identidad (CE)'),
      '#group' => 'bootstrap',
    ];

    $form['identification_tab_ce']['front_active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación documento de identidad cara frontal'),
      '#default_value' => $config_identification_ce['front_active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el documento contra la base de datos cara frontal.'),
    ];

    $form['identification_tab_ce']['title_cedula_frontal_positivo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab_ce']['cedula_frontal_ce_positivo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_ce_positivo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_ce_positivo = $config_identification_ce['cedula_frontal_ce_positivo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ce']['cedula_frontal_ce_positivo'], $cedula_frontal_ce_positivo, 'containerPositivos', 'cedula_frontal_ce_positivo');

    $form['identification_tab_ce']['title_cedula_frontal_negativo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que NO debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab_ce']['cedula_frontal_ce_negativo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_ce_negativo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_ce_negativo = $config_identification_ce['cedula_frontal_ce_negativo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ce']['cedula_frontal_ce_negativo'], $cedula_frontal_ce_negativo, 'containerNegativos', 'cedula_frontal_ce_negativo');

    $form['identification_tab_ce']['title_cedula_frontal_ce_regular_expresion'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Expresiones regulares cédula frontal</h3>',
    ];

    $form['identification_tab_ce']['cedula_frontal_ce_regular_expresion'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_ce_regular_expresion',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_ce_regular_expresion = $config_identification_ce['cedula_frontal_ce_regular_expresion'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ce']['cedula_frontal_ce_regular_expresion'], $cedula_frontal_ce_regular_expresion, 'containerRegularExpresion', 'cedula_frontal_ce_regular_expresion');

    $form['identification_tab_ce']['back_active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación documento de identidad cara posterior'),
      '#default_value' => $config_identification_ce['back_active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el documento contra la base de datos cara posterior.'),
    ];

    $form['identification_tab_ce']['title_cedula_posterior_positivo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que debe tener la validación de la cédula posterior</h3>',
    ];

    $form['identification_tab_ce']['cedula_posterior_ce_positivo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_ce_positivo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_ce_positivo = $config_identification_ce['cedula_posterior_ce_positivo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ce']['cedula_posterior_ce_positivo'], $cedula_posterior_ce_positivo, 'containerPositivos', 'cedula_posterior_ce_positivo');

    $form['identification_tab_ce']['title_cedula_posterior_ce_negativo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que NO debe tener la validación de la cédula posterior</h3>',
    ];

    $form['identification_tab_ce']['cedula_posterior_ce_negativo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_ce_negativo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_ce_negativo = $config_identification_ce['cedula_posterior_ce_negativo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ce']['cedula_posterior_ce_negativo'], $cedula_posterior_ce_negativo, 'containerNegativos', 'cedula_posterior_ce_negativo');

    $form['identification_tab_ce']['title_cedula_posterior_ce_regular_expresion'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Expresiones regulares cédula posterior</h3>',
    ];

    $form['identification_tab_ce']['cedula_posterior_ce_regular_expresion'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_ce_regular_expresion',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_ce_regular_expresion = $config_identification_ce['cedula_posterior_ce_regular_expresion'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ce']['cedula_posterior_ce_regular_expresion'], $cedula_posterior_ce_regular_expresion, 'containerRegularExpresion', 'cedula_posterior_ce_regular_expresion');

    // COnfiguracion PPT.
    $config_identification_ppt = $config->get('identification_tab_ppt');
    $form['identification_tab_ppt'] = [
      '#type' => 'details',
      '#title' => $this->t('Configuración documento de identidad (PPT)'),
      '#group' => 'bootstrap',
    ];

    $form['identification_tab_ppt']['front_active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación documento de identidad cara frontal'),
      '#default_value' => $config_identification_ppt['front_active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el documento contra la base de datos cara frontal.'),
    ];

    $form['identification_tab_ppt']['title_cedula_frontal_positivo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab_ppt']['cedula_frontal_ppt_positivo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_ppt_positivo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_ppt_positivo = $config_identification_ppt['cedula_frontal_ppt_positivo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ppt']['cedula_frontal_ppt_positivo'], $cedula_frontal_ppt_positivo, 'containerPositivos', 'cedula_frontal_ppt_positivo');

    $form['identification_tab_ppt']['title_cedula_frontal_negativo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que NO debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab_ppt']['cedula_frontal_ppt_negativo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_ppt_negativo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_ppt_negativo = $config_identification_ppt['cedula_frontal_ppt_negativo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ppt']['cedula_frontal_ppt_negativo'], $cedula_frontal_ppt_negativo, 'containerNegativos', 'cedula_frontal_ppt_negativo');

    $form['identification_tab_ppt']['title_cedula_frontal_ppt_regular_expresion'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Expresiones regulares cédula frontal</h3>',
    ];

    $form['identification_tab_ppt']['cedula_frontal_ppt_regular_expresion'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_ppt_regular_expresion',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_ppt_regular_expresion = $config_identification_ppt['cedula_frontal_ppt_regular_expresion'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ppt']['cedula_frontal_ppt_regular_expresion'], $cedula_frontal_ppt_regular_expresion, 'containerRegularExpresion', 'cedula_frontal_ppt_regular_expresion');

    $form['identification_tab_ppt']['back_active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación documento de identidad cara posterior'),
      '#default_value' => $config_identification_ppt['back_active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el documento contra la base de datos cara posterior.'),
    ];

    $form['identification_tab_ppt']['title_cedula_posterior_positivo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que debe tener la validación de la cédula posterior</h3>',
    ];

    $form['identification_tab_ppt']['cedula_posterior_ppt_positivo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_ppt_positivo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_ppt_positivo = $config_identification_ppt['cedula_posterior_ppt_positivo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ppt']['cedula_posterior_ppt_positivo'], $cedula_posterior_ppt_positivo, 'containerPositivos', 'cedula_posterior_ppt_positivo');

    $form['identification_tab_ppt']['title_cedula_posterior_ppt_negativo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que NO debe tener la validación de la cédula posterior</h3>',
    ];

    $form['identification_tab_ppt']['cedula_posterior_ppt_negativo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_ppt_negativo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_ppt_negativo = $config_identification_ppt['cedula_posterior_ppt_negativo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ppt']['cedula_posterior_ppt_negativo'], $cedula_posterior_ppt_negativo, 'containerNegativos', 'cedula_posterior_ppt_negativo');

    $form['identification_tab_ppt']['title_cedula_posterior_ppt_regular_expresion'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Expresiones regulares cédula posterior</h3>',
    ];

    $form['identification_tab_ppt']['cedula_posterior_ppt_regular_expresion'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_posterior_ppt_regular_expresion',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_posterior_ppt_regular_expresion = $config_identification_ppt['cedula_posterior_ppt_regular_expresion'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_ppt']['cedula_posterior_ppt_regular_expresion'], $cedula_posterior_ppt_regular_expresion, 'containerRegularExpresion', 'cedula_posterior_ppt_regular_expresion');

    // COnfiguracion PA.
    $config_identification_pa = $config->get('identification_tab_pa');
    $form['identification_tab_pa'] = [
      '#type' => 'details',
      '#title' => $this->t('Configuración documento de identidad (PA)'),
      '#group' => 'bootstrap',
    ];

    $form['identification_tab_pa']['front_active'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activar validación documento de identidad cara frontal'),
      '#default_value' => $config_identification_pa['front_active'] ?? FALSE,
      '#description' => $this->t('Al activar esta opción se validara el documento contra la base de datos cara frontal.'),
    ];

    $form['identification_tab_pa']['title_cedula_frontal_positivo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab_pa']['cedula_frontal_pa_positivo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_pa_positivo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_pa_positivo = $config_identification_pa['cedula_frontal_pa_positivo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_pa']['cedula_frontal_pa_positivo'], $cedula_frontal_pa_positivo, 'containerPositivos', 'cedula_frontal_pa_positivo');

    $form['identification_tab_pa']['title_cedula_frontal_negativo'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Etiquetas que NO debe tener la validación de la cédula frontal</h3>',
    ];

    $form['identification_tab_pa']['cedula_frontal_pa_negativo'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_pa_negativo',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_pa_negativo = $config_identification_pa['cedula_frontal_pa_negativo'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_pa']['cedula_frontal_pa_negativo'], $cedula_frontal_pa_negativo, 'containerNegativos', 'cedula_frontal_pa_negativo');

    $form['identification_tab_pa']['title_cedula_frontal_pa_regular_expresion'] = [
      '#type' => 'markup',
      '#markup' => '<h3>Expresiones regulares cédula frontal</h3>',
    ];

    $form['identification_tab_pa']['cedula_frontal_pa_regular_expresion'] = [
      '#type' => 'container',
      '#attributes' => [
        'id' => 'cedula_frontal_pa_regular_expresion',
        'class' => 'tag-validate-evidence',
      ],
    ];

    $cedula_frontal_pa_regular_expresion = $config_identification_pa['cedula_frontal_pa_regular_expresion'] ?? FALSE;

    $this->multipleField($form, $form_state, $form['identification_tab_pa']['cedula_frontal_pa_regular_expresion'], $cedula_frontal_pa_regular_expresion, 'containerRegularExpresion', 'cedula_frontal_pa_regular_expresion');

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $this->config('amazon_image_id_scan.settings')
      ->set('rekognition_tab', $form_state->getValue('rekognition_tab'))
      ->set('selfie_tab', $form_state->getValue('selfie_tab'))
      ->set('identification_tab', $form_state->getValue('identification_tab'))
      ->set('identification_tab_ce', $form_state->getValue('identification_tab_ce'))
      ->set('identification_tab_ppt', $form_state->getValue('identification_tab_ppt'))
      ->set('identification_tab_pa', $form_state->getValue('identification_tab_pa'))
      ->save();
  }

  /**
   * {@inheritdoc}
   */
  public function multipleField(array &$form, &$form_state, &$form_content, $default_value, $function, $name) {
    $delete_item = $form_state->get('delete_item_' . $name);
    $max = 0;
    if ($default_value) {
      $details = $default_value;
      $max = count($details) - 1;
      if ($delete_item && is_array($delete_item)) {
        foreach ($delete_item as $delete) {
          unset($details[$delete]);
        }
      }
      foreach ($details as $key => $value) {
        $this->$function($form, $form_content, $key, $name, $value);
      }
    }
    $add = $form_state->get('add_' . $name);
    if ($add) {
      for ($i = 1; $i <= $add; $i++) {
        $count = $max + $i;
        if (!$delete_item || !in_array($count, $delete_item)) {
          $this->$function($form, $form_content, $count, $name);
        }
      }
    }
    if (isset($form_content['add'])) {
      unset($form_content['add']);
    }
    $form_content['add'] = [
      '#type' => 'submit',
      '#value' => "Agregar item",
      '#submit' => ['::submitAddDetails'],
      '#ajax' => [
        'callback' => '::wrapperDetails',
        'wrapper' => $name,
      ],
      '#name' => $name,
      '#attributes' => [
        'class' => ['btn-add-item'],
      ],
    ];
  }

  /**
   * Contedor de etiquetas positivas.
   */
  public function containerPositivos(array &$form, &$form_content, $key, $function, $value = FALSE) {
    $form_content[$key]['label'] = [
      '#type' => 'textfield',
      '#title' => 'Etiqueta',
      '#default_value' => $value['label'] ?? NULL,
      '#size' => 15,
      '#maxlength' => 40,
    ];

    $form_content[$key]['percentage'] = [
      '#type' => 'number',
      '#title' => 'Porcentaje',
      '#default_value' => $value['percentage'] ?? NULL,
      '#max' => '100',
      '#size' => 10,
      '#attributes' => [
        'class' => ['field-percent'],
      ],
    ];
    $form_content[$key]['error_description'] = [
      '#type' => 'textfield',
      '#title' => 'Descripción del error',
      '#default_value' => $value['error_description'] ?? NULL,
      '#size' => 45,
      '#maxlength' => 250,
    ];
    $form_content[$key]['delete'] = [
      '#type' => 'submit',
      '#value' => "Eliminar item",
      '#submit' => ['::submitDeleteItem'],
      '#name' => $key . '-' . $function,
      '#ajax' => [
        'callback' => '::wrapperDetails',
        'wrapper' => $function,
      ],
      '#attributes' => [
        'class' => ['button-delete-item'],
      ],
    ];
    $form_content[$key]['separate'] = [
      '#type' => 'container',
      '#attributes' => [
        'class' => ['separador'],
      ],
    ];
  }

  /**
   * Label negativos.
   */
  public function containerNegativos(array &$form, &$form_content, $key, $function, $value = FALSE) {
    $form_content[$key]['label'] = [
      '#type' => 'textfield',
      '#title' => 'Etiqueta',
      '#default_value' => $value['label'] ?? NULL,
      '#size' => 15,
      '#maxlength' => 40,
    ];
    $form_content[$key]['error_description'] = [
      '#type' => 'textfield',
      '#title' => 'Descripción del error',
      '#default_value' => $value['error_description'] ?? NULL,
      '#size' => 45,
      '#maxlength' => 250,
      '#attributes' => [
        'class' => ['field-description-item'],
      ],
    ];
    $form_content[$key]['delete'] = [
      '#type' => 'submit',
      '#value' => "Eliminar item",
      '#submit' => ['::submitDeleteItem'],
      '#name' => $key . '-' . $function,
      '#ajax' => [
        'callback' => '::wrapperDetails',
        'wrapper' => $function,
      ],
      '#attributes' => [
        'class' => ['button-delete-item'],
      ],
    ];
    $form_content[$key]['separate'] = [
      '#type' => 'container',
      '#attributes' => [
        'class' => ['separador'],
      ],
    ];
  }

  /**
   * Contedor para expresiones regulares.
   */
  public function containerRegularExpresion(array &$form, &$form_content, $key, $function, $value = FALSE) {
    $form_content[$key]['label'] = [
      '#type' => 'textfield',
      '#title' => 'Expresion regular',
      '#default_value' => $value['label'] ?? FALSE,
      '#size' => 50,
      '#maxlength' => 250,
    ];

    $form_content[$key]['error_description'] = [
      '#type' => 'textfield',
      '#title' => 'Descripción del error',
      '#default_value' => $value['error_description'] ?? NULL,
      '#size' => 45,
      '#maxlength' => 250,
    ];
    $form_content[$key]['delete'] = [
      '#type' => 'submit',
      '#value' => "Eliminar item",
      '#submit' => ['::submitDeleteItem'],
      '#name' => $key . '-' . $function,
      '#ajax' => [
        'callback' => '::wrapperDetails',
        'wrapper' => $function,
      ],
      '#attributes' => [
        'class' => ['button-delete-item'],
      ],
    ];
    $form_content[$key]['separate'] = [
      '#type' => 'container',
      '#attributes' => [
        'class' => ['separador'],
      ],
    ];
  }

  /**
   * Eliminar item.
   */
  public function submitDeleteItem(array &$form, FormStateInterface $form_state) {
    $name = $form_state->getTriggeringElement()['#name'];
    $explode = explode('-', $name);
    $tid = $explode[0];
    $var = 'delete_item_' . $explode[1];
    $add = $form_state->get($var);
    if ($add) {
      $add[] = $tid;
      $form_state->set($var, $add);
    }
    else {
      $add[] = $tid;
      $form_state->set($var, $add);
    }
    $form_state->setRebuild();
  }

  /**
   * Wrapper dinamico.
   */
  public function wrapperDetails(array &$form, FormStateInterface $form_state) {
    $parents = $form_state->getTriggeringElement()['#parents'];
    return $form[$parents[0]][$parents[1]];
  }

  /**
   * Contados de numero de items.
   */
  public function submitAddDetails(array &$form, FormStateInterface $form_state) {
    $name = $form_state->getTriggeringElement()['#name'];
    $var = 'add_' . $name;
    $add = $form_state->get($var);
    if ($add) {
      $add += 1;
      $form_state->set($var, $add);
    }
    else {
      $form_state->set($var, 1);
    }
    $form_state->setRebuild();
  }

}
