<?php

namespace Drupal\amazon_onsite;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the aop feed item entity type.
 */
class AopFeedItemAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {

    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view aop feed item');

      case 'update':
        return AccessResult::allowedIfHasPermissions($account, ['edit aop feed item', 'administer aop feed item'], 'OR');

      case 'delete':
        return AccessResult::allowedIfHasPermissions($account, ['delete aop feed item', 'administer aop feed item'], 'OR');

      default:
        // No opinion.
        return AccessResult::neutral();
    }

  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermissions($account, ['create aop feed item', 'administer aop feed item'], 'OR');
  }

}
