/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md.
 */

import {
  View,
  LabeledFieldView,
  createLabeledInputText,
  ButtonView,
  submitHandler,
} from "ckeditor5/src/ui";
import { icons } from "ckeditor5/src/core";

export default class FormView extends View {
  constructor(locale) {
    super(locale);

    this.productId = this._createInput("Amazon Product ID");

    this.saveButtonView = this._createButton(
      "Save",
      icons.check,
      "ck-button-save"
    );
    // Submit type of the button will trigger the submit event on entire form when clicked
    // (see submitHandler() in render() below).
    this.saveButtonView.type = "submit";

    this.cancelButtonView = this._createButton(
      "Cancel",
      icons.cancel,
      "ck-button-cancel"
    );

    // Delegate ButtonView#execute to FormView#cancel
    this.cancelButtonView.delegate("execute").to(this, "cancel");

    this.childViews = this.createCollection([
      this.productId,
      this.saveButtonView,
      this.cancelButtonView,
    ]);

    this.setTemplate({
      tag: "form",
      attributes: {
        class: ["ck", "ck-insertasin-form"],
        tabindex: "-1",
      },
      children: this.childViews,
    });
  }

  render() {
    super.render();

    // Submit the form when the user clicked the save button or pressed enter in the input.
    submitHandler({
      view: this,
    });
  }

  focus() {
    this.childViews.first.focus();
  }

  _createInput(label) {
    const labeledInput = new LabeledFieldView(
      this.locale,
      createLabeledInputText
    );

    labeledInput.label = label;

    return labeledInput;
  }

  _createButton(label, icon, className) {
    const button = new ButtonView(this.locale);

    button.set({
      label,
      icon,
      tooltip: true,
      class: className,
    });

    return button;
  }
}
