<?php

namespace Drupal\asin\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'asin_text' widget.
 *
 * @FieldWidget(
 *   id = "asin_text",
 *   module = "asin",
 *   label = @Translation("ASIN as simple text"),
 *   field_types = {
 *     "asin"
 *   }
 * )
 */
class AmazonFieldWidget extends WidgetBase {

  //    /**
  //     * {@inheritdoc}
  //     */
  //    public function settingsSummary() {
  //      $summary = [];
  //      $summary[] = $this->t('Displays the random string.');
  //      return $summary;
  //    }
  //
  //    /**
  //     * {@inheritdoc}
  //     */
  //    public static function defaultSettings() {
  //      return [
  //          // Declare a setting named 'text_length', with
  //          // a default value of 'short'
  //          'text_length' => 'short',
  //        ] + parent::defaultSettings();
  //    }
  //
  //
  //    /**
  //     * {@inheritdoc}
  //     */
  //    public function settingsForm(array $form, FormStateInterface $form_state) {
  //      $form['text_length'] = [
  //        '#title' => $this->t('Text length'),
  //        '#type' => 'select',
  //        '#options' => [
  //          'short' => $this->t('Short'),
  //          'long' => $this->t('Long'),
  //        ],
  //        '#default_value' => $this->getSetting('text_length'),
  //      ];
  //
  //      return $form;
  //    }

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $value = isset($items[$delta]->asin) ? $items[$delta]->asin : '';

    /*    $element += [
    '#type' => 'textfield', //@todo i dont understand the naming/drupal api here. i thought its houdl have been field_asin?
    '#default_value' => $value,
    '#size' => 30,
    '#maxlength' => 15,
    '#element_validate' => [
    [$this, 'validate'],
    ],
    ];*/

    $element['asin'] = [
    // @todo i dont understand the naming/drupal api here. i thought its houdl have been field_asin?
      '#type' => 'textfield',
      '#default_value' => $value,
      '#size' => 30,
      '#maxlength' => 15,
      '#element_validate' => [
        [$this, 'validate'],
      ],
    ];

    return $element;
  }

  /**
   * Validate the asin field.
   */
  public function validate($element, FormStateInterface $form_state) {
    $asin = $element['#value'];

    // empty field value
    if (strlen($asin) === 0) {
      $form_state->setValueForElement($element, '');
    }
    else {
      $asins[] = $asin;

      //if that object is null we are saving a new node! Means we do not know
      //the nid and have to insert our asin log stuff in amazon_pa_node_insert()
      $node = \Drupal::routeMatch()->getParameter('node');

      if($node == null) {
        //this is a node beeing saved for the first time
        //so we can not use the normal process, logging of ASINS
        //we do it in "amazon_pa_node_insert"

        //we still need to make a  lookup to check if that asin is valid
        //@todo this also should be merged with a better function/change existing
        $locale = NULL;
        $assoc_id = amazon_pa_get_associate_id($locale);
        $params = [
          'ItemIds'    => $asins,
          'PartnerTag' => $assoc_id,
        ];
        $asin_data = amazon_pa_api_request('GetItems', $params, $locale);

      }
      //we edit/save an existing node and we have node data. so run the normal process
      else {
        $update_one_edit_enabled = \Drupal::config('amazon_pa.settings')->get(
          'update.amazon_update_on_node_edit'
        );

        // query api directly if set in the admin settings
        if ($update_one_edit_enabled == 1) {
          $asin_data = amazon_pa_item_lookup_from_web($asins, NULL);
        }
        // use database cache
        else {
          $asin_data = amazon_pa_item_lookup($asins);
        }
      }



      // invalid asin! amazon api gives us no data
      if (empty($asin_data)) {
        $form_state->setError($element, t("This is not a valid Amazon ASIN"));
      }
    }
  }

}
