<?php

/**
 * @file
 * amazon_pa.locales.inc
 *
 * Docs: https://webservices.amazon.com/paapi5/documentation/locale-reference.html at the bottom of the page
 * host and region: https://webservices.amazon.com/paapi5/documentation/common-request-parameters.html#host-and-region
 *
 *  has been updated for paapi5
 */

function _amazon_pa_load_locales() {
  $locales = [];
  // United States Amazon Locale:
  $locales['US'] = [
    'name'    => t('United States'),
    'url'     => 'www.amazon.com',
    'host'    => 'webservices.amazon.com',
    'region'  => 'us-east-1',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'All Indexes',
      'AmazonVideo'         => 'Prime Video',
      'Apparel'             => 'Apparel',
      'Appliances'          => 'Appliances',
      'ArtsAndCrafts'       => 'Arts & Crafts',
      'Automotive'          => 'Automotive',
      'Baby'                => 'Baby',
      'Beauty'              => 'Beauty',
      'Books'               => 'Books',
      'Classical'           => 'Classical',
      'Collectibles'        => 'Collectibles & Fine Art',
      'Computers'           => 'Computers',
      'DigitalMusic'        => 'Digital Music',
      'Electronics'         => 'Electronics',
      'EverythingElse'      => 'Everything Else',
      'Fashion'             => 'Clothing, Shoes & Jewelry',
      'FashionBaby'         => 'Clothing, Shoes & Jewelry Baby',
      'FashionBoys'         => 'Clothing, Shoes & Jewelry Boys',
      'FashionGirls'        => 'Clothing, Shoes & Jewelry Girls',
      'FashionMen'          => 'Clothing, Shoes & Jewelry Men',
      'FashionWomen'        => 'Clothing, Shoes & Jewelry Women',
      'GardenAndOutdoor'    => 'Garden & Outdoor',
      'GiftCards'           => 'Gift Cards',
      'GroceryAndGourmetFood' => 'Grocery & Gourmet Food',
      'Handmade'            => 'Handmade',
      'HealthPersonalCare'  => 'Health & Personal Care',
      'HomeAndKitchen'      => 'Home & Kitchen',
      'Industrial'          => 'Industrial',
      'Jewelry'             => 'Jewelry',
      'KindleStore'         => 'Kindle Store',
      'LocalServices'       => 'Home & Business Services',
      'Luggage'             => 'Luggage & Travel Gear',
      'LuxuryBeauty'        => 'Luxury Beauty',
      'Magazines'           => 'Magazines',
      'MobileAndAccessories' => 'Cell Phones & Accessories',
      'MobileApps'          => 'Mobile Apps',
      'MoviesAndTV'         => 'Movies & TV',
      'Music'               => 'CDs & Vinyl',
      'MusicalInstruments'  => 'Musical Instruments',
      'OfficeProducts'      => 'Office Products',
      'PetSupplies'         => 'Pet Supplies',
      'Photo'               => 'Photo',
      'Shoes'               => 'Shoes',
      'Software'            => 'Software',
      'SportsAndOutdoors'   => 'Sports & Outdoors',
      'ToolsAndHomeImprovement' => 'Tools & Home Improvement',
      'ToysAndGames'        => 'Toys & Games',
      'VHS'                 => 'VHS',
      'VideoGames'          => 'Video Games',
      'Watches'             => 'Watches',
    ],
  ];

  // United Kingdom Amazon Locale:
  $locales['UK'] = [
    'name'    => t('United Kingdom'),
    'url'     => 'www.amazon.co.uk',
    'host'    => 'webservices.amazon.co.uk',
    'region'  => 'eu-west-1',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'All Indexes',
      'AmazonVideo'         => 'Amazon Video',
      'Apparel'             => 'Apparel',
      'Appliances'          => 'Large Appliances',
      'Automotive'          => 'Car & Motorbike',
      'Baby'                => 'Baby',
      'Beauty'              => 'Beauty',
      'Books'               => 'Books',
      'Classical'           => 'Classical Music',
      'Computers'           => 'Computers & Accessories',
      'DigitalMusic'        => 'Digital Music',
      'Electronics'         => 'Electronics',
      'EverythingElse'      => 'Everything Else',
      'Fashion'             => 'Fashion',
      'GardenAndOutdoor'    => 'Garden & Outdoor',
      'GiftCards'           => 'Gift Cards',
      'GroceryAndGourmetFood' => 'Grocery & Gourmet Food',
      'Handmade'            => 'Handmade',
      'HealthPersonalCare'  => 'Health & Personal Care',
      'HomeAndKitchen'      => 'Home & Kitchen',
      'Industrial'          => 'Industrial & Scientific',
      'Jewelry'             => 'Jewelry',
      'KindleStore'         => 'Kindle Store',
      'Lighting'            => 'Lighting',
      'LuxuryBeauty'        => 'Luxury Beauty',
      'MobileApps'          => 'Apps & Games',
      'MoviesAndTV'         => 'DVD & Blu-ray',
      'Music'               => 'CDs & Vinyl',
      'MusicalInstruments'  => 'Musical Instruments & DJ',
      'OfficeProducts'      => 'Stationery & Office Supplies',
      'PetSupplies'         => 'Pet Supplies',
      'Shoes'               => 'Shoes',
      'Software'            => 'Software',
      'SportsAndOutdoors'   => 'Sports & Outdoors',
      'ToolsAndHomeImprovement' => 'DIY & Tools',
      'ToysAndGames'        => 'Toys & Games',
      'VHS'                 => 'VHS',
      'VideoGames'          => 'Video Games',
      'Watches'             => 'Watches',
    ],
  ];

  // Germany Amazon Locale:
  $locales['DE'] = [
    'name'    => t('Germany'),
    'url'     => 'www.amazon.de',
    'host'    => 'webservices.amazon.de',
    'region'  => 'eu-west-1',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'Alle Kategorien',
      'AmazonVideo'         => 'Prime Video',
      'Apparel'             => 'Bekleidung',
      'Appliances'          => 'Elektro-Großgeräte',
      'Automotive'          => 'Auto & Motorrad',
      'Baby'                => 'Baby',
      'Beauty'              => 'Beauty',
      'Books'               => 'Bücher',
      'Classical'           => 'Klassik',
      'Computers'           => 'Computer & Zubehör',
      'DigitalMusic'        => 'Musik-Downloads',
      'Electronics'         => 'Elektronik & Foto',
      'ForeignBooks'        => 'Bücher (Fremdsprachig)',
      'GardenAndOutdoor'    => 'Garten',
      'GiftCards'           => 'Geschenkgutscheine',
      'GroceryAndGourmetFood' => 'Lebensmittel & Getränke',
      'Handmade'            => 'Handmade',
      'HealthPersonalCare'  => 'Drogerie & Körperpflege',
      'HomeAndKitchen'      => 'Küche, Haushalt & Wohnen',
      'Industrial'          => 'Gewerbe, Industrie & Wissenschaft',
      'Jewelry'             => 'Schmuck',
      'KindleStore'         => 'Kindle-Shop',
      'Lighting'            => 'Beleuchtung',
      'Luggage'             => 'Koffer, Rucksäcke & Taschen',
      'LuxuryBeauty'        => 'Luxury Beauty',
      'Magazines'           => 'Zeitschriften',
      'MobileApps'          => 'Apps & Spiele',
      'MoviesAndTV'         => 'DVD & Blu-ray',
      'Music'               => 'Musik-CDs & Vinyl',
      'MusicalInstruments'  => 'Musikinstrumente & DJ-Equipment',
      'OfficeProducts'      => 'Bürobedarf & Schreibwaren',
      'PetSupplies'         => 'Haustier',
      'Photo'               => 'Kamera & Foto',
      'Shoes'               => 'Schuhe & Handtaschen',
      'Software'            => 'Software',
      'SportsAndOutdoors'  => 'Sport & Freizeit',
      'ToolsAndHomeImprovement'  => 'Baumarkt',
      'ToysAndGames'        => 'Spielzeug',
      'VHS'                 => 'VHS',
      'VideoGames'          => 'Games',
      'Watches'             => 'Uhren',
    ],
  ];

  // Japan Amazon Locale:
  $locales['JP'] = [
    'name'    => t('Japan'),
    'url' => 'www.amazon.co.jp',
    'host' => 'webservices.www.amazon.co.jp',
    'region' => 'us-west-2',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'All Indexes',
      'Apparel'             => 'Apparel',
      'Appliances'          => 'Appliances',
      'Automotive'          => 'Automotive',
      'Baby'                => 'Baby',
      'Beauty'              => 'Beauty',
      'Books'               => 'Books',
      'Classical'           => 'Classical',
      'DVD'                 => 'DVD',
      'Electronics'         => 'Electronics',
      'ForeignBooks'        => 'Foreign Books',
      'Grocery'             => 'Grocery',
      'HealthPersonalCare'  => 'Health & Personal Care',
      'Hobbies'             => 'Hobbies',
      'HomeImprovement'     => 'Home Improvement',
      'Jewelry'             => 'Jewelry',
      'Kitchen'             => 'Kichen',
      'Marketplace'         => 'Marketplace',
      'MP3Downloads'        => 'MP3 Downloads',
      'Music'               => 'Music',
      'MusicalInstruments'  => 'Musical Instruments',
      'MusicTracks'         => 'Music Tracks',
      'OfficeProducts'      => 'Office',
      'Shoes'               => 'Shoes',
      'Software'            => 'Software',
      'SportingGoods'       => 'Sporting Goods',
      'Toys'                => 'Toys',
      'VHS'                 => 'VHS',
      'Video'               => 'Video',
      'VideoGames'          => 'Video Games',
    ],
  ];

  // France Amazon Locale:
  $locales['FR'] = [
    'name' => t('France'),
    'url' => 'www.amazon.fr',
    'host' => 'webservices.amazon.fr',
    'region' => 'eu-west-1',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'All Indexes',
      'Apparel'             => 'Apparel',
      'Baby'                => 'Baby',
      'Beauty'              => 'Beauty',
      'Books'               => 'Books',
      'Classical'           => 'Classical',
      'DVD'                 => 'DVD',
      'Electronics'         => 'Electronics',
      'HealthPersonalCare'  => 'Health & Personal Care',
      'Jewelry'             => 'Jewelry',
      'KindleStore'         => 'Kindle Store',
      'Kitchen'             => 'Kichen',
      'Lighting'            => 'Lighting',
      'MP3Downloads'        => 'MP3 Downloads',
      'Music'               => 'Music',
      'MusicalInstruments'  => 'Musical Instruments',
      'MusicTracks'         => 'Music Tracks',
      'OfficeProducts'      => 'Office',
      'PCHardware'          => 'PC Hardware',
      'Shoes'               => 'Shoes',
      'Software'            => 'Software',
      'SportingGoods'       => 'Sporting Goods',
      'Toys'                => 'Toys',
      'VHS'                 => 'VHS',
      'Video'               => 'Video',
      'VideoGames'          => 'Video Games',
      'Watches'             => 'Watches',
    ],
  ];

  // Canada Amazon Locale:
  $locales['CA'] = [
    'name'    => t('Canada'),
    'url' => 'www.amazon.ca',
    'host' => 'webservices.amazon.ca',
    'region' => 'us-east-1',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'All Indexes',
      'Baby'                => 'Baby',
      'Books'               => 'Books',
      'Classical'           => 'Classical',
      'DVD'                 => 'DVD',
      'Electronics'         => 'Electronics',
      'ForeignBooks'        => 'Foreign Books',
      'Music'               => 'Music',
      'Software'            => 'Software',
      'SoftwareVideoGames'  => 'Software: Video Games',
      'VHS'                 => 'VHS',
      'Video'               => 'Video',
      'VideoGames'          => 'Video Games',
    ],
  ];

  // Italy Amazon Locale:
  $locales['IT'] = [
    'name' => t('Italy'),
    'url' => 'www.amazon.it',
    'host' => 'webservices.amazon.it',
    'region' => 'eu-west-1',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'All Indexes',
      'Baby'                => 'Baby',
      'Books'               => 'Books',
      'DVD'                 => 'DVD',
      'Electronics'         => 'Electronics',
      'ForeignBooks'        => 'Foreign Books',
      'Garden'              => 'Garden',
      'KindleStore'         => 'Kindle Store',
      'Kitchen'             => 'Kichen',
      'Lighting'            => 'Lighting',
      'Music'               => 'Music',
      'Shoes'               => 'Shoes',
      'Software'            => 'Software',
      'Toys'                => 'Toys',
      'VideoGames'          => 'Video Games',
      'Watches'             => 'Watches',
    ],
  ];

  // Spain Amazon Locale:
  $locales['ES'] = [
    'name' => t('Spain'),
    'url' => 'www.amazon.es',
    'host' => 'webservices.amazon.es',
    'region' => 'eu-west-1',
    'da_associate_id' => '',
    'search_indexes' => [
      'All'                 => 'All Indexes',
      'Books'               => 'Books',
      'DVD'                 => 'DVD',
      'Electronics'         => 'Electronics',
      'ForeignBooks'        => 'Foreign Books',
      'KindleStore'         => 'Kindle Store',
      'Kitchen'             => 'Kichen',
      'Music'               => 'Music',
      'Software'            => 'Software',
      'Toys'                => 'Toys',
      'VideoGames'          => 'Video Games',
      'Watches'             => 'Watches',
    ],
  ];

  return $locales;
}
