<?php
namespace Drupal\asin\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;


/**
 * Plugin implementation of the 'asin_text' widget.
 *
 * @FieldWidget(
 *   id = "asin_text",
 *   module = "asin",
 *   label = @Translation("ASIN as simple text"),
 *   field_types = {
 *     "asin"
 *   }
 * )
 */
class AmazonFieldWidget extends WidgetBase {

//    /**
//     * {@inheritdoc}
//     */
//    public function settingsSummary() {
//      $summary = [];
//      $summary[] = $this->t('Displays the random string.');
//      return $summary;
//    }
//
//    /**
//     * {@inheritdoc}
//     */
//    public static function defaultSettings() {
//      return [
//          // Declare a setting named 'text_length', with
//          // a default value of 'short'
//          'text_length' => 'short',
//        ] + parent::defaultSettings();
//    }
//
//
//    /**
//     * {@inheritdoc}
//     */
//    public function settingsForm(array $form, FormStateInterface $form_state) {
//      $form['text_length'] = [
//        '#title' => $this->t('Text length'),
//        '#type' => 'select',
//        '#options' => [
//          'short' => $this->t('Short'),
//          'long' => $this->t('Long'),
//        ],
//        '#default_value' => $this->getSetting('text_length'),
//      ];
//
//      return $form;
//    }


  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $value = isset($items[$delta]->asin) ? $items[$delta]->asin : '';

/*    $element += [
      '#type' => 'textfield', //@todo muss das net field_asin heißen?
      '#default_value' => $value,
      '#size' => 30,
      '#maxlength' => 15,
      '#element_validate' => [
        [$this, 'validate'],
      ],
    ];*/

    $element['asin'] = [
      '#type' => 'textfield', //@todo muss das net field_asin heißen?
      '#default_value' => $value,
      '#size' => 30,
      '#maxlength' => 15,
      '#element_validate' => [
        [$this, 'validate'],
      ],
    ];


    return $element;
  }

  /**
   * Validate the asin field.
   */
  public function validate($element, FormStateInterface $form_state) {

    $asin = $element['#value'];
    if (strlen($asin) === 0) {
      $form_state->setValueForElement($element, '');
      return;
    } else {
      //on node save lookup asin and save to db
      $asins[] = $asin;
      amazon_pa_item_lookup_from_web($asins);
    }

  }

}
