<?php

namespace Drupal\amazon_pa\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class AmazonPaDatabase extends ConfigFormBase {


function getEditableConfigNames() {

  return [
    'amazon_pa.settings',
  ];
}

function getFormId() {
  return 'amazon_pa_admin_database_settings';
}

function buildForm(array $form, FormStateInterface $form_state) {

  $form['database_info'] = array(
    '#markup' => '<p><b>Invalid ASINS should be removed to avoid throtteling issues. This pages removes them from the "items_table". Remember to change the nodes using this ASINS in a field or token too, or they will be regenerated!</b></p>'
  );

  //delete a single asin
  $form['asin_delete'] = array(
    '#type' => 'textfield',
    '#title' => $this->t('Delete a single Amazon ASIN from database'),
    '#description' => $this->t('The ASIN of a product listed on Amazon.'),
    '#required' => FALSE,
  );
  $form['asin_delete_submit'] = array(
    '#type' => 'submit',
    '#value' => $this->t('Delete ASIN'),
    '#submit' => array('amazon_pa_database_form_submit'),
    '#validate' => array('amazon_pa_database_form_validate'),
  );

  //delete all invalid asins from amazon_items table
  $form['invalid_asins'] = array (
    '#type' => 'fieldset',
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['invalid_asins']['delete_invalid_asins']= array(
    '#type' => 'submit',
    '#value' => $this->t('Delete ALL invalid ASINs from database'),
    '#submit' => array('amazon_pa_delete_invalid_all_asins_submit'),
    '#validate' => array('amazon_pa_delete_invalid_all_asins_validate'),
  );

  return parent::buildForm($form, $form_state);

}

function validateForm(array &$form, FormStateInterface $form_state) {

}

function submitForm(array &$form, FormStateInterface $form_state) {

  $config = $this->config('amazon_pa.settings');

  $config
    ->set('amazon_refresh_schedule', $form_state->getValue('amazon_refresh_schedule'))

    ->save();

  parent::submitForm($form, $form_state);
}


}
