<?php

namespace Drupal\amazon_pa\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class AmazonPaStorage extends ConfigFormBase {


function getEditableConfigNames() {

  return [
    'amazon_pa.settings',
  ];
}

function getFormId() {
  return 'amazon_pa_admin_storage_settings';
}

function buildForm(array $form, FormStateInterface $form_state) {

  $config = $this->config('amazon_pa.settings');

  $period = array('3600' => $this->t('1 hour'), '7200' => $this->t('2 hours'), '14400' => $this->t('4 hours'), '21600' => $this->t('6 hours'), '43200' => $this->t('12 hours'), '86400' => $this->t('24 hours'));

  $form['details']['amazon_refresh_schedule'] = array(
    '#type' => 'select',
    '#title' => $this->t('Amazon refresh schedule'),
    '#description' => $this->t('Cached information on Amazon items must be refreshed regularly to keep pricing and stock information up to date. Cron must be enabled for this function to work properly.'),
    '#default_value' => $config->get('details.amazon_refresh_schedule'),
    '#options' => $period
  );
  $form['details']['amazon_refresh_cron_limit'] = array(
    '#type' => 'textfield',
    '#title' => $this->t('Limit'),
    '#description' => $this->t('This will be the number of ASINS! processed each time cron runs.'),
    '#default_value' => $config->get('details.amazon_refresh_cron_limit'),
  );
  $form['debug'] = array (
    '#type' => 'fieldset',
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['debug']['amazon_request_delay'] = array(
    '#type' => 'textfield',
    '#title' => $this->t('DEBUG: Delay between requests'),
    '#description' => $this->t('<b>This also slows down the page load by this amount! Only use for debug purposes</b>. This will fore a delay between two requests. Useful when you are NEW and get throtteled errors "too many requests", see logfiles. '),
    '#default_value' => $config->get('debug.amazon_request_delay'),
  );
  $form['debug']['amazon_request_amount'] = array(
    '#type' => 'textfield',
    '#title' => $this->t('DEBUG: Requests sent'),
    '#description' => $this->t('Counting requests for debug purpose.'),
    '#default_value' => $config->get('debug.amazon_request_amount'),
  );
  $form['debug']['amazon_request_amount_checkbox'] = array(
    '#type' => 'checkbox',
    '#title' => $this->t('Activate request counter'),
    '#description' => $this->t('Counting requests for debug purpose.'),
    '#default_value' => $config->get('debug.amazon_request_amount_checkbox'),
  );
  $form['debug']['amazon_only_nodes'] = array(
    '#type' => 'checkbox',
    '#title' => $this->t('Trigger API request only on a node. Meaning node/x'),
    '#description' => $this->t('Useful for rebuilding the whole amazon_items table with a webcrawler like linkchecker. <b>DEACTIVATE AFTER!</b>'),
    '#default_value' => $config->get('debug.amazon_only_nodes'),
  );
  $form['details']['amazon_core_data'] = array(
    '#type' => 'checkboxes',
    '#title' => $this->t('Store extended product data'),
    '#default_value' => $config->get('details.amazon_core_data'),
    '#options' => array(
      'creators' => $this->t('Book authors, film actors, etc.'),
      'images' => $this->t('Product image links'),
    ),
  );

  return parent::buildForm($form, $form_state);

}

function validateForm(array &$form, FormStateInterface $form_state) {

}

function submitForm(array &$form, FormStateInterface $form_state) {

  $config = $this->config('amazon_pa.settings');

  $config
    ->set('details.amazon_refresh_schedule', $form_state->getValue('amazon_refresh_schedule'))
    ->set('details.amazon_refresh_cron_limit', $form_state->getValue('amazon_refresh_cron_limit'))
    ->set('debug.amazon_request_delay', $form_state->getValue('amazon_request_delay'))
    ->set('debug.amazon_request_amount', $form_state->getValue('amazon_request_amount'))
    ->set('debug.amazon_request_amount_checkbox', $form_state->getValue('amazon_request_amount_checkbox'))
    ->set('debug.amazon_only_nodes', $form_state->getValue('amazon_only_nodes'))
    ->set('details.amazon_core_data', $form_state->getValue('amazon_core_data'))
    ->save();

  parent::submitForm($form, $form_state);
}


}
