<?php

/**
 * @file
 * Views integration for the Amazon SES Log module.
 */

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Implements hook_views_data().
 */
function amazon_ses_log_views_data() {
  $data['amazon_ses_log']['table']['group'] = new TranslatableMarkup('Amazon SES Log');

  $data['amazon_ses_log']['table']['base'] = [
    'field' => 'id',
    'title' => new TranslatableMarkup('Amazon SES Log'),
    'help' => new TranslatableMarkup("This table contains the logged e-mails."),
    'weight' => -10,
  ];

  $data['amazon_ses_log']['message_id'] = [
    'title' => new TranslatableMarkup('Message ID'),
    'help' => new TranslatableMarkup('The ID of the sent email.'),
    'field' => [
      'id' => 'standard',
      'click sortable' => TRUE,
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  $data['amazon_ses_log']['from'] = [
    'title' => new TranslatableMarkup('From'),
    'help' => new TranslatableMarkup('The From address of the sent email.'),
    'field' => [
      'id' => 'standard',
      'click sortable' => TRUE,
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  $data['amazon_ses_log']['to'] = [
    'title' => new TranslatableMarkup('To'),
    'help' => new TranslatableMarkup('The To address of the sent email.'),
    'field' => [
      'id' => 'standard',
      'click sortable' => TRUE,
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  $data['amazon_ses_log']['subject'] = [
    'title' => new TranslatableMarkup('Subject'),
    'help' => new TranslatableMarkup('The subject address of the sent email.'),
    'field' => [
      'id' => 'standard',
      'click sortable' => TRUE,
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  $data['amazon_ses_log']['body'] = [
    'title' => new TranslatableMarkup('Body'),
    'help' => new TranslatableMarkup('The body of the sent email.'),
    'field' => [
      'id' => 'standard',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  $data['amazon_ses_log']['raw_message'] = [
    'title' => new TranslatableMarkup('Raw message'),
    'help' => new TranslatableMarkup('The sent email in raw format.'),
    'field' => [
      'id' => 'standard',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  $data['amazon_ses_log']['sent'] = [
    'title' => new TranslatableMarkup('Sent'),
    'help' => new TranslatableMarkup('The date the email was sent.'),
    'field' => [
      'id' => 'date',
      'click sortable' => TRUE,
    ],
    'sort' => [
      'id' => 'date',
    ],
    'filter' => [
      'id' => 'date',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  $data['amazon_ses_log']['operations'] = [
    'title' => new TranslatableMarkup('Operations'),
    'help' => new TranslatableMarkup('Operation links for the logged email.'),
    'field' => [
      'id' => 'amazon_ses_log_operations',
      'real field' => 'message_id',
    ],
  ];

  $data['amazon_ses_log']['clear'] = [
    'title' => new TranslatableMarkup('Clear link'),
    'help' => new TranslatableMarkup('Provide a link to clear the log.'),
    'field' => [
      'id' => 'amazon_ses_log_clear',
      'real field' => 'message_id',
    ],
  ];

  return $data;
}
