<?php

namespace Drupal\amazon_ses_log\Form;

use Drupal\Core\Database\Connection;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for Amazon SES Log confirmation forms.
 */
abstract class AmazonSesLogConfirmFormBase extends ConfirmFormBase {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    /** @var self $instance */
    $instance = parent::create($container);
    $instance
      ->setDatabaseConnection($container->get('database'))
      ->setEntityTypeManager($container->get('entity_type.manager'));

    return $instance;
  }

  /**
   * Set the database connection.
   *
   * @param \Drupal\Core\Database\Connection $connection
   *   The database connection.
   *
   * @return $this
   */
  public function setDatabaseConnection(Connection $connection) {
    $this->database = $connection;
    return $this;
  }

  /**
   * Set the entity type manager.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   *
   * @return $this
   */
  public function setEntityTypeManager(EntityTypeManagerInterface $entity_type_manager) {
    $this->entityTypeManager = $entity_type_manager;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $view_storage = $this->entityTypeManager->getStorage('view');

    /** @var \Drupal\views\Entity\View $view */
    $view = $view_storage->load('amazon_ses_log');
    $view->invalidateCaches();

    $form_state->setRedirect('view.amazon_ses_log.log');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('view.amazon_ses_log.log');
  }

}
