<?php

namespace Drupal\amazon_ses_log\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Form for confirming clearing the log.
 */
class ConfirmClearForm extends AmazonSesLogConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'amazon_ses_log_confirm_clear';
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->database->truncate('amazon_ses_log')->execute();

    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to clear the log?');
  }

}
