<?php

namespace Drupal\amazon_ses_log\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Form for confirming deleting a log entry.
 */
class ConfirmDeleteForm extends AmazonSesLogConfirmFormBase {

  /**
   * The Message ID of the logged email.
   *
   * @var string
   */
  protected $messageId;

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'amazon_ses_log_confirm_delete';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $message_id = NULL) {
    $this->messageId = $message_id;

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->database->delete('amazon_ses_log')
      ->condition('message_id', $this->messageId)
      ->execute();

    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete this log entry?');
  }

}
