<?php

namespace Drupal\amazon_ses_log;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

class FormAlter implements ContainerInjectionInterface {

  use StringTranslationTrait;

  /**
   * The Amazon SES config object.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected $config;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = (new static())
      ->setConfig($container->get('config.factory'));

    return $instance;
  }

  /**
   * Set the messenger service.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   *
   * @return $this
   */
  protected function setConfig(ConfigFactoryInterface $config_factory) {
    $this->config = $config_factory->getEditable('amazon_ses.settings');
    return $this;
  }

  /**
   * Alter the Amazon SES settings form.
   *
   * @param array $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  public function alterSettingsForm(&$form, FormStateInterface $form_state) {
    $form['log'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Log'),
      '#description' => $this->t('Throttle the sending. Helpful to prevent
        exceeding the rate limit when send a high volume of emails.'),
      '#default_value' => $this->config->get('log'),
      '#weight' => 5,
    ];

    $form['actions']['submit']['#submit'][] = [$this, 'logSettingsSubmit'];
  }

  /**
   * Submit callback to save the log setting.
   *
   * @param array $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  public function logSettingsSubmit(array &$form, FormStateInterface $form_state) {
    $this->config
      ->set('log', $form_state->getValue('log'))
      ->save();
  }

}
