<?php

namespace Drupal\amazon_ses_log\Plugin\views\field;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Provides a field handler that renders operation links.
 *
 * @ViewsField("amazon_ses_log_clear")
 */
class ClearLink extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['text'] = ['default' => $this->t('Clear log')];

    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);

    $form['text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Text to display'),
      '#default_value' => $this->options['text'],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $url = Url::fromRoute('view.amazon_ses_log.log');
    $link = Link::fromTextAndUrl($this->options['text'], $url)->toRenderable();
    $link['#attributes'] = [
      'class' => [
        'button',
        'button--primary',
      ],
    ];

    return $link;
  }

}
