<?php

namespace Drupal\amazon_ses_log\Plugin\views\field;

use Drupal\Core\Url;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Provides a field handler that renders operation links.
 *
 * @ViewsField("amazon_ses_log_operations")
 */
class Operations extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $message_id = $this->getValue($values);

    $links = [
      'details' => [
        'title' => $this->t('Details'),
        'url' => Url::fromRoute('view.amazon_ses_log.details', [
          'arg_0' => $message_id,
        ]),
      ],
      'raw' => [
        'title' => $this->t('Raw message'),
        'url' => Url::fromRoute('view.amazon_ses_log.raw', [
          'arg_0' => $message_id,
        ]),
      ],
      'delete' => [
        'title' => $this->t('Delete'),
        'url' => Url::fromRoute('amazon_ses_log.delete', [
          'message_id' => $message_id,
        ]),
      ],
    ];

    return [
      '#type' => 'dropbutton',
      '#dropbutton_type' => 'small',
      '#links' => $links,
    ];
  }

}
