<?php

namespace Drupal\amazon_ses;

use Aws\Exception\CredentialsException;
use Aws\SesV2\SesV2Client;
use Drupal\Core\Config\ConfigFactory;
use Drupal\Core\Logger\LoggerChannelInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Factory class for AWS SesClient instances.
 */
class AmazonSesClientFactory {
  use StringTranslationTrait;

  /**
   * The logger channel.
   *
   * @var \Drupal\Core\Logger\LoggerChannelInterface
   */
  protected $logger;

  /**
   * Constructs the service.
   *
   * @param \Drupal\Core\Logger\LoggerChannelInterface $logger
   *   The logger factory service.
   */
  public function __construct(LoggerChannelInterface $logger) {
    $this->logger = $logger;
  }

  /**
   * Creates an AWS SesClient instance.
   *
   * @param array $options
   *   The default client options.
   * @param \Drupal\Core\Config\ConfigFactory $configFactory
   *   The config factory.
   *
   * @return \Aws\SesV2\SesV2Client
   *   The client instance.
   */
  public function createInstance(array $options, ConfigFactory $configFactory) {
    $settings = $configFactory->get('amazon_ses.settings');
    $credentials = $settings->get('credentials');

    $options['region'] = $credentials['region'];

    if ($credentials['key'] && $credentials['secret']) {
      $options['credentials'] = [
        'key' => $credentials['key'],
        'secret' => $credentials['secret'],
      ];
    }

    try {
      $client = new SesV2Client($options);

      return $client;
    }
    catch (CredentialsException $e) {
      $this->logger->error($e->getMessage());
    }

  }

}
