<?php

namespace Drupal\Tests\amazon_ses\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Aws\SesV2\SesV2Client;

/**
 * Tests the Amazon SES Client service.
 *
 * @group amazon_ses
 */
class AmazonSesClientServiceTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'amazon_ses',
    'amazon_ses_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installConfig(['amazon_ses_test']);
  }

  /**
   * Tests that the client service creates a SesClient object.
   */
  public function testCreateInstance() {
    $client = $this->container->get('amazon_ses.client');
    $this->assertInstanceOf(SesV2Client::class, $client);
  }

}
