<?php

namespace Drupal\amazon_ses\Traits;

use Drupal\amazon_ses\AmazonSesHandlerInterface;

/**
 * Amazon SES handler trait.
 */
trait HandlerTrait {

  /**
   * The Amazon SES handler service.
   *
   * @var \Drupal\amazon_ses\AmazonSesHandlerInterface
   */
  protected $handler;

  /**
   * Set the handler object.
   *
   * @param \Drupal\amazon_ses\AmazonSesHandlerInterface $handler
   *   The handler object.
   *
   * @return $this
   */
  protected function setHandler(AmazonSesHandlerInterface $handler) {
    $this->setDeprecationMessage();
    $this->handler = $handler;

    return $this;
  }

  /**
   * Verify that the AWS SES client has been initialized.
   *
   * @return bool
   *   TRUE if the client is initialized, FALSE if not.
   */
  protected function verifyClient() {
    $this->setDeprecationMessage();
    $client = $this->handler->getClient();

    if (!$client) {
      $this->messenger()->addError($this->t('Unable to initialize the SES
        client. More information may be available in the log.'));
    }

    return (bool) $client;
  }

  /**
   * Set a deprecation message.
   */
  protected function setDeprecationMessage() {
    @trigger_error('\Drupal\amazon_ses\Traits\HandlerTrait is deprecated in amazon_ses:3.1.0 and will be removed in amazon_ses:4.0.0. See https://www.drupal.org/project/amazon_ses/issues/3466096', E_USER_DEPRECATED);
  }

}
