<?php

namespace Drupal\amazon_ses\Traits;

use Drupal\amazon_ses\MessageBuilderInterface;

/**
 * Amazon SES message builder trait.
 */
trait MessageBuilderTrait {

  /**
   * The message builder service.
   *
   * @var \Drupal\amazon_ses\MessageBuilderInterface
   */
  protected $messageBuilder;

  /**
   * Set the message builder.
   *
   * @param \Drupal\amazon_ses\MessageBuilderInterface $message_builder
   *   The message builder service.
   *
   * @return $this
   */
  protected function setMessageBuilder(MessageBuilderInterface $message_builder) {
    @trigger_error('\Drupal\amazon_ses\Traits\MessageBuilderTrait is deprecated in amazon_ses:3.1.0 and will be removed in amazon_ses:4.0.0. See https://www.drupal.org/project/amazon_ses/issues/3466096', E_USER_DEPRECATED);

    $this->messageBuilder = $message_builder;
    return $this;
  }

}
