<?php

namespace Drupal\amazon_ses\Event;

use Symfony\Component\Mime\Email;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Defines mail group message events.
 */
class MailSentEvent extends Event {

  const SENT = 'amazon_ses.mail_sent';

  public function __construct(
    protected string $messageId,
    protected Email $email,
  ) {}

  /**
   * Gets the message ID.
   *
   * @return string
   *   The ID of the sent message.
   */
  public function getMessageId() {
    return $this->messageId;
  }

  /**
   * Gets the Email object.
   *
   * @return \Symfony\Component\Mime\Email
   *   The Email object representing the sent message.
   */
  public function getEmail() {
    return $this->email;
  }

}
