<?php

namespace Drupal\amazon_ses\Form;

use Drupal\amazon_ses\AmazonSesHandlerInterface;
use Drupal\Core\Form\FormBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Amazon SES form base class.
 */
abstract class AmazonSesFormBase extends FormBase {

  public function __construct(
    protected AmazonSesHandlerInterface $handler,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('amazon_ses.handler'),
    );
  }

}
