<?php
include drupal_get_path('module', 'amfphp') . "/amfphp/amf-core/app/Gateway.php";

//You can set this constant appropriately to disable traces and debugging headers
//You will also have the constant available in your classes, for changing
//the mysql server info for example
define("PRODUCTION_SERVER", variable_get('amfphp_production_server', 0));

$gateway = new Gateway();

//Set where the services classes are loaded from, *with trailing slash*
$gateway->setBaseClassPath(drupal_get_path('module', 'amfphp') . '/services/');

//Loose mode means echo'ing or whitespace in your file won't make AMFPHP choke
$gateway->setLooseMode(variable_get('amfphp_loose_mode', 1));

//Read above large note for explanation of charset handling
//The main contributor (Patrick Mineault) is French, 
//so don't be afraid if he forgot to turn off iconv by default!
//$gateway->setCharsetHandler("utf8_decode", "ISO-8859-1", "ISO-8859-1");

//Error types that will be rooted to the NetConnection debugger
$gateway->setErrorHandling(E_ALL ^ E_NOTICE);

//choices are php5 (SoapClient), nusoap and pear
//If you don't plan on using web services with AMFPHP, 
//you can safely let this setting alone
//Note that for nusoap to work you MUST place the library under /amf-core/lib/nusoap.php
$gateway->setWebServiceHandler(variable_get('amfphp_web_service_handler', 'php5'));

//Adding an adapter mapping will make returns of the mapped typed be intercepted
//and mapped in adapters/%adapterName%Adapter.php. This works by using get_class
//So for example, if you return a PEAR resultset object, it is an instance of DB_result
//And we want this to be processed as a recordset in adapters/peardbAdapter.php,
//hence the following line:
//$gateway->addAdapterMapping('db_result', 'peardb');
//For PDO (PHP 5.1 specific)
//$gateway->addAdapterMapping('pdostatement', 'pdo');
//For oo-style MySQLi
//$gateway->addAdapterMapping('mysqli_result', 'mysqli');
//For filtered array 
//And for filtered typed array (see adapters/lib/Arrayf.php and Arrayft.php)
$gateway->addAdapterMapping('arrayf', 'arrayf');
$gateway->addAdapterMapping('arrayft', 'arrayft');
//And you can add your own after this point... (note lowercase for both args!)

if(PRODUCTION_SERVER)
{
	//Disable trace actions
	$gateway->disableTrace();
	
	//Disable debugging headers
	$gateway->disableDebug();
	
	//Disable Service description
	$gateway->disableServiceDescription();
}

//If you are running into low-level issues with corrupt messages and 
//the like, you can add $gateway->logIncomingMessages('path/to/incoming/messages/');
//and $gateway->logOutgoingMessages('path/to/outgoing/messages/'); here

//If using under SSL (https) with IE6, usually the default amfphp method will 
//work. It is however possible that it doesn't, in which case, enable the 
//second SSL method, and apply the patch described here:
//http://www.gmrweb.net/2005/08/18/flash-remoting-https-internet-explorer/
//(requires mod_headers)
//$gateway->useSslSecondMethod();

//This is new to AMFPHP 1.2: 
//Set custom class mappings (kept in a second config file for convenience)
include_once(drupal_get_path('module', 'amfphp') . '/amfphp/advancedsettings.php');

//Service now
$gateway->service();