<?php
include 'Node.php';
class Contact
{
  function Contact()
  {
    $this->methodTable = array(
      'sendEmail' => array(
        'access' => 'remote',
        'description' => t('Sends an email.')
      )
    );
  }
  
  // Remote Methods
  
  function sendEmail($_from_name, $_from_email, $_subject, $_message)
  { 
    global $base_url;

    // Prepare the sender:
    $from = $_from_name . ' <' . $_from_email . '>';

    // Compose the body:

    $message[] = t($_message);

    // Tidy up the body:
    foreach ($message as $key => $value) {
      $message[$key] = wordwrap($value);
    }

    // Format the category:
    $subject = t("Message Received from %name", array('%name' => $_from_name));

    // Prepare the body:
    $body = implode("\n\n", $message);

    // Send the e-mail to the recipients:
    user_mail(variable_get('site_mail', ''), $subject, $body, "From: $from\nReply-to: $from\nX-Mailer: Drupal\nReturn-path: $from\nErrors-to: $from");

    // Log the operation:
    watchdog('mail', t('%name-from sent an e-mail from the contact form.', array('%name-from' => $from)));
    return true;
  }
}