<?php
class Node 
{
  function Node()
  {
    $this->methodTable = array(
      'load' => array(
        'access' => 'remote',
        'description' => t('Loads a node')
      )
    );
  }
  
  // Remote Methods
  
  /**
   * Loads a node by nid using the node_load function
   * Returns only the requested fields
   */
  function load($nid, $fields)
  {
    return $this->format(node_load(array('nid' => $nid)), $fields);
  }
  
  // Public Methods
  
  /**
   * Strips node and returns only the requested fields
   * Also applies filters to the body field, and strips unwanted 
   * carriage returns which cause double spacing in flash.
   * 
   * @TODO - make recursive so that all fields can be returned for
   *         subnodes
   */
  function format($node, $fields = array())
  {
    // apply filters to fields
    $node->body = check_markup($node->body, $node->filter, FALSE);
    
    // loop through and get only requested fields
    if (count($fields) > 0) {
      foreach($fields as $field) {
        if (is_array($field)) {
          foreach ($field as $subnode_name => $subnode) {
            if (isset($node->{$subnode_name})) {
              if (!is_array($node->{$subnode_name})) {
                foreach ($subnode as $subnode_field) {
                  $val->{$subnode_name}->{$subnode_field} = $node->{$subnode_name}->{$subnode_field};
                  
                  // strip unwanted returns from strings
                  if (is_string($node->{$subnode_name}->{$subnode_field})) {
                    $node->{$subnode_name}->{$subnode_field} = str_replace("\r", '', $node->{$subnode_name}->{$subnode_field});
                  }
                }
              }
            }
          }
        }
        else {
          $val->{$field} = $node->{$field};
          
          // strip unwanted returns from field
          if (is_string($node->{$field})) {
            $node->{$field} = str_replace("\r", '', $node->{$field});
          }
        }
      }
    } else {
      $val = $node;
    }

    return $val;
  }
}