<?php
include 'Node.php';
class Taxonomy
{
  function Taxonomy()
  {
    $this->methodTable = array(
      'getTree' => array(
        'access' => 'remote',
        'description' => t('Gets terms in a taxonomy.')),
      'selectNodes' => array(
        'access' => 'remote',
        'description' => t('Select nodes matching the terms.')
      )
    );
  }
  
  /**
   * Returns a taxonomy tree
   */
  function getTree($vid)
  {
    return taxonomy_get_tree($vid);
  }
  
  /**
   * Selects nodes within the given terms
   */
  function selectNodes($tids = array(), $fields = array(), $operator = 'or', $depth = 0, $pager = TRUE, $order = 'n.sticky DESC, n.created DESC')
  {
    $result = taxonomy_select_nodes($tids, $operator, $depth, $pager, $order);
    while ($node = db_fetch_object($result)) {
      $nodes[] = Node::format(node_load($node), $fields);
    }
    
    return $nodes;
  }
}