<?php
include 'Node.php';
class Views
{
  function Views()
  {
    $this->methodTable = array(
      'getView' => array(
        'access' => 'remote',
        'description' => t('Gets nodes in a view')
      ),
      'getPagedView' => array(
        'access' => 'remote',
        'description' => t('Gets nodes in a paged view')
      )
    );
  }
  
  // Remote Methods
  
  /**
   * Gets an array of nodes in the view.
   */
  function getView($view_name, $fields = array(), $args = array())
  { 
    $view = views_get_view($view_name);
    if ($view == null)
    {
      return t('View does not exist.');
    }
    
    $result = views_build_view('result', $view, $args, false, $view->nodes_per_page);

    while ($node = db_fetch_object($result['result'])) {
      $nodes[] = Node::format(node_load($node), $fields);
    }

    return $nodes;
  }
  
  /**
   * Gets an array of nodes in the view.
   * Returns as an info array with items and pages.
   * Items is an array of nodes.
   * Pages is a count of total pages.
   */
  function getPagedView($view_name, $fields = array(), $args = array(), $page = 0)
  { 
    $view = views_get_view($view_name);
    if ($view == null)
    {
      return t('View does not exist.');
    }
    
    $result = views_build_view('result', $view, $args, false, $view->nodes_per_page, $page);

    while ($node = db_fetch_object($result['result'])) {
      $nodes[] = Node::format(node_load($node), $fields);
    }

    $return = array();
    $return['items'] = $nodes;
    $return['pages'] = ceil(db_result(db_query($result['countquery'])) / $view->nodes_per_page);
    
    return $return;
  }
}