<?php

namespace Drupal\amoebacrm\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Company edit forms.
 *
 * @ingroup company
 */
class CompanyForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;

    $status = parent::save($form, $form_state);

    switch ($status) {
      case SAVED_NEW:
        $this->messenger()->addMessage($this->t('Created the %label Company.', [
          '%label' => $entity->label(),
        ]));
        break;

      default:
        $this->messenger()->addMessage($this->t('Saved the %label Company.', [
          '%label' => $entity->label(),
        ]));
    }
    $form_state->setRedirect('entity.company.canonical', ['company' => $entity->id()]);
  }

}
