<?php

namespace Drupal\amp_optimizer\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class Settings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['amp_optimizer.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'amp_optimizer_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['transform_enabled'] = [
      '#type' => 'radios',
      '#options' => [
        $this->t('Disabled'),
        $this->t('Enabled'),
      ],
      '#default_value' => $this->config('amp_optimizer.settings')->get('transform_enabled') ?? 0,
      '#title' => $this->t('Status of optimisation'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('amp_optimizer.settings')
      ->set('transform_enabled', (int) $form_state->getValue('transform_enabled', 0))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
