<?php

/**
 * amplify.admin
 *
 * @file
 */

/**
 * Administrative form for QP services.
 */
function qpservices_admin_form() {
  
  $form['amplify_api_key'] = array(
    '#type' => 'textfield',
    '#title' => t('Amplify API Key'),
    '#description' => t('Enter your developer API key for the OpenAmplify web service'),
    '#default_value' => variable_get('amplify_api_key', ''),
    '#size' => 60,
    '#maxlength' => 256,
    '#required' => FALSE,
  );
  
  
  // Get node types that OpenAmplify should submit.
  $types = node_get_types();
  $type_list = array();
  foreach ($types as $key => $type) {
    $type_list[$key] = $type->name;
  }
  $form['amplify_node_types'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Amplified Node Types'),
    '#description' => t('List of node types that will be amplified by OpenAmplify.'),
    '#options' => $type_list,
    '#default_value' => variable_get('amplify_node_types', array()),
    '#required' => FALSE,
  );
  
  return system_settings_form($form);
}