<?php
/**
 * @file
 * Hooks provided by AMQP.
 */

/**
 * Hook for registering module consumers.
 *
 * Each entry associates a module callback function with a consumer and
 * registers that consumer with the AMQP server.
 */
function hook_amqp_consumers() {
  $consumers = array(
  	'mymodule_unique_consumer_name' => array(
	    'callback' => 'mymodule_consumer_callback',
	    'exchange' => 'exchange_name',
	    'routing_key' => 'routing.key',
	    'queue_name' => 'mymodule_queue',
	    'flags' => AMQP_DURABLE,
	    'type' => AMQP_EX_TYPE_DIRECT
	    'arguments' => array(),
    )
  );
  return $consumers;
}

/**
 * Example Callback for mymodule consumer
 *
 * This callback name is defined in hook_amqp_consumers()
 *
 * @param $message
 *   The message being consumed.
 */
function mymodule_consumer_callback($message) {
  // Now that you have the message, you can do something with it.
}


/**
 * Hook for altering a message before publishing.
 *
 * @param $message
 *   The message, passed by reference.
 * @param $exchange_name
 *   The name of the exchange.
 * @param $routing_key
 *   The routing key for the message.
 */
function hook_amqp_message_alter(&$message, $exchange_name, $routing_key) {
  if ($exchange_name == 'exchange_name' && $routing_key == 'routing.key') {
  	// We can alter the message before it is published.
  	$message .= " - altered message.";
  }
}

