<?php

/**
 * Admin settings form for AMQP module
 */
function amqp_admin_form() {
  $installed = amqp_installed(TRUE);
  $form = array();

  $form['amqp_host'] = array(
    '#type' => 'textfield',
    '#title' => t('AMQP host'),
    '#description' => t('Hostname (URI) of AMQP server.'),
    '#default_value' => amqp_variable_host(),
  );
  $form['amqp_port'] = array(
    '#type' => 'textfield',
    '#title' => t('AMQP port'),
    '#description' => t('Port of AMQP server.'),
    '#default_value' => amqp_variable_port(),
  );
  $form['amqp_login'] = array(
    '#type' => 'textfield',
    '#title' => t('AMQP login'),
    '#description' => t('Username / Login for AMQP server.'),
    '#default_value' => amqp_variable_login(),
  );
  $form['amqp_password'] = array(
    '#type' => 'textfield',
    '#title' => t('AMQP password'),
    '#description' => t('Password for above user.'),
    '#default_value' => amqp_variable_password(),
  );
  $form['amqp_test_message'] = array(
    '#type' => 'button',
    '#value' => t('Test Connection'),
    '#executes_submit_callback' => TRUE,
    '#disabled' => !$installed,
    '#submit' => array('amqp_admin_form_submit'),
    '#description' => t('After saving above settings, click this button to test your connection.')
  );

  return system_settings_form($form);
}

function amqp_admin_form_submit($form, &$form_state) {
  $msg = t('This is a test message from the AMQP Drupal module. If you are reading this, it means the module has been properly configured.');

  amqp_publish('amqp.test', 'amqp.test.routing.key', $msg, AMQP_DURABLE, AMQP_EX_TYPE_DIRECT);
}

/**
 * Implementation of hook_amqp_consumers().
 */
function amqp_amqp_consumers() {
  $consumers = array(array(
    'callback' => 'amqp_test_message_consumer',
    'exchange' => 'amqp.test',
    'routing_key' => 'amqp.test.routing.key',
    'queue_name' => 'amqp_test_queue',
    'arguments' => array(),
    'flags' => AMQP_DURABLE,
    'type' => AMQP_EX_TYPE_DIRECT
  ));
  return $consumers;
}

/**
 * Test message consumer callback
 */
function amqp_test_message_consumer($message) {
  drupal_set_message($message);
}

function amqp_connection_args() {
  return array(
    'host' => amqp_variable_host(),
    'port' => amqp_variable_port(),
    'login' => amqp_variable_login(),
    'password' => amqp_variable_password(),
  );
}

function amqp_variable_host() {
  return variable_get('amqp_host', 'localhost');
}

function amqp_variable_port() {
  return variable_get('amqp_port', 5672);
}

function amqp_variable_login() {
  return variable_get('amqp_login', 'guest');
}

function amqp_variable_password() {
  return variable_get('amqp_password', 'guest');
}
