<?php



class GoogleUniversalAnalyticsService extends AnalyticsService {

  public function getOutput($page) {
    $output = "(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
})(window,document,'script','//www.google-analytics.com/analytics.js','ga');";
    $actions = array();
    $actions[] = array('create', $this->service->data->ua, 'auto', array('name' => $this->service->machine_name));
    $actions[] = array($this->service->machine_name . '.send', 'pageview');
    $code = theme('analytics_google_universal_js', array('actions' => $actions, 'service' => $service));
    $output = array();
    $output['#attached']['js'][] = array(
      'data' => $code,
      'type' => 'inline',
      'weight' => 100000,
      'preprocess' => FALSE,
    );
    return $output;

    $output .= "ga('create', '{$this->service->data->ua}', 'auto', " . json_encode(array('name' => $this->service->machine_name)) . ");";
    $output .=

ga('create', 'UA-12345-6', 'auto', {'name': 'newTracker'});
ga('create', 'UA-XXXX-Y', 'auto');  // Replace with your property ID.
ga('send', 'pageview');

</script>
<!-- End Google Analytics -->
  }

}

function template_preprocess_analytics_google_universal_js(array &$variables) {

}

function template_process_analytics_google_universal_js(array &$variables) {
  $variables['actions'] = array();
  foreach ($variables['actions_array'] as $action) {
    if (!is_array($action)) {
      $action = array($action);
    }
    $variables['actions'][] = 'ga(' . drupal_json_encode($action) . ');';
  }
  $variables['actions'] = implode("\n", $variables['actions']);
}

class GoogleAnalyticsGAService extends AnalyticsService {

}
