<?php

namespace Drupal\analytics\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class AnalyticsSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'analytics_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['analytics.settings'];
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('analytics.settings');

    $form['privacy'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Privacy'),
    ];
    $form['privacy']['dnt'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Respect Do Not Track (DNT) cookies.'),
      '#default_value' => $config->get('privacy.dnt'),
    ];
    $form['privacy']['anonymize_ip'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Anonymize IP addresses if possible.'),
      '#default_value' => $config->get('privacy.anonymize_ip'),
      '#access' => FALSE,
    ];

    $form['advanced'] = [
      '#type' => 'details',
      '#title' => t('Advanced'),
      '#open' => FALSE,
    ];
    $form['advanced']['cache_urls'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Cache files locally where possible.'),
      '#default_value' => $config->get('cache_urls'),
    ];
    $form['advanced']['disable_page_build'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Disable default analytics service rendering in hook_page_bottom().'),
      '#default_value' => $config->get('disable_page_build'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('analytics.settings')
      ->set('privacy.dnt', $form_state->getValue('dnt'))
      ->set('privacy.anonymize_ip', $form_state->getValue('anonymize_ip'))
      ->set('cache_urls', $form_state->getValue('cache_urls'))
      ->set('disable_page_build', $form_state->getValue('disable_page_build'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
