"use strict";

!function($) {
    angular.module("app", [ "app.core", "app.flickr", "ui.router", "ngResource", "infinite-scroll", "angularFileUpload", "ngJcrop" ]).run([ "$rootScope", "$state", "$stateParams", "$window", "$location", "$timeout", function($rootScope, $state, $stateParams, $window, $location, $timeout) {
        $rootScope.settings = {
            defaults: {}
        }, $rootScope.files = {}, $rootScope.settings.defaults.flickrKey = "5202f8e46861f39f55bedfa2374a41d8", 
        $rootScope.settings.defaults.multiple = !1, $rootScope.settings.defaults.cardinality = 1, 
        $rootScope.tabs = {
            upload: {
                key: "upload",
                title: "Upload"
            },
            site: {
                key: "browse",
                title: "Site Files",
                params: {
                    person: "all"
                }
            },
            flickr: {
                key: "flickr",
                title: "Flickr"
            }
        }, $rootScope.settings.defaults.tabs = [ "upload", "site", "flickr" ], $rootScope.$state = $state, 
        $rootScope.$stateParams = $stateParams, $rootScope.addFiles = function(files) {
            Array.prototype.push.apply($rootScope.files[$rootScope.activeField], files), void 0 != $rootScope.settings[$rootScope.activeField].addlFieldName && void 0 != $rootScope.files[$rootScope.settings[$rootScope.activeField].addlFieldName] && Array.prototype.push.apply($rootScope.files[$rootScope.settings[$rootScope.activeField].addlFieldName], files), 
            jQuery("#" + $rootScope.activeField + "_media").trigger("change"), console.log("elem", jQuery("#" + $rootScope.activeField + "_media").val()), 
            $state.go("base");
        }, $rootScope.$on("$stateChangeSuccess", function(event, toState, toParams, fromState, fromParams) {}), 
        $rootScope.goSubRoute = function(baseRoute, subRoute, baseName) {
            baseName = void 0 == baseName ? "base" : baseName;
            var stateName = baseRoute + "." + subRoute;
            try {
                var state = $state.get(stateName);
                if (void 0 == state || null == state) throw "myException";
            } catch (e) {
                stateName = baseRoute + "." + baseName;
            }
            $state.go(stateName);
        };
    } ]).config([ "$locationProvider", "$stateProvider", "$urlRouterProvider", function($locationProvider, $stateProvider, $urlRouterProvider) {} ]);
}(jQuery), angular.module("app.core", [ "ui.router", "angularFileUpload" ]).config([ "$stateProvider", "$urlRouterProvider", function($stateProvider, $urlRouterProvider) {
    $stateProvider.state("base", {}).state("modal.edit", {
        controller: "edit",
        params: {
            fid: null
        },
        templateUrl: "views/edit.html"
    }).state("modal", {
        templateUrl: "views/modal.html",
        controller: "modal",
        onEnter: function($state) {
            jQuery(document).on("keyup", function(e) {
                27 == e.keyCode && (jQuery(document).off("keyup"), $state.go("base"));
            }), jQuery(document).on("click", ".modal-backdrop, .modal-holder", function() {
                $state.go("base");
            }), jQuery(document).on("click", ".modal-box, .modal-box *", function(e) {
                e.stopPropagation();
            });
        },
        "abstract": !0
    }).state("modal.upload", {
        templateUrl: "views/upload.html",
        controller: "upload"
    }).state("modal.browse", {
        params: {
            person: "all"
        },
        templateUrl: "views/browse.html",
        controller: "browse"
    });
} ]).controller("modal", function($scope, $rootScope, $state, $stateParams) {
    $scope.tabs = $rootScope.settings[$rootScope.activeField].tabs, $scope.activeTab = $state.current.controller, 
    $scope.loadTab = function(item) {
        $scope.activeTab = item.key, $state.go("modal." + item.key, item.params);
    }, $scope.close = function($event) {
        $state.go("base"), $event.preventDefault();
    };
}).controller("edit", function($scope, $rootScope, $state, $stateParams, CoreFile) {
    $scope.file = CoreFile.load({
        fid: $stateParams.fid
    });
}).controller("browse", function($scope, $rootScope, $state, $stateParams, CoreBrowser, CoreFile) {
    $scope.filters = {
        page: 1,
        person: $stateParams.person
    }, $scope.selected = [], $scope.items = [], $scope.loadItems = function(push) {
        CoreBrowser.query($scope.filters, function(data) {
            void 0 !== push && 1 == push ? Array.prototype.push.apply($scope.items, data) : $scope.items = data;
        });
    }, $scope.updateFilters = function($event) {
        $scope.filters.page = 1, $scope.items = $scope.loadItems(), void 0 != $event && $event.preventDefault();
    }, $scope.updateFilters(), $scope.updateActive = function(item) {
        void 0 != item && ($rootScope.settings[$rootScope.activeField].multiple && item.active ? (item.active = !1, 
        angular.forEach($scope.selected, function(activeItem, key) {
            activeItem.id == item.id && $scope.selected.splice(key, 1);
        })) : ($scope.active = item, $rootScope.settings[$rootScope.activeField].multiple ? (item.active = !0, 
        $scope.active = item) : angular.forEach($scope.items, function(activeItem, key) {
            $scope.items[key].active = activeItem.fid == item.fid ? !0 : !1;
        }), $rootScope.settings[$rootScope.activeField].multiple ? $scope.selected.push(item) : $scope.selected = [ item ], 
        CoreFile.load({
            fid: item.fid
        }, function(data) {
            $scope.active = data;
        })));
    }, $scope.submit = function($event) {
        $rootScope.addFiles($scope.selected), $event.preventDefault();
    }, $scope.addItems = function() {};
}).controller("upload", function($scope, $rootScope, $state, $stateParams, FileUploader, CoreFile) {
    $scope.uploading = !1, $scope.basePage = $state.current.name ? !1 : !0, $scope.selected = [];
    var uploader = $scope.uploader = new FileUploader({
        url: $rootScope.settings[$rootScope.activeField].apiUrl + "upload",
        autoUpload: !0
    });
    uploader.onAfterAddingFile = function(fileItem) {
        fileItem.showThumb = -1 != fileItem.file.type.indexOf("image") ? !0 : !1;
    }, uploader.onBeforeUploadItem = function(item) {
        $scope.uploading = !0;
    }, uploader.onSuccessItem = function(fileItem, response, status, headers) {
        console.info("onSuccessItem", fileItem, response, status, headers), $scope.selected.push(response), 
        fileItem = response, void 0 == $scope.file && ($scope.file = fileItem, $scope.activeKey = 0), 
        $scope.basePage && ($rootScope.addFiles($scope.selected), $scope.selected = []);
    }, uploader.onCompleteAll = function() {
        console.info("onCompleteAll"), $scope.uploading = !1;
    }, $scope.fileDetails = function(key, file) {
        void 0 != file.fid && $scope.file != file ? ($scope.file = file, $scope.activeKey = key) : ($scope.file = void 0, 
        $scope.activeKey = -1);
    }, $scope.submit = function($event) {
        $rootScope.addFiles($scope.selected), $scope.selected = [], $event && $event.preventDefault();
    }, $scope.fetch = function($event) {
        var file = new CoreFile({
            external: this.externalFile
        });
        file.$save(function(data) {
            $rootScope.addFiles([ data ]);
        }), $event.preventDefault();
    };
}), angular.module("app.flickr", [ "ui.router", "ngResource" ]).config([ "$stateProvider", "$urlRouterProvider", function($stateProvider, $urlRouterProvider) {
    $stateProvider.state("modal.flickr", {
        templateUrl: "views/flickr.html",
        controller: function($scope, $rootScope, $state, Flickr, CoreFile) {
            $scope.filters = {
                method: "flickr.photos.search",
                tags: $rootScope.settings[$rootScope.activeField].flickrSearch,
                license: "4,5",
                page: 1
            }, $scope.licenses = Flickr.load({
                method: "flickr.photos.licenses.getInfo"
            }), $scope.selected = [], $scope.active = void 0, $scope.loadItems = function(push) {
                Flickr.load($scope.filters, function(data) {
                    var structured = [];
                    angular.forEach(data.photos.photo, function(item, key) {
                        structured.push({
                            thumbUrl: "https://farm" + item.farm + ".staticflickr.com/" + item.server + "/" + item.id + "_" + item.secret + "_q.jpg",
                            name: item.title,
                            id: item.id,
                            secret: item.secret,
                            farm: item.farm,
                            server: item.server
                        });
                    }), void 0 !== push && 1 == push ? ($scope.items = void 0 != $scope.items ? $scope.items : [], 
                    Array.prototype.push.apply($scope.items, structured)) : $scope.items = structured;
                });
            }, $scope.updateFilters = function($event) {
                $scope.filters.page = 1, $scope.items = $scope.loadItems(), void 0 != $event && $event.preventDefault();
            }, $scope.updateFilters(), $scope.updateActive = function(item) {
                void 0 != item && ($rootScope.settings[$rootScope.activeField].multiple && item.active ? (item.active = !1, 
                angular.forEach($scope.selected, function(activeItem, key) {
                    activeItem.id == item.id && $scope.selected.splice(key, 1);
                })) : ($scope.active = item, $rootScope.settings[$rootScope.activeField].multiple ? item.active = !0 : angular.forEach($scope.items, function(activeItem, key) {
                    $scope.items[key].active = activeItem.id == item.id ? !0 : !1;
                }), Flickr.load({
                    method: "flickr.photos.getInfo",
                    photo_id: item.id,
                    secret: item.secret
                }, function(data) {
                    $scope.active.previewUrl = "https://farm" + item.farm + ".staticflickr.com/" + item.server + "/" + item.id + "_" + item.secret + "_m.jpg", 
                    $scope.active.name = data.photo.title._content, $scope.active.alt = $scope.active.name, 
                    $scope.active.filename = $scope.active.name + ".jpg", $scope.active.source = data.photo.urls.url[0]._content, 
                    $scope.active.user = data.photo.owner.realname ? data.photo.owner.realname : data.photo.owner.username, 
                    $scope.active.userLink = "https://www.flickr.com/people/" + data.photo.owner.nsid, 
                    $scope.active.attribution = $scope.active.user + " on Flickr", $scope.active.title = data.photo.title._content, 
                    $scope.active.license = data.photo.license, $scope.active.licenseMeta = $scope.licenses.licenses.license[data.photo.license], 
                    Flickr.load({
                        method: "flickr.photos.getSizes",
                        photo_id: item.id,
                        secret: item.secret
                    }, function(data) {
                        var size = data.sizes.size.pop();
                        $scope.active.width = size.width, $scope.active.height = size.height, $scope.active.url = size.source, 
                        $rootScope.settings[$rootScope.activeField].multiple ? $scope.selected.push($scope.active) : $scope.selected = [ $scope.active ];
                    });
                })));
            }, $scope.submit = function($event) {
                $scope.queue = {
                    total: $scope.selected.length,
                    completed: 0,
                    files: []
                }, angular.forEach($scope.selected, function(item, key) {
                    console.log("item", item);
                    var file = new CoreFile(item);
                    file.$save(function(data) {
                        $scope.queue.completed++, $scope.queue.files[key] = data, $scope.queue.progress = $scope.queue.completed / $scope.queue.total, 
                        $scope.queue.completed >= $scope.queue.total && ($rootScope.addFiles($scope.queue.files), 
                        $scope.queue = void 0);
                    });
                }), $event.preventDefault();
            };
        }
    });
} ]), angular.module("app.flickr").factory("Flickr", function($resource, $rootScope) {
    return $resource("https://api.flickr.com/services/rest/", {
        api_key: $rootScope.settings[$rootScope.activeField].flickrKey,
        format: "json",
        jsoncallback: "JSON_CALLBACK"
    }, {
        load: {
            method: "JSONP"
        }
    });
}), angular.module("app.core").factory("CoreBrowser", function($resource, $rootScope) {
    return $resource($rootScope.settings[$rootScope.activeField].apiUrl + "browse/:person/:type/:name", {
        format: "json",
        type: "@type",
        name: "@name",
        person: "@person"
    }, {
        load: {
            method: "JSON"
        }
    });
}).factory("CoreFile", function($resource, $rootScope) {
    return $resource($rootScope.settings[$rootScope.activeField].apiUrl + "file", {
        format: "json",
        fid: "@fid",
        filename: "@filename",
        name: "@name",
        title: "@title",
        alt: "@alt",
        license: "@license",
        attribution: "@attribution",
        source: "@source",
        url: "@url",
        crop: "@crop",
        external: "@external",
        token: $rootScope.settings[$rootScope.activeField].token
    }, {
        load: {
            method: "JSON"
        }
    });
}), angular.module("app.core").controller("thumbnails", function($scope, $rootScope, $state, $stateParams, $timeout, FileUploader) {
    $scope.init = function(params) {
        $rootScope.activeField = params.fieldName, $rootScope.files[params.fieldName] = void 0 != params.files ? params.files : $rootScope.files, 
        params.files = void 0;
        var settings = {};
        angular.extend(settings, $rootScope.settings.defaults, params), settings.multiple = 1 != parseInt(settings.cardinality) ? !0 : !1;
        var tabs = [];
        angular.forEach(settings.tabs, function(tab, key) {
            void 0 != $rootScope.tabs[tab] && tabs.push($rootScope.tabs[tab]);
        }), settings.tabs = tabs, settings.tabs.slice().reverse(), $rootScope.settings[settings.fieldName] = settings, 
        console.log("settings", $rootScope.settings);
    };
    var uploader = $scope.uploader = new FileUploader({
        url: "/api/angular-media/upload",
        autoUpload: !0
    });
    uploader.onAfterAddingFile = function(fileItem) {
        fileItem.showThumb = -1 != fileItem.file.type.indexOf("image") ? !0 : !1;
    }, uploader.onBeforeUploadItem = function(item) {
        $scope.uploading = !0;
    }, uploader.onSuccessItem = function(fileItem, response, status, headers) {
        $scope.selected.push(response), fileItem = response, void 0 == $scope.file && ($scope.file = fileItem, 
        $scope.activeKey = 0);
    }, $scope.remove = function(fieldName, key) {
        $rootScope.files[fieldName].splice(key, 1);
    }, $scope.edit = function(fid, fieldName, key) {
        $rootScope.activeField = fieldName, $rootScope.activeKey = key, $state.go("modal.edit", {
            fid: fid
        });
    }, $scope.select = function(fieldName, $event) {
        $rootScope.activeField = fieldName, $rootScope.activeKey = void 0, $state.go("modal.upload"), 
        $event.preventDefault();
    };
}), angular.module("app.core").directive("thumbnails", function() {
    return {
        restrict: "A",
        templateUrl: "views/thumbnail.html",
        link: function($scope, $element, $attrs) {
            if (void 0 != $scope.file && (void 0 != $scope.file.filemime || void 0 != $scope.file.mime)) {
                var mime = void 0 != $scope.file.mime ? $scope.file.mime.split("/") : $scope.file.filemime.split("/");
                $scope.fileType = mime[1];
            }
            $scope["class"] = $attrs["class"];
        }
    };
}).directive("ngThumb", [ "$window", function($window) {
    var helper = {
        support: !(!$window.FileReader || !$window.CanvasRenderingContext2D),
        isFile: function(item) {
            return angular.isObject(item) && item instanceof $window.File;
        },
        isImage: function(file) {
            var type = "|" + file.type.slice(file.type.lastIndexOf("/") + 1) + "|";
            return -1 !== "|jpg|png|jpeg|bmp|gif|".indexOf(type);
        }
    };
    return {
        restrict: "A",
        template: "<canvas/>",
        link: function(scope, element, attributes) {
            function onLoadFile(event) {
                var img = new Image();
                img.onload = onLoadImage, img.src = event.target.result;
            }
            function onLoadImage() {
                var width = params.width || this.width / this.height * params.height, height = params.height || this.height / this.width * params.width;
                canvas.attr({
                    width: width,
                    height: height
                }), canvas[0].getContext("2d").drawImage(this, 0, 0, width, height);
            }
            if (helper.support) {
                var params = scope.$eval(attributes.ngThumb);
                if (helper.isFile(params.file) && helper.isImage(params.file)) {
                    var canvas = element.find("canvas"), reader = new FileReader();
                    reader.onload = onLoadFile, reader.readAsDataURL(params.file);
                }
            }
        }
    };
} ]), angular.module("app.core").directive("editForm", function($rootScope, CoreFile) {
    return {
        restrict: "A",
        templateUrl: "views/editForm.html",
        link: function($scope, $element, $attrs) {
            void 0 != $scope.file.filemime && ($scope.croppable = -1 != $scope.file.filemime.indexOf("image") && "none" != $rootScope.settings[$rootScope.activeField].cropRatio), 
            void 0 == $scope.file.$save && void 0 != $scope.file.fid && ($scope.file = CoreFile.load({
                fid: $scope.file.fid
            }), $scope.croppable = -1 != $scope.file.filemime.indexOf("image") && "none" != $rootScope.settings[$rootScope.activeField].cropRatio), 
            void 0 != $attrs.overwriteOnly && ($scope.overwriteOnly = !0), $scope.startEdit = function($event) {
                $scope.editing = !0, $event.preventDefault();
            }, $scope.stopEdit = function($event) {
                $scope.editing = !1, $event.preventDefault();
            }, $scope.saveFile = function($event) {
                $scope.file.$save(), $scope.editing = !1, $event.preventDefault();
            }, $scope.startCrop = function($event) {
                $scope.crop = !0, $scope.coords = [], $event.preventDefault();
            }, $scope.stopCrop = function($event) {
                $scope.crop = !1, $event.preventDefault();
            }, $scope.saveCrop = function(overwrite, $event) {
                var $jcrop = jQuery(".jcrop-holder"), params = {
                    width: $jcrop.width(),
                    height: $jcrop.height(),
                    coords: $scope.coords,
                    overwrite: overwrite
                };
                $scope.file.crop = JSON.stringify(params), $scope.file.$save(function(data) {
                    $scope.file = data, void 0 != $rootScope.activeKey && ($rootScope.files[$rootScope.activeField][$rootScope.activeKey] = data);
                }), $scope.crop = !1, $event.preventDefault();
            }, $scope.close = function($event) {
                $state.go("base"), $event.preventDefault();
            };
        }
    };
});