/**
 * @license AngularJS v1.2.28
 * (c) 2010-2014 Google, Inc. http://angularjs.org
 * License: MIT
 */
!function(window, document, undefined) {
    "use strict";
    function minErr(module) {
        return function() {
            var message, i, code = arguments[0], prefix = "[" + (module ? module + ":" : "") + code + "] ", template = arguments[1], templateArgs = arguments, stringify = function(obj) {
                return "function" == typeof obj ? obj.toString().replace(/ \{[\s\S]*$/, "") : "undefined" == typeof obj ? "undefined" : "string" != typeof obj ? JSON.stringify(obj) : obj;
            };
            for (message = prefix + template.replace(/\{\d+\}/g, function(match) {
                var arg, index = +match.slice(1, -1);
                return index + 2 < templateArgs.length ? (arg = templateArgs[index + 2], "function" == typeof arg ? arg.toString().replace(/ ?\{[\s\S]*$/, "") : "undefined" == typeof arg ? "undefined" : "string" != typeof arg ? toJson(arg) : arg) : match;
            }), message = message + "\nhttp://errors.angularjs.org/1.2.28/" + (module ? module + "/" : "") + code, 
            i = 2; i < arguments.length; i++) message = message + (2 == i ? "?" : "&") + "p" + (i - 2) + "=" + encodeURIComponent(stringify(arguments[i]));
            return new Error(message);
        };
    }
    function isArrayLike(obj) {
        if (null == obj || isWindow(obj)) return !1;
        var length = obj.length;
        return 1 === obj.nodeType && length ? !0 : isString(obj) || isArray(obj) || 0 === length || "number" == typeof length && length > 0 && length - 1 in obj;
    }
    function forEach(obj, iterator, context) {
        var key;
        if (obj) if (isFunction(obj)) for (key in obj) "prototype" == key || "length" == key || "name" == key || obj.hasOwnProperty && !obj.hasOwnProperty(key) || iterator.call(context, obj[key], key); else if (isArray(obj) || isArrayLike(obj)) for (key = 0; key < obj.length; key++) iterator.call(context, obj[key], key); else if (obj.forEach && obj.forEach !== forEach) obj.forEach(iterator, context); else for (key in obj) obj.hasOwnProperty(key) && iterator.call(context, obj[key], key);
        return obj;
    }
    function sortedKeys(obj) {
        var keys = [];
        for (var key in obj) obj.hasOwnProperty(key) && keys.push(key);
        return keys.sort();
    }
    function forEachSorted(obj, iterator, context) {
        for (var keys = sortedKeys(obj), i = 0; i < keys.length; i++) iterator.call(context, obj[keys[i]], keys[i]);
        return keys;
    }
    function reverseParams(iteratorFn) {
        return function(value, key) {
            iteratorFn(key, value);
        };
    }
    function nextUid() {
        for (var digit, index = uid.length; index; ) {
            if (index--, digit = uid[index].charCodeAt(0), 57 == digit) return uid[index] = "A", 
            uid.join("");
            if (90 != digit) return uid[index] = String.fromCharCode(digit + 1), uid.join("");
            uid[index] = "0";
        }
        return uid.unshift("0"), uid.join("");
    }
    function setHashKey(obj, h) {
        h ? obj.$$hashKey = h : delete obj.$$hashKey;
    }
    function extend(dst) {
        var h = dst.$$hashKey;
        return forEach(arguments, function(obj) {
            obj !== dst && forEach(obj, function(value, key) {
                dst[key] = value;
            });
        }), setHashKey(dst, h), dst;
    }
    function int(str) {
        return parseInt(str, 10);
    }
    function inherit(parent, extra) {
        return extend(new (extend(function() {}, {
            prototype: parent
        }))(), extra);
    }
    function noop() {}
    function identity($) {
        return $;
    }
    function valueFn(value) {
        return function() {
            return value;
        };
    }
    function isUndefined(value) {
        return "undefined" == typeof value;
    }
    function isDefined(value) {
        return "undefined" != typeof value;
    }
    function isObject(value) {
        return null != value && "object" == typeof value;
    }
    function isString(value) {
        return "string" == typeof value;
    }
    function isNumber(value) {
        return "number" == typeof value;
    }
    function isDate(value) {
        return "[object Date]" === toString.call(value);
    }
    function isFunction(value) {
        return "function" == typeof value;
    }
    function isRegExp(value) {
        return "[object RegExp]" === toString.call(value);
    }
    function isWindow(obj) {
        return obj && obj.document && obj.location && obj.alert && obj.setInterval;
    }
    function isScope(obj) {
        return obj && obj.$evalAsync && obj.$watch;
    }
    function isFile(obj) {
        return "[object File]" === toString.call(obj);
    }
    function isBlob(obj) {
        return "[object Blob]" === toString.call(obj);
    }
    function isPromiseLike(obj) {
        return obj && isFunction(obj.then);
    }
    function isElement(node) {
        return !(!node || !(node.nodeName || node.prop && node.attr && node.find));
    }
    function map(obj, iterator, context) {
        var results = [];
        return forEach(obj, function(value, index, list) {
            results.push(iterator.call(context, value, index, list));
        }), results;
    }
    function includes(array, obj) {
        return -1 != indexOf(array, obj);
    }
    function indexOf(array, obj) {
        if (array.indexOf) return array.indexOf(obj);
        for (var i = 0; i < array.length; i++) if (obj === array[i]) return i;
        return -1;
    }
    function arrayRemove(array, value) {
        var index = indexOf(array, value);
        return index >= 0 && array.splice(index, 1), value;
    }
    function copy(source, destination, stackSource, stackDest) {
        if (isWindow(source) || isScope(source)) throw ngMinErr("cpws", "Can't copy! Making copies of Window or Scope instances is not supported.");
        if (destination) {
            if (source === destination) throw ngMinErr("cpi", "Can't copy! Source and destination are identical.");
            if (stackSource = stackSource || [], stackDest = stackDest || [], isObject(source)) {
                var index = indexOf(stackSource, source);
                if (-1 !== index) return stackDest[index];
                stackSource.push(source), stackDest.push(destination);
            }
            var result;
            if (isArray(source)) {
                destination.length = 0;
                for (var i = 0; i < source.length; i++) result = copy(source[i], null, stackSource, stackDest), 
                isObject(source[i]) && (stackSource.push(source[i]), stackDest.push(result)), destination.push(result);
            } else {
                var h = destination.$$hashKey;
                isArray(destination) ? destination.length = 0 : forEach(destination, function(value, key) {
                    delete destination[key];
                });
                for (var key in source) result = copy(source[key], null, stackSource, stackDest), 
                isObject(source[key]) && (stackSource.push(source[key]), stackDest.push(result)), 
                destination[key] = result;
                setHashKey(destination, h);
            }
        } else destination = source, source && (isArray(source) ? destination = copy(source, [], stackSource, stackDest) : isDate(source) ? destination = new Date(source.getTime()) : isRegExp(source) ? (destination = new RegExp(source.source, source.toString().match(/[^\/]*$/)[0]), 
        destination.lastIndex = source.lastIndex) : isObject(source) && (destination = copy(source, {}, stackSource, stackDest)));
        return destination;
    }
    function shallowCopy(src, dst) {
        if (isArray(src)) {
            dst = dst || [];
            for (var i = 0; i < src.length; i++) dst[i] = src[i];
        } else if (isObject(src)) {
            dst = dst || {};
            for (var key in src) !hasOwnProperty.call(src, key) || "$" === key.charAt(0) && "$" === key.charAt(1) || (dst[key] = src[key]);
        }
        return dst || src;
    }
    function equals(o1, o2) {
        if (o1 === o2) return !0;
        if (null === o1 || null === o2) return !1;
        if (o1 !== o1 && o2 !== o2) return !0;
        var length, key, keySet, t1 = typeof o1, t2 = typeof o2;
        if (t1 == t2 && "object" == t1) {
            if (!isArray(o1)) {
                if (isDate(o1)) return isDate(o2) ? isNaN(o1.getTime()) && isNaN(o2.getTime()) || o1.getTime() === o2.getTime() : !1;
                if (isRegExp(o1) && isRegExp(o2)) return o1.toString() == o2.toString();
                if (isScope(o1) || isScope(o2) || isWindow(o1) || isWindow(o2) || isArray(o2)) return !1;
                keySet = {};
                for (key in o1) if ("$" !== key.charAt(0) && !isFunction(o1[key])) {
                    if (!equals(o1[key], o2[key])) return !1;
                    keySet[key] = !0;
                }
                for (key in o2) if (!keySet.hasOwnProperty(key) && "$" !== key.charAt(0) && o2[key] !== undefined && !isFunction(o2[key])) return !1;
                return !0;
            }
            if (!isArray(o2)) return !1;
            if ((length = o1.length) == o2.length) {
                for (key = 0; length > key; key++) if (!equals(o1[key], o2[key])) return !1;
                return !0;
            }
        }
        return !1;
    }
    function concat(array1, array2, index) {
        return array1.concat(slice.call(array2, index));
    }
    function sliceArgs(args, startIndex) {
        return slice.call(args, startIndex || 0);
    }
    function bind(self, fn) {
        var curryArgs = arguments.length > 2 ? sliceArgs(arguments, 2) : [];
        return !isFunction(fn) || fn instanceof RegExp ? fn : curryArgs.length ? function() {
            return arguments.length ? fn.apply(self, curryArgs.concat(slice.call(arguments, 0))) : fn.apply(self, curryArgs);
        } : function() {
            return arguments.length ? fn.apply(self, arguments) : fn.call(self);
        };
    }
    function toJsonReplacer(key, value) {
        var val = value;
        return "string" == typeof key && "$" === key.charAt(0) ? val = undefined : isWindow(value) ? val = "$WINDOW" : value && document === value ? val = "$DOCUMENT" : isScope(value) && (val = "$SCOPE"), 
        val;
    }
    function toJson(obj, pretty) {
        return "undefined" == typeof obj ? undefined : JSON.stringify(obj, toJsonReplacer, pretty ? "  " : null);
    }
    function fromJson(json) {
        return isString(json) ? JSON.parse(json) : json;
    }
    function toBoolean(value) {
        if ("function" == typeof value) value = !0; else if (value && 0 !== value.length) {
            var v = lowercase("" + value);
            value = !("f" == v || "0" == v || "false" == v || "no" == v || "n" == v || "[]" == v);
        } else value = !1;
        return value;
    }
    function startingTag(element) {
        element = jqLite(element).clone();
        try {
            element.empty();
        } catch (e) {}
        var TEXT_NODE = 3, elemHtml = jqLite("<div>").append(element).html();
        try {
            return element[0].nodeType === TEXT_NODE ? lowercase(elemHtml) : elemHtml.match(/^(<[^>]+>)/)[1].replace(/^<([\w\-]+)/, function(match, nodeName) {
                return "<" + lowercase(nodeName);
            });
        } catch (e) {
            return lowercase(elemHtml);
        }
    }
    function tryDecodeURIComponent(value) {
        try {
            return decodeURIComponent(value);
        } catch (e) {}
    }
    function parseKeyValue(keyValue) {
        var key_value, key, obj = {};
        return forEach((keyValue || "").split("&"), function(keyValue) {
            if (keyValue && (key_value = keyValue.replace(/\+/g, "%20").split("="), key = tryDecodeURIComponent(key_value[0]), 
            isDefined(key))) {
                var val = isDefined(key_value[1]) ? tryDecodeURIComponent(key_value[1]) : !0;
                hasOwnProperty.call(obj, key) ? isArray(obj[key]) ? obj[key].push(val) : obj[key] = [ obj[key], val ] : obj[key] = val;
            }
        }), obj;
    }
    function toKeyValue(obj) {
        var parts = [];
        return forEach(obj, function(value, key) {
            isArray(value) ? forEach(value, function(arrayValue) {
                parts.push(encodeUriQuery(key, !0) + (arrayValue === !0 ? "" : "=" + encodeUriQuery(arrayValue, !0)));
            }) : parts.push(encodeUriQuery(key, !0) + (value === !0 ? "" : "=" + encodeUriQuery(value, !0)));
        }), parts.length ? parts.join("&") : "";
    }
    function encodeUriSegment(val) {
        return encodeUriQuery(val, !0).replace(/%26/gi, "&").replace(/%3D/gi, "=").replace(/%2B/gi, "+");
    }
    function encodeUriQuery(val, pctEncodeSpaces) {
        return encodeURIComponent(val).replace(/%40/gi, "@").replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, pctEncodeSpaces ? "%20" : "+");
    }
    function angularInit(element, bootstrap) {
        function append(element) {
            element && elements.push(element);
        }
        var appElement, module, elements = [ element ], names = [ "ng:app", "ng-app", "x-ng-app", "data-ng-app" ], NG_APP_CLASS_REGEXP = /\sng[:\-]app(:\s*([\w\d_]+);?)?\s/;
        forEach(names, function(name) {
            names[name] = !0, append(document.getElementById(name)), name = name.replace(":", "\\:"), 
            element.querySelectorAll && (forEach(element.querySelectorAll("." + name), append), 
            forEach(element.querySelectorAll("." + name + "\\:"), append), forEach(element.querySelectorAll("[" + name + "]"), append));
        }), forEach(elements, function(element) {
            if (!appElement) {
                var className = " " + element.className + " ", match = NG_APP_CLASS_REGEXP.exec(className);
                match ? (appElement = element, module = (match[2] || "").replace(/\s+/g, ",")) : forEach(element.attributes, function(attr) {
                    !appElement && names[attr.name] && (appElement = element, module = attr.value);
                });
            }
        }), appElement && bootstrap(appElement, module ? [ module ] : []);
    }
    function bootstrap(element, modules) {
        var doBootstrap = function() {
            if (element = jqLite(element), element.injector()) {
                var tag = element[0] === document ? "document" : startingTag(element);
                throw ngMinErr("btstrpd", "App Already Bootstrapped with this Element '{0}'", tag.replace(/</, "&lt;").replace(/>/, "&gt;"));
            }
            modules = modules || [], modules.unshift([ "$provide", function($provide) {
                $provide.value("$rootElement", element);
            } ]), modules.unshift("ng");
            var injector = createInjector(modules);
            return injector.invoke([ "$rootScope", "$rootElement", "$compile", "$injector", "$animate", function(scope, element, compile, injector, animate) {
                scope.$apply(function() {
                    element.data("$injector", injector), compile(element)(scope);
                });
            } ]), injector;
        }, NG_DEFER_BOOTSTRAP = /^NG_DEFER_BOOTSTRAP!/;
        return window && !NG_DEFER_BOOTSTRAP.test(window.name) ? doBootstrap() : (window.name = window.name.replace(NG_DEFER_BOOTSTRAP, ""), 
        void (angular.resumeBootstrap = function(extraModules) {
            forEach(extraModules, function(module) {
                modules.push(module);
            }), doBootstrap();
        }));
    }
    function snake_case(name, separator) {
        return separator = separator || "_", name.replace(SNAKE_CASE_REGEXP, function(letter, pos) {
            return (pos ? separator : "") + letter.toLowerCase();
        });
    }
    function bindJQuery() {
        jQuery = window.jQuery, jQuery && jQuery.fn.on ? (jqLite = jQuery, extend(jQuery.fn, {
            scope: JQLitePrototype.scope,
            isolateScope: JQLitePrototype.isolateScope,
            controller: JQLitePrototype.controller,
            injector: JQLitePrototype.injector,
            inheritedData: JQLitePrototype.inheritedData
        }), jqLitePatchJQueryRemove("remove", !0, !0, !1), jqLitePatchJQueryRemove("empty", !1, !1, !1), 
        jqLitePatchJQueryRemove("html", !1, !1, !0)) : jqLite = JQLite, angular.element = jqLite;
    }
    function assertArg(arg, name, reason) {
        if (!arg) throw ngMinErr("areq", "Argument '{0}' is {1}", name || "?", reason || "required");
        return arg;
    }
    function assertArgFn(arg, name, acceptArrayAnnotation) {
        return acceptArrayAnnotation && isArray(arg) && (arg = arg[arg.length - 1]), assertArg(isFunction(arg), name, "not a function, got " + (arg && "object" == typeof arg ? arg.constructor.name || "Object" : typeof arg)), 
        arg;
    }
    function assertNotHasOwnProperty(name, context) {
        if ("hasOwnProperty" === name) throw ngMinErr("badname", "hasOwnProperty is not a valid {0} name", context);
    }
    function getter(obj, path, bindFnToScope) {
        if (!path) return obj;
        for (var key, keys = path.split("."), lastInstance = obj, len = keys.length, i = 0; len > i; i++) key = keys[i], 
        obj && (obj = (lastInstance = obj)[key]);
        return !bindFnToScope && isFunction(obj) ? bind(lastInstance, obj) : obj;
    }
    function getBlockElements(nodes) {
        var startNode = nodes[0], endNode = nodes[nodes.length - 1];
        if (startNode === endNode) return jqLite(startNode);
        var element = startNode, elements = [ element ];
        do {
            if (element = element.nextSibling, !element) break;
            elements.push(element);
        } while (element !== endNode);
        return jqLite(elements);
    }
    function setupModuleLoader(window) {
        function ensure(obj, name, factory) {
            return obj[name] || (obj[name] = factory());
        }
        var $injectorMinErr = minErr("$injector"), ngMinErr = minErr("ng"), angular = ensure(window, "angular", Object);
        return angular.$$minErr = angular.$$minErr || minErr, ensure(angular, "module", function() {
            var modules = {};
            return function(name, requires, configFn) {
                var assertNotHasOwnProperty = function(name, context) {
                    if ("hasOwnProperty" === name) throw ngMinErr("badname", "hasOwnProperty is not a valid {0} name", context);
                };
                return assertNotHasOwnProperty(name, "module"), requires && modules.hasOwnProperty(name) && (modules[name] = null), 
                ensure(modules, name, function() {
                    function invokeLater(provider, method, insertMethod) {
                        return function() {
                            return invokeQueue[insertMethod || "push"]([ provider, method, arguments ]), moduleInstance;
                        };
                    }
                    if (!requires) throw $injectorMinErr("nomod", "Module '{0}' is not available! You either misspelled the module name or forgot to load it. If registering a module ensure that you specify the dependencies as the second argument.", name);
                    var invokeQueue = [], runBlocks = [], config = invokeLater("$injector", "invoke"), moduleInstance = {
                        _invokeQueue: invokeQueue,
                        _runBlocks: runBlocks,
                        requires: requires,
                        name: name,
                        provider: invokeLater("$provide", "provider"),
                        factory: invokeLater("$provide", "factory"),
                        service: invokeLater("$provide", "service"),
                        value: invokeLater("$provide", "value"),
                        constant: invokeLater("$provide", "constant", "unshift"),
                        animation: invokeLater("$animateProvider", "register"),
                        filter: invokeLater("$filterProvider", "register"),
                        controller: invokeLater("$controllerProvider", "register"),
                        directive: invokeLater("$compileProvider", "directive"),
                        config: config,
                        run: function(block) {
                            return runBlocks.push(block), this;
                        }
                    };
                    return configFn && config(configFn), moduleInstance;
                });
            };
        });
    }
    function publishExternalAPI(angular) {
        extend(angular, {
            bootstrap: bootstrap,
            copy: copy,
            extend: extend,
            equals: equals,
            element: jqLite,
            forEach: forEach,
            injector: createInjector,
            noop: noop,
            bind: bind,
            toJson: toJson,
            fromJson: fromJson,
            identity: identity,
            isUndefined: isUndefined,
            isDefined: isDefined,
            isString: isString,
            isFunction: isFunction,
            isObject: isObject,
            isNumber: isNumber,
            isElement: isElement,
            isArray: isArray,
            version: version,
            isDate: isDate,
            lowercase: lowercase,
            uppercase: uppercase,
            callbacks: {
                counter: 0
            },
            $$minErr: minErr,
            $$csp: csp
        }), angularModule = setupModuleLoader(window);
        try {
            angularModule("ngLocale");
        } catch (e) {
            angularModule("ngLocale", []).provider("$locale", $LocaleProvider);
        }
        angularModule("ng", [ "ngLocale" ], [ "$provide", function($provide) {
            $provide.provider({
                $$sanitizeUri: $$SanitizeUriProvider
            }), $provide.provider("$compile", $CompileProvider).directive({
                a: htmlAnchorDirective,
                input: inputDirective,
                textarea: inputDirective,
                form: formDirective,
                script: scriptDirective,
                select: selectDirective,
                style: styleDirective,
                option: optionDirective,
                ngBind: ngBindDirective,
                ngBindHtml: ngBindHtmlDirective,
                ngBindTemplate: ngBindTemplateDirective,
                ngClass: ngClassDirective,
                ngClassEven: ngClassEvenDirective,
                ngClassOdd: ngClassOddDirective,
                ngCloak: ngCloakDirective,
                ngController: ngControllerDirective,
                ngForm: ngFormDirective,
                ngHide: ngHideDirective,
                ngIf: ngIfDirective,
                ngInclude: ngIncludeDirective,
                ngInit: ngInitDirective,
                ngNonBindable: ngNonBindableDirective,
                ngPluralize: ngPluralizeDirective,
                ngRepeat: ngRepeatDirective,
                ngShow: ngShowDirective,
                ngStyle: ngStyleDirective,
                ngSwitch: ngSwitchDirective,
                ngSwitchWhen: ngSwitchWhenDirective,
                ngSwitchDefault: ngSwitchDefaultDirective,
                ngOptions: ngOptionsDirective,
                ngTransclude: ngTranscludeDirective,
                ngModel: ngModelDirective,
                ngList: ngListDirective,
                ngChange: ngChangeDirective,
                required: requiredDirective,
                ngRequired: requiredDirective,
                ngValue: ngValueDirective
            }).directive({
                ngInclude: ngIncludeFillContentDirective
            }).directive(ngAttributeAliasDirectives).directive(ngEventDirectives), $provide.provider({
                $anchorScroll: $AnchorScrollProvider,
                $animate: $AnimateProvider,
                $browser: $BrowserProvider,
                $cacheFactory: $CacheFactoryProvider,
                $controller: $ControllerProvider,
                $document: $DocumentProvider,
                $exceptionHandler: $ExceptionHandlerProvider,
                $filter: $FilterProvider,
                $interpolate: $InterpolateProvider,
                $interval: $IntervalProvider,
                $http: $HttpProvider,
                $httpBackend: $HttpBackendProvider,
                $location: $LocationProvider,
                $log: $LogProvider,
                $parse: $ParseProvider,
                $rootScope: $RootScopeProvider,
                $q: $QProvider,
                $sce: $SceProvider,
                $sceDelegate: $SceDelegateProvider,
                $sniffer: $SnifferProvider,
                $templateCache: $TemplateCacheProvider,
                $timeout: $TimeoutProvider,
                $window: $WindowProvider,
                $$rAF: $$RAFProvider,
                $$asyncCallback: $$AsyncCallbackProvider
            });
        } ]);
    }
    function jqNextId() {
        return ++jqId;
    }
    function camelCase(name) {
        return name.replace(SPECIAL_CHARS_REGEXP, function(_, separator, letter, offset) {
            return offset ? letter.toUpperCase() : letter;
        }).replace(MOZ_HACK_REGEXP, "Moz$1");
    }
    function jqLitePatchJQueryRemove(name, dispatchThis, filterElems, getterIfNoArguments) {
        function removePatch(param) {
            var set, setIndex, setLength, element, childIndex, childLength, children, list = filterElems && param ? [ this.filter(param) ] : [ this ], fireEvent = dispatchThis;
            if (!getterIfNoArguments || null != param) for (;list.length; ) for (set = list.shift(), 
            setIndex = 0, setLength = set.length; setLength > setIndex; setIndex++) for (element = jqLite(set[setIndex]), 
            fireEvent ? element.triggerHandler("$destroy") : fireEvent = !fireEvent, childIndex = 0, 
            childLength = (children = element.children()).length; childLength > childIndex; childIndex++) list.push(jQuery(children[childIndex]));
            return originalJqFn.apply(this, arguments);
        }
        var originalJqFn = jQuery.fn[name];
        originalJqFn = originalJqFn.$original || originalJqFn, removePatch.$original = originalJqFn, 
        jQuery.fn[name] = removePatch;
    }
    function jqLiteIsTextNode(html) {
        return !HTML_REGEXP.test(html);
    }
    function jqLiteBuildFragment(html, context) {
        var tmp, tag, wrap, i, j, jj, fragment = context.createDocumentFragment(), nodes = [];
        if (jqLiteIsTextNode(html)) nodes.push(context.createTextNode(html)); else {
            for (tmp = fragment.appendChild(context.createElement("div")), tag = (TAG_NAME_REGEXP.exec(html) || [ "", "" ])[1].toLowerCase(), 
            wrap = wrapMap[tag] || wrapMap._default, tmp.innerHTML = "<div>&#160;</div>" + wrap[1] + html.replace(XHTML_TAG_REGEXP, "<$1></$2>") + wrap[2], 
            tmp.removeChild(tmp.firstChild), i = wrap[0]; i--; ) tmp = tmp.lastChild;
            for (j = 0, jj = tmp.childNodes.length; jj > j; ++j) nodes.push(tmp.childNodes[j]);
            tmp = fragment.firstChild, tmp.textContent = "";
        }
        return fragment.textContent = "", fragment.innerHTML = "", nodes;
    }
    function jqLiteParseHTML(html, context) {
        context = context || document;
        var parsed;
        return (parsed = SINGLE_TAG_REGEXP.exec(html)) ? [ context.createElement(parsed[1]) ] : jqLiteBuildFragment(html, context);
    }
    function JQLite(element) {
        if (element instanceof JQLite) return element;
        if (isString(element) && (element = trim(element)), !(this instanceof JQLite)) {
            if (isString(element) && "<" != element.charAt(0)) throw jqLiteMinErr("nosel", "Looking up elements via selectors is not supported by jqLite! See: http://docs.angularjs.org/api/angular.element");
            return new JQLite(element);
        }
        if (isString(element)) {
            jqLiteAddNodes(this, jqLiteParseHTML(element));
            var fragment = jqLite(document.createDocumentFragment());
            fragment.append(this);
        } else jqLiteAddNodes(this, element);
    }
    function jqLiteClone(element) {
        return element.cloneNode(!0);
    }
    function jqLiteDealoc(element) {
        jqLiteRemoveData(element);
        for (var i = 0, children = element.childNodes || []; i < children.length; i++) jqLiteDealoc(children[i]);
    }
    function jqLiteOff(element, type, fn, unsupported) {
        if (isDefined(unsupported)) throw jqLiteMinErr("offargs", "jqLite#off() does not support the `selector` argument");
        var events = jqLiteExpandoStore(element, "events"), handle = jqLiteExpandoStore(element, "handle");
        handle && (isUndefined(type) ? forEach(events, function(eventHandler, type) {
            removeEventListenerFn(element, type, eventHandler), delete events[type];
        }) : forEach(type.split(" "), function(type) {
            isUndefined(fn) ? (removeEventListenerFn(element, type, events[type]), delete events[type]) : arrayRemove(events[type] || [], fn);
        }));
    }
    function jqLiteRemoveData(element, name) {
        var expandoId = element.ng339, expandoStore = jqCache[expandoId];
        if (expandoStore) {
            if (name) return void delete jqCache[expandoId].data[name];
            expandoStore.handle && (expandoStore.events.$destroy && expandoStore.handle({}, "$destroy"), 
            jqLiteOff(element)), delete jqCache[expandoId], element.ng339 = undefined;
        }
    }
    function jqLiteExpandoStore(element, key, value) {
        var expandoId = element.ng339, expandoStore = jqCache[expandoId || -1];
        return isDefined(value) ? (expandoStore || (element.ng339 = expandoId = jqNextId(), 
        expandoStore = jqCache[expandoId] = {}), void (expandoStore[key] = value)) : expandoStore && expandoStore[key];
    }
    function jqLiteData(element, key, value) {
        var data = jqLiteExpandoStore(element, "data"), isSetter = isDefined(value), keyDefined = !isSetter && isDefined(key), isSimpleGetter = keyDefined && !isObject(key);
        if (data || isSimpleGetter || jqLiteExpandoStore(element, "data", data = {}), isSetter) data[key] = value; else {
            if (!keyDefined) return data;
            if (isSimpleGetter) return data && data[key];
            extend(data, key);
        }
    }
    function jqLiteHasClass(element, selector) {
        return element.getAttribute ? (" " + (element.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").indexOf(" " + selector + " ") > -1 : !1;
    }
    function jqLiteRemoveClass(element, cssClasses) {
        cssClasses && element.setAttribute && forEach(cssClasses.split(" "), function(cssClass) {
            element.setAttribute("class", trim((" " + (element.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").replace(" " + trim(cssClass) + " ", " ")));
        });
    }
    function jqLiteAddClass(element, cssClasses) {
        if (cssClasses && element.setAttribute) {
            var existingClasses = (" " + (element.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ");
            forEach(cssClasses.split(" "), function(cssClass) {
                cssClass = trim(cssClass), -1 === existingClasses.indexOf(" " + cssClass + " ") && (existingClasses += cssClass + " ");
            }), element.setAttribute("class", trim(existingClasses));
        }
    }
    function jqLiteAddNodes(root, elements) {
        if (elements) {
            elements = elements.nodeName || !isDefined(elements.length) || isWindow(elements) ? [ elements ] : elements;
            for (var i = 0; i < elements.length; i++) root.push(elements[i]);
        }
    }
    function jqLiteController(element, name) {
        return jqLiteInheritedData(element, "$" + (name || "ngController") + "Controller");
    }
    function jqLiteInheritedData(element, name, value) {
        9 == element.nodeType && (element = element.documentElement);
        for (var names = isArray(name) ? name : [ name ]; element; ) {
            for (var i = 0, ii = names.length; ii > i; i++) if ((value = jqLite.data(element, names[i])) !== undefined) return value;
            element = element.parentNode || 11 === element.nodeType && element.host;
        }
    }
    function jqLiteEmpty(element) {
        for (var i = 0, childNodes = element.childNodes; i < childNodes.length; i++) jqLiteDealoc(childNodes[i]);
        for (;element.firstChild; ) element.removeChild(element.firstChild);
    }
    function getBooleanAttrName(element, name) {
        var booleanAttr = BOOLEAN_ATTR[name.toLowerCase()];
        return booleanAttr && BOOLEAN_ELEMENTS[element.nodeName] && booleanAttr;
    }
    function createEventHandler(element, events) {
        var eventHandler = function(event, type) {
            if (event.preventDefault || (event.preventDefault = function() {
                event.returnValue = !1;
            }), event.stopPropagation || (event.stopPropagation = function() {
                event.cancelBubble = !0;
            }), event.target || (event.target = event.srcElement || document), isUndefined(event.defaultPrevented)) {
                var prevent = event.preventDefault;
                event.preventDefault = function() {
                    event.defaultPrevented = !0, prevent.call(event);
                }, event.defaultPrevented = !1;
            }
            event.isDefaultPrevented = function() {
                return event.defaultPrevented || event.returnValue === !1;
            };
            var eventHandlersCopy = shallowCopy(events[type || event.type] || []);
            forEach(eventHandlersCopy, function(fn) {
                fn.call(element, event);
            }), 8 >= msie ? (event.preventDefault = null, event.stopPropagation = null, event.isDefaultPrevented = null) : (delete event.preventDefault, 
            delete event.stopPropagation, delete event.isDefaultPrevented);
        };
        return eventHandler.elem = element, eventHandler;
    }
    function hashKey(obj, nextUidFn) {
        var key, objType = typeof obj;
        return "function" == objType || "object" == objType && null !== obj ? "function" == typeof (key = obj.$$hashKey) ? key = obj.$$hashKey() : key === undefined && (key = obj.$$hashKey = (nextUidFn || nextUid)()) : key = obj, 
        objType + ":" + key;
    }
    function HashMap(array, isolatedUid) {
        if (isolatedUid) {
            var uid = 0;
            this.nextUid = function() {
                return ++uid;
            };
        }
        forEach(array, this.put, this);
    }
    function annotate(fn) {
        var $inject, fnText, argDecl, last;
        return "function" == typeof fn ? ($inject = fn.$inject) || ($inject = [], fn.length && (fnText = fn.toString().replace(STRIP_COMMENTS, ""), 
        argDecl = fnText.match(FN_ARGS), forEach(argDecl[1].split(FN_ARG_SPLIT), function(arg) {
            arg.replace(FN_ARG, function(all, underscore, name) {
                $inject.push(name);
            });
        })), fn.$inject = $inject) : isArray(fn) ? (last = fn.length - 1, assertArgFn(fn[last], "fn"), 
        $inject = fn.slice(0, last)) : assertArgFn(fn, "fn", !0), $inject;
    }
    function createInjector(modulesToLoad) {
        function supportObject(delegate) {
            return function(key, value) {
                return isObject(key) ? void forEach(key, reverseParams(delegate)) : delegate(key, value);
            };
        }
        function provider(name, provider_) {
            if (assertNotHasOwnProperty(name, "service"), (isFunction(provider_) || isArray(provider_)) && (provider_ = providerInjector.instantiate(provider_)), 
            !provider_.$get) throw $injectorMinErr("pget", "Provider '{0}' must define $get factory method.", name);
            return providerCache[name + providerSuffix] = provider_;
        }
        function factory(name, factoryFn) {
            return provider(name, {
                $get: factoryFn
            });
        }
        function service(name, constructor) {
            return factory(name, [ "$injector", function($injector) {
                return $injector.instantiate(constructor);
            } ]);
        }
        function value(name, val) {
            return factory(name, valueFn(val));
        }
        function constant(name, value) {
            assertNotHasOwnProperty(name, "constant"), providerCache[name] = value, instanceCache[name] = value;
        }
        function decorator(serviceName, decorFn) {
            var origProvider = providerInjector.get(serviceName + providerSuffix), orig$get = origProvider.$get;
            origProvider.$get = function() {
                var origInstance = instanceInjector.invoke(orig$get, origProvider);
                return instanceInjector.invoke(decorFn, null, {
                    $delegate: origInstance
                });
            };
        }
        function loadModules(modulesToLoad) {
            var moduleFn, invokeQueue, i, ii, runBlocks = [];
            return forEach(modulesToLoad, function(module) {
                if (!loadedModules.get(module)) {
                    loadedModules.put(module, !0);
                    try {
                        if (isString(module)) for (moduleFn = angularModule(module), runBlocks = runBlocks.concat(loadModules(moduleFn.requires)).concat(moduleFn._runBlocks), 
                        invokeQueue = moduleFn._invokeQueue, i = 0, ii = invokeQueue.length; ii > i; i++) {
                            var invokeArgs = invokeQueue[i], provider = providerInjector.get(invokeArgs[0]);
                            provider[invokeArgs[1]].apply(provider, invokeArgs[2]);
                        } else isFunction(module) ? runBlocks.push(providerInjector.invoke(module)) : isArray(module) ? runBlocks.push(providerInjector.invoke(module)) : assertArgFn(module, "module");
                    } catch (e) {
                        throw isArray(module) && (module = module[module.length - 1]), e.message && e.stack && -1 == e.stack.indexOf(e.message) && (e = e.message + "\n" + e.stack), 
                        $injectorMinErr("modulerr", "Failed to instantiate module {0} due to:\n{1}", module, e.stack || e.message || e);
                    }
                }
            }), runBlocks;
        }
        function createInternalInjector(cache, factory) {
            function getService(serviceName) {
                if (cache.hasOwnProperty(serviceName)) {
                    if (cache[serviceName] === INSTANTIATING) throw $injectorMinErr("cdep", "Circular dependency found: {0}", serviceName + " <- " + path.join(" <- "));
                    return cache[serviceName];
                }
                try {
                    return path.unshift(serviceName), cache[serviceName] = INSTANTIATING, cache[serviceName] = factory(serviceName);
                } catch (err) {
                    throw cache[serviceName] === INSTANTIATING && delete cache[serviceName], err;
                } finally {
                    path.shift();
                }
            }
            function invoke(fn, self, locals) {
                var length, i, key, args = [], $inject = annotate(fn);
                for (i = 0, length = $inject.length; length > i; i++) {
                    if (key = $inject[i], "string" != typeof key) throw $injectorMinErr("itkn", "Incorrect injection token! Expected service name as string, got {0}", key);
                    args.push(locals && locals.hasOwnProperty(key) ? locals[key] : getService(key));
                }
                return isArray(fn) && (fn = fn[length]), fn.apply(self, args);
            }
            function instantiate(Type, locals) {
                var instance, returnedValue, Constructor = function() {};
                return Constructor.prototype = (isArray(Type) ? Type[Type.length - 1] : Type).prototype, 
                instance = new Constructor(), returnedValue = invoke(Type, instance, locals), isObject(returnedValue) || isFunction(returnedValue) ? returnedValue : instance;
            }
            return {
                invoke: invoke,
                instantiate: instantiate,
                get: getService,
                annotate: annotate,
                has: function(name) {
                    return providerCache.hasOwnProperty(name + providerSuffix) || cache.hasOwnProperty(name);
                }
            };
        }
        var INSTANTIATING = {}, providerSuffix = "Provider", path = [], loadedModules = new HashMap([], !0), providerCache = {
            $provide: {
                provider: supportObject(provider),
                factory: supportObject(factory),
                service: supportObject(service),
                value: supportObject(value),
                constant: supportObject(constant),
                decorator: decorator
            }
        }, providerInjector = providerCache.$injector = createInternalInjector(providerCache, function() {
            throw $injectorMinErr("unpr", "Unknown provider: {0}", path.join(" <- "));
        }), instanceCache = {}, instanceInjector = instanceCache.$injector = createInternalInjector(instanceCache, function(servicename) {
            var provider = providerInjector.get(servicename + providerSuffix);
            return instanceInjector.invoke(provider.$get, provider);
        });
        return forEach(loadModules(modulesToLoad), function(fn) {
            instanceInjector.invoke(fn || noop);
        }), instanceInjector;
    }
    function $AnchorScrollProvider() {
        var autoScrollingEnabled = !0;
        this.disableAutoScrolling = function() {
            autoScrollingEnabled = !1;
        }, this.$get = [ "$window", "$location", "$rootScope", function($window, $location, $rootScope) {
            function getFirstAnchor(list) {
                var result = null;
                return forEach(list, function(element) {
                    result || "a" !== lowercase(element.nodeName) || (result = element);
                }), result;
            }
            function scroll() {
                var elm, hash = $location.hash();
                hash ? (elm = document.getElementById(hash)) ? elm.scrollIntoView() : (elm = getFirstAnchor(document.getElementsByName(hash))) ? elm.scrollIntoView() : "top" === hash && $window.scrollTo(0, 0) : $window.scrollTo(0, 0);
            }
            var document = $window.document;
            return autoScrollingEnabled && $rootScope.$watch(function() {
                return $location.hash();
            }, function() {
                $rootScope.$evalAsync(scroll);
            }), scroll;
        } ];
    }
    function $$AsyncCallbackProvider() {
        this.$get = [ "$$rAF", "$timeout", function($$rAF, $timeout) {
            return $$rAF.supported ? function(fn) {
                return $$rAF(fn);
            } : function(fn) {
                return $timeout(fn, 0, !1);
            };
        } ];
    }
    function Browser(window, document, $log, $sniffer) {
        function completeOutstandingRequest(fn) {
            try {
                fn.apply(null, sliceArgs(arguments, 1));
            } finally {
                if (outstandingRequestCount--, 0 === outstandingRequestCount) for (;outstandingRequestCallbacks.length; ) try {
                    outstandingRequestCallbacks.pop()();
                } catch (e) {
                    $log.error(e);
                }
            }
        }
        function startPoller(interval, setTimeout) {
            !function check() {
                forEach(pollFns, function(pollFn) {
                    pollFn();
                }), pollTimeout = setTimeout(check, interval);
            }();
        }
        function fireUrlChange() {
            lastBrowserUrl != self.url() && (lastBrowserUrl = self.url(), forEach(urlChangeListeners, function(listener) {
                listener(self.url());
            }));
        }
        var self = this, rawDocument = document[0], location = window.location, history = window.history, setTimeout = window.setTimeout, clearTimeout = window.clearTimeout, pendingDeferIds = {};
        self.isMock = !1;
        var outstandingRequestCount = 0, outstandingRequestCallbacks = [];
        self.$$completeOutstandingRequest = completeOutstandingRequest, self.$$incOutstandingRequestCount = function() {
            outstandingRequestCount++;
        }, self.notifyWhenNoOutstandingRequests = function(callback) {
            forEach(pollFns, function(pollFn) {
                pollFn();
            }), 0 === outstandingRequestCount ? callback() : outstandingRequestCallbacks.push(callback);
        };
        var pollTimeout, pollFns = [];
        self.addPollFn = function(fn) {
            return isUndefined(pollTimeout) && startPoller(100, setTimeout), pollFns.push(fn), 
            fn;
        };
        var lastBrowserUrl = location.href, baseElement = document.find("base"), reloadLocation = null;
        self.url = function(url, replace) {
            if (location !== window.location && (location = window.location), history !== window.history && (history = window.history), 
            url) {
                if (lastBrowserUrl == url) return;
                var sameBase = lastBrowserUrl && stripHash(lastBrowserUrl) === stripHash(url);
                return lastBrowserUrl = url, !sameBase && $sniffer.history ? replace ? history.replaceState(null, "", url) : (history.pushState(null, "", url), 
                baseElement.attr("href", baseElement.attr("href"))) : (sameBase || (reloadLocation = url), 
                replace ? location.replace(url) : location.href = url), self;
            }
            return reloadLocation || location.href.replace(/%27/g, "'");
        };
        var urlChangeListeners = [], urlChangeInit = !1;
        self.onUrlChange = function(callback) {
            return urlChangeInit || ($sniffer.history && jqLite(window).on("popstate", fireUrlChange), 
            $sniffer.hashchange ? jqLite(window).on("hashchange", fireUrlChange) : self.addPollFn(fireUrlChange), 
            urlChangeInit = !0), urlChangeListeners.push(callback), callback;
        }, self.$$checkUrlChange = fireUrlChange, self.baseHref = function() {
            var href = baseElement.attr("href");
            return href ? href.replace(/^(https?\:)?\/\/[^\/]*/, "") : "";
        };
        var lastCookies = {}, lastCookieString = "", cookiePath = self.baseHref();
        self.cookies = function(name, value) {
            var cookieLength, cookieArray, cookie, i, index;
            if (!name) {
                if (rawDocument.cookie !== lastCookieString) for (lastCookieString = rawDocument.cookie, 
                cookieArray = lastCookieString.split("; "), lastCookies = {}, i = 0; i < cookieArray.length; i++) cookie = cookieArray[i], 
                index = cookie.indexOf("="), index > 0 && (name = unescape(cookie.substring(0, index)), 
                lastCookies[name] === undefined && (lastCookies[name] = unescape(cookie.substring(index + 1))));
                return lastCookies;
            }
            value === undefined ? rawDocument.cookie = escape(name) + "=;path=" + cookiePath + ";expires=Thu, 01 Jan 1970 00:00:00 GMT" : isString(value) && (cookieLength = (rawDocument.cookie = escape(name) + "=" + escape(value) + ";path=" + cookiePath).length + 1, 
            cookieLength > 4096 && $log.warn("Cookie '" + name + "' possibly not set or overflowed because it was too large (" + cookieLength + " > 4096 bytes)!"));
        }, self.defer = function(fn, delay) {
            var timeoutId;
            return outstandingRequestCount++, timeoutId = setTimeout(function() {
                delete pendingDeferIds[timeoutId], completeOutstandingRequest(fn);
            }, delay || 0), pendingDeferIds[timeoutId] = !0, timeoutId;
        }, self.defer.cancel = function(deferId) {
            return pendingDeferIds[deferId] ? (delete pendingDeferIds[deferId], clearTimeout(deferId), 
            completeOutstandingRequest(noop), !0) : !1;
        };
    }
    function $BrowserProvider() {
        this.$get = [ "$window", "$log", "$sniffer", "$document", function($window, $log, $sniffer, $document) {
            return new Browser($window, $document, $log, $sniffer);
        } ];
    }
    function $CacheFactoryProvider() {
        this.$get = function() {
            function cacheFactory(cacheId, options) {
                function refresh(entry) {
                    entry != freshEnd && (staleEnd ? staleEnd == entry && (staleEnd = entry.n) : staleEnd = entry, 
                    link(entry.n, entry.p), link(entry, freshEnd), freshEnd = entry, freshEnd.n = null);
                }
                function link(nextEntry, prevEntry) {
                    nextEntry != prevEntry && (nextEntry && (nextEntry.p = prevEntry), prevEntry && (prevEntry.n = nextEntry));
                }
                if (cacheId in caches) throw minErr("$cacheFactory")("iid", "CacheId '{0}' is already taken!", cacheId);
                var size = 0, stats = extend({}, options, {
                    id: cacheId
                }), data = {}, capacity = options && options.capacity || Number.MAX_VALUE, lruHash = {}, freshEnd = null, staleEnd = null;
                return caches[cacheId] = {
                    put: function(key, value) {
                        if (capacity < Number.MAX_VALUE) {
                            var lruEntry = lruHash[key] || (lruHash[key] = {
                                key: key
                            });
                            refresh(lruEntry);
                        }
                        if (!isUndefined(value)) return key in data || size++, data[key] = value, size > capacity && this.remove(staleEnd.key), 
                        value;
                    },
                    get: function(key) {
                        if (capacity < Number.MAX_VALUE) {
                            var lruEntry = lruHash[key];
                            if (!lruEntry) return;
                            refresh(lruEntry);
                        }
                        return data[key];
                    },
                    remove: function(key) {
                        if (capacity < Number.MAX_VALUE) {
                            var lruEntry = lruHash[key];
                            if (!lruEntry) return;
                            lruEntry == freshEnd && (freshEnd = lruEntry.p), lruEntry == staleEnd && (staleEnd = lruEntry.n), 
                            link(lruEntry.n, lruEntry.p), delete lruHash[key];
                        }
                        delete data[key], size--;
                    },
                    removeAll: function() {
                        data = {}, size = 0, lruHash = {}, freshEnd = staleEnd = null;
                    },
                    destroy: function() {
                        data = null, stats = null, lruHash = null, delete caches[cacheId];
                    },
                    info: function() {
                        return extend({}, stats, {
                            size: size
                        });
                    }
                };
            }
            var caches = {};
            return cacheFactory.info = function() {
                var info = {};
                return forEach(caches, function(cache, cacheId) {
                    info[cacheId] = cache.info();
                }), info;
            }, cacheFactory.get = function(cacheId) {
                return caches[cacheId];
            }, cacheFactory;
        };
    }
    function $TemplateCacheProvider() {
        this.$get = [ "$cacheFactory", function($cacheFactory) {
            return $cacheFactory("templates");
        } ];
    }
    function $CompileProvider($provide, $$sanitizeUriProvider) {
        var hasDirectives = {}, Suffix = "Directive", COMMENT_DIRECTIVE_REGEXP = /^\s*directive\:\s*([\d\w_\-]+)\s+(.*)$/, CLASS_DIRECTIVE_REGEXP = /(([\d\w_\-]+)(?:\:([^;]+))?;?)/, EVENT_HANDLER_ATTR_REGEXP = /^(on[a-z]+|formaction)$/;
        this.directive = function registerDirective(name, directiveFactory) {
            return assertNotHasOwnProperty(name, "directive"), isString(name) ? (assertArg(directiveFactory, "directiveFactory"), 
            hasDirectives.hasOwnProperty(name) || (hasDirectives[name] = [], $provide.factory(name + Suffix, [ "$injector", "$exceptionHandler", function($injector, $exceptionHandler) {
                var directives = [];
                return forEach(hasDirectives[name], function(directiveFactory, index) {
                    try {
                        var directive = $injector.invoke(directiveFactory);
                        isFunction(directive) ? directive = {
                            compile: valueFn(directive)
                        } : !directive.compile && directive.link && (directive.compile = valueFn(directive.link)), 
                        directive.priority = directive.priority || 0, directive.index = index, directive.name = directive.name || name, 
                        directive.require = directive.require || directive.controller && directive.name, 
                        directive.restrict = directive.restrict || "A", directives.push(directive);
                    } catch (e) {
                        $exceptionHandler(e);
                    }
                }), directives;
            } ])), hasDirectives[name].push(directiveFactory)) : forEach(name, reverseParams(registerDirective)), 
            this;
        }, this.aHrefSanitizationWhitelist = function(regexp) {
            return isDefined(regexp) ? ($$sanitizeUriProvider.aHrefSanitizationWhitelist(regexp), 
            this) : $$sanitizeUriProvider.aHrefSanitizationWhitelist();
        }, this.imgSrcSanitizationWhitelist = function(regexp) {
            return isDefined(regexp) ? ($$sanitizeUriProvider.imgSrcSanitizationWhitelist(regexp), 
            this) : $$sanitizeUriProvider.imgSrcSanitizationWhitelist();
        }, this.$get = [ "$injector", "$interpolate", "$exceptionHandler", "$http", "$templateCache", "$parse", "$controller", "$rootScope", "$document", "$sce", "$animate", "$$sanitizeUri", function($injector, $interpolate, $exceptionHandler, $http, $templateCache, $parse, $controller, $rootScope, $document, $sce, $animate, $$sanitizeUri) {
            function compile($compileNodes, transcludeFn, maxPriority, ignoreDirective, previousCompileContext) {
                $compileNodes instanceof jqLite || ($compileNodes = jqLite($compileNodes)), forEach($compileNodes, function(node, index) {
                    3 == node.nodeType && node.nodeValue.match(/\S+/) && ($compileNodes[index] = node = jqLite(node).wrap("<span></span>").parent()[0]);
                });
                var compositeLinkFn = compileNodes($compileNodes, transcludeFn, $compileNodes, maxPriority, ignoreDirective, previousCompileContext);
                return safeAddClass($compileNodes, "ng-scope"), function(scope, cloneConnectFn, transcludeControllers, parentBoundTranscludeFn) {
                    assertArg(scope, "scope");
                    var $linkNode = cloneConnectFn ? JQLitePrototype.clone.call($compileNodes) : $compileNodes;
                    forEach(transcludeControllers, function(instance, name) {
                        $linkNode.data("$" + name + "Controller", instance);
                    });
                    for (var i = 0, ii = $linkNode.length; ii > i; i++) {
                        var node = $linkNode[i], nodeType = node.nodeType;
                        (1 === nodeType || 9 === nodeType) && $linkNode.eq(i).data("$scope", scope);
                    }
                    return cloneConnectFn && cloneConnectFn($linkNode, scope), compositeLinkFn && compositeLinkFn(scope, $linkNode, $linkNode, parentBoundTranscludeFn), 
                    $linkNode;
                };
            }
            function safeAddClass($element, className) {
                try {
                    $element.addClass(className);
                } catch (e) {}
            }
            function compileNodes(nodeList, transcludeFn, $rootElement, maxPriority, ignoreDirective, previousCompileContext) {
                function compositeLinkFn(scope, nodeList, $rootElement, parentBoundTranscludeFn) {
                    var nodeLinkFn, childLinkFn, node, childScope, i, ii, n, childBoundTranscludeFn, nodeListLength = nodeList.length, stableNodeList = new Array(nodeListLength);
                    for (i = 0; nodeListLength > i; i++) stableNodeList[i] = nodeList[i];
                    for (i = 0, n = 0, ii = linkFns.length; ii > i; n++) node = stableNodeList[n], nodeLinkFn = linkFns[i++], 
                    childLinkFn = linkFns[i++], nodeLinkFn ? (nodeLinkFn.scope ? (childScope = scope.$new(), 
                    jqLite.data(node, "$scope", childScope)) : childScope = scope, childBoundTranscludeFn = nodeLinkFn.transcludeOnThisElement ? createBoundTranscludeFn(scope, nodeLinkFn.transclude, parentBoundTranscludeFn) : !nodeLinkFn.templateOnThisElement && parentBoundTranscludeFn ? parentBoundTranscludeFn : !parentBoundTranscludeFn && transcludeFn ? createBoundTranscludeFn(scope, transcludeFn) : null, 
                    nodeLinkFn(childLinkFn, childScope, node, $rootElement, childBoundTranscludeFn)) : childLinkFn && childLinkFn(scope, node.childNodes, undefined, parentBoundTranscludeFn);
                }
                for (var attrs, directives, nodeLinkFn, childNodes, childLinkFn, linkFnFound, linkFns = [], i = 0; i < nodeList.length; i++) attrs = new Attributes(), 
                directives = collectDirectives(nodeList[i], [], attrs, 0 === i ? maxPriority : undefined, ignoreDirective), 
                nodeLinkFn = directives.length ? applyDirectivesToNode(directives, nodeList[i], attrs, transcludeFn, $rootElement, null, [], [], previousCompileContext) : null, 
                nodeLinkFn && nodeLinkFn.scope && safeAddClass(attrs.$$element, "ng-scope"), childLinkFn = nodeLinkFn && nodeLinkFn.terminal || !(childNodes = nodeList[i].childNodes) || !childNodes.length ? null : compileNodes(childNodes, nodeLinkFn ? (nodeLinkFn.transcludeOnThisElement || !nodeLinkFn.templateOnThisElement) && nodeLinkFn.transclude : transcludeFn), 
                linkFns.push(nodeLinkFn, childLinkFn), linkFnFound = linkFnFound || nodeLinkFn || childLinkFn, 
                previousCompileContext = null;
                return linkFnFound ? compositeLinkFn : null;
            }
            function createBoundTranscludeFn(scope, transcludeFn, previousBoundTranscludeFn) {
                var boundTranscludeFn = function(transcludedScope, cloneFn, controllers) {
                    var scopeCreated = !1;
                    transcludedScope || (transcludedScope = scope.$new(), transcludedScope.$$transcluded = !0, 
                    scopeCreated = !0);
                    var clone = transcludeFn(transcludedScope, cloneFn, controllers, previousBoundTranscludeFn);
                    return scopeCreated && clone.on("$destroy", function() {
                        transcludedScope.$destroy();
                    }), clone;
                };
                return boundTranscludeFn;
            }
            function collectDirectives(node, directives, attrs, maxPriority, ignoreDirective) {
                var match, className, nodeType = node.nodeType, attrsMap = attrs.$attr;
                switch (nodeType) {
                  case 1:
                    addDirective(directives, directiveNormalize(nodeName_(node).toLowerCase()), "E", maxPriority, ignoreDirective);
                    for (var attr, name, nName, ngAttrName, value, isNgAttr, nAttrs = node.attributes, j = 0, jj = nAttrs && nAttrs.length; jj > j; j++) {
                        var attrStartName = !1, attrEndName = !1;
                        if (attr = nAttrs[j], !msie || msie >= 8 || attr.specified) {
                            name = attr.name, value = trim(attr.value), ngAttrName = directiveNormalize(name), 
                            (isNgAttr = NG_ATTR_BINDING.test(ngAttrName)) && (name = snake_case(ngAttrName.substr(6), "-"));
                            var directiveNName = ngAttrName.replace(/(Start|End)$/, "");
                            ngAttrName === directiveNName + "Start" && (attrStartName = name, attrEndName = name.substr(0, name.length - 5) + "end", 
                            name = name.substr(0, name.length - 6)), nName = directiveNormalize(name.toLowerCase()), 
                            attrsMap[nName] = name, (isNgAttr || !attrs.hasOwnProperty(nName)) && (attrs[nName] = value, 
                            getBooleanAttrName(node, nName) && (attrs[nName] = !0)), addAttrInterpolateDirective(node, directives, value, nName), 
                            addDirective(directives, nName, "A", maxPriority, ignoreDirective, attrStartName, attrEndName);
                        }
                    }
                    if (className = node.className, isString(className) && "" !== className) for (;match = CLASS_DIRECTIVE_REGEXP.exec(className); ) nName = directiveNormalize(match[2]), 
                    addDirective(directives, nName, "C", maxPriority, ignoreDirective) && (attrs[nName] = trim(match[3])), 
                    className = className.substr(match.index + match[0].length);
                    break;

                  case 3:
                    addTextInterpolateDirective(directives, node.nodeValue);
                    break;

                  case 8:
                    try {
                        match = COMMENT_DIRECTIVE_REGEXP.exec(node.nodeValue), match && (nName = directiveNormalize(match[1]), 
                        addDirective(directives, nName, "M", maxPriority, ignoreDirective) && (attrs[nName] = trim(match[2])));
                    } catch (e) {}
                }
                return directives.sort(byPriority), directives;
            }
            function groupScan(node, attrStart, attrEnd) {
                var nodes = [], depth = 0;
                if (attrStart && node.hasAttribute && node.hasAttribute(attrStart)) {
                    do {
                        if (!node) throw $compileMinErr("uterdir", "Unterminated attribute, found '{0}' but no matching '{1}' found.", attrStart, attrEnd);
                        1 == node.nodeType && (node.hasAttribute(attrStart) && depth++, node.hasAttribute(attrEnd) && depth--), 
                        nodes.push(node), node = node.nextSibling;
                    } while (depth > 0);
                } else nodes.push(node);
                return jqLite(nodes);
            }
            function groupElementsLinkFnWrapper(linkFn, attrStart, attrEnd) {
                return function(scope, element, attrs, controllers, transcludeFn) {
                    return element = groupScan(element[0], attrStart, attrEnd), linkFn(scope, element, attrs, controllers, transcludeFn);
                };
            }
            function applyDirectivesToNode(directives, compileNode, templateAttrs, transcludeFn, jqCollection, originalReplaceDirective, preLinkFns, postLinkFns, previousCompileContext) {
                function addLinkFns(pre, post, attrStart, attrEnd) {
                    pre && (attrStart && (pre = groupElementsLinkFnWrapper(pre, attrStart, attrEnd)), 
                    pre.require = directive.require, pre.directiveName = directiveName, (newIsolateScopeDirective === directive || directive.$$isolateScope) && (pre = cloneAndAnnotateFn(pre, {
                        isolateScope: !0
                    })), preLinkFns.push(pre)), post && (attrStart && (post = groupElementsLinkFnWrapper(post, attrStart, attrEnd)), 
                    post.require = directive.require, post.directiveName = directiveName, (newIsolateScopeDirective === directive || directive.$$isolateScope) && (post = cloneAndAnnotateFn(post, {
                        isolateScope: !0
                    })), postLinkFns.push(post));
                }
                function getControllers(directiveName, require, $element, elementControllers) {
                    var value, retrievalMethod = "data", optional = !1;
                    if (isString(require)) {
                        for (;"^" == (value = require.charAt(0)) || "?" == value; ) require = require.substr(1), 
                        "^" == value && (retrievalMethod = "inheritedData"), optional = optional || "?" == value;
                        if (value = null, elementControllers && "data" === retrievalMethod && (value = elementControllers[require]), 
                        value = value || $element[retrievalMethod]("$" + require + "Controller"), !value && !optional) throw $compileMinErr("ctreq", "Controller '{0}', required by directive '{1}', can't be found!", require, directiveName);
                        return value;
                    }
                    return isArray(require) && (value = [], forEach(require, function(require) {
                        value.push(getControllers(directiveName, require, $element, elementControllers));
                    })), value;
                }
                function nodeLinkFn(childLinkFn, scope, linkNode, $rootElement, boundTranscludeFn) {
                    function controllersBoundTransclude(scope, cloneAttachFn) {
                        var transcludeControllers;
                        return arguments.length < 2 && (cloneAttachFn = scope, scope = undefined), hasElementTranscludeDirective && (transcludeControllers = elementControllers), 
                        boundTranscludeFn(scope, cloneAttachFn, transcludeControllers);
                    }
                    var attrs, $element, i, ii, linkFn, controller, isolateScope, transcludeFn, elementControllers = {};
                    if (attrs = compileNode === linkNode ? templateAttrs : shallowCopy(templateAttrs, new Attributes(jqLite(linkNode), templateAttrs.$attr)), 
                    $element = attrs.$$element, newIsolateScopeDirective) {
                        var LOCAL_REGEXP = /^\s*([@=&])(\??)\s*(\w*)\s*$/;
                        isolateScope = scope.$new(!0), !templateDirective || templateDirective !== newIsolateScopeDirective && templateDirective !== newIsolateScopeDirective.$$originalDirective ? $element.data("$isolateScopeNoTemplate", isolateScope) : $element.data("$isolateScope", isolateScope), 
                        safeAddClass($element, "ng-isolate-scope"), forEach(newIsolateScopeDirective.scope, function(definition, scopeName) {
                            var lastValue, parentGet, parentSet, compare, match = definition.match(LOCAL_REGEXP) || [], attrName = match[3] || scopeName, optional = "?" == match[2], mode = match[1];
                            switch (isolateScope.$$isolateBindings[scopeName] = mode + attrName, mode) {
                              case "@":
                                attrs.$observe(attrName, function(value) {
                                    isolateScope[scopeName] = value;
                                }), attrs.$$observers[attrName].$$scope = scope, attrs[attrName] && (isolateScope[scopeName] = $interpolate(attrs[attrName])(scope));
                                break;

                              case "=":
                                if (optional && !attrs[attrName]) return;
                                parentGet = $parse(attrs[attrName]), compare = parentGet.literal ? equals : function(a, b) {
                                    return a === b || a !== a && b !== b;
                                }, parentSet = parentGet.assign || function() {
                                    throw lastValue = isolateScope[scopeName] = parentGet(scope), $compileMinErr("nonassign", "Expression '{0}' used with directive '{1}' is non-assignable!", attrs[attrName], newIsolateScopeDirective.name);
                                }, lastValue = isolateScope[scopeName] = parentGet(scope), isolateScope.$watch(function() {
                                    var parentValue = parentGet(scope);
                                    return compare(parentValue, isolateScope[scopeName]) || (compare(parentValue, lastValue) ? parentSet(scope, parentValue = isolateScope[scopeName]) : isolateScope[scopeName] = parentValue), 
                                    lastValue = parentValue;
                                }, null, parentGet.literal);
                                break;

                              case "&":
                                parentGet = $parse(attrs[attrName]), isolateScope[scopeName] = function(locals) {
                                    return parentGet(scope, locals);
                                };
                                break;

                              default:
                                throw $compileMinErr("iscp", "Invalid isolate scope definition for directive '{0}'. Definition: {... {1}: '{2}' ...}", newIsolateScopeDirective.name, scopeName, definition);
                            }
                        });
                    }
                    for (transcludeFn = boundTranscludeFn && controllersBoundTransclude, controllerDirectives && forEach(controllerDirectives, function(directive) {
                        var controllerInstance, locals = {
                            $scope: directive === newIsolateScopeDirective || directive.$$isolateScope ? isolateScope : scope,
                            $element: $element,
                            $attrs: attrs,
                            $transclude: transcludeFn
                        };
                        controller = directive.controller, "@" == controller && (controller = attrs[directive.name]), 
                        controllerInstance = $controller(controller, locals), elementControllers[directive.name] = controllerInstance, 
                        hasElementTranscludeDirective || $element.data("$" + directive.name + "Controller", controllerInstance), 
                        directive.controllerAs && (locals.$scope[directive.controllerAs] = controllerInstance);
                    }), i = 0, ii = preLinkFns.length; ii > i; i++) try {
                        linkFn = preLinkFns[i], linkFn(linkFn.isolateScope ? isolateScope : scope, $element, attrs, linkFn.require && getControllers(linkFn.directiveName, linkFn.require, $element, elementControllers), transcludeFn);
                    } catch (e) {
                        $exceptionHandler(e, startingTag($element));
                    }
                    var scopeToChild = scope;
                    for (newIsolateScopeDirective && (newIsolateScopeDirective.template || null === newIsolateScopeDirective.templateUrl) && (scopeToChild = isolateScope), 
                    childLinkFn && childLinkFn(scopeToChild, linkNode.childNodes, undefined, boundTranscludeFn), 
                    i = postLinkFns.length - 1; i >= 0; i--) try {
                        linkFn = postLinkFns[i], linkFn(linkFn.isolateScope ? isolateScope : scope, $element, attrs, linkFn.require && getControllers(linkFn.directiveName, linkFn.require, $element, elementControllers), transcludeFn);
                    } catch (e) {
                        $exceptionHandler(e, startingTag($element));
                    }
                }
                previousCompileContext = previousCompileContext || {};
                for (var newScopeDirective, directive, directiveName, $template, linkFn, directiveValue, terminalPriority = -Number.MAX_VALUE, controllerDirectives = previousCompileContext.controllerDirectives, newIsolateScopeDirective = previousCompileContext.newIsolateScopeDirective, templateDirective = previousCompileContext.templateDirective, nonTlbTranscludeDirective = previousCompileContext.nonTlbTranscludeDirective, hasTranscludeDirective = !1, hasTemplate = !1, hasElementTranscludeDirective = previousCompileContext.hasElementTranscludeDirective, $compileNode = templateAttrs.$$element = jqLite(compileNode), replaceDirective = originalReplaceDirective, childTranscludeFn = transcludeFn, i = 0, ii = directives.length; ii > i; i++) {
                    directive = directives[i];
                    var attrStart = directive.$$start, attrEnd = directive.$$end;
                    if (attrStart && ($compileNode = groupScan(compileNode, attrStart, attrEnd)), $template = undefined, 
                    terminalPriority > directive.priority) break;
                    if ((directiveValue = directive.scope) && (newScopeDirective = newScopeDirective || directive, 
                    directive.templateUrl || (assertNoDuplicate("new/isolated scope", newIsolateScopeDirective, directive, $compileNode), 
                    isObject(directiveValue) && (newIsolateScopeDirective = directive))), directiveName = directive.name, 
                    !directive.templateUrl && directive.controller && (directiveValue = directive.controller, 
                    controllerDirectives = controllerDirectives || {}, assertNoDuplicate("'" + directiveName + "' controller", controllerDirectives[directiveName], directive, $compileNode), 
                    controllerDirectives[directiveName] = directive), (directiveValue = directive.transclude) && (hasTranscludeDirective = !0, 
                    directive.$$tlb || (assertNoDuplicate("transclusion", nonTlbTranscludeDirective, directive, $compileNode), 
                    nonTlbTranscludeDirective = directive), "element" == directiveValue ? (hasElementTranscludeDirective = !0, 
                    terminalPriority = directive.priority, $template = $compileNode, $compileNode = templateAttrs.$$element = jqLite(document.createComment(" " + directiveName + ": " + templateAttrs[directiveName] + " ")), 
                    compileNode = $compileNode[0], replaceWith(jqCollection, sliceArgs($template), compileNode), 
                    childTranscludeFn = compile($template, transcludeFn, terminalPriority, replaceDirective && replaceDirective.name, {
                        nonTlbTranscludeDirective: nonTlbTranscludeDirective
                    })) : ($template = jqLite(jqLiteClone(compileNode)).contents(), $compileNode.empty(), 
                    childTranscludeFn = compile($template, transcludeFn))), directive.template) if (hasTemplate = !0, 
                    assertNoDuplicate("template", templateDirective, directive, $compileNode), templateDirective = directive, 
                    directiveValue = isFunction(directive.template) ? directive.template($compileNode, templateAttrs) : directive.template, 
                    directiveValue = denormalizeTemplate(directiveValue), directive.replace) {
                        if (replaceDirective = directive, $template = jqLiteIsTextNode(directiveValue) ? [] : jqLite(trim(directiveValue)), 
                        compileNode = $template[0], 1 != $template.length || 1 !== compileNode.nodeType) throw $compileMinErr("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", directiveName, "");
                        replaceWith(jqCollection, $compileNode, compileNode);
                        var newTemplateAttrs = {
                            $attr: {}
                        }, templateDirectives = collectDirectives(compileNode, [], newTemplateAttrs), unprocessedDirectives = directives.splice(i + 1, directives.length - (i + 1));
                        newIsolateScopeDirective && markDirectivesAsIsolate(templateDirectives), directives = directives.concat(templateDirectives).concat(unprocessedDirectives), 
                        mergeTemplateAttributes(templateAttrs, newTemplateAttrs), ii = directives.length;
                    } else $compileNode.html(directiveValue);
                    if (directive.templateUrl) hasTemplate = !0, assertNoDuplicate("template", templateDirective, directive, $compileNode), 
                    templateDirective = directive, directive.replace && (replaceDirective = directive), 
                    nodeLinkFn = compileTemplateUrl(directives.splice(i, directives.length - i), $compileNode, templateAttrs, jqCollection, hasTranscludeDirective && childTranscludeFn, preLinkFns, postLinkFns, {
                        controllerDirectives: controllerDirectives,
                        newIsolateScopeDirective: newIsolateScopeDirective,
                        templateDirective: templateDirective,
                        nonTlbTranscludeDirective: nonTlbTranscludeDirective
                    }), ii = directives.length; else if (directive.compile) try {
                        linkFn = directive.compile($compileNode, templateAttrs, childTranscludeFn), isFunction(linkFn) ? addLinkFns(null, linkFn, attrStart, attrEnd) : linkFn && addLinkFns(linkFn.pre, linkFn.post, attrStart, attrEnd);
                    } catch (e) {
                        $exceptionHandler(e, startingTag($compileNode));
                    }
                    directive.terminal && (nodeLinkFn.terminal = !0, terminalPriority = Math.max(terminalPriority, directive.priority));
                }
                return nodeLinkFn.scope = newScopeDirective && newScopeDirective.scope === !0, nodeLinkFn.transcludeOnThisElement = hasTranscludeDirective, 
                nodeLinkFn.templateOnThisElement = hasTemplate, nodeLinkFn.transclude = childTranscludeFn, 
                previousCompileContext.hasElementTranscludeDirective = hasElementTranscludeDirective, 
                nodeLinkFn;
            }
            function markDirectivesAsIsolate(directives) {
                for (var j = 0, jj = directives.length; jj > j; j++) directives[j] = inherit(directives[j], {
                    $$isolateScope: !0
                });
            }
            function addDirective(tDirectives, name, location, maxPriority, ignoreDirective, startAttrName, endAttrName) {
                if (name === ignoreDirective) return null;
                var match = null;
                if (hasDirectives.hasOwnProperty(name)) for (var directive, directives = $injector.get(name + Suffix), i = 0, ii = directives.length; ii > i; i++) try {
                    directive = directives[i], (maxPriority === undefined || maxPriority > directive.priority) && -1 != directive.restrict.indexOf(location) && (startAttrName && (directive = inherit(directive, {
                        $$start: startAttrName,
                        $$end: endAttrName
                    })), tDirectives.push(directive), match = directive);
                } catch (e) {
                    $exceptionHandler(e);
                }
                return match;
            }
            function mergeTemplateAttributes(dst, src) {
                var srcAttr = src.$attr, dstAttr = dst.$attr, $element = dst.$$element;
                forEach(dst, function(value, key) {
                    "$" != key.charAt(0) && (src[key] && src[key] !== value && (value += ("style" === key ? ";" : " ") + src[key]), 
                    dst.$set(key, value, !0, srcAttr[key]));
                }), forEach(src, function(value, key) {
                    "class" == key ? (safeAddClass($element, value), dst["class"] = (dst["class"] ? dst["class"] + " " : "") + value) : "style" == key ? ($element.attr("style", $element.attr("style") + ";" + value), 
                    dst.style = (dst.style ? dst.style + ";" : "") + value) : "$" == key.charAt(0) || dst.hasOwnProperty(key) || (dst[key] = value, 
                    dstAttr[key] = srcAttr[key]);
                });
            }
            function compileTemplateUrl(directives, $compileNode, tAttrs, $rootElement, childTranscludeFn, preLinkFns, postLinkFns, previousCompileContext) {
                var afterTemplateNodeLinkFn, afterTemplateChildLinkFn, linkQueue = [], beforeTemplateCompileNode = $compileNode[0], origAsyncDirective = directives.shift(), derivedSyncDirective = extend({}, origAsyncDirective, {
                    templateUrl: null,
                    transclude: null,
                    replace: null,
                    $$originalDirective: origAsyncDirective
                }), templateUrl = isFunction(origAsyncDirective.templateUrl) ? origAsyncDirective.templateUrl($compileNode, tAttrs) : origAsyncDirective.templateUrl;
                return $compileNode.empty(), $http.get($sce.getTrustedResourceUrl(templateUrl), {
                    cache: $templateCache
                }).success(function(content) {
                    var compileNode, tempTemplateAttrs, $template, childBoundTranscludeFn;
                    if (content = denormalizeTemplate(content), origAsyncDirective.replace) {
                        if ($template = jqLiteIsTextNode(content) ? [] : jqLite(trim(content)), compileNode = $template[0], 
                        1 != $template.length || 1 !== compileNode.nodeType) throw $compileMinErr("tplrt", "Template for directive '{0}' must have exactly one root element. {1}", origAsyncDirective.name, templateUrl);
                        tempTemplateAttrs = {
                            $attr: {}
                        }, replaceWith($rootElement, $compileNode, compileNode);
                        var templateDirectives = collectDirectives(compileNode, [], tempTemplateAttrs);
                        isObject(origAsyncDirective.scope) && markDirectivesAsIsolate(templateDirectives), 
                        directives = templateDirectives.concat(directives), mergeTemplateAttributes(tAttrs, tempTemplateAttrs);
                    } else compileNode = beforeTemplateCompileNode, $compileNode.html(content);
                    for (directives.unshift(derivedSyncDirective), afterTemplateNodeLinkFn = applyDirectivesToNode(directives, compileNode, tAttrs, childTranscludeFn, $compileNode, origAsyncDirective, preLinkFns, postLinkFns, previousCompileContext), 
                    forEach($rootElement, function(node, i) {
                        node == compileNode && ($rootElement[i] = $compileNode[0]);
                    }), afterTemplateChildLinkFn = compileNodes($compileNode[0].childNodes, childTranscludeFn); linkQueue.length; ) {
                        var scope = linkQueue.shift(), beforeTemplateLinkNode = linkQueue.shift(), linkRootElement = linkQueue.shift(), boundTranscludeFn = linkQueue.shift(), linkNode = $compileNode[0];
                        if (beforeTemplateLinkNode !== beforeTemplateCompileNode) {
                            var oldClasses = beforeTemplateLinkNode.className;
                            previousCompileContext.hasElementTranscludeDirective && origAsyncDirective.replace || (linkNode = jqLiteClone(compileNode)), 
                            replaceWith(linkRootElement, jqLite(beforeTemplateLinkNode), linkNode), safeAddClass(jqLite(linkNode), oldClasses);
                        }
                        childBoundTranscludeFn = afterTemplateNodeLinkFn.transcludeOnThisElement ? createBoundTranscludeFn(scope, afterTemplateNodeLinkFn.transclude, boundTranscludeFn) : boundTranscludeFn, 
                        afterTemplateNodeLinkFn(afterTemplateChildLinkFn, scope, linkNode, $rootElement, childBoundTranscludeFn);
                    }
                    linkQueue = null;
                }).error(function(response, code, headers, config) {
                    throw $compileMinErr("tpload", "Failed to load template: {0}", config.url);
                }), function(ignoreChildLinkFn, scope, node, rootElement, boundTranscludeFn) {
                    var childBoundTranscludeFn = boundTranscludeFn;
                    linkQueue ? (linkQueue.push(scope), linkQueue.push(node), linkQueue.push(rootElement), 
                    linkQueue.push(childBoundTranscludeFn)) : (afterTemplateNodeLinkFn.transcludeOnThisElement && (childBoundTranscludeFn = createBoundTranscludeFn(scope, afterTemplateNodeLinkFn.transclude, boundTranscludeFn)), 
                    afterTemplateNodeLinkFn(afterTemplateChildLinkFn, scope, node, rootElement, childBoundTranscludeFn));
                };
            }
            function byPriority(a, b) {
                var diff = b.priority - a.priority;
                return 0 !== diff ? diff : a.name !== b.name ? a.name < b.name ? -1 : 1 : a.index - b.index;
            }
            function assertNoDuplicate(what, previousDirective, directive, element) {
                if (previousDirective) throw $compileMinErr("multidir", "Multiple directives [{0}, {1}] asking for {2} on: {3}", previousDirective.name, directive.name, what, startingTag(element));
            }
            function addTextInterpolateDirective(directives, text) {
                var interpolateFn = $interpolate(text, !0);
                interpolateFn && directives.push({
                    priority: 0,
                    compile: function(templateNode) {
                        var parent = templateNode.parent(), hasCompileParent = parent.length;
                        return hasCompileParent && safeAddClass(templateNode.parent(), "ng-binding"), function(scope, node) {
                            var parent = node.parent(), bindings = parent.data("$binding") || [];
                            bindings.push(interpolateFn), parent.data("$binding", bindings), hasCompileParent || safeAddClass(parent, "ng-binding"), 
                            scope.$watch(interpolateFn, function(value) {
                                node[0].nodeValue = value;
                            });
                        };
                    }
                });
            }
            function getTrustedContext(node, attrNormalizedName) {
                if ("srcdoc" == attrNormalizedName) return $sce.HTML;
                var tag = nodeName_(node);
                return "xlinkHref" == attrNormalizedName || "FORM" == tag && "action" == attrNormalizedName || "IMG" != tag && ("src" == attrNormalizedName || "ngSrc" == attrNormalizedName) ? $sce.RESOURCE_URL : void 0;
            }
            function addAttrInterpolateDirective(node, directives, value, name) {
                var interpolateFn = $interpolate(value, !0);
                if (interpolateFn) {
                    if ("multiple" === name && "SELECT" === nodeName_(node)) throw $compileMinErr("selmulti", "Binding to the 'multiple' attribute is not supported. Element: {0}", startingTag(node));
                    directives.push({
                        priority: 100,
                        compile: function() {
                            return {
                                pre: function(scope, element, attr) {
                                    var $$observers = attr.$$observers || (attr.$$observers = {});
                                    if (EVENT_HANDLER_ATTR_REGEXP.test(name)) throw $compileMinErr("nodomevents", "Interpolations for HTML DOM event attributes are disallowed.  Please use the ng- versions (such as ng-click instead of onclick) instead.");
                                    interpolateFn = $interpolate(attr[name], !0, getTrustedContext(node, name)), interpolateFn && (attr[name] = interpolateFn(scope), 
                                    ($$observers[name] || ($$observers[name] = [])).$$inter = !0, (attr.$$observers && attr.$$observers[name].$$scope || scope).$watch(interpolateFn, function(newValue, oldValue) {
                                        "class" === name && newValue != oldValue ? attr.$updateClass(newValue, oldValue) : attr.$set(name, newValue);
                                    }));
                                }
                            };
                        }
                    });
                }
            }
            function replaceWith($rootElement, elementsToRemove, newNode) {
                var i, ii, firstElementToRemove = elementsToRemove[0], removeCount = elementsToRemove.length, parent = firstElementToRemove.parentNode;
                if ($rootElement) for (i = 0, ii = $rootElement.length; ii > i; i++) if ($rootElement[i] == firstElementToRemove) {
                    $rootElement[i++] = newNode;
                    for (var j = i, j2 = j + removeCount - 1, jj = $rootElement.length; jj > j; j++, 
                    j2++) jj > j2 ? $rootElement[j] = $rootElement[j2] : delete $rootElement[j];
                    $rootElement.length -= removeCount - 1;
                    break;
                }
                parent && parent.replaceChild(newNode, firstElementToRemove);
                var fragment = document.createDocumentFragment();
                fragment.appendChild(firstElementToRemove), newNode[jqLite.expando] = firstElementToRemove[jqLite.expando];
                for (var k = 1, kk = elementsToRemove.length; kk > k; k++) {
                    var element = elementsToRemove[k];
                    jqLite(element).remove(), fragment.appendChild(element), delete elementsToRemove[k];
                }
                elementsToRemove[0] = newNode, elementsToRemove.length = 1;
            }
            function cloneAndAnnotateFn(fn, annotation) {
                return extend(function() {
                    return fn.apply(null, arguments);
                }, fn, annotation);
            }
            var Attributes = function(element, attr) {
                this.$$element = element, this.$attr = attr || {};
            };
            Attributes.prototype = {
                $normalize: directiveNormalize,
                $addClass: function(classVal) {
                    classVal && classVal.length > 0 && $animate.addClass(this.$$element, classVal);
                },
                $removeClass: function(classVal) {
                    classVal && classVal.length > 0 && $animate.removeClass(this.$$element, classVal);
                },
                $updateClass: function(newClasses, oldClasses) {
                    var toAdd = tokenDifference(newClasses, oldClasses), toRemove = tokenDifference(oldClasses, newClasses);
                    0 === toAdd.length ? $animate.removeClass(this.$$element, toRemove) : 0 === toRemove.length ? $animate.addClass(this.$$element, toAdd) : $animate.setClass(this.$$element, toAdd, toRemove);
                },
                $set: function(key, value, writeAttr, attrName) {
                    var nodeName, booleanKey = getBooleanAttrName(this.$$element[0], key);
                    booleanKey && (this.$$element.prop(key, value), attrName = booleanKey), this[key] = value, 
                    attrName ? this.$attr[key] = attrName : (attrName = this.$attr[key], attrName || (this.$attr[key] = attrName = snake_case(key, "-"))), 
                    nodeName = nodeName_(this.$$element), ("A" === nodeName && "href" === key || "IMG" === nodeName && "src" === key) && (this[key] = value = $$sanitizeUri(value, "src" === key)), 
                    writeAttr !== !1 && (null === value || value === undefined ? this.$$element.removeAttr(attrName) : this.$$element.attr(attrName, value));
                    var $$observers = this.$$observers;
                    $$observers && forEach($$observers[key], function(fn) {
                        try {
                            fn(value);
                        } catch (e) {
                            $exceptionHandler(e);
                        }
                    });
                },
                $observe: function(key, fn) {
                    var attrs = this, $$observers = attrs.$$observers || (attrs.$$observers = {}), listeners = $$observers[key] || ($$observers[key] = []);
                    return listeners.push(fn), $rootScope.$evalAsync(function() {
                        listeners.$$inter || fn(attrs[key]);
                    }), fn;
                }
            };
            var startSymbol = $interpolate.startSymbol(), endSymbol = $interpolate.endSymbol(), denormalizeTemplate = "{{" == startSymbol || "}}" == endSymbol ? identity : function(template) {
                return template.replace(/\{\{/g, startSymbol).replace(/}}/g, endSymbol);
            }, NG_ATTR_BINDING = /^ngAttr[A-Z]/;
            return compile;
        } ];
    }
    function directiveNormalize(name) {
        return camelCase(name.replace(PREFIX_REGEXP, ""));
    }
    function tokenDifference(str1, str2) {
        var values = "", tokens1 = str1.split(/\s+/), tokens2 = str2.split(/\s+/);
        outer: for (var i = 0; i < tokens1.length; i++) {
            for (var token = tokens1[i], j = 0; j < tokens2.length; j++) if (token == tokens2[j]) continue outer;
            values += (values.length > 0 ? " " : "") + token;
        }
        return values;
    }
    function $ControllerProvider() {
        var controllers = {}, CNTRL_REG = /^(\S+)(\s+as\s+(\w+))?$/;
        this.register = function(name, constructor) {
            assertNotHasOwnProperty(name, "controller"), isObject(name) ? extend(controllers, name) : controllers[name] = constructor;
        }, this.$get = [ "$injector", "$window", function($injector, $window) {
            return function(expression, locals) {
                var instance, match, constructor, identifier;
                if (isString(expression) && (match = expression.match(CNTRL_REG), constructor = match[1], 
                identifier = match[3], expression = controllers.hasOwnProperty(constructor) ? controllers[constructor] : getter(locals.$scope, constructor, !0) || getter($window, constructor, !0), 
                assertArgFn(expression, constructor, !0)), instance = $injector.instantiate(expression, locals), 
                identifier) {
                    if (!locals || "object" != typeof locals.$scope) throw minErr("$controller")("noscp", "Cannot export controller '{0}' as '{1}'! No $scope object provided via `locals`.", constructor || expression.name, identifier);
                    locals.$scope[identifier] = instance;
                }
                return instance;
            };
        } ];
    }
    function $DocumentProvider() {
        this.$get = [ "$window", function(window) {
            return jqLite(window.document);
        } ];
    }
    function $ExceptionHandlerProvider() {
        this.$get = [ "$log", function($log) {
            return function(exception, cause) {
                $log.error.apply($log, arguments);
            };
        } ];
    }
    function parseHeaders(headers) {
        var key, val, i, parsed = {};
        return headers ? (forEach(headers.split("\n"), function(line) {
            i = line.indexOf(":"), key = lowercase(trim(line.substr(0, i))), val = trim(line.substr(i + 1)), 
            key && (parsed[key] = parsed[key] ? parsed[key] + ", " + val : val);
        }), parsed) : parsed;
    }
    function headersGetter(headers) {
        var headersObj = isObject(headers) ? headers : undefined;
        return function(name) {
            return headersObj || (headersObj = parseHeaders(headers)), name ? headersObj[lowercase(name)] || null : headersObj;
        };
    }
    function transformData(data, headers, fns) {
        return isFunction(fns) ? fns(data, headers) : (forEach(fns, function(fn) {
            data = fn(data, headers);
        }), data);
    }
    function isSuccess(status) {
        return status >= 200 && 300 > status;
    }
    function $HttpProvider() {
        var JSON_START = /^\s*(\[|\{[^\{])/, JSON_END = /[\}\]]\s*$/, PROTECTION_PREFIX = /^\)\]\}',?\n/, CONTENT_TYPE_APPLICATION_JSON = {
            "Content-Type": "application/json;charset=utf-8"
        }, defaults = this.defaults = {
            transformResponse: [ function(data) {
                return isString(data) && (data = data.replace(PROTECTION_PREFIX, ""), JSON_START.test(data) && JSON_END.test(data) && (data = fromJson(data))), 
                data;
            } ],
            transformRequest: [ function(d) {
                return !isObject(d) || isFile(d) || isBlob(d) ? d : toJson(d);
            } ],
            headers: {
                common: {
                    Accept: "application/json, text/plain, */*"
                },
                post: shallowCopy(CONTENT_TYPE_APPLICATION_JSON),
                put: shallowCopy(CONTENT_TYPE_APPLICATION_JSON),
                patch: shallowCopy(CONTENT_TYPE_APPLICATION_JSON)
            },
            xsrfCookieName: "XSRF-TOKEN",
            xsrfHeaderName: "X-XSRF-TOKEN"
        }, interceptorFactories = this.interceptors = [], responseInterceptorFactories = this.responseInterceptors = [];
        this.$get = [ "$httpBackend", "$browser", "$cacheFactory", "$rootScope", "$q", "$injector", function($httpBackend, $browser, $cacheFactory, $rootScope, $q, $injector) {
            function $http(requestConfig) {
                function transformResponse(response) {
                    var resp = extend({}, response, {
                        data: transformData(response.data, response.headers, config.transformResponse)
                    });
                    return isSuccess(response.status) ? resp : $q.reject(resp);
                }
                function mergeHeaders(config) {
                    function execHeaders(headers) {
                        var headerContent;
                        forEach(headers, function(headerFn, header) {
                            isFunction(headerFn) && (headerContent = headerFn(), null != headerContent ? headers[header] = headerContent : delete headers[header]);
                        });
                    }
                    var defHeaderName, lowercaseDefHeaderName, reqHeaderName, defHeaders = defaults.headers, reqHeaders = extend({}, config.headers);
                    defHeaders = extend({}, defHeaders.common, defHeaders[lowercase(config.method)]);
                    defaultHeadersIteration: for (defHeaderName in defHeaders) {
                        lowercaseDefHeaderName = lowercase(defHeaderName);
                        for (reqHeaderName in reqHeaders) if (lowercase(reqHeaderName) === lowercaseDefHeaderName) continue defaultHeadersIteration;
                        reqHeaders[defHeaderName] = defHeaders[defHeaderName];
                    }
                    return execHeaders(reqHeaders), reqHeaders;
                }
                var config = {
                    method: "get",
                    transformRequest: defaults.transformRequest,
                    transformResponse: defaults.transformResponse
                }, headers = mergeHeaders(requestConfig);
                extend(config, requestConfig), config.headers = headers, config.method = uppercase(config.method);
                var serverRequest = function(config) {
                    headers = config.headers;
                    var reqData = transformData(config.data, headersGetter(headers), config.transformRequest);
                    return isUndefined(reqData) && forEach(headers, function(value, header) {
                        "content-type" === lowercase(header) && delete headers[header];
                    }), isUndefined(config.withCredentials) && !isUndefined(defaults.withCredentials) && (config.withCredentials = defaults.withCredentials), 
                    sendReq(config, reqData, headers).then(transformResponse, transformResponse);
                }, chain = [ serverRequest, undefined ], promise = $q.when(config);
                for (forEach(reversedInterceptors, function(interceptor) {
                    (interceptor.request || interceptor.requestError) && chain.unshift(interceptor.request, interceptor.requestError), 
                    (interceptor.response || interceptor.responseError) && chain.push(interceptor.response, interceptor.responseError);
                }); chain.length; ) {
                    var thenFn = chain.shift(), rejectFn = chain.shift();
                    promise = promise.then(thenFn, rejectFn);
                }
                return promise.success = function(fn) {
                    return promise.then(function(response) {
                        fn(response.data, response.status, response.headers, config);
                    }), promise;
                }, promise.error = function(fn) {
                    return promise.then(null, function(response) {
                        fn(response.data, response.status, response.headers, config);
                    }), promise;
                }, promise;
            }
            function createShortMethods(names) {
                forEach(arguments, function(name) {
                    $http[name] = function(url, config) {
                        return $http(extend(config || {}, {
                            method: name,
                            url: url
                        }));
                    };
                });
            }
            function createShortMethodsWithData(name) {
                forEach(arguments, function(name) {
                    $http[name] = function(url, data, config) {
                        return $http(extend(config || {}, {
                            method: name,
                            url: url,
                            data: data
                        }));
                    };
                });
            }
            function sendReq(config, reqData, reqHeaders) {
                function done(status, response, headersString, statusText) {
                    cache && (isSuccess(status) ? cache.put(url, [ status, response, parseHeaders(headersString), statusText ]) : cache.remove(url)), 
                    resolvePromise(response, status, headersString, statusText), $rootScope.$$phase || $rootScope.$apply();
                }
                function resolvePromise(response, status, headers, statusText) {
                    status = Math.max(status, 0), (isSuccess(status) ? deferred.resolve : deferred.reject)({
                        data: response,
                        status: status,
                        headers: headersGetter(headers),
                        config: config,
                        statusText: statusText
                    });
                }
                function removePendingReq() {
                    var idx = indexOf($http.pendingRequests, config);
                    -1 !== idx && $http.pendingRequests.splice(idx, 1);
                }
                var cache, cachedResp, deferred = $q.defer(), promise = deferred.promise, url = buildUrl(config.url, config.params);
                if ($http.pendingRequests.push(config), promise.then(removePendingReq, removePendingReq), 
                !config.cache && !defaults.cache || config.cache === !1 || "GET" !== config.method && "JSONP" !== config.method || (cache = isObject(config.cache) ? config.cache : isObject(defaults.cache) ? defaults.cache : defaultCache), 
                cache) if (cachedResp = cache.get(url), isDefined(cachedResp)) {
                    if (isPromiseLike(cachedResp)) return cachedResp.then(removePendingReq, removePendingReq), 
                    cachedResp;
                    isArray(cachedResp) ? resolvePromise(cachedResp[1], cachedResp[0], shallowCopy(cachedResp[2]), cachedResp[3]) : resolvePromise(cachedResp, 200, {}, "OK");
                } else cache.put(url, promise);
                if (isUndefined(cachedResp)) {
                    var xsrfValue = urlIsSameOrigin(config.url) ? $browser.cookies()[config.xsrfCookieName || defaults.xsrfCookieName] : undefined;
                    xsrfValue && (reqHeaders[config.xsrfHeaderName || defaults.xsrfHeaderName] = xsrfValue), 
                    $httpBackend(config.method, url, reqData, done, reqHeaders, config.timeout, config.withCredentials, config.responseType);
                }
                return promise;
            }
            function buildUrl(url, params) {
                if (!params) return url;
                var parts = [];
                return forEachSorted(params, function(value, key) {
                    null === value || isUndefined(value) || (isArray(value) || (value = [ value ]), 
                    forEach(value, function(v) {
                        isObject(v) && (v = isDate(v) ? v.toISOString() : toJson(v)), parts.push(encodeUriQuery(key) + "=" + encodeUriQuery(v));
                    }));
                }), parts.length > 0 && (url += (-1 == url.indexOf("?") ? "?" : "&") + parts.join("&")), 
                url;
            }
            var defaultCache = $cacheFactory("$http"), reversedInterceptors = [];
            return forEach(interceptorFactories, function(interceptorFactory) {
                reversedInterceptors.unshift(isString(interceptorFactory) ? $injector.get(interceptorFactory) : $injector.invoke(interceptorFactory));
            }), forEach(responseInterceptorFactories, function(interceptorFactory, index) {
                var responseFn = isString(interceptorFactory) ? $injector.get(interceptorFactory) : $injector.invoke(interceptorFactory);
                reversedInterceptors.splice(index, 0, {
                    response: function(response) {
                        return responseFn($q.when(response));
                    },
                    responseError: function(response) {
                        return responseFn($q.reject(response));
                    }
                });
            }), $http.pendingRequests = [], createShortMethods("get", "delete", "head", "jsonp"), 
            createShortMethodsWithData("post", "put", "patch"), $http.defaults = defaults, $http;
        } ];
    }
    function createXhr(method) {
        if (8 >= msie && (!method.match(/^(get|post|head|put|delete|options)$/i) || !window.XMLHttpRequest)) return new window.ActiveXObject("Microsoft.XMLHTTP");
        if (window.XMLHttpRequest) return new window.XMLHttpRequest();
        throw minErr("$httpBackend")("noxhr", "This browser does not support XMLHttpRequest.");
    }
    function $HttpBackendProvider() {
        this.$get = [ "$browser", "$window", "$document", function($browser, $window, $document) {
            return createHttpBackend($browser, createXhr, $browser.defer, $window.angular.callbacks, $document[0]);
        } ];
    }
    function createHttpBackend($browser, createXhr, $browserDefer, callbacks, rawDocument) {
        function jsonpReq(url, callbackId, done) {
            var script = rawDocument.createElement("script"), callback = null;
            return script.type = "text/javascript", script.src = url, script.async = !0, callback = function(event) {
                removeEventListenerFn(script, "load", callback), removeEventListenerFn(script, "error", callback), 
                rawDocument.body.removeChild(script), script = null;
                var status = -1, text = "unknown";
                event && ("load" !== event.type || callbacks[callbackId].called || (event = {
                    type: "error"
                }), text = event.type, status = "error" === event.type ? 404 : 200), done && done(status, text);
            }, addEventListenerFn(script, "load", callback), addEventListenerFn(script, "error", callback), 
            8 >= msie && (script.onreadystatechange = function() {
                isString(script.readyState) && /loaded|complete/.test(script.readyState) && (script.onreadystatechange = null, 
                callback({
                    type: "load"
                }));
            }), rawDocument.body.appendChild(script), callback;
        }
        var ABORTED = -1;
        return function(method, url, post, callback, headers, timeout, withCredentials, responseType) {
            function timeoutRequest() {
                status = ABORTED, jsonpDone && jsonpDone(), xhr && xhr.abort();
            }
            function completeRequest(callback, status, response, headersString, statusText) {
                timeoutId && $browserDefer.cancel(timeoutId), jsonpDone = xhr = null, 0 === status && (status = response ? 200 : "file" == urlResolve(url).protocol ? 404 : 0), 
                status = 1223 === status ? 204 : status, statusText = statusText || "", callback(status, response, headersString, statusText), 
                $browser.$$completeOutstandingRequest(noop);
            }
            var status;
            if ($browser.$$incOutstandingRequestCount(), url = url || $browser.url(), "jsonp" == lowercase(method)) {
                var callbackId = "_" + (callbacks.counter++).toString(36);
                callbacks[callbackId] = function(data) {
                    callbacks[callbackId].data = data, callbacks[callbackId].called = !0;
                };
                var jsonpDone = jsonpReq(url.replace("JSON_CALLBACK", "angular.callbacks." + callbackId), callbackId, function(status, text) {
                    completeRequest(callback, status, callbacks[callbackId].data, "", text), callbacks[callbackId] = noop;
                });
            } else {
                var xhr = createXhr(method);
                if (xhr.open(method, url, !0), forEach(headers, function(value, key) {
                    isDefined(value) && xhr.setRequestHeader(key, value);
                }), xhr.onreadystatechange = function() {
                    if (xhr && 4 == xhr.readyState) {
                        var responseHeaders = null, response = null, statusText = "";
                        status !== ABORTED && (responseHeaders = xhr.getAllResponseHeaders(), response = "response" in xhr ? xhr.response : xhr.responseText), 
                        status === ABORTED && 10 > msie || (statusText = xhr.statusText), completeRequest(callback, status || xhr.status, response, responseHeaders, statusText);
                    }
                }, withCredentials && (xhr.withCredentials = !0), responseType) try {
                    xhr.responseType = responseType;
                } catch (e) {
                    if ("json" !== responseType) throw e;
                }
                xhr.send(post || null);
            }
            if (timeout > 0) var timeoutId = $browserDefer(timeoutRequest, timeout); else isPromiseLike(timeout) && timeout.then(timeoutRequest);
        };
    }
    function $InterpolateProvider() {
        var startSymbol = "{{", endSymbol = "}}";
        this.startSymbol = function(value) {
            return value ? (startSymbol = value, this) : startSymbol;
        }, this.endSymbol = function(value) {
            return value ? (endSymbol = value, this) : endSymbol;
        }, this.$get = [ "$parse", "$exceptionHandler", "$sce", function($parse, $exceptionHandler, $sce) {
            function $interpolate(text, mustHaveExpression, trustedContext) {
                for (var startIndex, endIndex, fn, exp, index = 0, parts = [], length = text.length, hasInterpolation = !1, concat = []; length > index; ) -1 != (startIndex = text.indexOf(startSymbol, index)) && -1 != (endIndex = text.indexOf(endSymbol, startIndex + startSymbolLength)) ? (index != startIndex && parts.push(text.substring(index, startIndex)), 
                parts.push(fn = $parse(exp = text.substring(startIndex + startSymbolLength, endIndex))), 
                fn.exp = exp, index = endIndex + endSymbolLength, hasInterpolation = !0) : (index != length && parts.push(text.substring(index)), 
                index = length);
                if ((length = parts.length) || (parts.push(""), length = 1), trustedContext && parts.length > 1) throw $interpolateMinErr("noconcat", "Error while interpolating: {0}\nStrict Contextual Escaping disallows interpolations that concatenate multiple expressions when a trusted value is required.  See http://docs.angularjs.org/api/ng.$sce", text);
                return !mustHaveExpression || hasInterpolation ? (concat.length = length, fn = function(context) {
                    try {
                        for (var part, i = 0, ii = length; ii > i; i++) {
                            if ("function" == typeof (part = parts[i])) if (part = part(context), part = trustedContext ? $sce.getTrusted(trustedContext, part) : $sce.valueOf(part), 
                            null == part) part = ""; else switch (typeof part) {
                              case "string":
                                break;

                              case "number":
                                part = "" + part;
                                break;

                              default:
                                part = toJson(part);
                            }
                            concat[i] = part;
                        }
                        return concat.join("");
                    } catch (err) {
                        var newErr = $interpolateMinErr("interr", "Can't interpolate: {0}\n{1}", text, err.toString());
                        $exceptionHandler(newErr);
                    }
                }, fn.exp = text, fn.parts = parts, fn) : void 0;
            }
            var startSymbolLength = startSymbol.length, endSymbolLength = endSymbol.length;
            return $interpolate.startSymbol = function() {
                return startSymbol;
            }, $interpolate.endSymbol = function() {
                return endSymbol;
            }, $interpolate;
        } ];
    }
    function $IntervalProvider() {
        this.$get = [ "$rootScope", "$window", "$q", function($rootScope, $window, $q) {
            function interval(fn, delay, count, invokeApply) {
                var setInterval = $window.setInterval, clearInterval = $window.clearInterval, deferred = $q.defer(), promise = deferred.promise, iteration = 0, skipApply = isDefined(invokeApply) && !invokeApply;
                return count = isDefined(count) ? count : 0, promise.then(null, null, fn), promise.$$intervalId = setInterval(function() {
                    deferred.notify(iteration++), count > 0 && iteration >= count && (deferred.resolve(iteration), 
                    clearInterval(promise.$$intervalId), delete intervals[promise.$$intervalId]), skipApply || $rootScope.$apply();
                }, delay), intervals[promise.$$intervalId] = deferred, promise;
            }
            var intervals = {};
            return interval.cancel = function(promise) {
                return promise && promise.$$intervalId in intervals ? (intervals[promise.$$intervalId].reject("canceled"), 
                $window.clearInterval(promise.$$intervalId), delete intervals[promise.$$intervalId], 
                !0) : !1;
            }, interval;
        } ];
    }
    function $LocaleProvider() {
        this.$get = function() {
            return {
                id: "en-us",
                NUMBER_FORMATS: {
                    DECIMAL_SEP: ".",
                    GROUP_SEP: ",",
                    PATTERNS: [ {
                        minInt: 1,
                        minFrac: 0,
                        maxFrac: 3,
                        posPre: "",
                        posSuf: "",
                        negPre: "-",
                        negSuf: "",
                        gSize: 3,
                        lgSize: 3
                    }, {
                        minInt: 1,
                        minFrac: 2,
                        maxFrac: 2,
                        posPre: "¤",
                        posSuf: "",
                        negPre: "(¤",
                        negSuf: ")",
                        gSize: 3,
                        lgSize: 3
                    } ],
                    CURRENCY_SYM: "$"
                },
                DATETIME_FORMATS: {
                    MONTH: "January,February,March,April,May,June,July,August,September,October,November,December".split(","),
                    SHORTMONTH: "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(","),
                    DAY: "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),
                    SHORTDAY: "Sun,Mon,Tue,Wed,Thu,Fri,Sat".split(","),
                    AMPMS: [ "AM", "PM" ],
                    medium: "MMM d, y h:mm:ss a",
                    "short": "M/d/yy h:mm a",
                    fullDate: "EEEE, MMMM d, y",
                    longDate: "MMMM d, y",
                    mediumDate: "MMM d, y",
                    shortDate: "M/d/yy",
                    mediumTime: "h:mm:ss a",
                    shortTime: "h:mm a"
                },
                pluralCat: function(num) {
                    return 1 === num ? "one" : "other";
                }
            };
        };
    }
    function encodePath(path) {
        for (var segments = path.split("/"), i = segments.length; i--; ) segments[i] = encodeUriSegment(segments[i]);
        return segments.join("/");
    }
    function parseAbsoluteUrl(absoluteUrl, locationObj, appBase) {
        var parsedUrl = urlResolve(absoluteUrl, appBase);
        locationObj.$$protocol = parsedUrl.protocol, locationObj.$$host = parsedUrl.hostname, 
        locationObj.$$port = int(parsedUrl.port) || DEFAULT_PORTS[parsedUrl.protocol] || null;
    }
    function parseAppUrl(relativeUrl, locationObj, appBase) {
        var prefixed = "/" !== relativeUrl.charAt(0);
        prefixed && (relativeUrl = "/" + relativeUrl);
        var match = urlResolve(relativeUrl, appBase);
        locationObj.$$path = decodeURIComponent(prefixed && "/" === match.pathname.charAt(0) ? match.pathname.substring(1) : match.pathname), 
        locationObj.$$search = parseKeyValue(match.search), locationObj.$$hash = decodeURIComponent(match.hash), 
        locationObj.$$path && "/" != locationObj.$$path.charAt(0) && (locationObj.$$path = "/" + locationObj.$$path);
    }
    function beginsWith(begin, whole) {
        return 0 === whole.indexOf(begin) ? whole.substr(begin.length) : void 0;
    }
    function stripHash(url) {
        var index = url.indexOf("#");
        return -1 == index ? url : url.substr(0, index);
    }
    function stripFile(url) {
        return url.substr(0, stripHash(url).lastIndexOf("/") + 1);
    }
    function serverBase(url) {
        return url.substring(0, url.indexOf("/", url.indexOf("//") + 2));
    }
    function LocationHtml5Url(appBase, basePrefix) {
        this.$$html5 = !0, basePrefix = basePrefix || "";
        var appBaseNoFile = stripFile(appBase);
        parseAbsoluteUrl(appBase, this, appBase), this.$$parse = function(url) {
            var pathUrl = beginsWith(appBaseNoFile, url);
            if (!isString(pathUrl)) throw $locationMinErr("ipthprfx", 'Invalid url "{0}", missing path prefix "{1}".', url, appBaseNoFile);
            parseAppUrl(pathUrl, this, appBase), this.$$path || (this.$$path = "/"), this.$$compose();
        }, this.$$compose = function() {
            var search = toKeyValue(this.$$search), hash = this.$$hash ? "#" + encodeUriSegment(this.$$hash) : "";
            this.$$url = encodePath(this.$$path) + (search ? "?" + search : "") + hash, this.$$absUrl = appBaseNoFile + this.$$url.substr(1);
        }, this.$$parseLinkUrl = function(url, relHref) {
            var appUrl, prevAppUrl, rewrittenUrl;
            return (appUrl = beginsWith(appBase, url)) !== undefined ? (prevAppUrl = appUrl, 
            rewrittenUrl = (appUrl = beginsWith(basePrefix, appUrl)) !== undefined ? appBaseNoFile + (beginsWith("/", appUrl) || appUrl) : appBase + prevAppUrl) : (appUrl = beginsWith(appBaseNoFile, url)) !== undefined ? rewrittenUrl = appBaseNoFile + appUrl : appBaseNoFile == url + "/" && (rewrittenUrl = appBaseNoFile), 
            rewrittenUrl && this.$$parse(rewrittenUrl), !!rewrittenUrl;
        };
    }
    function LocationHashbangUrl(appBase, hashPrefix) {
        var appBaseNoFile = stripFile(appBase);
        parseAbsoluteUrl(appBase, this, appBase), this.$$parse = function(url) {
            function removeWindowsDriveName(path, url, base) {
                var firstPathSegmentMatch, windowsFilePathExp = /^\/[A-Z]:(\/.*)/;
                return 0 === url.indexOf(base) && (url = url.replace(base, "")), windowsFilePathExp.exec(url) ? path : (firstPathSegmentMatch = windowsFilePathExp.exec(path), 
                firstPathSegmentMatch ? firstPathSegmentMatch[1] : path);
            }
            var withoutBaseUrl = beginsWith(appBase, url) || beginsWith(appBaseNoFile, url), withoutHashUrl = "#" == withoutBaseUrl.charAt(0) ? beginsWith(hashPrefix, withoutBaseUrl) : this.$$html5 ? withoutBaseUrl : "";
            if (!isString(withoutHashUrl)) throw $locationMinErr("ihshprfx", 'Invalid url "{0}", missing hash prefix "{1}".', url, hashPrefix);
            parseAppUrl(withoutHashUrl, this, appBase), this.$$path = removeWindowsDriveName(this.$$path, withoutHashUrl, appBase), 
            this.$$compose();
        }, this.$$compose = function() {
            var search = toKeyValue(this.$$search), hash = this.$$hash ? "#" + encodeUriSegment(this.$$hash) : "";
            this.$$url = encodePath(this.$$path) + (search ? "?" + search : "") + hash, this.$$absUrl = appBase + (this.$$url ? hashPrefix + this.$$url : "");
        }, this.$$parseLinkUrl = function(url, relHref) {
            return stripHash(appBase) == stripHash(url) ? (this.$$parse(url), !0) : !1;
        };
    }
    function LocationHashbangInHtml5Url(appBase, hashPrefix) {
        this.$$html5 = !0, LocationHashbangUrl.apply(this, arguments);
        var appBaseNoFile = stripFile(appBase);
        this.$$parseLinkUrl = function(url, relHref) {
            var rewrittenUrl, appUrl;
            return appBase == stripHash(url) ? rewrittenUrl = url : (appUrl = beginsWith(appBaseNoFile, url)) ? rewrittenUrl = appBase + hashPrefix + appUrl : appBaseNoFile === url + "/" && (rewrittenUrl = appBaseNoFile), 
            rewrittenUrl && this.$$parse(rewrittenUrl), !!rewrittenUrl;
        }, this.$$compose = function() {
            var search = toKeyValue(this.$$search), hash = this.$$hash ? "#" + encodeUriSegment(this.$$hash) : "";
            this.$$url = encodePath(this.$$path) + (search ? "?" + search : "") + hash, this.$$absUrl = appBase + hashPrefix + this.$$url;
        };
    }
    function locationGetter(property) {
        return function() {
            return this[property];
        };
    }
    function locationGetterSetter(property, preprocess) {
        return function(value) {
            return isUndefined(value) ? this[property] : (this[property] = preprocess(value), 
            this.$$compose(), this);
        };
    }
    function $LocationProvider() {
        var hashPrefix = "", html5Mode = !1;
        this.hashPrefix = function(prefix) {
            return isDefined(prefix) ? (hashPrefix = prefix, this) : hashPrefix;
        }, this.html5Mode = function(mode) {
            return isDefined(mode) ? (html5Mode = mode, this) : html5Mode;
        }, this.$get = [ "$rootScope", "$browser", "$sniffer", "$rootElement", function($rootScope, $browser, $sniffer, $rootElement) {
            function afterLocationChange(oldUrl) {
                $rootScope.$broadcast("$locationChangeSuccess", $location.absUrl(), oldUrl);
            }
            var $location, LocationMode, appBase, baseHref = $browser.baseHref(), initialUrl = $browser.url();
            html5Mode ? (appBase = serverBase(initialUrl) + (baseHref || "/"), LocationMode = $sniffer.history ? LocationHtml5Url : LocationHashbangInHtml5Url) : (appBase = stripHash(initialUrl), 
            LocationMode = LocationHashbangUrl), $location = new LocationMode(appBase, "#" + hashPrefix), 
            $location.$$parseLinkUrl(initialUrl, initialUrl);
            var IGNORE_URI_REGEXP = /^\s*(javascript|mailto):/i;
            $rootElement.on("click", function(event) {
                if (!event.ctrlKey && !event.metaKey && 2 != event.which) {
                    for (var elm = jqLite(event.target); "a" !== lowercase(elm[0].nodeName); ) if (elm[0] === $rootElement[0] || !(elm = elm.parent())[0]) return;
                    var absHref = elm.prop("href"), relHref = elm.attr("href") || elm.attr("xlink:href");
                    isObject(absHref) && "[object SVGAnimatedString]" === absHref.toString() && (absHref = urlResolve(absHref.animVal).href), 
                    IGNORE_URI_REGEXP.test(absHref) || !absHref || elm.attr("target") || event.isDefaultPrevented() || $location.$$parseLinkUrl(absHref, relHref) && (event.preventDefault(), 
                    $location.absUrl() != $browser.url() && ($rootScope.$apply(), window.angular["ff-684208-preventDefault"] = !0));
                }
            }), $location.absUrl() != initialUrl && $browser.url($location.absUrl(), !0), $browser.onUrlChange(function(newUrl) {
                $location.absUrl() != newUrl && ($rootScope.$evalAsync(function() {
                    var oldUrl = $location.absUrl();
                    $location.$$parse(newUrl), $rootScope.$broadcast("$locationChangeStart", newUrl, oldUrl).defaultPrevented ? ($location.$$parse(oldUrl), 
                    $browser.url(oldUrl)) : afterLocationChange(oldUrl);
                }), $rootScope.$$phase || $rootScope.$digest());
            });
            var changeCounter = 0;
            return $rootScope.$watch(function() {
                var oldUrl = $browser.url(), currentReplace = $location.$$replace;
                return changeCounter && oldUrl == $location.absUrl() || (changeCounter++, $rootScope.$evalAsync(function() {
                    $rootScope.$broadcast("$locationChangeStart", $location.absUrl(), oldUrl).defaultPrevented ? $location.$$parse(oldUrl) : ($browser.url($location.absUrl(), currentReplace), 
                    afterLocationChange(oldUrl));
                })), $location.$$replace = !1, changeCounter;
            }), $location;
        } ];
    }
    function $LogProvider() {
        var debug = !0, self = this;
        this.debugEnabled = function(flag) {
            return isDefined(flag) ? (debug = flag, this) : debug;
        }, this.$get = [ "$window", function($window) {
            function formatError(arg) {
                return arg instanceof Error && (arg.stack ? arg = arg.message && -1 === arg.stack.indexOf(arg.message) ? "Error: " + arg.message + "\n" + arg.stack : arg.stack : arg.sourceURL && (arg = arg.message + "\n" + arg.sourceURL + ":" + arg.line)), 
                arg;
            }
            function consoleLog(type) {
                var console = $window.console || {}, logFn = console[type] || console.log || noop, hasApply = !1;
                try {
                    hasApply = !!logFn.apply;
                } catch (e) {}
                return hasApply ? function() {
                    var args = [];
                    return forEach(arguments, function(arg) {
                        args.push(formatError(arg));
                    }), logFn.apply(console, args);
                } : function(arg1, arg2) {
                    logFn(arg1, null == arg2 ? "" : arg2);
                };
            }
            return {
                log: consoleLog("log"),
                info: consoleLog("info"),
                warn: consoleLog("warn"),
                error: consoleLog("error"),
                debug: function() {
                    var fn = consoleLog("debug");
                    return function() {
                        debug && fn.apply(self, arguments);
                    };
                }()
            };
        } ];
    }
    function ensureSafeMemberName(name, fullExpression) {
        if ("__defineGetter__" === name || "__defineSetter__" === name || "__lookupGetter__" === name || "__lookupSetter__" === name || "__proto__" === name) throw $parseMinErr("isecfld", "Attempting to access a disallowed field in Angular expressions! Expression: {0}", fullExpression);
        return name;
    }
    function ensureSafeObject(obj, fullExpression) {
        if (obj) {
            if (obj.constructor === obj) throw $parseMinErr("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", fullExpression);
            if (obj.document && obj.location && obj.alert && obj.setInterval) throw $parseMinErr("isecwindow", "Referencing the Window in Angular expressions is disallowed! Expression: {0}", fullExpression);
            if (obj.children && (obj.nodeName || obj.prop && obj.attr && obj.find)) throw $parseMinErr("isecdom", "Referencing DOM nodes in Angular expressions is disallowed! Expression: {0}", fullExpression);
            if (obj === Object) throw $parseMinErr("isecobj", "Referencing Object in Angular expressions is disallowed! Expression: {0}", fullExpression);
        }
        return obj;
    }
    function ensureSafeFunction(obj, fullExpression) {
        if (obj) {
            if (obj.constructor === obj) throw $parseMinErr("isecfn", "Referencing Function in Angular expressions is disallowed! Expression: {0}", fullExpression);
            if (obj === CALL || obj === APPLY || BIND && obj === BIND) throw $parseMinErr("isecff", "Referencing call, apply or bind in Angular expressions is disallowed! Expression: {0}", fullExpression);
        }
    }
    function setter(obj, path, setValue, fullExp, options) {
        ensureSafeObject(obj, fullExp), options = options || {};
        for (var key, element = path.split("."), i = 0; element.length > 1; i++) {
            key = ensureSafeMemberName(element.shift(), fullExp);
            var propertyObj = ensureSafeObject(obj[key], fullExp);
            propertyObj || (propertyObj = {}, obj[key] = propertyObj), obj = propertyObj, obj.then && options.unwrapPromises && (promiseWarning(fullExp), 
            "$$v" in obj || !function(promise) {
                promise.then(function(val) {
                    promise.$$v = val;
                });
            }(obj), obj.$$v === undefined && (obj.$$v = {}), obj = obj.$$v);
        }
        return key = ensureSafeMemberName(element.shift(), fullExp), ensureSafeObject(obj[key], fullExp), 
        obj[key] = setValue, setValue;
    }
    function isPossiblyDangerousMemberName(name) {
        return "constructor" == name;
    }
    function cspSafeGetterFn(key0, key1, key2, key3, key4, fullExp, options) {
        ensureSafeMemberName(key0, fullExp), ensureSafeMemberName(key1, fullExp), ensureSafeMemberName(key2, fullExp), 
        ensureSafeMemberName(key3, fullExp), ensureSafeMemberName(key4, fullExp);
        var eso = function(o) {
            return ensureSafeObject(o, fullExp);
        }, expensiveChecks = options.expensiveChecks, eso0 = expensiveChecks || isPossiblyDangerousMemberName(key0) ? eso : identity, eso1 = expensiveChecks || isPossiblyDangerousMemberName(key1) ? eso : identity, eso2 = expensiveChecks || isPossiblyDangerousMemberName(key2) ? eso : identity, eso3 = expensiveChecks || isPossiblyDangerousMemberName(key3) ? eso : identity, eso4 = expensiveChecks || isPossiblyDangerousMemberName(key4) ? eso : identity;
        return options.unwrapPromises ? function(scope, locals) {
            var promise, pathVal = locals && locals.hasOwnProperty(key0) ? locals : scope;
            return null == pathVal ? pathVal : (pathVal = eso0(pathVal[key0]), pathVal && pathVal.then && (promiseWarning(fullExp), 
            "$$v" in pathVal || (promise = pathVal, promise.$$v = undefined, promise.then(function(val) {
                promise.$$v = eso0(val);
            })), pathVal = eso0(pathVal.$$v)), key1 ? null == pathVal ? undefined : (pathVal = eso1(pathVal[key1]), 
            pathVal && pathVal.then && (promiseWarning(fullExp), "$$v" in pathVal || (promise = pathVal, 
            promise.$$v = undefined, promise.then(function(val) {
                promise.$$v = eso1(val);
            })), pathVal = eso1(pathVal.$$v)), key2 ? null == pathVal ? undefined : (pathVal = eso2(pathVal[key2]), 
            pathVal && pathVal.then && (promiseWarning(fullExp), "$$v" in pathVal || (promise = pathVal, 
            promise.$$v = undefined, promise.then(function(val) {
                promise.$$v = eso2(val);
            })), pathVal = eso2(pathVal.$$v)), key3 ? null == pathVal ? undefined : (pathVal = eso3(pathVal[key3]), 
            pathVal && pathVal.then && (promiseWarning(fullExp), "$$v" in pathVal || (promise = pathVal, 
            promise.$$v = undefined, promise.then(function(val) {
                promise.$$v = eso3(val);
            })), pathVal = eso3(pathVal.$$v)), key4 ? null == pathVal ? undefined : (pathVal = eso4(pathVal[key4]), 
            pathVal && pathVal.then && (promiseWarning(fullExp), "$$v" in pathVal || (promise = pathVal, 
            promise.$$v = undefined, promise.then(function(val) {
                promise.$$v = eso4(val);
            })), pathVal = eso4(pathVal.$$v)), pathVal) : pathVal) : pathVal) : pathVal) : pathVal);
        } : function(scope, locals) {
            var pathVal = locals && locals.hasOwnProperty(key0) ? locals : scope;
            return null == pathVal ? pathVal : (pathVal = eso0(pathVal[key0]), key1 ? null == pathVal ? undefined : (pathVal = eso1(pathVal[key1]), 
            key2 ? null == pathVal ? undefined : (pathVal = eso2(pathVal[key2]), key3 ? null == pathVal ? undefined : (pathVal = eso3(pathVal[key3]), 
            key4 ? null == pathVal ? undefined : pathVal = eso4(pathVal[key4]) : pathVal) : pathVal) : pathVal) : pathVal);
        };
    }
    function getterFnWithExtraArgs(fn, fullExpression) {
        return function(s, l) {
            return fn(s, l, promiseWarning, ensureSafeObject, fullExpression);
        };
    }
    function getterFn(path, options, fullExp) {
        var expensiveChecks = options.expensiveChecks, getterFnCache = expensiveChecks ? getterFnCacheExpensive : getterFnCacheDefault;
        if (getterFnCache.hasOwnProperty(path)) return getterFnCache[path];
        var fn, pathKeys = path.split("."), pathKeysLength = pathKeys.length;
        if (options.csp) fn = 6 > pathKeysLength ? cspSafeGetterFn(pathKeys[0], pathKeys[1], pathKeys[2], pathKeys[3], pathKeys[4], fullExp, options) : function(scope, locals) {
            var val, i = 0;
            do val = cspSafeGetterFn(pathKeys[i++], pathKeys[i++], pathKeys[i++], pathKeys[i++], pathKeys[i++], fullExp, options)(scope, locals), 
            locals = undefined, scope = val; while (pathKeysLength > i);
            return val;
        }; else {
            var code = "var p;\n";
            expensiveChecks && (code += "s = eso(s, fe);\nl = eso(l, fe);\n");
            var needsEnsureSafeObject = expensiveChecks;
            forEach(pathKeys, function(key, index) {
                ensureSafeMemberName(key, fullExp);
                var lookupJs = (index ? "s" : '((l&&l.hasOwnProperty("' + key + '"))?l:s)') + '["' + key + '"]', wrapWithEso = expensiveChecks || isPossiblyDangerousMemberName(key);
                wrapWithEso && (lookupJs = "eso(" + lookupJs + ", fe)", needsEnsureSafeObject = !0), 
                code += "if(s == null) return undefined;\ns=" + lookupJs + ";\n", options.unwrapPromises && (code += 'if (s && s.then) {\n pw("' + fullExp.replace(/(["\r\n])/g, "\\$1") + '");\n if (!("$$v" in s)) {\n p=s;\n p.$$v = undefined;\n p.then(function(v) {p.$$v=' + (wrapWithEso ? "eso(v)" : "v") + ";});\n}\n s=" + (wrapWithEso ? "eso(s.$$v)" : "s.$$v") + "\n}\n");
            }), code += "return s;";
            var evaledFnGetter = new Function("s", "l", "pw", "eso", "fe", code);
            evaledFnGetter.toString = valueFn(code), (needsEnsureSafeObject || options.unwrapPromises) && (evaledFnGetter = getterFnWithExtraArgs(evaledFnGetter, fullExp)), 
            fn = evaledFnGetter;
        }
        return "hasOwnProperty" !== path && (getterFnCache[path] = fn), fn;
    }
    function $ParseProvider() {
        var cacheDefault = {}, cacheExpensive = {}, $parseOptions = {
            csp: !1,
            unwrapPromises: !1,
            logPromiseWarnings: !0,
            expensiveChecks: !1
        };
        this.unwrapPromises = function(value) {
            return isDefined(value) ? ($parseOptions.unwrapPromises = !!value, this) : $parseOptions.unwrapPromises;
        }, this.logPromiseWarnings = function(value) {
            return isDefined(value) ? ($parseOptions.logPromiseWarnings = value, this) : $parseOptions.logPromiseWarnings;
        }, this.$get = [ "$filter", "$sniffer", "$log", function($filter, $sniffer, $log) {
            $parseOptions.csp = $sniffer.csp;
            var $parseOptionsExpensive = {
                csp: $parseOptions.csp,
                unwrapPromises: $parseOptions.unwrapPromises,
                logPromiseWarnings: $parseOptions.logPromiseWarnings,
                expensiveChecks: !0
            };
            return promiseWarning = function(fullExp) {
                $parseOptions.logPromiseWarnings && !promiseWarningCache.hasOwnProperty(fullExp) && (promiseWarningCache[fullExp] = !0, 
                $log.warn("[$parse] Promise found in the expression `" + fullExp + "`. Automatic unwrapping of promises in Angular expressions is deprecated."));
            }, function(exp, expensiveChecks) {
                var parsedExpression;
                switch (typeof exp) {
                  case "string":
                    var cache = expensiveChecks ? cacheExpensive : cacheDefault;
                    if (cache.hasOwnProperty(exp)) return cache[exp];
                    var parseOptions = expensiveChecks ? $parseOptionsExpensive : $parseOptions, lexer = new Lexer(parseOptions), parser = new Parser(lexer, $filter, parseOptions);
                    return parsedExpression = parser.parse(exp), "hasOwnProperty" !== exp && (cache[exp] = parsedExpression), 
                    parsedExpression;

                  case "function":
                    return exp;

                  default:
                    return noop;
                }
            };
        } ];
    }
    function $QProvider() {
        this.$get = [ "$rootScope", "$exceptionHandler", function($rootScope, $exceptionHandler) {
            return qFactory(function(callback) {
                $rootScope.$evalAsync(callback);
            }, $exceptionHandler);
        } ];
    }
    function qFactory(nextTick, exceptionHandler) {
        function defaultCallback(value) {
            return value;
        }
        function defaultErrback(reason) {
            return reject(reason);
        }
        function all(promises) {
            var deferred = defer(), counter = 0, results = isArray(promises) ? [] : {};
            return forEach(promises, function(promise, key) {
                counter++, ref(promise).then(function(value) {
                    results.hasOwnProperty(key) || (results[key] = value, --counter || deferred.resolve(results));
                }, function(reason) {
                    results.hasOwnProperty(key) || deferred.reject(reason);
                });
            }), 0 === counter && deferred.resolve(results), deferred.promise;
        }
        var defer = function() {
            var value, deferred, pending = [];
            return deferred = {
                resolve: function(val) {
                    if (pending) {
                        var callbacks = pending;
                        pending = undefined, value = ref(val), callbacks.length && nextTick(function() {
                            for (var callback, i = 0, ii = callbacks.length; ii > i; i++) callback = callbacks[i], 
                            value.then(callback[0], callback[1], callback[2]);
                        });
                    }
                },
                reject: function(reason) {
                    deferred.resolve(createInternalRejectedPromise(reason));
                },
                notify: function(progress) {
                    if (pending) {
                        var callbacks = pending;
                        pending.length && nextTick(function() {
                            for (var callback, i = 0, ii = callbacks.length; ii > i; i++) callback = callbacks[i], 
                            callback[2](progress);
                        });
                    }
                },
                promise: {
                    then: function(callback, errback, progressback) {
                        var result = defer(), wrappedCallback = function(value) {
                            try {
                                result.resolve((isFunction(callback) ? callback : defaultCallback)(value));
                            } catch (e) {
                                result.reject(e), exceptionHandler(e);
                            }
                        }, wrappedErrback = function(reason) {
                            try {
                                result.resolve((isFunction(errback) ? errback : defaultErrback)(reason));
                            } catch (e) {
                                result.reject(e), exceptionHandler(e);
                            }
                        }, wrappedProgressback = function(progress) {
                            try {
                                result.notify((isFunction(progressback) ? progressback : defaultCallback)(progress));
                            } catch (e) {
                                exceptionHandler(e);
                            }
                        };
                        return pending ? pending.push([ wrappedCallback, wrappedErrback, wrappedProgressback ]) : value.then(wrappedCallback, wrappedErrback, wrappedProgressback), 
                        result.promise;
                    },
                    "catch": function(callback) {
                        return this.then(null, callback);
                    },
                    "finally": function(callback) {
                        function makePromise(value, resolved) {
                            var result = defer();
                            return resolved ? result.resolve(value) : result.reject(value), result.promise;
                        }
                        function handleCallback(value, isResolved) {
                            var callbackOutput = null;
                            try {
                                callbackOutput = (callback || defaultCallback)();
                            } catch (e) {
                                return makePromise(e, !1);
                            }
                            return isPromiseLike(callbackOutput) ? callbackOutput.then(function() {
                                return makePromise(value, isResolved);
                            }, function(error) {
                                return makePromise(error, !1);
                            }) : makePromise(value, isResolved);
                        }
                        return this.then(function(value) {
                            return handleCallback(value, !0);
                        }, function(error) {
                            return handleCallback(error, !1);
                        });
                    }
                }
            };
        }, ref = function(value) {
            return isPromiseLike(value) ? value : {
                then: function(callback) {
                    var result = defer();
                    return nextTick(function() {
                        result.resolve(callback(value));
                    }), result.promise;
                }
            };
        }, reject = function(reason) {
            var result = defer();
            return result.reject(reason), result.promise;
        }, createInternalRejectedPromise = function(reason) {
            return {
                then: function(callback, errback) {
                    var result = defer();
                    return nextTick(function() {
                        try {
                            result.resolve((isFunction(errback) ? errback : defaultErrback)(reason));
                        } catch (e) {
                            result.reject(e), exceptionHandler(e);
                        }
                    }), result.promise;
                }
            };
        }, when = function(value, callback, errback, progressback) {
            var done, result = defer(), wrappedCallback = function(value) {
                try {
                    return (isFunction(callback) ? callback : defaultCallback)(value);
                } catch (e) {
                    return exceptionHandler(e), reject(e);
                }
            }, wrappedErrback = function(reason) {
                try {
                    return (isFunction(errback) ? errback : defaultErrback)(reason);
                } catch (e) {
                    return exceptionHandler(e), reject(e);
                }
            }, wrappedProgressback = function(progress) {
                try {
                    return (isFunction(progressback) ? progressback : defaultCallback)(progress);
                } catch (e) {
                    exceptionHandler(e);
                }
            };
            return nextTick(function() {
                ref(value).then(function(value) {
                    done || (done = !0, result.resolve(ref(value).then(wrappedCallback, wrappedErrback, wrappedProgressback)));
                }, function(reason) {
                    done || (done = !0, result.resolve(wrappedErrback(reason)));
                }, function(progress) {
                    done || result.notify(wrappedProgressback(progress));
                });
            }), result.promise;
        };
        return {
            defer: defer,
            reject: reject,
            when: when,
            all: all
        };
    }
    function $$RAFProvider() {
        this.$get = [ "$window", "$timeout", function($window, $timeout) {
            var requestAnimationFrame = $window.requestAnimationFrame || $window.webkitRequestAnimationFrame || $window.mozRequestAnimationFrame, cancelAnimationFrame = $window.cancelAnimationFrame || $window.webkitCancelAnimationFrame || $window.mozCancelAnimationFrame || $window.webkitCancelRequestAnimationFrame, rafSupported = !!requestAnimationFrame, raf = rafSupported ? function(fn) {
                var id = requestAnimationFrame(fn);
                return function() {
                    cancelAnimationFrame(id);
                };
            } : function(fn) {
                var timer = $timeout(fn, 16.66, !1);
                return function() {
                    $timeout.cancel(timer);
                };
            };
            return raf.supported = rafSupported, raf;
        } ];
    }
    function $RootScopeProvider() {
        var TTL = 10, $rootScopeMinErr = minErr("$rootScope"), lastDirtyWatch = null;
        this.digestTtl = function(value) {
            return arguments.length && (TTL = value), TTL;
        }, this.$get = [ "$injector", "$exceptionHandler", "$parse", "$browser", function($injector, $exceptionHandler, $parse, $browser) {
            function Scope() {
                this.$id = nextUid(), this.$$phase = this.$parent = this.$$watchers = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = null, 
                this["this"] = this.$root = this, this.$$destroyed = !1, this.$$asyncQueue = [], 
                this.$$postDigestQueue = [], this.$$listeners = {}, this.$$listenerCount = {}, this.$$isolateBindings = {};
            }
            function beginPhase(phase) {
                if ($rootScope.$$phase) throw $rootScopeMinErr("inprog", "{0} already in progress", $rootScope.$$phase);
                $rootScope.$$phase = phase;
            }
            function clearPhase() {
                $rootScope.$$phase = null;
            }
            function compileToFn(exp, name) {
                var fn = $parse(exp);
                return assertArgFn(fn, name), fn;
            }
            function decrementListenerCount(current, count, name) {
                do current.$$listenerCount[name] -= count, 0 === current.$$listenerCount[name] && delete current.$$listenerCount[name]; while (current = current.$parent);
            }
            function initWatchVal() {}
            Scope.prototype = {
                constructor: Scope,
                $new: function(isolate) {
                    var child;
                    return isolate ? (child = new Scope(), child.$root = this.$root, child.$$asyncQueue = this.$$asyncQueue, 
                    child.$$postDigestQueue = this.$$postDigestQueue) : (this.$$childScopeClass || (this.$$childScopeClass = function() {
                        this.$$watchers = this.$$nextSibling = this.$$childHead = this.$$childTail = null, 
                        this.$$listeners = {}, this.$$listenerCount = {}, this.$id = nextUid(), this.$$childScopeClass = null;
                    }, this.$$childScopeClass.prototype = this), child = new this.$$childScopeClass()), 
                    child["this"] = child, child.$parent = this, child.$$prevSibling = this.$$childTail, 
                    this.$$childHead ? (this.$$childTail.$$nextSibling = child, this.$$childTail = child) : this.$$childHead = this.$$childTail = child, 
                    child;
                },
                $watch: function(watchExp, listener, objectEquality) {
                    var scope = this, get = compileToFn(watchExp, "watch"), array = scope.$$watchers, watcher = {
                        fn: listener,
                        last: initWatchVal,
                        get: get,
                        exp: watchExp,
                        eq: !!objectEquality
                    };
                    if (lastDirtyWatch = null, !isFunction(listener)) {
                        var listenFn = compileToFn(listener || noop, "listener");
                        watcher.fn = function(newVal, oldVal, scope) {
                            listenFn(scope);
                        };
                    }
                    if ("string" == typeof watchExp && get.constant) {
                        var originalFn = watcher.fn;
                        watcher.fn = function(newVal, oldVal, scope) {
                            originalFn.call(this, newVal, oldVal, scope), arrayRemove(array, watcher);
                        };
                    }
                    return array || (array = scope.$$watchers = []), array.unshift(watcher), function() {
                        arrayRemove(array, watcher), lastDirtyWatch = null;
                    };
                },
                $watchCollection: function(obj, listener) {
                    function $watchCollectionWatch() {
                        newValue = objGetter(self);
                        var newLength, key, bothNaN;
                        if (isObject(newValue)) if (isArrayLike(newValue)) {
                            oldValue !== internalArray && (oldValue = internalArray, oldLength = oldValue.length = 0, 
                            changeDetected++), newLength = newValue.length, oldLength !== newLength && (changeDetected++, 
                            oldValue.length = oldLength = newLength);
                            for (var i = 0; newLength > i; i++) bothNaN = oldValue[i] !== oldValue[i] && newValue[i] !== newValue[i], 
                            bothNaN || oldValue[i] === newValue[i] || (changeDetected++, oldValue[i] = newValue[i]);
                        } else {
                            oldValue !== internalObject && (oldValue = internalObject = {}, oldLength = 0, changeDetected++), 
                            newLength = 0;
                            for (key in newValue) newValue.hasOwnProperty(key) && (newLength++, oldValue.hasOwnProperty(key) ? (bothNaN = oldValue[key] !== oldValue[key] && newValue[key] !== newValue[key], 
                            bothNaN || oldValue[key] === newValue[key] || (changeDetected++, oldValue[key] = newValue[key])) : (oldLength++, 
                            oldValue[key] = newValue[key], changeDetected++));
                            if (oldLength > newLength) {
                                changeDetected++;
                                for (key in oldValue) oldValue.hasOwnProperty(key) && !newValue.hasOwnProperty(key) && (oldLength--, 
                                delete oldValue[key]);
                            }
                        } else oldValue !== newValue && (oldValue = newValue, changeDetected++);
                        return changeDetected;
                    }
                    function $watchCollectionAction() {
                        if (initRun ? (initRun = !1, listener(newValue, newValue, self)) : listener(newValue, veryOldValue, self), 
                        trackVeryOldValue) if (isObject(newValue)) if (isArrayLike(newValue)) {
                            veryOldValue = new Array(newValue.length);
                            for (var i = 0; i < newValue.length; i++) veryOldValue[i] = newValue[i];
                        } else {
                            veryOldValue = {};
                            for (var key in newValue) hasOwnProperty.call(newValue, key) && (veryOldValue[key] = newValue[key]);
                        } else veryOldValue = newValue;
                    }
                    var newValue, oldValue, veryOldValue, self = this, trackVeryOldValue = listener.length > 1, changeDetected = 0, objGetter = $parse(obj), internalArray = [], internalObject = {}, initRun = !0, oldLength = 0;
                    return this.$watch($watchCollectionWatch, $watchCollectionAction);
                },
                $digest: function() {
                    var watch, value, last, watchers, length, dirty, next, current, logIdx, logMsg, asyncTask, asyncQueue = this.$$asyncQueue, postDigestQueue = this.$$postDigestQueue, ttl = TTL, target = this, watchLog = [];
                    beginPhase("$digest"), $browser.$$checkUrlChange(), lastDirtyWatch = null;
                    do {
                        for (dirty = !1, current = target; asyncQueue.length; ) {
                            try {
                                asyncTask = asyncQueue.shift(), asyncTask.scope.$eval(asyncTask.expression);
                            } catch (e) {
                                clearPhase(), $exceptionHandler(e);
                            }
                            lastDirtyWatch = null;
                        }
                        traverseScopesLoop: do {
                            if (watchers = current.$$watchers) for (length = watchers.length; length--; ) try {
                                if (watch = watchers[length]) if ((value = watch.get(current)) === (last = watch.last) || (watch.eq ? equals(value, last) : "number" == typeof value && "number" == typeof last && isNaN(value) && isNaN(last))) {
                                    if (watch === lastDirtyWatch) {
                                        dirty = !1;
                                        break traverseScopesLoop;
                                    }
                                } else dirty = !0, lastDirtyWatch = watch, watch.last = watch.eq ? copy(value, null) : value, 
                                watch.fn(value, last === initWatchVal ? value : last, current), 5 > ttl && (logIdx = 4 - ttl, 
                                watchLog[logIdx] || (watchLog[logIdx] = []), logMsg = isFunction(watch.exp) ? "fn: " + (watch.exp.name || watch.exp.toString()) : watch.exp, 
                                logMsg += "; newVal: " + toJson(value) + "; oldVal: " + toJson(last), watchLog[logIdx].push(logMsg));
                            } catch (e) {
                                clearPhase(), $exceptionHandler(e);
                            }
                            if (!(next = current.$$childHead || current !== target && current.$$nextSibling)) for (;current !== target && !(next = current.$$nextSibling); ) current = current.$parent;
                        } while (current = next);
                        if ((dirty || asyncQueue.length) && !ttl--) throw clearPhase(), $rootScopeMinErr("infdig", "{0} $digest() iterations reached. Aborting!\nWatchers fired in the last 5 iterations: {1}", TTL, toJson(watchLog));
                    } while (dirty || asyncQueue.length);
                    for (clearPhase(); postDigestQueue.length; ) try {
                        postDigestQueue.shift()();
                    } catch (e) {
                        $exceptionHandler(e);
                    }
                },
                $destroy: function() {
                    if (!this.$$destroyed) {
                        var parent = this.$parent;
                        this.$broadcast("$destroy"), this.$$destroyed = !0, this !== $rootScope && (forEach(this.$$listenerCount, bind(null, decrementListenerCount, this)), 
                        parent.$$childHead == this && (parent.$$childHead = this.$$nextSibling), parent.$$childTail == this && (parent.$$childTail = this.$$prevSibling), 
                        this.$$prevSibling && (this.$$prevSibling.$$nextSibling = this.$$nextSibling), this.$$nextSibling && (this.$$nextSibling.$$prevSibling = this.$$prevSibling), 
                        this.$parent = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = this.$root = null, 
                        this.$$listeners = {}, this.$$watchers = this.$$asyncQueue = this.$$postDigestQueue = [], 
                        this.$destroy = this.$digest = this.$apply = noop, this.$on = this.$watch = function() {
                            return noop;
                        });
                    }
                },
                $eval: function(expr, locals) {
                    return $parse(expr)(this, locals);
                },
                $evalAsync: function(expr) {
                    $rootScope.$$phase || $rootScope.$$asyncQueue.length || $browser.defer(function() {
                        $rootScope.$$asyncQueue.length && $rootScope.$digest();
                    }), this.$$asyncQueue.push({
                        scope: this,
                        expression: expr
                    });
                },
                $$postDigest: function(fn) {
                    this.$$postDigestQueue.push(fn);
                },
                $apply: function(expr) {
                    try {
                        return beginPhase("$apply"), this.$eval(expr);
                    } catch (e) {
                        $exceptionHandler(e);
                    } finally {
                        clearPhase();
                        try {
                            $rootScope.$digest();
                        } catch (e) {
                            throw $exceptionHandler(e), e;
                        }
                    }
                },
                $on: function(name, listener) {
                    var namedListeners = this.$$listeners[name];
                    namedListeners || (this.$$listeners[name] = namedListeners = []), namedListeners.push(listener);
                    var current = this;
                    do current.$$listenerCount[name] || (current.$$listenerCount[name] = 0), current.$$listenerCount[name]++; while (current = current.$parent);
                    var self = this;
                    return function() {
                        var indexOfListener = indexOf(namedListeners, listener);
                        -1 !== indexOfListener && (namedListeners[indexOfListener] = null, decrementListenerCount(self, 1, name));
                    };
                },
                $emit: function(name, args) {
                    var namedListeners, i, length, empty = [], scope = this, stopPropagation = !1, event = {
                        name: name,
                        targetScope: scope,
                        stopPropagation: function() {
                            stopPropagation = !0;
                        },
                        preventDefault: function() {
                            event.defaultPrevented = !0;
                        },
                        defaultPrevented: !1
                    }, listenerArgs = concat([ event ], arguments, 1);
                    do {
                        for (namedListeners = scope.$$listeners[name] || empty, event.currentScope = scope, 
                        i = 0, length = namedListeners.length; length > i; i++) if (namedListeners[i]) try {
                            namedListeners[i].apply(null, listenerArgs);
                        } catch (e) {
                            $exceptionHandler(e);
                        } else namedListeners.splice(i, 1), i--, length--;
                        if (stopPropagation) return event;
                        scope = scope.$parent;
                    } while (scope);
                    return event;
                },
                $broadcast: function(name, args) {
                    for (var listeners, i, length, target = this, current = target, next = target, event = {
                        name: name,
                        targetScope: target,
                        preventDefault: function() {
                            event.defaultPrevented = !0;
                        },
                        defaultPrevented: !1
                    }, listenerArgs = concat([ event ], arguments, 1); current = next; ) {
                        for (event.currentScope = current, listeners = current.$$listeners[name] || [], 
                        i = 0, length = listeners.length; length > i; i++) if (listeners[i]) try {
                            listeners[i].apply(null, listenerArgs);
                        } catch (e) {
                            $exceptionHandler(e);
                        } else listeners.splice(i, 1), i--, length--;
                        if (!(next = current.$$listenerCount[name] && current.$$childHead || current !== target && current.$$nextSibling)) for (;current !== target && !(next = current.$$nextSibling); ) current = current.$parent;
                    }
                    return event;
                }
            };
            var $rootScope = new Scope();
            return $rootScope;
        } ];
    }
    function $$SanitizeUriProvider() {
        var aHrefSanitizationWhitelist = /^\s*(https?|ftp|mailto|tel|file):/, imgSrcSanitizationWhitelist = /^\s*((https?|ftp|file):|data:image\/)/;
        this.aHrefSanitizationWhitelist = function(regexp) {
            return isDefined(regexp) ? (aHrefSanitizationWhitelist = regexp, this) : aHrefSanitizationWhitelist;
        }, this.imgSrcSanitizationWhitelist = function(regexp) {
            return isDefined(regexp) ? (imgSrcSanitizationWhitelist = regexp, this) : imgSrcSanitizationWhitelist;
        }, this.$get = function() {
            return function(uri, isImage) {
                var normalizedVal, regex = isImage ? imgSrcSanitizationWhitelist : aHrefSanitizationWhitelist;
                return msie && !(msie >= 8) || (normalizedVal = urlResolve(uri).href, "" === normalizedVal || normalizedVal.match(regex)) ? uri : "unsafe:" + normalizedVal;
            };
        };
    }
    function escapeForRegexp(s) {
        return s.replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
    }
    function adjustMatcher(matcher) {
        if ("self" === matcher) return matcher;
        if (isString(matcher)) {
            if (matcher.indexOf("***") > -1) throw $sceMinErr("iwcard", "Illegal sequence *** in string matcher.  String: {0}", matcher);
            return matcher = escapeForRegexp(matcher).replace("\\*\\*", ".*").replace("\\*", "[^:/.?&;]*"), 
            new RegExp("^" + matcher + "$");
        }
        if (isRegExp(matcher)) return new RegExp("^" + matcher.source + "$");
        throw $sceMinErr("imatcher", 'Matchers may only be "self", string patterns or RegExp objects');
    }
    function adjustMatchers(matchers) {
        var adjustedMatchers = [];
        return isDefined(matchers) && forEach(matchers, function(matcher) {
            adjustedMatchers.push(adjustMatcher(matcher));
        }), adjustedMatchers;
    }
    function $SceDelegateProvider() {
        this.SCE_CONTEXTS = SCE_CONTEXTS;
        var resourceUrlWhitelist = [ "self" ], resourceUrlBlacklist = [];
        this.resourceUrlWhitelist = function(value) {
            return arguments.length && (resourceUrlWhitelist = adjustMatchers(value)), resourceUrlWhitelist;
        }, this.resourceUrlBlacklist = function(value) {
            return arguments.length && (resourceUrlBlacklist = adjustMatchers(value)), resourceUrlBlacklist;
        }, this.$get = [ "$injector", function($injector) {
            function matchUrl(matcher, parsedUrl) {
                return "self" === matcher ? urlIsSameOrigin(parsedUrl) : !!matcher.exec(parsedUrl.href);
            }
            function isResourceUrlAllowedByPolicy(url) {
                var i, n, parsedUrl = urlResolve(url.toString()), allowed = !1;
                for (i = 0, n = resourceUrlWhitelist.length; n > i; i++) if (matchUrl(resourceUrlWhitelist[i], parsedUrl)) {
                    allowed = !0;
                    break;
                }
                if (allowed) for (i = 0, n = resourceUrlBlacklist.length; n > i; i++) if (matchUrl(resourceUrlBlacklist[i], parsedUrl)) {
                    allowed = !1;
                    break;
                }
                return allowed;
            }
            function generateHolderType(Base) {
                var holderType = function(trustedValue) {
                    this.$$unwrapTrustedValue = function() {
                        return trustedValue;
                    };
                };
                return Base && (holderType.prototype = new Base()), holderType.prototype.valueOf = function() {
                    return this.$$unwrapTrustedValue();
                }, holderType.prototype.toString = function() {
                    return this.$$unwrapTrustedValue().toString();
                }, holderType;
            }
            function trustAs(type, trustedValue) {
                var Constructor = byType.hasOwnProperty(type) ? byType[type] : null;
                if (!Constructor) throw $sceMinErr("icontext", "Attempted to trust a value in invalid context. Context: {0}; Value: {1}", type, trustedValue);
                if (null === trustedValue || trustedValue === undefined || "" === trustedValue) return trustedValue;
                if ("string" != typeof trustedValue) throw $sceMinErr("itype", "Attempted to trust a non-string value in a content requiring a string: Context: {0}", type);
                return new Constructor(trustedValue);
            }
            function valueOf(maybeTrusted) {
                return maybeTrusted instanceof trustedValueHolderBase ? maybeTrusted.$$unwrapTrustedValue() : maybeTrusted;
            }
            function getTrusted(type, maybeTrusted) {
                if (null === maybeTrusted || maybeTrusted === undefined || "" === maybeTrusted) return maybeTrusted;
                var constructor = byType.hasOwnProperty(type) ? byType[type] : null;
                if (constructor && maybeTrusted instanceof constructor) return maybeTrusted.$$unwrapTrustedValue();
                if (type === SCE_CONTEXTS.RESOURCE_URL) {
                    if (isResourceUrlAllowedByPolicy(maybeTrusted)) return maybeTrusted;
                    throw $sceMinErr("insecurl", "Blocked loading resource from url not allowed by $sceDelegate policy.  URL: {0}", maybeTrusted.toString());
                }
                if (type === SCE_CONTEXTS.HTML) return htmlSanitizer(maybeTrusted);
                throw $sceMinErr("unsafe", "Attempting to use an unsafe value in a safe context.");
            }
            var htmlSanitizer = function(html) {
                throw $sceMinErr("unsafe", "Attempting to use an unsafe value in a safe context.");
            };
            $injector.has("$sanitize") && (htmlSanitizer = $injector.get("$sanitize"));
            var trustedValueHolderBase = generateHolderType(), byType = {};
            return byType[SCE_CONTEXTS.HTML] = generateHolderType(trustedValueHolderBase), byType[SCE_CONTEXTS.CSS] = generateHolderType(trustedValueHolderBase), 
            byType[SCE_CONTEXTS.URL] = generateHolderType(trustedValueHolderBase), byType[SCE_CONTEXTS.JS] = generateHolderType(trustedValueHolderBase), 
            byType[SCE_CONTEXTS.RESOURCE_URL] = generateHolderType(byType[SCE_CONTEXTS.URL]), 
            {
                trustAs: trustAs,
                getTrusted: getTrusted,
                valueOf: valueOf
            };
        } ];
    }
    function $SceProvider() {
        var enabled = !0;
        this.enabled = function(value) {
            return arguments.length && (enabled = !!value), enabled;
        }, this.$get = [ "$parse", "$sniffer", "$sceDelegate", function($parse, $sniffer, $sceDelegate) {
            if (enabled && $sniffer.msie && $sniffer.msieDocumentMode < 8) throw $sceMinErr("iequirks", "Strict Contextual Escaping does not support Internet Explorer version < 9 in quirks mode.  You can fix this by adding the text <!doctype html> to the top of your HTML document.  See http://docs.angularjs.org/api/ng.$sce for more information.");
            var sce = shallowCopy(SCE_CONTEXTS);
            sce.isEnabled = function() {
                return enabled;
            }, sce.trustAs = $sceDelegate.trustAs, sce.getTrusted = $sceDelegate.getTrusted, 
            sce.valueOf = $sceDelegate.valueOf, enabled || (sce.trustAs = sce.getTrusted = function(type, value) {
                return value;
            }, sce.valueOf = identity), sce.parseAs = function(type, expr) {
                var parsed = $parse(expr);
                return parsed.literal && parsed.constant ? parsed : function(self, locals) {
                    return sce.getTrusted(type, parsed(self, locals));
                };
            };
            var parse = sce.parseAs, getTrusted = sce.getTrusted, trustAs = sce.trustAs;
            return forEach(SCE_CONTEXTS, function(enumValue, name) {
                var lName = lowercase(name);
                sce[camelCase("parse_as_" + lName)] = function(expr) {
                    return parse(enumValue, expr);
                }, sce[camelCase("get_trusted_" + lName)] = function(value) {
                    return getTrusted(enumValue, value);
                }, sce[camelCase("trust_as_" + lName)] = function(value) {
                    return trustAs(enumValue, value);
                };
            }), sce;
        } ];
    }
    function $SnifferProvider() {
        this.$get = [ "$window", "$document", function($window, $document) {
            var vendorPrefix, match, eventSupport = {}, android = int((/android (\d+)/.exec(lowercase(($window.navigator || {}).userAgent)) || [])[1]), boxee = /Boxee/i.test(($window.navigator || {}).userAgent), document = $document[0] || {}, documentMode = document.documentMode, vendorRegex = /^(Moz|webkit|O|ms)(?=[A-Z])/, bodyStyle = document.body && document.body.style, transitions = !1, animations = !1;
            if (bodyStyle) {
                for (var prop in bodyStyle) if (match = vendorRegex.exec(prop)) {
                    vendorPrefix = match[0], vendorPrefix = vendorPrefix.substr(0, 1).toUpperCase() + vendorPrefix.substr(1);
                    break;
                }
                vendorPrefix || (vendorPrefix = "WebkitOpacity" in bodyStyle && "webkit"), transitions = !!("transition" in bodyStyle || vendorPrefix + "Transition" in bodyStyle), 
                animations = !!("animation" in bodyStyle || vendorPrefix + "Animation" in bodyStyle), 
                !android || transitions && animations || (transitions = isString(document.body.style.webkitTransition), 
                animations = isString(document.body.style.webkitAnimation));
            }
            return {
                history: !(!$window.history || !$window.history.pushState || 4 > android || boxee),
                hashchange: "onhashchange" in $window && (!documentMode || documentMode > 7),
                hasEvent: function(event) {
                    if ("input" == event && 9 == msie) return !1;
                    if (isUndefined(eventSupport[event])) {
                        var divElm = document.createElement("div");
                        eventSupport[event] = "on" + event in divElm;
                    }
                    return eventSupport[event];
                },
                csp: csp(),
                vendorPrefix: vendorPrefix,
                transitions: transitions,
                animations: animations,
                android: android,
                msie: msie,
                msieDocumentMode: documentMode
            };
        } ];
    }
    function $TimeoutProvider() {
        this.$get = [ "$rootScope", "$browser", "$q", "$exceptionHandler", function($rootScope, $browser, $q, $exceptionHandler) {
            function timeout(fn, delay, invokeApply) {
                var timeoutId, deferred = $q.defer(), promise = deferred.promise, skipApply = isDefined(invokeApply) && !invokeApply;
                return timeoutId = $browser.defer(function() {
                    try {
                        deferred.resolve(fn());
                    } catch (e) {
                        deferred.reject(e), $exceptionHandler(e);
                    } finally {
                        delete deferreds[promise.$$timeoutId];
                    }
                    skipApply || $rootScope.$apply();
                }, delay), promise.$$timeoutId = timeoutId, deferreds[timeoutId] = deferred, promise;
            }
            var deferreds = {};
            return timeout.cancel = function(promise) {
                return promise && promise.$$timeoutId in deferreds ? (deferreds[promise.$$timeoutId].reject("canceled"), 
                delete deferreds[promise.$$timeoutId], $browser.defer.cancel(promise.$$timeoutId)) : !1;
            }, timeout;
        } ];
    }
    function urlResolve(url, base) {
        var href = url;
        return msie && (urlParsingNode.setAttribute("href", href), href = urlParsingNode.href), 
        urlParsingNode.setAttribute("href", href), {
            href: urlParsingNode.href,
            protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, "") : "",
            host: urlParsingNode.host,
            search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, "") : "",
            hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, "") : "",
            hostname: urlParsingNode.hostname,
            port: urlParsingNode.port,
            pathname: "/" === urlParsingNode.pathname.charAt(0) ? urlParsingNode.pathname : "/" + urlParsingNode.pathname
        };
    }
    function urlIsSameOrigin(requestUrl) {
        var parsed = isString(requestUrl) ? urlResolve(requestUrl) : requestUrl;
        return parsed.protocol === originUrl.protocol && parsed.host === originUrl.host;
    }
    function $WindowProvider() {
        this.$get = valueFn(window);
    }
    function $FilterProvider($provide) {
        function register(name, factory) {
            if (isObject(name)) {
                var filters = {};
                return forEach(name, function(filter, key) {
                    filters[key] = register(key, filter);
                }), filters;
            }
            return $provide.factory(name + suffix, factory);
        }
        var suffix = "Filter";
        this.register = register, this.$get = [ "$injector", function($injector) {
            return function(name) {
                return $injector.get(name + suffix);
            };
        } ], register("currency", currencyFilter), register("date", dateFilter), register("filter", filterFilter), 
        register("json", jsonFilter), register("limitTo", limitToFilter), register("lowercase", lowercaseFilter), 
        register("number", numberFilter), register("orderBy", orderByFilter), register("uppercase", uppercaseFilter);
    }
    function filterFilter() {
        return function(array, expression, comparator) {
            if (!isArray(array)) return array;
            var comparatorType = typeof comparator, predicates = [];
            predicates.check = function(value) {
                for (var j = 0; j < predicates.length; j++) if (!predicates[j](value)) return !1;
                return !0;
            }, "function" !== comparatorType && (comparator = "boolean" === comparatorType && comparator ? function(obj, text) {
                return angular.equals(obj, text);
            } : function(obj, text) {
                if (obj && text && "object" == typeof obj && "object" == typeof text) {
                    for (var objKey in obj) if ("$" !== objKey.charAt(0) && hasOwnProperty.call(obj, objKey) && comparator(obj[objKey], text[objKey])) return !0;
                    return !1;
                }
                return text = ("" + text).toLowerCase(), ("" + obj).toLowerCase().indexOf(text) > -1;
            });
            var search = function(obj, text) {
                if ("string" == typeof text && "!" === text.charAt(0)) return !search(obj, text.substr(1));
                switch (typeof obj) {
                  case "boolean":
                  case "number":
                  case "string":
                    return comparator(obj, text);

                  case "object":
                    switch (typeof text) {
                      case "object":
                        return comparator(obj, text);

                      default:
                        for (var objKey in obj) if ("$" !== objKey.charAt(0) && search(obj[objKey], text)) return !0;
                    }
                    return !1;

                  case "array":
                    for (var i = 0; i < obj.length; i++) if (search(obj[i], text)) return !0;
                    return !1;

                  default:
                    return !1;
                }
            };
            switch (typeof expression) {
              case "boolean":
              case "number":
              case "string":
                expression = {
                    $: expression
                };

              case "object":
                for (var key in expression) !function(path) {
                    "undefined" != typeof expression[path] && predicates.push(function(value) {
                        return search("$" == path ? value : value && value[path], expression[path]);
                    });
                }(key);
                break;

              case "function":
                predicates.push(expression);
                break;

              default:
                return array;
            }
            for (var filtered = [], j = 0; j < array.length; j++) {
                var value = array[j];
                predicates.check(value) && filtered.push(value);
            }
            return filtered;
        };
    }
    function currencyFilter($locale) {
        var formats = $locale.NUMBER_FORMATS;
        return function(amount, currencySymbol) {
            return isUndefined(currencySymbol) && (currencySymbol = formats.CURRENCY_SYM), formatNumber(amount, formats.PATTERNS[1], formats.GROUP_SEP, formats.DECIMAL_SEP, 2).replace(/\u00A4/g, currencySymbol);
        };
    }
    function numberFilter($locale) {
        var formats = $locale.NUMBER_FORMATS;
        return function(number, fractionSize) {
            return formatNumber(number, formats.PATTERNS[0], formats.GROUP_SEP, formats.DECIMAL_SEP, fractionSize);
        };
    }
    function formatNumber(number, pattern, groupSep, decimalSep, fractionSize) {
        if (null == number || !isFinite(number) || isObject(number)) return "";
        var isNegative = 0 > number;
        number = Math.abs(number);
        var numStr = number + "", formatedText = "", parts = [], hasExponent = !1;
        if (-1 !== numStr.indexOf("e")) {
            var match = numStr.match(/([\d\.]+)e(-?)(\d+)/);
            match && "-" == match[2] && match[3] > fractionSize + 1 ? (numStr = "0", number = 0) : (formatedText = numStr, 
            hasExponent = !0);
        }
        if (hasExponent) fractionSize > 0 && number > -1 && 1 > number && (formatedText = number.toFixed(fractionSize)); else {
            var fractionLen = (numStr.split(DECIMAL_SEP)[1] || "").length;
            isUndefined(fractionSize) && (fractionSize = Math.min(Math.max(pattern.minFrac, fractionLen), pattern.maxFrac)), 
            number = +(Math.round(+(number.toString() + "e" + fractionSize)).toString() + "e" + -fractionSize), 
            0 === number && (isNegative = !1);
            var fraction = ("" + number).split(DECIMAL_SEP), whole = fraction[0];
            fraction = fraction[1] || "";
            var i, pos = 0, lgroup = pattern.lgSize, group = pattern.gSize;
            if (whole.length >= lgroup + group) for (pos = whole.length - lgroup, i = 0; pos > i; i++) (pos - i) % group === 0 && 0 !== i && (formatedText += groupSep), 
            formatedText += whole.charAt(i);
            for (i = pos; i < whole.length; i++) (whole.length - i) % lgroup === 0 && 0 !== i && (formatedText += groupSep), 
            formatedText += whole.charAt(i);
            for (;fraction.length < fractionSize; ) fraction += "0";
            fractionSize && "0" !== fractionSize && (formatedText += decimalSep + fraction.substr(0, fractionSize));
        }
        return parts.push(isNegative ? pattern.negPre : pattern.posPre), parts.push(formatedText), 
        parts.push(isNegative ? pattern.negSuf : pattern.posSuf), parts.join("");
    }
    function padNumber(num, digits, trim) {
        var neg = "";
        for (0 > num && (neg = "-", num = -num), num = "" + num; num.length < digits; ) num = "0" + num;
        return trim && (num = num.substr(num.length - digits)), neg + num;
    }
    function dateGetter(name, size, offset, trim) {
        return offset = offset || 0, function(date) {
            var value = date["get" + name]();
            return (offset > 0 || value > -offset) && (value += offset), 0 === value && -12 == offset && (value = 12), 
            padNumber(value, size, trim);
        };
    }
    function dateStrGetter(name, shortForm) {
        return function(date, formats) {
            var value = date["get" + name](), get = uppercase(shortForm ? "SHORT" + name : name);
            return formats[get][value];
        };
    }
    function timeZoneGetter(date) {
        var zone = -1 * date.getTimezoneOffset(), paddedZone = zone >= 0 ? "+" : "";
        return paddedZone += padNumber(Math[zone > 0 ? "floor" : "ceil"](zone / 60), 2) + padNumber(Math.abs(zone % 60), 2);
    }
    function ampmGetter(date, formats) {
        return date.getHours() < 12 ? formats.AMPMS[0] : formats.AMPMS[1];
    }
    function dateFilter($locale) {
        function jsonStringToDate(string) {
            var match;
            if (match = string.match(R_ISO8601_STR)) {
                var date = new Date(0), tzHour = 0, tzMin = 0, dateSetter = match[8] ? date.setUTCFullYear : date.setFullYear, timeSetter = match[8] ? date.setUTCHours : date.setHours;
                match[9] && (tzHour = int(match[9] + match[10]), tzMin = int(match[9] + match[11])), 
                dateSetter.call(date, int(match[1]), int(match[2]) - 1, int(match[3]));
                var h = int(match[4] || 0) - tzHour, m = int(match[5] || 0) - tzMin, s = int(match[6] || 0), ms = Math.round(1e3 * parseFloat("0." + (match[7] || 0)));
                return timeSetter.call(date, h, m, s, ms), date;
            }
            return string;
        }
        var R_ISO8601_STR = /^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/;
        return function(date, format) {
            var fn, match, text = "", parts = [];
            if (format = format || "mediumDate", format = $locale.DATETIME_FORMATS[format] || format, 
            isString(date) && (date = NUMBER_STRING.test(date) ? int(date) : jsonStringToDate(date)), 
            isNumber(date) && (date = new Date(date)), !isDate(date)) return date;
            for (;format; ) match = DATE_FORMATS_SPLIT.exec(format), match ? (parts = concat(parts, match, 1), 
            format = parts.pop()) : (parts.push(format), format = null);
            return forEach(parts, function(value) {
                fn = DATE_FORMATS[value], text += fn ? fn(date, $locale.DATETIME_FORMATS) : value.replace(/(^'|'$)/g, "").replace(/''/g, "'");
            }), text;
        };
    }
    function jsonFilter() {
        return function(object) {
            return toJson(object, !0);
        };
    }
    function limitToFilter() {
        return function(input, limit) {
            if (!isArray(input) && !isString(input)) return input;
            if (limit = Math.abs(Number(limit)) === 1 / 0 ? Number(limit) : int(limit), isString(input)) return limit ? limit >= 0 ? input.slice(0, limit) : input.slice(limit, input.length) : "";
            var i, n, out = [];
            for (limit > input.length ? limit = input.length : limit < -input.length && (limit = -input.length), 
            limit > 0 ? (i = 0, n = limit) : (i = input.length + limit, n = input.length); n > i; i++) out.push(input[i]);
            return out;
        };
    }
    function orderByFilter($parse) {
        return function(array, sortPredicate, reverseOrder) {
            function comparator(o1, o2) {
                for (var i = 0; i < sortPredicate.length; i++) {
                    var comp = sortPredicate[i](o1, o2);
                    if (0 !== comp) return comp;
                }
                return 0;
            }
            function reverseComparator(comp, descending) {
                return toBoolean(descending) ? function(a, b) {
                    return comp(b, a);
                } : comp;
            }
            function compare(v1, v2) {
                var t1 = typeof v1, t2 = typeof v2;
                return t1 == t2 ? (isDate(v1) && isDate(v2) && (v1 = v1.valueOf(), v2 = v2.valueOf()), 
                "string" == t1 && (v1 = v1.toLowerCase(), v2 = v2.toLowerCase()), v1 === v2 ? 0 : v2 > v1 ? -1 : 1) : t2 > t1 ? -1 : 1;
            }
            return isArrayLike(array) ? (sortPredicate = isArray(sortPredicate) ? sortPredicate : [ sortPredicate ], 
            0 === sortPredicate.length && (sortPredicate = [ "+" ]), sortPredicate = map(sortPredicate, function(predicate) {
                var descending = !1, get = predicate || identity;
                if (isString(predicate)) {
                    if (("+" == predicate.charAt(0) || "-" == predicate.charAt(0)) && (descending = "-" == predicate.charAt(0), 
                    predicate = predicate.substring(1)), "" === predicate) return reverseComparator(function(a, b) {
                        return compare(a, b);
                    }, descending);
                    if (get = $parse(predicate), get.constant) {
                        var key = get();
                        return reverseComparator(function(a, b) {
                            return compare(a[key], b[key]);
                        }, descending);
                    }
                }
                return reverseComparator(function(a, b) {
                    return compare(get(a), get(b));
                }, descending);
            }), slice.call(array).sort(reverseComparator(comparator, reverseOrder))) : array;
        };
    }
    function ngDirective(directive) {
        return isFunction(directive) && (directive = {
            link: directive
        }), directive.restrict = directive.restrict || "AC", valueFn(directive);
    }
    function FormController(element, attrs, $scope, $animate) {
        function toggleValidCss(isValid, validationErrorKey) {
            validationErrorKey = validationErrorKey ? "-" + snake_case(validationErrorKey, "-") : "", 
            $animate.setClass(element, (isValid ? VALID_CLASS : INVALID_CLASS) + validationErrorKey, (isValid ? INVALID_CLASS : VALID_CLASS) + validationErrorKey);
        }
        var form = this, parentForm = element.parent().controller("form") || nullFormCtrl, invalidCount = 0, errors = form.$error = {}, controls = [];
        form.$name = attrs.name || attrs.ngForm, form.$dirty = !1, form.$pristine = !0, 
        form.$valid = !0, form.$invalid = !1, parentForm.$addControl(form), element.addClass(PRISTINE_CLASS), 
        toggleValidCss(!0), form.$addControl = function(control) {
            assertNotHasOwnProperty(control.$name, "input"), controls.push(control), control.$name && (form[control.$name] = control);
        }, form.$removeControl = function(control) {
            control.$name && form[control.$name] === control && delete form[control.$name], 
            forEach(errors, function(queue, validationToken) {
                form.$setValidity(validationToken, !0, control);
            }), arrayRemove(controls, control);
        }, form.$setValidity = function(validationToken, isValid, control) {
            var queue = errors[validationToken];
            if (isValid) queue && (arrayRemove(queue, control), queue.length || (invalidCount--, 
            invalidCount || (toggleValidCss(isValid), form.$valid = !0, form.$invalid = !1), 
            errors[validationToken] = !1, toggleValidCss(!0, validationToken), parentForm.$setValidity(validationToken, !0, form))); else {
                if (invalidCount || toggleValidCss(isValid), queue) {
                    if (includes(queue, control)) return;
                } else errors[validationToken] = queue = [], invalidCount++, toggleValidCss(!1, validationToken), 
                parentForm.$setValidity(validationToken, !1, form);
                queue.push(control), form.$valid = !1, form.$invalid = !0;
            }
        }, form.$setDirty = function() {
            $animate.removeClass(element, PRISTINE_CLASS), $animate.addClass(element, DIRTY_CLASS), 
            form.$dirty = !0, form.$pristine = !1, parentForm.$setDirty();
        }, form.$setPristine = function() {
            $animate.removeClass(element, DIRTY_CLASS), $animate.addClass(element, PRISTINE_CLASS), 
            form.$dirty = !1, form.$pristine = !0, forEach(controls, function(control) {
                control.$setPristine();
            });
        };
    }
    function validate(ctrl, validatorName, validity, value) {
        return ctrl.$setValidity(validatorName, validity), validity ? value : undefined;
    }
    function testFlags(validity, flags) {
        var i, flag;
        if (flags) for (i = 0; i < flags.length; ++i) if (flag = flags[i], validity[flag]) return !0;
        return !1;
    }
    function addNativeHtml5Validators(ctrl, validatorName, badFlags, ignoreFlags, validity) {
        if (isObject(validity)) {
            ctrl.$$hasNativeValidators = !0;
            var validator = function(value) {
                return ctrl.$error[validatorName] || testFlags(validity, ignoreFlags) || !testFlags(validity, badFlags) ? value : void ctrl.$setValidity(validatorName, !1);
            };
            ctrl.$parsers.push(validator);
        }
    }
    function textInputType(scope, element, attr, ctrl, $sniffer, $browser) {
        var validity = element.prop(VALIDITY_STATE_PROPERTY), placeholder = element[0].placeholder, noevent = {}, type = lowercase(element[0].type);
        if (ctrl.$$validityState = validity, !$sniffer.android) {
            var composing = !1;
            element.on("compositionstart", function(data) {
                composing = !0;
            }), element.on("compositionend", function() {
                composing = !1, listener();
            });
        }
        var listener = function(ev) {
            if (!composing) {
                var value = element.val();
                if (msie && "input" === (ev || noevent).type && element[0].placeholder !== placeholder) return void (placeholder = element[0].placeholder);
                "password" !== type && toBoolean(attr.ngTrim || "T") && (value = trim(value));
                var revalidate = validity && ctrl.$$hasNativeValidators;
                (ctrl.$viewValue !== value || "" === value && revalidate) && (scope.$root.$$phase ? ctrl.$setViewValue(value) : scope.$apply(function() {
                    ctrl.$setViewValue(value);
                }));
            }
        };
        if ($sniffer.hasEvent("input")) element.on("input", listener); else {
            var timeout, deferListener = function() {
                timeout || (timeout = $browser.defer(function() {
                    listener(), timeout = null;
                }));
            };
            element.on("keydown", function(event) {
                var key = event.keyCode;
                91 === key || key > 15 && 19 > key || key >= 37 && 40 >= key || deferListener();
            }), $sniffer.hasEvent("paste") && element.on("paste cut", deferListener);
        }
        element.on("change", listener), ctrl.$render = function() {
            element.val(ctrl.$isEmpty(ctrl.$viewValue) ? "" : ctrl.$viewValue);
        };
        var patternValidator, match, pattern = attr.ngPattern;
        if (pattern) {
            var validateRegex = function(regexp, value) {
                return validate(ctrl, "pattern", ctrl.$isEmpty(value) || regexp.test(value), value);
            };
            match = pattern.match(/^\/(.*)\/([gim]*)$/), match ? (pattern = new RegExp(match[1], match[2]), 
            patternValidator = function(value) {
                return validateRegex(pattern, value);
            }) : patternValidator = function(value) {
                var patternObj = scope.$eval(pattern);
                if (!patternObj || !patternObj.test) throw minErr("ngPattern")("noregexp", "Expected {0} to be a RegExp but was {1}. Element: {2}", pattern, patternObj, startingTag(element));
                return validateRegex(patternObj, value);
            }, ctrl.$formatters.push(patternValidator), ctrl.$parsers.push(patternValidator);
        }
        if (attr.ngMinlength) {
            var minlength = int(attr.ngMinlength), minLengthValidator = function(value) {
                return validate(ctrl, "minlength", ctrl.$isEmpty(value) || value.length >= minlength, value);
            };
            ctrl.$parsers.push(minLengthValidator), ctrl.$formatters.push(minLengthValidator);
        }
        if (attr.ngMaxlength) {
            var maxlength = int(attr.ngMaxlength), maxLengthValidator = function(value) {
                return validate(ctrl, "maxlength", ctrl.$isEmpty(value) || value.length <= maxlength, value);
            };
            ctrl.$parsers.push(maxLengthValidator), ctrl.$formatters.push(maxLengthValidator);
        }
    }
    function numberInputType(scope, element, attr, ctrl, $sniffer, $browser) {
        if (textInputType(scope, element, attr, ctrl, $sniffer, $browser), ctrl.$parsers.push(function(value) {
            var empty = ctrl.$isEmpty(value);
            return empty || NUMBER_REGEXP.test(value) ? (ctrl.$setValidity("number", !0), "" === value ? null : empty ? value : parseFloat(value)) : (ctrl.$setValidity("number", !1), 
            undefined);
        }), addNativeHtml5Validators(ctrl, "number", numberBadFlags, null, ctrl.$$validityState), 
        ctrl.$formatters.push(function(value) {
            return ctrl.$isEmpty(value) ? "" : "" + value;
        }), attr.min) {
            var minValidator = function(value) {
                var min = parseFloat(attr.min);
                return validate(ctrl, "min", ctrl.$isEmpty(value) || value >= min, value);
            };
            ctrl.$parsers.push(minValidator), ctrl.$formatters.push(minValidator);
        }
        if (attr.max) {
            var maxValidator = function(value) {
                var max = parseFloat(attr.max);
                return validate(ctrl, "max", ctrl.$isEmpty(value) || max >= value, value);
            };
            ctrl.$parsers.push(maxValidator), ctrl.$formatters.push(maxValidator);
        }
        ctrl.$formatters.push(function(value) {
            return validate(ctrl, "number", ctrl.$isEmpty(value) || isNumber(value), value);
        });
    }
    function urlInputType(scope, element, attr, ctrl, $sniffer, $browser) {
        textInputType(scope, element, attr, ctrl, $sniffer, $browser);
        var urlValidator = function(value) {
            return validate(ctrl, "url", ctrl.$isEmpty(value) || URL_REGEXP.test(value), value);
        };
        ctrl.$formatters.push(urlValidator), ctrl.$parsers.push(urlValidator);
    }
    function emailInputType(scope, element, attr, ctrl, $sniffer, $browser) {
        textInputType(scope, element, attr, ctrl, $sniffer, $browser);
        var emailValidator = function(value) {
            return validate(ctrl, "email", ctrl.$isEmpty(value) || EMAIL_REGEXP.test(value), value);
        };
        ctrl.$formatters.push(emailValidator), ctrl.$parsers.push(emailValidator);
    }
    function radioInputType(scope, element, attr, ctrl) {
        isUndefined(attr.name) && element.attr("name", nextUid()), element.on("click", function() {
            element[0].checked && scope.$apply(function() {
                ctrl.$setViewValue(attr.value);
            });
        }), ctrl.$render = function() {
            var value = attr.value;
            element[0].checked = value == ctrl.$viewValue;
        }, attr.$observe("value", ctrl.$render);
    }
    function checkboxInputType(scope, element, attr, ctrl) {
        var trueValue = attr.ngTrueValue, falseValue = attr.ngFalseValue;
        isString(trueValue) || (trueValue = !0), isString(falseValue) || (falseValue = !1), 
        element.on("click", function() {
            scope.$apply(function() {
                ctrl.$setViewValue(element[0].checked);
            });
        }), ctrl.$render = function() {
            element[0].checked = ctrl.$viewValue;
        }, ctrl.$isEmpty = function(value) {
            return value !== trueValue;
        }, ctrl.$formatters.push(function(value) {
            return value === trueValue;
        }), ctrl.$parsers.push(function(value) {
            return value ? trueValue : falseValue;
        });
    }
    function classDirective(name, selector) {
        return name = "ngClass" + name, [ "$animate", function($animate) {
            function arrayDifference(tokens1, tokens2) {
                var values = [];
                outer: for (var i = 0; i < tokens1.length; i++) {
                    for (var token = tokens1[i], j = 0; j < tokens2.length; j++) if (token == tokens2[j]) continue outer;
                    values.push(token);
                }
                return values;
            }
            function arrayClasses(classVal) {
                if (isArray(classVal)) return classVal;
                if (isString(classVal)) return classVal.split(" ");
                if (isObject(classVal)) {
                    var classes = [];
                    return forEach(classVal, function(v, k) {
                        v && (classes = classes.concat(k.split(" ")));
                    }), classes;
                }
                return classVal;
            }
            return {
                restrict: "AC",
                link: function(scope, element, attr) {
                    function addClasses(classes) {
                        var newClasses = digestClassCounts(classes, 1);
                        attr.$addClass(newClasses);
                    }
                    function removeClasses(classes) {
                        var newClasses = digestClassCounts(classes, -1);
                        attr.$removeClass(newClasses);
                    }
                    function digestClassCounts(classes, count) {
                        var classCounts = element.data("$classCounts") || {}, classesToUpdate = [];
                        return forEach(classes, function(className) {
                            (count > 0 || classCounts[className]) && (classCounts[className] = (classCounts[className] || 0) + count, 
                            classCounts[className] === +(count > 0) && classesToUpdate.push(className));
                        }), element.data("$classCounts", classCounts), classesToUpdate.join(" ");
                    }
                    function updateClasses(oldClasses, newClasses) {
                        var toAdd = arrayDifference(newClasses, oldClasses), toRemove = arrayDifference(oldClasses, newClasses);
                        toRemove = digestClassCounts(toRemove, -1), toAdd = digestClassCounts(toAdd, 1), 
                        0 === toAdd.length ? $animate.removeClass(element, toRemove) : 0 === toRemove.length ? $animate.addClass(element, toAdd) : $animate.setClass(element, toAdd, toRemove);
                    }
                    function ngClassWatchAction(newVal) {
                        if (selector === !0 || scope.$index % 2 === selector) {
                            var newClasses = arrayClasses(newVal || []);
                            if (oldVal) {
                                if (!equals(newVal, oldVal)) {
                                    var oldClasses = arrayClasses(oldVal);
                                    updateClasses(oldClasses, newClasses);
                                }
                            } else addClasses(newClasses);
                        }
                        oldVal = shallowCopy(newVal);
                    }
                    var oldVal;
                    scope.$watch(attr[name], ngClassWatchAction, !0), attr.$observe("class", function(value) {
                        ngClassWatchAction(scope.$eval(attr[name]));
                    }), "ngClass" !== name && scope.$watch("$index", function($index, old$index) {
                        var mod = 1 & $index;
                        if (mod !== (1 & old$index)) {
                            var classes = arrayClasses(scope.$eval(attr[name]));
                            mod === selector ? addClasses(classes) : removeClasses(classes);
                        }
                    });
                }
            };
        } ];
    }
    var VALIDITY_STATE_PROPERTY = "validity", lowercase = function(string) {
        return isString(string) ? string.toLowerCase() : string;
    }, hasOwnProperty = Object.prototype.hasOwnProperty, uppercase = function(string) {
        return isString(string) ? string.toUpperCase() : string;
    }, manualLowercase = function(s) {
        return isString(s) ? s.replace(/[A-Z]/g, function(ch) {
            return String.fromCharCode(32 | ch.charCodeAt(0));
        }) : s;
    }, manualUppercase = function(s) {
        return isString(s) ? s.replace(/[a-z]/g, function(ch) {
            return String.fromCharCode(-33 & ch.charCodeAt(0));
        }) : s;
    };
    "i" !== "I".toLowerCase() && (lowercase = manualLowercase, uppercase = manualUppercase);
    var msie, jqLite, jQuery, angularModule, nodeName_, slice = [].slice, push = [].push, toString = Object.prototype.toString, ngMinErr = minErr("ng"), angular = window.angular || (window.angular = {}), uid = [ "0", "0", "0" ];
    msie = int((/msie (\d+)/.exec(lowercase(navigator.userAgent)) || [])[1]), isNaN(msie) && (msie = int((/trident\/.*; rv:(\d+)/.exec(lowercase(navigator.userAgent)) || [])[1])), 
    noop.$inject = [], identity.$inject = [];
    var isArray = function() {
        return isFunction(Array.isArray) ? Array.isArray : function(value) {
            return "[object Array]" === toString.call(value);
        };
    }(), trim = function() {
        return String.prototype.trim ? function(value) {
            return isString(value) ? value.trim() : value;
        } : function(value) {
            return isString(value) ? value.replace(/^\s\s*/, "").replace(/\s\s*$/, "") : value;
        };
    }();
    nodeName_ = 9 > msie ? function(element) {
        return element = element.nodeName ? element : element[0], element.scopeName && "HTML" != element.scopeName ? uppercase(element.scopeName + ":" + element.nodeName) : element.nodeName;
    } : function(element) {
        return element.nodeName ? element.nodeName : element[0].nodeName;
    };
    var csp = function() {
        if (isDefined(csp.isActive_)) return csp.isActive_;
        var active = !(!document.querySelector("[ng-csp]") && !document.querySelector("[data-ng-csp]"));
        if (!active) try {
            new Function("");
        } catch (e) {
            active = !0;
        }
        return csp.isActive_ = active;
    }, SNAKE_CASE_REGEXP = /[A-Z]/g, version = {
        full: "1.2.28",
        major: 1,
        minor: 2,
        dot: 28,
        codeName: "finnish-disembarkation"
    };
    JQLite.expando = "ng339";
    var jqCache = JQLite.cache = {}, jqId = 1, addEventListenerFn = window.document.addEventListener ? function(element, type, fn) {
        element.addEventListener(type, fn, !1);
    } : function(element, type, fn) {
        element.attachEvent("on" + type, fn);
    }, removeEventListenerFn = window.document.removeEventListener ? function(element, type, fn) {
        element.removeEventListener(type, fn, !1);
    } : function(element, type, fn) {
        element.detachEvent("on" + type, fn);
    }, SPECIAL_CHARS_REGEXP = (JQLite._data = function(node) {
        return this.cache[node[this.expando]] || {};
    }, /([\:\-\_]+(.))/g), MOZ_HACK_REGEXP = /^moz([A-Z])/, jqLiteMinErr = minErr("jqLite"), SINGLE_TAG_REGEXP = /^<(\w+)\s*\/?>(?:<\/\1>|)$/, HTML_REGEXP = /<|&#?\w+;/, TAG_NAME_REGEXP = /<([\w:]+)/, XHTML_TAG_REGEXP = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, wrapMap = {
        option: [ 1, '<select multiple="multiple">', "</select>" ],
        thead: [ 1, "<table>", "</table>" ],
        col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
        tr: [ 2, "<table><tbody>", "</tbody></table>" ],
        td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
        _default: [ 0, "", "" ]
    };
    wrapMap.optgroup = wrapMap.option, wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead, 
    wrapMap.th = wrapMap.td;
    var JQLitePrototype = JQLite.prototype = {
        ready: function(fn) {
            function trigger() {
                fired || (fired = !0, fn());
            }
            var fired = !1;
            "complete" === document.readyState ? setTimeout(trigger) : (this.on("DOMContentLoaded", trigger), 
            JQLite(window).on("load", trigger));
        },
        toString: function() {
            var value = [];
            return forEach(this, function(e) {
                value.push("" + e);
            }), "[" + value.join(", ") + "]";
        },
        eq: function(index) {
            return jqLite(index >= 0 ? this[index] : this[this.length + index]);
        },
        length: 0,
        push: push,
        sort: [].sort,
        splice: [].splice
    }, BOOLEAN_ATTR = {};
    forEach("multiple,selected,checked,disabled,readOnly,required,open".split(","), function(value) {
        BOOLEAN_ATTR[lowercase(value)] = value;
    });
    var BOOLEAN_ELEMENTS = {};
    forEach("input,select,option,textarea,button,form,details".split(","), function(value) {
        BOOLEAN_ELEMENTS[uppercase(value)] = !0;
    }), forEach({
        data: jqLiteData,
        removeData: jqLiteRemoveData
    }, function(fn, name) {
        JQLite[name] = fn;
    }), forEach({
        data: jqLiteData,
        inheritedData: jqLiteInheritedData,
        scope: function(element) {
            return jqLite.data(element, "$scope") || jqLiteInheritedData(element.parentNode || element, [ "$isolateScope", "$scope" ]);
        },
        isolateScope: function(element) {
            return jqLite.data(element, "$isolateScope") || jqLite.data(element, "$isolateScopeNoTemplate");
        },
        controller: jqLiteController,
        injector: function(element) {
            return jqLiteInheritedData(element, "$injector");
        },
        removeAttr: function(element, name) {
            element.removeAttribute(name);
        },
        hasClass: jqLiteHasClass,
        css: function(element, name, value) {
            if (name = camelCase(name), !isDefined(value)) {
                var val;
                return 8 >= msie && (val = element.currentStyle && element.currentStyle[name], "" === val && (val = "auto")), 
                val = val || element.style[name], 8 >= msie && (val = "" === val ? undefined : val), 
                val;
            }
            element.style[name] = value;
        },
        attr: function(element, name, value) {
            var lowercasedName = lowercase(name);
            if (BOOLEAN_ATTR[lowercasedName]) {
                if (!isDefined(value)) return element[name] || (element.attributes.getNamedItem(name) || noop).specified ? lowercasedName : undefined;
                value ? (element[name] = !0, element.setAttribute(name, lowercasedName)) : (element[name] = !1, 
                element.removeAttribute(lowercasedName));
            } else if (isDefined(value)) element.setAttribute(name, value); else if (element.getAttribute) {
                var ret = element.getAttribute(name, 2);
                return null === ret ? undefined : ret;
            }
        },
        prop: function(element, name, value) {
            return isDefined(value) ? void (element[name] = value) : element[name];
        },
        text: function() {
            function getText(element, value) {
                var textProp = NODE_TYPE_TEXT_PROPERTY[element.nodeType];
                return isUndefined(value) ? textProp ? element[textProp] : "" : void (element[textProp] = value);
            }
            var NODE_TYPE_TEXT_PROPERTY = [];
            return 9 > msie ? (NODE_TYPE_TEXT_PROPERTY[1] = "innerText", NODE_TYPE_TEXT_PROPERTY[3] = "nodeValue") : NODE_TYPE_TEXT_PROPERTY[1] = NODE_TYPE_TEXT_PROPERTY[3] = "textContent", 
            getText.$dv = "", getText;
        }(),
        val: function(element, value) {
            if (isUndefined(value)) {
                if ("SELECT" === nodeName_(element) && element.multiple) {
                    var result = [];
                    return forEach(element.options, function(option) {
                        option.selected && result.push(option.value || option.text);
                    }), 0 === result.length ? null : result;
                }
                return element.value;
            }
            element.value = value;
        },
        html: function(element, value) {
            if (isUndefined(value)) return element.innerHTML;
            for (var i = 0, childNodes = element.childNodes; i < childNodes.length; i++) jqLiteDealoc(childNodes[i]);
            element.innerHTML = value;
        },
        empty: jqLiteEmpty
    }, function(fn, name) {
        JQLite.prototype[name] = function(arg1, arg2) {
            var i, key, nodeCount = this.length;
            if (fn !== jqLiteEmpty && (2 == fn.length && fn !== jqLiteHasClass && fn !== jqLiteController ? arg1 : arg2) === undefined) {
                if (isObject(arg1)) {
                    for (i = 0; nodeCount > i; i++) if (fn === jqLiteData) fn(this[i], arg1); else for (key in arg1) fn(this[i], key, arg1[key]);
                    return this;
                }
                for (var value = fn.$dv, jj = value === undefined ? Math.min(nodeCount, 1) : nodeCount, j = 0; jj > j; j++) {
                    var nodeValue = fn(this[j], arg1, arg2);
                    value = value ? value + nodeValue : nodeValue;
                }
                return value;
            }
            for (i = 0; nodeCount > i; i++) fn(this[i], arg1, arg2);
            return this;
        };
    }), forEach({
        removeData: jqLiteRemoveData,
        dealoc: jqLiteDealoc,
        on: function onFn(element, type, fn, unsupported) {
            if (isDefined(unsupported)) throw jqLiteMinErr("onargs", "jqLite#on() does not support the `selector` or `eventData` parameters");
            var events = jqLiteExpandoStore(element, "events"), handle = jqLiteExpandoStore(element, "handle");
            events || jqLiteExpandoStore(element, "events", events = {}), handle || jqLiteExpandoStore(element, "handle", handle = createEventHandler(element, events)), 
            forEach(type.split(" "), function(type) {
                var eventFns = events[type];
                if (!eventFns) {
                    if ("mouseenter" == type || "mouseleave" == type) {
                        var contains = document.body.contains || document.body.compareDocumentPosition ? function(a, b) {
                            var adown = 9 === a.nodeType ? a.documentElement : a, bup = b && b.parentNode;
                            return a === bup || !(!bup || 1 !== bup.nodeType || !(adown.contains ? adown.contains(bup) : a.compareDocumentPosition && 16 & a.compareDocumentPosition(bup)));
                        } : function(a, b) {
                            if (b) for (;b = b.parentNode; ) if (b === a) return !0;
                            return !1;
                        };
                        events[type] = [];
                        var eventmap = {
                            mouseleave: "mouseout",
                            mouseenter: "mouseover"
                        };
                        onFn(element, eventmap[type], function(event) {
                            var target = this, related = event.relatedTarget;
                            (!related || related !== target && !contains(target, related)) && handle(event, type);
                        });
                    } else addEventListenerFn(element, type, handle), events[type] = [];
                    eventFns = events[type];
                }
                eventFns.push(fn);
            });
        },
        off: jqLiteOff,
        one: function(element, type, fn) {
            element = jqLite(element), element.on(type, function onFn() {
                element.off(type, fn), element.off(type, onFn);
            }), element.on(type, fn);
        },
        replaceWith: function(element, replaceNode) {
            var index, parent = element.parentNode;
            jqLiteDealoc(element), forEach(new JQLite(replaceNode), function(node) {
                index ? parent.insertBefore(node, index.nextSibling) : parent.replaceChild(node, element), 
                index = node;
            });
        },
        children: function(element) {
            var children = [];
            return forEach(element.childNodes, function(element) {
                1 === element.nodeType && children.push(element);
            }), children;
        },
        contents: function(element) {
            return element.contentDocument || element.childNodes || [];
        },
        append: function(element, node) {
            forEach(new JQLite(node), function(child) {
                (1 === element.nodeType || 11 === element.nodeType) && element.appendChild(child);
            });
        },
        prepend: function(element, node) {
            if (1 === element.nodeType) {
                var index = element.firstChild;
                forEach(new JQLite(node), function(child) {
                    element.insertBefore(child, index);
                });
            }
        },
        wrap: function(element, wrapNode) {
            wrapNode = jqLite(wrapNode)[0];
            var parent = element.parentNode;
            parent && parent.replaceChild(wrapNode, element), wrapNode.appendChild(element);
        },
        remove: function(element) {
            jqLiteDealoc(element);
            var parent = element.parentNode;
            parent && parent.removeChild(element);
        },
        after: function(element, newElement) {
            var index = element, parent = element.parentNode;
            forEach(new JQLite(newElement), function(node) {
                parent.insertBefore(node, index.nextSibling), index = node;
            });
        },
        addClass: jqLiteAddClass,
        removeClass: jqLiteRemoveClass,
        toggleClass: function(element, selector, condition) {
            selector && forEach(selector.split(" "), function(className) {
                var classCondition = condition;
                isUndefined(classCondition) && (classCondition = !jqLiteHasClass(element, className)), 
                (classCondition ? jqLiteAddClass : jqLiteRemoveClass)(element, className);
            });
        },
        parent: function(element) {
            var parent = element.parentNode;
            return parent && 11 !== parent.nodeType ? parent : null;
        },
        next: function(element) {
            if (element.nextElementSibling) return element.nextElementSibling;
            for (var elm = element.nextSibling; null != elm && 1 !== elm.nodeType; ) elm = elm.nextSibling;
            return elm;
        },
        find: function(element, selector) {
            return element.getElementsByTagName ? element.getElementsByTagName(selector) : [];
        },
        clone: jqLiteClone,
        triggerHandler: function(element, event, extraParameters) {
            var dummyEvent, eventFnsCopy, handlerArgs, eventName = event.type || event, eventFns = (jqLiteExpandoStore(element, "events") || {})[eventName];
            eventFns && (dummyEvent = {
                preventDefault: function() {
                    this.defaultPrevented = !0;
                },
                isDefaultPrevented: function() {
                    return this.defaultPrevented === !0;
                },
                stopPropagation: noop,
                type: eventName,
                target: element
            }, event.type && (dummyEvent = extend(dummyEvent, event)), eventFnsCopy = shallowCopy(eventFns), 
            handlerArgs = extraParameters ? [ dummyEvent ].concat(extraParameters) : [ dummyEvent ], 
            forEach(eventFnsCopy, function(fn) {
                fn.apply(element, handlerArgs);
            }));
        }
    }, function(fn, name) {
        JQLite.prototype[name] = function(arg1, arg2, arg3) {
            for (var value, i = 0; i < this.length; i++) isUndefined(value) ? (value = fn(this[i], arg1, arg2, arg3), 
            isDefined(value) && (value = jqLite(value))) : jqLiteAddNodes(value, fn(this[i], arg1, arg2, arg3));
            return isDefined(value) ? value : this;
        }, JQLite.prototype.bind = JQLite.prototype.on, JQLite.prototype.unbind = JQLite.prototype.off;
    }), HashMap.prototype = {
        put: function(key, value) {
            this[hashKey(key, this.nextUid)] = value;
        },
        get: function(key) {
            return this[hashKey(key, this.nextUid)];
        },
        remove: function(key) {
            var value = this[key = hashKey(key, this.nextUid)];
            return delete this[key], value;
        }
    };
    var FN_ARGS = /^function\s*[^\(]*\(\s*([^\)]*)\)/m, FN_ARG_SPLIT = /,/, FN_ARG = /^\s*(_?)(\S+?)\1\s*$/, STRIP_COMMENTS = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm, $injectorMinErr = minErr("$injector"), $animateMinErr = minErr("$animate"), $AnimateProvider = [ "$provide", function($provide) {
        this.$$selectors = {}, this.register = function(name, factory) {
            var key = name + "-animation";
            if (name && "." != name.charAt(0)) throw $animateMinErr("notcsel", "Expecting class selector starting with '.' got '{0}'.", name);
            this.$$selectors[name.substr(1)] = key, $provide.factory(key, factory);
        }, this.classNameFilter = function(expression) {
            return 1 === arguments.length && (this.$$classNameFilter = expression instanceof RegExp ? expression : null), 
            this.$$classNameFilter;
        }, this.$get = [ "$timeout", "$$asyncCallback", function($timeout, $$asyncCallback) {
            function async(fn) {
                fn && $$asyncCallback(fn);
            }
            return {
                enter: function(element, parent, after, done) {
                    after ? after.after(element) : (parent && parent[0] || (parent = after.parent()), 
                    parent.append(element)), async(done);
                },
                leave: function(element, done) {
                    element.remove(), async(done);
                },
                move: function(element, parent, after, done) {
                    this.enter(element, parent, after, done);
                },
                addClass: function(element, className, done) {
                    className = isString(className) ? className : isArray(className) ? className.join(" ") : "", 
                    forEach(element, function(element) {
                        jqLiteAddClass(element, className);
                    }), async(done);
                },
                removeClass: function(element, className, done) {
                    className = isString(className) ? className : isArray(className) ? className.join(" ") : "", 
                    forEach(element, function(element) {
                        jqLiteRemoveClass(element, className);
                    }), async(done);
                },
                setClass: function(element, add, remove, done) {
                    forEach(element, function(element) {
                        jqLiteAddClass(element, add), jqLiteRemoveClass(element, remove);
                    }), async(done);
                },
                enabled: noop
            };
        } ];
    } ], $compileMinErr = minErr("$compile");
    $CompileProvider.$inject = [ "$provide", "$$sanitizeUriProvider" ];
    var PREFIX_REGEXP = /^(x[\:\-_]|data[\:\-_])/i, $interpolateMinErr = minErr("$interpolate"), PATH_MATCH = /^([^\?#]*)(\?([^#]*))?(#(.*))?$/, DEFAULT_PORTS = {
        http: 80,
        https: 443,
        ftp: 21
    }, $locationMinErr = minErr("$location");
    LocationHashbangInHtml5Url.prototype = LocationHashbangUrl.prototype = LocationHtml5Url.prototype = {
        $$html5: !1,
        $$replace: !1,
        absUrl: locationGetter("$$absUrl"),
        url: function(url) {
            if (isUndefined(url)) return this.$$url;
            var match = PATH_MATCH.exec(url);
            return match[1] && this.path(decodeURIComponent(match[1])), (match[2] || match[1]) && this.search(match[3] || ""), 
            this.hash(match[5] || ""), this;
        },
        protocol: locationGetter("$$protocol"),
        host: locationGetter("$$host"),
        port: locationGetter("$$port"),
        path: locationGetterSetter("$$path", function(path) {
            return path = null !== path ? path.toString() : "", "/" == path.charAt(0) ? path : "/" + path;
        }),
        search: function(search, paramValue) {
            switch (arguments.length) {
              case 0:
                return this.$$search;

              case 1:
                if (isString(search) || isNumber(search)) search = search.toString(), this.$$search = parseKeyValue(search); else {
                    if (!isObject(search)) throw $locationMinErr("isrcharg", "The first argument of the `$location#search()` call must be a string or an object.");
                    forEach(search, function(value, key) {
                        null == value && delete search[key];
                    }), this.$$search = search;
                }
                break;

              default:
                isUndefined(paramValue) || null === paramValue ? delete this.$$search[search] : this.$$search[search] = paramValue;
            }
            return this.$$compose(), this;
        },
        hash: locationGetterSetter("$$hash", function(hash) {
            return null !== hash ? hash.toString() : "";
        }),
        replace: function() {
            return this.$$replace = !0, this;
        }
    };
    var promiseWarning, $parseMinErr = minErr("$parse"), promiseWarningCache = {}, CALL = Function.prototype.call, APPLY = Function.prototype.apply, BIND = Function.prototype.bind, OPERATORS = {
        "null": function() {
            return null;
        },
        "true": function() {
            return !0;
        },
        "false": function() {
            return !1;
        },
        undefined: noop,
        "+": function(self, locals, a, b) {
            return a = a(self, locals), b = b(self, locals), isDefined(a) ? isDefined(b) ? a + b : a : isDefined(b) ? b : undefined;
        },
        "-": function(self, locals, a, b) {
            return a = a(self, locals), b = b(self, locals), (isDefined(a) ? a : 0) - (isDefined(b) ? b : 0);
        },
        "*": function(self, locals, a, b) {
            return a(self, locals) * b(self, locals);
        },
        "/": function(self, locals, a, b) {
            return a(self, locals) / b(self, locals);
        },
        "%": function(self, locals, a, b) {
            return a(self, locals) % b(self, locals);
        },
        "^": function(self, locals, a, b) {
            return a(self, locals) ^ b(self, locals);
        },
        "=": noop,
        "===": function(self, locals, a, b) {
            return a(self, locals) === b(self, locals);
        },
        "!==": function(self, locals, a, b) {
            return a(self, locals) !== b(self, locals);
        },
        "==": function(self, locals, a, b) {
            return a(self, locals) == b(self, locals);
        },
        "!=": function(self, locals, a, b) {
            return a(self, locals) != b(self, locals);
        },
        "<": function(self, locals, a, b) {
            return a(self, locals) < b(self, locals);
        },
        ">": function(self, locals, a, b) {
            return a(self, locals) > b(self, locals);
        },
        "<=": function(self, locals, a, b) {
            return a(self, locals) <= b(self, locals);
        },
        ">=": function(self, locals, a, b) {
            return a(self, locals) >= b(self, locals);
        },
        "&&": function(self, locals, a, b) {
            return a(self, locals) && b(self, locals);
        },
        "||": function(self, locals, a, b) {
            return a(self, locals) || b(self, locals);
        },
        "&": function(self, locals, a, b) {
            return a(self, locals) & b(self, locals);
        },
        "|": function(self, locals, a, b) {
            return b(self, locals)(self, locals, a(self, locals));
        },
        "!": function(self, locals, a) {
            return !a(self, locals);
        }
    }, ESCAPE = {
        n: "\n",
        f: "\f",
        r: "\r",
        t: "	",
        v: "",
        "'": "'",
        '"': '"'
    }, Lexer = function(options) {
        this.options = options;
    };
    Lexer.prototype = {
        constructor: Lexer,
        lex: function(text) {
            for (this.text = text, this.index = 0, this.ch = undefined, this.lastCh = ":", this.tokens = []; this.index < this.text.length; ) {
                if (this.ch = this.text.charAt(this.index), this.is("\"'")) this.readString(this.ch); else if (this.isNumber(this.ch) || this.is(".") && this.isNumber(this.peek())) this.readNumber(); else if (this.isIdent(this.ch)) this.readIdent(); else if (this.is("(){}[].,;:?")) this.tokens.push({
                    index: this.index,
                    text: this.ch
                }), this.index++; else {
                    if (this.isWhitespace(this.ch)) {
                        this.index++;
                        continue;
                    }
                    var ch2 = this.ch + this.peek(), ch3 = ch2 + this.peek(2), fn = OPERATORS[this.ch], fn2 = OPERATORS[ch2], fn3 = OPERATORS[ch3];
                    fn3 ? (this.tokens.push({
                        index: this.index,
                        text: ch3,
                        fn: fn3
                    }), this.index += 3) : fn2 ? (this.tokens.push({
                        index: this.index,
                        text: ch2,
                        fn: fn2
                    }), this.index += 2) : fn ? (this.tokens.push({
                        index: this.index,
                        text: this.ch,
                        fn: fn
                    }), this.index += 1) : this.throwError("Unexpected next character ", this.index, this.index + 1);
                }
                this.lastCh = this.ch;
            }
            return this.tokens;
        },
        is: function(chars) {
            return -1 !== chars.indexOf(this.ch);
        },
        was: function(chars) {
            return -1 !== chars.indexOf(this.lastCh);
        },
        peek: function(i) {
            var num = i || 1;
            return this.index + num < this.text.length ? this.text.charAt(this.index + num) : !1;
        },
        isNumber: function(ch) {
            return ch >= "0" && "9" >= ch;
        },
        isWhitespace: function(ch) {
            return " " === ch || "\r" === ch || "	" === ch || "\n" === ch || "" === ch || " " === ch;
        },
        isIdent: function(ch) {
            return ch >= "a" && "z" >= ch || ch >= "A" && "Z" >= ch || "_" === ch || "$" === ch;
        },
        isExpOperator: function(ch) {
            return "-" === ch || "+" === ch || this.isNumber(ch);
        },
        throwError: function(error, start, end) {
            end = end || this.index;
            var colStr = isDefined(start) ? "s " + start + "-" + this.index + " [" + this.text.substring(start, end) + "]" : " " + end;
            throw $parseMinErr("lexerr", "Lexer Error: {0} at column{1} in expression [{2}].", error, colStr, this.text);
        },
        readNumber: function() {
            for (var number = "", start = this.index; this.index < this.text.length; ) {
                var ch = lowercase(this.text.charAt(this.index));
                if ("." == ch || this.isNumber(ch)) number += ch; else {
                    var peekCh = this.peek();
                    if ("e" == ch && this.isExpOperator(peekCh)) number += ch; else if (this.isExpOperator(ch) && peekCh && this.isNumber(peekCh) && "e" == number.charAt(number.length - 1)) number += ch; else {
                        if (!this.isExpOperator(ch) || peekCh && this.isNumber(peekCh) || "e" != number.charAt(number.length - 1)) break;
                        this.throwError("Invalid exponent");
                    }
                }
                this.index++;
            }
            number = 1 * number, this.tokens.push({
                index: start,
                text: number,
                literal: !0,
                constant: !0,
                fn: function() {
                    return number;
                }
            });
        },
        readIdent: function() {
            for (var lastDot, peekIndex, methodName, ch, parser = this, ident = "", start = this.index; this.index < this.text.length && (ch = this.text.charAt(this.index), 
            "." === ch || this.isIdent(ch) || this.isNumber(ch)); ) "." === ch && (lastDot = this.index), 
            ident += ch, this.index++;
            if (lastDot) for (peekIndex = this.index; peekIndex < this.text.length; ) {
                if (ch = this.text.charAt(peekIndex), "(" === ch) {
                    methodName = ident.substr(lastDot - start + 1), ident = ident.substr(0, lastDot - start), 
                    this.index = peekIndex;
                    break;
                }
                if (!this.isWhitespace(ch)) break;
                peekIndex++;
            }
            var token = {
                index: start,
                text: ident
            };
            if (OPERATORS.hasOwnProperty(ident)) token.fn = OPERATORS[ident], token.literal = !0, 
            token.constant = !0; else {
                var getter = getterFn(ident, this.options, this.text);
                token.fn = extend(function(self, locals) {
                    return getter(self, locals);
                }, {
                    assign: function(self, value) {
                        return setter(self, ident, value, parser.text, parser.options);
                    }
                });
            }
            this.tokens.push(token), methodName && (this.tokens.push({
                index: lastDot,
                text: "."
            }), this.tokens.push({
                index: lastDot + 1,
                text: methodName
            }));
        },
        readString: function(quote) {
            var start = this.index;
            this.index++;
            for (var string = "", rawString = quote, escape = !1; this.index < this.text.length; ) {
                var ch = this.text.charAt(this.index);
                if (rawString += ch, escape) {
                    if ("u" === ch) {
                        var hex = this.text.substring(this.index + 1, this.index + 5);
                        hex.match(/[\da-f]{4}/i) || this.throwError("Invalid unicode escape [\\u" + hex + "]"), 
                        this.index += 4, string += String.fromCharCode(parseInt(hex, 16));
                    } else {
                        var rep = ESCAPE[ch];
                        string += rep || ch;
                    }
                    escape = !1;
                } else if ("\\" === ch) escape = !0; else {
                    if (ch === quote) return this.index++, void this.tokens.push({
                        index: start,
                        text: rawString,
                        string: string,
                        literal: !0,
                        constant: !0,
                        fn: function() {
                            return string;
                        }
                    });
                    string += ch;
                }
                this.index++;
            }
            this.throwError("Unterminated quote", start);
        }
    };
    var Parser = function(lexer, $filter, options) {
        this.lexer = lexer, this.$filter = $filter, this.options = options;
    };
    Parser.ZERO = extend(function() {
        return 0;
    }, {
        constant: !0
    }), Parser.prototype = {
        constructor: Parser,
        parse: function(text) {
            this.text = text, this.tokens = this.lexer.lex(text);
            var value = this.statements();
            return 0 !== this.tokens.length && this.throwError("is an unexpected token", this.tokens[0]), 
            value.literal = !!value.literal, value.constant = !!value.constant, value;
        },
        primary: function() {
            var primary;
            if (this.expect("(")) primary = this.filterChain(), this.consume(")"); else if (this.expect("[")) primary = this.arrayDeclaration(); else if (this.expect("{")) primary = this.object(); else {
                var token = this.expect();
                primary = token.fn, primary || this.throwError("not a primary expression", token), 
                primary.literal = !!token.literal, primary.constant = !!token.constant;
            }
            for (var next, context; next = this.expect("(", "[", "."); ) "(" === next.text ? (primary = this.functionCall(primary, context), 
            context = null) : "[" === next.text ? (context = primary, primary = this.objectIndex(primary)) : "." === next.text ? (context = primary, 
            primary = this.fieldAccess(primary)) : this.throwError("IMPOSSIBLE");
            return primary;
        },
        throwError: function(msg, token) {
            throw $parseMinErr("syntax", "Syntax Error: Token '{0}' {1} at column {2} of the expression [{3}] starting at [{4}].", token.text, msg, token.index + 1, this.text, this.text.substring(token.index));
        },
        peekToken: function() {
            if (0 === this.tokens.length) throw $parseMinErr("ueoe", "Unexpected end of expression: {0}", this.text);
            return this.tokens[0];
        },
        peek: function(e1, e2, e3, e4) {
            if (this.tokens.length > 0) {
                var token = this.tokens[0], t = token.text;
                if (t === e1 || t === e2 || t === e3 || t === e4 || !e1 && !e2 && !e3 && !e4) return token;
            }
            return !1;
        },
        expect: function(e1, e2, e3, e4) {
            var token = this.peek(e1, e2, e3, e4);
            return token ? (this.tokens.shift(), token) : !1;
        },
        consume: function(e1) {
            this.expect(e1) || this.throwError("is unexpected, expecting [" + e1 + "]", this.peek());
        },
        unaryFn: function(fn, right) {
            return extend(function(self, locals) {
                return fn(self, locals, right);
            }, {
                constant: right.constant
            });
        },
        ternaryFn: function(left, middle, right) {
            return extend(function(self, locals) {
                return left(self, locals) ? middle(self, locals) : right(self, locals);
            }, {
                constant: left.constant && middle.constant && right.constant
            });
        },
        binaryFn: function(left, fn, right) {
            return extend(function(self, locals) {
                return fn(self, locals, left, right);
            }, {
                constant: left.constant && right.constant
            });
        },
        statements: function() {
            for (var statements = []; ;) if (this.tokens.length > 0 && !this.peek("}", ")", ";", "]") && statements.push(this.filterChain()), 
            !this.expect(";")) return 1 === statements.length ? statements[0] : function(self, locals) {
                for (var value, i = 0; i < statements.length; i++) {
                    var statement = statements[i];
                    statement && (value = statement(self, locals));
                }
                return value;
            };
        },
        filterChain: function() {
            for (var token, left = this.expression(); ;) {
                if (!(token = this.expect("|"))) return left;
                left = this.binaryFn(left, token.fn, this.filter());
            }
        },
        filter: function() {
            for (var token = this.expect(), fn = this.$filter(token.text), argsFn = []; ;) {
                if (!(token = this.expect(":"))) {
                    var fnInvoke = function(self, locals, input) {
                        for (var args = [ input ], i = 0; i < argsFn.length; i++) args.push(argsFn[i](self, locals));
                        return fn.apply(self, args);
                    };
                    return function() {
                        return fnInvoke;
                    };
                }
                argsFn.push(this.expression());
            }
        },
        expression: function() {
            return this.assignment();
        },
        assignment: function() {
            var right, token, left = this.ternary();
            return (token = this.expect("=")) ? (left.assign || this.throwError("implies assignment but [" + this.text.substring(0, token.index) + "] can not be assigned to", token), 
            right = this.ternary(), function(scope, locals) {
                return left.assign(scope, right(scope, locals), locals);
            }) : left;
        },
        ternary: function() {
            var middle, token, left = this.logicalOR();
            return (token = this.expect("?")) ? (middle = this.assignment(), (token = this.expect(":")) ? this.ternaryFn(left, middle, this.assignment()) : void this.throwError("expected :", token)) : left;
        },
        logicalOR: function() {
            for (var token, left = this.logicalAND(); ;) {
                if (!(token = this.expect("||"))) return left;
                left = this.binaryFn(left, token.fn, this.logicalAND());
            }
        },
        logicalAND: function() {
            var token, left = this.equality();
            return (token = this.expect("&&")) && (left = this.binaryFn(left, token.fn, this.logicalAND())), 
            left;
        },
        equality: function() {
            var token, left = this.relational();
            return (token = this.expect("==", "!=", "===", "!==")) && (left = this.binaryFn(left, token.fn, this.equality())), 
            left;
        },
        relational: function() {
            var token, left = this.additive();
            return (token = this.expect("<", ">", "<=", ">=")) && (left = this.binaryFn(left, token.fn, this.relational())), 
            left;
        },
        additive: function() {
            for (var token, left = this.multiplicative(); token = this.expect("+", "-"); ) left = this.binaryFn(left, token.fn, this.multiplicative());
            return left;
        },
        multiplicative: function() {
            for (var token, left = this.unary(); token = this.expect("*", "/", "%"); ) left = this.binaryFn(left, token.fn, this.unary());
            return left;
        },
        unary: function() {
            var token;
            return this.expect("+") ? this.primary() : (token = this.expect("-")) ? this.binaryFn(Parser.ZERO, token.fn, this.unary()) : (token = this.expect("!")) ? this.unaryFn(token.fn, this.unary()) : this.primary();
        },
        fieldAccess: function(object) {
            var parser = this, field = this.expect().text, getter = getterFn(field, this.options, this.text);
            return extend(function(scope, locals, self) {
                return getter(self || object(scope, locals));
            }, {
                assign: function(scope, value, locals) {
                    var o = object(scope, locals);
                    return o || object.assign(scope, o = {}), setter(o, field, value, parser.text, parser.options);
                }
            });
        },
        objectIndex: function(obj) {
            var parser = this, indexFn = this.expression();
            return this.consume("]"), extend(function(self, locals) {
                var v, p, o = obj(self, locals), i = indexFn(self, locals);
                return ensureSafeMemberName(i, parser.text), o ? (v = ensureSafeObject(o[i], parser.text), 
                v && v.then && parser.options.unwrapPromises && (p = v, "$$v" in v || (p.$$v = undefined, 
                p.then(function(val) {
                    p.$$v = val;
                })), v = v.$$v), v) : undefined;
            }, {
                assign: function(self, value, locals) {
                    var key = ensureSafeMemberName(indexFn(self, locals), parser.text), o = ensureSafeObject(obj(self, locals), parser.text);
                    return o || obj.assign(self, o = {}), o[key] = value;
                }
            });
        },
        functionCall: function(fn, contextGetter) {
            var argsFn = [];
            if (")" !== this.peekToken().text) do argsFn.push(this.expression()); while (this.expect(","));
            this.consume(")");
            var parser = this;
            return function(scope, locals) {
                for (var args = [], context = contextGetter ? contextGetter(scope, locals) : scope, i = 0; i < argsFn.length; i++) args.push(ensureSafeObject(argsFn[i](scope, locals), parser.text));
                var fnPtr = fn(scope, locals, context) || noop;
                ensureSafeObject(context, parser.text), ensureSafeFunction(fnPtr, parser.text);
                var v = fnPtr.apply ? fnPtr.apply(context, args) : fnPtr(args[0], args[1], args[2], args[3], args[4]);
                return ensureSafeObject(v, parser.text);
            };
        },
        arrayDeclaration: function() {
            var elementFns = [], allConstant = !0;
            if ("]" !== this.peekToken().text) do {
                if (this.peek("]")) break;
                var elementFn = this.expression();
                elementFns.push(elementFn), elementFn.constant || (allConstant = !1);
            } while (this.expect(","));
            return this.consume("]"), extend(function(self, locals) {
                for (var array = [], i = 0; i < elementFns.length; i++) array.push(elementFns[i](self, locals));
                return array;
            }, {
                literal: !0,
                constant: allConstant
            });
        },
        object: function() {
            var keyValues = [], allConstant = !0;
            if ("}" !== this.peekToken().text) do {
                if (this.peek("}")) break;
                var token = this.expect(), key = token.string || token.text;
                this.consume(":");
                var value = this.expression();
                keyValues.push({
                    key: key,
                    value: value
                }), value.constant || (allConstant = !1);
            } while (this.expect(","));
            return this.consume("}"), extend(function(self, locals) {
                for (var object = {}, i = 0; i < keyValues.length; i++) {
                    var keyValue = keyValues[i];
                    object[keyValue.key] = keyValue.value(self, locals);
                }
                return object;
            }, {
                literal: !0,
                constant: allConstant
            });
        }
    };
    var getterFnCacheDefault = {}, getterFnCacheExpensive = {}, $sceMinErr = minErr("$sce"), SCE_CONTEXTS = {
        HTML: "html",
        CSS: "css",
        URL: "url",
        RESOURCE_URL: "resourceUrl",
        JS: "js"
    }, urlParsingNode = document.createElement("a"), originUrl = urlResolve(window.location.href, !0);
    $FilterProvider.$inject = [ "$provide" ], currencyFilter.$inject = [ "$locale" ], 
    numberFilter.$inject = [ "$locale" ];
    var DECIMAL_SEP = ".", DATE_FORMATS = {
        yyyy: dateGetter("FullYear", 4),
        yy: dateGetter("FullYear", 2, 0, !0),
        y: dateGetter("FullYear", 1),
        MMMM: dateStrGetter("Month"),
        MMM: dateStrGetter("Month", !0),
        MM: dateGetter("Month", 2, 1),
        M: dateGetter("Month", 1, 1),
        dd: dateGetter("Date", 2),
        d: dateGetter("Date", 1),
        HH: dateGetter("Hours", 2),
        H: dateGetter("Hours", 1),
        hh: dateGetter("Hours", 2, -12),
        h: dateGetter("Hours", 1, -12),
        mm: dateGetter("Minutes", 2),
        m: dateGetter("Minutes", 1),
        ss: dateGetter("Seconds", 2),
        s: dateGetter("Seconds", 1),
        sss: dateGetter("Milliseconds", 3),
        EEEE: dateStrGetter("Day"),
        EEE: dateStrGetter("Day", !0),
        a: ampmGetter,
        Z: timeZoneGetter
    }, DATE_FORMATS_SPLIT = /((?:[^yMdHhmsaZE']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|d+|H+|h+|m+|s+|a|Z))(.*)/, NUMBER_STRING = /^\-?\d+$/;
    dateFilter.$inject = [ "$locale" ];
    var lowercaseFilter = valueFn(lowercase), uppercaseFilter = valueFn(uppercase);
    orderByFilter.$inject = [ "$parse" ];
    var htmlAnchorDirective = valueFn({
        restrict: "E",
        compile: function(element, attr) {
            return 8 >= msie && (attr.href || attr.name || attr.$set("href", ""), element.append(document.createComment("IE fix"))), 
            attr.href || attr.xlinkHref || attr.name ? void 0 : function(scope, element) {
                var href = "[object SVGAnimatedString]" === toString.call(element.prop("href")) ? "xlink:href" : "href";
                element.on("click", function(event) {
                    element.attr(href) || event.preventDefault();
                });
            };
        }
    }), ngAttributeAliasDirectives = {};
    forEach(BOOLEAN_ATTR, function(propName, attrName) {
        if ("multiple" != propName) {
            var normalized = directiveNormalize("ng-" + attrName);
            ngAttributeAliasDirectives[normalized] = function() {
                return {
                    priority: 100,
                    link: function(scope, element, attr) {
                        scope.$watch(attr[normalized], function(value) {
                            attr.$set(attrName, !!value);
                        });
                    }
                };
            };
        }
    }), forEach([ "src", "srcset", "href" ], function(attrName) {
        var normalized = directiveNormalize("ng-" + attrName);
        ngAttributeAliasDirectives[normalized] = function() {
            return {
                priority: 99,
                link: function(scope, element, attr) {
                    var propName = attrName, name = attrName;
                    "href" === attrName && "[object SVGAnimatedString]" === toString.call(element.prop("href")) && (name = "xlinkHref", 
                    attr.$attr[name] = "xlink:href", propName = null), attr.$observe(normalized, function(value) {
                        return value ? (attr.$set(name, value), void (msie && propName && element.prop(propName, attr[name]))) : void ("href" === attrName && attr.$set(name, null));
                    });
                }
            };
        };
    });
    var nullFormCtrl = {
        $addControl: noop,
        $removeControl: noop,
        $setValidity: noop,
        $setDirty: noop,
        $setPristine: noop
    };
    FormController.$inject = [ "$element", "$attrs", "$scope", "$animate" ];
    var formDirectiveFactory = function(isNgForm) {
        return [ "$timeout", function($timeout) {
            var formDirective = {
                name: "form",
                restrict: isNgForm ? "EAC" : "E",
                controller: FormController,
                compile: function() {
                    return {
                        pre: function(scope, formElement, attr, controller) {
                            if (!attr.action) {
                                var preventDefaultListener = function(event) {
                                    event.preventDefault ? event.preventDefault() : event.returnValue = !1;
                                };
                                addEventListenerFn(formElement[0], "submit", preventDefaultListener), formElement.on("$destroy", function() {
                                    $timeout(function() {
                                        removeEventListenerFn(formElement[0], "submit", preventDefaultListener);
                                    }, 0, !1);
                                });
                            }
                            var parentFormCtrl = formElement.parent().controller("form"), alias = attr.name || attr.ngForm;
                            alias && setter(scope, alias, controller, alias), parentFormCtrl && formElement.on("$destroy", function() {
                                parentFormCtrl.$removeControl(controller), alias && setter(scope, alias, undefined, alias), 
                                extend(controller, nullFormCtrl);
                            });
                        }
                    };
                }
            };
            return formDirective;
        } ];
    }, formDirective = formDirectiveFactory(), ngFormDirective = formDirectiveFactory(!0), URL_REGEXP = /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/, EMAIL_REGEXP = /^[a-z0-9!#$%&'*+\/=?^_`{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i, NUMBER_REGEXP = /^\s*(\-|\+)?(\d+|(\d*(\.\d*)))\s*$/, inputType = {
        text: textInputType,
        number: numberInputType,
        url: urlInputType,
        email: emailInputType,
        radio: radioInputType,
        checkbox: checkboxInputType,
        hidden: noop,
        button: noop,
        submit: noop,
        reset: noop,
        file: noop
    }, numberBadFlags = [ "badInput" ], inputDirective = [ "$browser", "$sniffer", function($browser, $sniffer) {
        return {
            restrict: "E",
            require: "?ngModel",
            link: function(scope, element, attr, ctrl) {
                ctrl && (inputType[lowercase(attr.type)] || inputType.text)(scope, element, attr, ctrl, $sniffer, $browser);
            }
        };
    } ], VALID_CLASS = "ng-valid", INVALID_CLASS = "ng-invalid", PRISTINE_CLASS = "ng-pristine", DIRTY_CLASS = "ng-dirty", NgModelController = [ "$scope", "$exceptionHandler", "$attrs", "$element", "$parse", "$animate", function($scope, $exceptionHandler, $attr, $element, $parse, $animate) {
        function toggleValidCss(isValid, validationErrorKey) {
            validationErrorKey = validationErrorKey ? "-" + snake_case(validationErrorKey, "-") : "", 
            $animate.removeClass($element, (isValid ? INVALID_CLASS : VALID_CLASS) + validationErrorKey), 
            $animate.addClass($element, (isValid ? VALID_CLASS : INVALID_CLASS) + validationErrorKey);
        }
        this.$viewValue = Number.NaN, this.$modelValue = Number.NaN, this.$parsers = [], 
        this.$formatters = [], this.$viewChangeListeners = [], this.$pristine = !0, this.$dirty = !1, 
        this.$valid = !0, this.$invalid = !1, this.$name = $attr.name;
        var ngModelGet = $parse($attr.ngModel), ngModelSet = ngModelGet.assign;
        if (!ngModelSet) throw minErr("ngModel")("nonassign", "Expression '{0}' is non-assignable. Element: {1}", $attr.ngModel, startingTag($element));
        this.$render = noop, this.$isEmpty = function(value) {
            return isUndefined(value) || "" === value || null === value || value !== value;
        };
        var parentForm = $element.inheritedData("$formController") || nullFormCtrl, invalidCount = 0, $error = this.$error = {};
        $element.addClass(PRISTINE_CLASS), toggleValidCss(!0), this.$setValidity = function(validationErrorKey, isValid) {
            $error[validationErrorKey] !== !isValid && (isValid ? ($error[validationErrorKey] && invalidCount--, 
            invalidCount || (toggleValidCss(!0), this.$valid = !0, this.$invalid = !1)) : (toggleValidCss(!1), 
            this.$invalid = !0, this.$valid = !1, invalidCount++), $error[validationErrorKey] = !isValid, 
            toggleValidCss(isValid, validationErrorKey), parentForm.$setValidity(validationErrorKey, isValid, this));
        }, this.$setPristine = function() {
            this.$dirty = !1, this.$pristine = !0, $animate.removeClass($element, DIRTY_CLASS), 
            $animate.addClass($element, PRISTINE_CLASS);
        }, this.$setViewValue = function(value) {
            this.$viewValue = value, this.$pristine && (this.$dirty = !0, this.$pristine = !1, 
            $animate.removeClass($element, PRISTINE_CLASS), $animate.addClass($element, DIRTY_CLASS), 
            parentForm.$setDirty()), forEach(this.$parsers, function(fn) {
                value = fn(value);
            }), this.$modelValue !== value && (this.$modelValue = value, ngModelSet($scope, value), 
            forEach(this.$viewChangeListeners, function(listener) {
                try {
                    listener();
                } catch (e) {
                    $exceptionHandler(e);
                }
            }));
        };
        var ctrl = this;
        $scope.$watch(function() {
            var value = ngModelGet($scope);
            if (ctrl.$modelValue !== value) {
                var formatters = ctrl.$formatters, idx = formatters.length;
                for (ctrl.$modelValue = value; idx--; ) value = formatters[idx](value);
                ctrl.$viewValue !== value && (ctrl.$viewValue = value, ctrl.$render());
            }
            return value;
        });
    } ], ngModelDirective = function() {
        return {
            require: [ "ngModel", "^?form" ],
            controller: NgModelController,
            link: function(scope, element, attr, ctrls) {
                var modelCtrl = ctrls[0], formCtrl = ctrls[1] || nullFormCtrl;
                formCtrl.$addControl(modelCtrl), scope.$on("$destroy", function() {
                    formCtrl.$removeControl(modelCtrl);
                });
            }
        };
    }, ngChangeDirective = valueFn({
        require: "ngModel",
        link: function(scope, element, attr, ctrl) {
            ctrl.$viewChangeListeners.push(function() {
                scope.$eval(attr.ngChange);
            });
        }
    }), requiredDirective = function() {
        return {
            require: "?ngModel",
            link: function(scope, elm, attr, ctrl) {
                if (ctrl) {
                    attr.required = !0;
                    var validator = function(value) {
                        return attr.required && ctrl.$isEmpty(value) ? void ctrl.$setValidity("required", !1) : (ctrl.$setValidity("required", !0), 
                        value);
                    };
                    ctrl.$formatters.push(validator), ctrl.$parsers.unshift(validator), attr.$observe("required", function() {
                        validator(ctrl.$viewValue);
                    });
                }
            }
        };
    }, ngListDirective = function() {
        return {
            require: "ngModel",
            link: function(scope, element, attr, ctrl) {
                var match = /\/(.*)\//.exec(attr.ngList), separator = match && new RegExp(match[1]) || attr.ngList || ",", parse = function(viewValue) {
                    if (!isUndefined(viewValue)) {
                        var list = [];
                        return viewValue && forEach(viewValue.split(separator), function(value) {
                            value && list.push(trim(value));
                        }), list;
                    }
                };
                ctrl.$parsers.push(parse), ctrl.$formatters.push(function(value) {
                    return isArray(value) ? value.join(", ") : undefined;
                }), ctrl.$isEmpty = function(value) {
                    return !value || !value.length;
                };
            }
        };
    }, CONSTANT_VALUE_REGEXP = /^(true|false|\d+)$/, ngValueDirective = function() {
        return {
            priority: 100,
            compile: function(tpl, tplAttr) {
                return CONSTANT_VALUE_REGEXP.test(tplAttr.ngValue) ? function(scope, elm, attr) {
                    attr.$set("value", scope.$eval(attr.ngValue));
                } : function(scope, elm, attr) {
                    scope.$watch(attr.ngValue, function(value) {
                        attr.$set("value", value);
                    });
                };
            }
        };
    }, ngBindDirective = ngDirective({
        compile: function(templateElement) {
            return templateElement.addClass("ng-binding"), function(scope, element, attr) {
                element.data("$binding", attr.ngBind), scope.$watch(attr.ngBind, function(value) {
                    element.text(value == undefined ? "" : value);
                });
            };
        }
    }), ngBindTemplateDirective = [ "$interpolate", function($interpolate) {
        return function(scope, element, attr) {
            var interpolateFn = $interpolate(element.attr(attr.$attr.ngBindTemplate));
            element.addClass("ng-binding").data("$binding", interpolateFn), attr.$observe("ngBindTemplate", function(value) {
                element.text(value);
            });
        };
    } ], ngBindHtmlDirective = [ "$sce", "$parse", function($sce, $parse) {
        return {
            compile: function(tElement) {
                return tElement.addClass("ng-binding"), function(scope, element, attr) {
                    function getStringValue() {
                        return (parsed(scope) || "").toString();
                    }
                    element.data("$binding", attr.ngBindHtml);
                    var parsed = $parse(attr.ngBindHtml);
                    scope.$watch(getStringValue, function(value) {
                        element.html($sce.getTrustedHtml(parsed(scope)) || "");
                    });
                };
            }
        };
    } ], ngClassDirective = classDirective("", !0), ngClassOddDirective = classDirective("Odd", 0), ngClassEvenDirective = classDirective("Even", 1), ngCloakDirective = ngDirective({
        compile: function(element, attr) {
            attr.$set("ngCloak", undefined), element.removeClass("ng-cloak");
        }
    }), ngControllerDirective = [ function() {
        return {
            scope: !0,
            controller: "@",
            priority: 500
        };
    } ], ngEventDirectives = {}, forceAsyncEvents = {
        blur: !0,
        focus: !0
    };
    forEach("click dblclick mousedown mouseup mouseover mouseout mousemove mouseenter mouseleave keydown keyup keypress submit focus blur copy cut paste".split(" "), function(eventName) {
        var directiveName = directiveNormalize("ng-" + eventName);
        ngEventDirectives[directiveName] = [ "$parse", "$rootScope", function($parse, $rootScope) {
            return {
                compile: function($element, attr) {
                    var fn = $parse(attr[directiveName], !0);
                    return function(scope, element) {
                        element.on(eventName, function(event) {
                            var callback = function() {
                                fn(scope, {
                                    $event: event
                                });
                            };
                            forceAsyncEvents[eventName] && $rootScope.$$phase ? scope.$evalAsync(callback) : scope.$apply(callback);
                        });
                    };
                }
            };
        } ];
    });
    var ngIfDirective = [ "$animate", function($animate) {
        return {
            transclude: "element",
            priority: 600,
            terminal: !0,
            restrict: "A",
            $$tlb: !0,
            link: function($scope, $element, $attr, ctrl, $transclude) {
                var block, childScope, previousElements;
                $scope.$watch($attr.ngIf, function(value) {
                    toBoolean(value) ? childScope || (childScope = $scope.$new(), $transclude(childScope, function(clone) {
                        clone[clone.length++] = document.createComment(" end ngIf: " + $attr.ngIf + " "), 
                        block = {
                            clone: clone
                        }, $animate.enter(clone, $element.parent(), $element);
                    })) : (previousElements && (previousElements.remove(), previousElements = null), 
                    childScope && (childScope.$destroy(), childScope = null), block && (previousElements = getBlockElements(block.clone), 
                    $animate.leave(previousElements, function() {
                        previousElements = null;
                    }), block = null));
                });
            }
        };
    } ], ngIncludeDirective = [ "$http", "$templateCache", "$anchorScroll", "$animate", "$sce", function($http, $templateCache, $anchorScroll, $animate, $sce) {
        return {
            restrict: "ECA",
            priority: 400,
            terminal: !0,
            transclude: "element",
            controller: angular.noop,
            compile: function(element, attr) {
                var srcExp = attr.ngInclude || attr.src, onloadExp = attr.onload || "", autoScrollExp = attr.autoscroll;
                return function(scope, $element, $attr, ctrl, $transclude) {
                    var currentScope, previousElement, currentElement, changeCounter = 0, cleanupLastIncludeContent = function() {
                        previousElement && (previousElement.remove(), previousElement = null), currentScope && (currentScope.$destroy(), 
                        currentScope = null), currentElement && ($animate.leave(currentElement, function() {
                            previousElement = null;
                        }), previousElement = currentElement, currentElement = null);
                    };
                    scope.$watch($sce.parseAsResourceUrl(srcExp), function(src) {
                        var afterAnimation = function() {
                            !isDefined(autoScrollExp) || autoScrollExp && !scope.$eval(autoScrollExp) || $anchorScroll();
                        }, thisChangeId = ++changeCounter;
                        src ? ($http.get(src, {
                            cache: $templateCache
                        }).success(function(response) {
                            if (thisChangeId === changeCounter) {
                                var newScope = scope.$new();
                                ctrl.template = response;
                                var clone = $transclude(newScope, function(clone) {
                                    cleanupLastIncludeContent(), $animate.enter(clone, null, $element, afterAnimation);
                                });
                                currentScope = newScope, currentElement = clone, currentScope.$emit("$includeContentLoaded"), 
                                scope.$eval(onloadExp);
                            }
                        }).error(function() {
                            thisChangeId === changeCounter && cleanupLastIncludeContent();
                        }), scope.$emit("$includeContentRequested")) : (cleanupLastIncludeContent(), ctrl.template = null);
                    });
                };
            }
        };
    } ], ngIncludeFillContentDirective = [ "$compile", function($compile) {
        return {
            restrict: "ECA",
            priority: -400,
            require: "ngInclude",
            link: function(scope, $element, $attr, ctrl) {
                $element.html(ctrl.template), $compile($element.contents())(scope);
            }
        };
    } ], ngInitDirective = ngDirective({
        priority: 450,
        compile: function() {
            return {
                pre: function(scope, element, attrs) {
                    scope.$eval(attrs.ngInit);
                }
            };
        }
    }), ngNonBindableDirective = ngDirective({
        terminal: !0,
        priority: 1e3
    }), ngPluralizeDirective = [ "$locale", "$interpolate", function($locale, $interpolate) {
        var BRACE = /{}/g;
        return {
            restrict: "EA",
            link: function(scope, element, attr) {
                var numberExp = attr.count, whenExp = attr.$attr.when && element.attr(attr.$attr.when), offset = attr.offset || 0, whens = scope.$eval(whenExp) || {}, whensExpFns = {}, startSymbol = $interpolate.startSymbol(), endSymbol = $interpolate.endSymbol(), isWhen = /^when(Minus)?(.+)$/;
                forEach(attr, function(expression, attributeName) {
                    isWhen.test(attributeName) && (whens[lowercase(attributeName.replace("when", "").replace("Minus", "-"))] = element.attr(attr.$attr[attributeName]));
                }), forEach(whens, function(expression, key) {
                    whensExpFns[key] = $interpolate(expression.replace(BRACE, startSymbol + numberExp + "-" + offset + endSymbol));
                }), scope.$watch(function() {
                    var value = parseFloat(scope.$eval(numberExp));
                    return isNaN(value) ? "" : (value in whens || (value = $locale.pluralCat(value - offset)), 
                    whensExpFns[value](scope, element, !0));
                }, function(newVal) {
                    element.text(newVal);
                });
            }
        };
    } ], ngRepeatDirective = [ "$parse", "$animate", function($parse, $animate) {
        function getBlockStart(block) {
            return block.clone[0];
        }
        function getBlockEnd(block) {
            return block.clone[block.clone.length - 1];
        }
        var NG_REMOVED = "$$NG_REMOVED", ngRepeatMinErr = minErr("ngRepeat");
        return {
            transclude: "element",
            priority: 1e3,
            terminal: !0,
            $$tlb: !0,
            link: function($scope, $element, $attr, ctrl, $transclude) {
                var trackByExp, trackByExpGetter, trackByIdExpFn, trackByIdArrayFn, trackByIdObjFn, lhs, rhs, valueIdentifier, keyIdentifier, expression = $attr.ngRepeat, match = expression.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?\s*$/), hashFnLocals = {
                    $id: hashKey
                };
                if (!match) throw ngRepeatMinErr("iexp", "Expected expression in form of '_item_ in _collection_[ track by _id_]' but got '{0}'.", expression);
                if (lhs = match[1], rhs = match[2], trackByExp = match[3], trackByExp ? (trackByExpGetter = $parse(trackByExp), 
                trackByIdExpFn = function(key, value, index) {
                    return keyIdentifier && (hashFnLocals[keyIdentifier] = key), hashFnLocals[valueIdentifier] = value, 
                    hashFnLocals.$index = index, trackByExpGetter($scope, hashFnLocals);
                }) : (trackByIdArrayFn = function(key, value) {
                    return hashKey(value);
                }, trackByIdObjFn = function(key) {
                    return key;
                }), match = lhs.match(/^(?:([\$\w]+)|\(([\$\w]+)\s*,\s*([\$\w]+)\))$/), !match) throw ngRepeatMinErr("iidexp", "'_item_' in '_item_ in _collection_' should be an identifier or '(_key_, _value_)' expression, but got '{0}'.", lhs);
                valueIdentifier = match[3] || match[1], keyIdentifier = match[2];
                var lastBlockMap = {};
                $scope.$watchCollection(rhs, function(collection) {
                    var index, length, nextNode, arrayLength, childScope, key, value, trackById, trackByIdFn, collectionKeys, block, elementsToRemove, previousNode = $element[0], nextBlockMap = {}, nextBlockOrder = [];
                    if (isArrayLike(collection)) collectionKeys = collection, trackByIdFn = trackByIdExpFn || trackByIdArrayFn; else {
                        trackByIdFn = trackByIdExpFn || trackByIdObjFn, collectionKeys = [];
                        for (key in collection) collection.hasOwnProperty(key) && "$" != key.charAt(0) && collectionKeys.push(key);
                        collectionKeys.sort();
                    }
                    for (arrayLength = collectionKeys.length, length = nextBlockOrder.length = collectionKeys.length, 
                    index = 0; length > index; index++) if (key = collection === collectionKeys ? index : collectionKeys[index], 
                    value = collection[key], trackById = trackByIdFn(key, value, index), assertNotHasOwnProperty(trackById, "`track by` id"), 
                    lastBlockMap.hasOwnProperty(trackById)) block = lastBlockMap[trackById], delete lastBlockMap[trackById], 
                    nextBlockMap[trackById] = block, nextBlockOrder[index] = block; else {
                        if (nextBlockMap.hasOwnProperty(trackById)) throw forEach(nextBlockOrder, function(block) {
                            block && block.scope && (lastBlockMap[block.id] = block);
                        }), ngRepeatMinErr("dupes", "Duplicates in a repeater are not allowed. Use 'track by' expression to specify unique keys. Repeater: {0}, Duplicate key: {1}, Duplicate value: {2}", expression, trackById, toJson(value));
                        nextBlockOrder[index] = {
                            id: trackById
                        }, nextBlockMap[trackById] = !1;
                    }
                    for (key in lastBlockMap) lastBlockMap.hasOwnProperty(key) && (block = lastBlockMap[key], 
                    elementsToRemove = getBlockElements(block.clone), $animate.leave(elementsToRemove), 
                    forEach(elementsToRemove, function(element) {
                        element[NG_REMOVED] = !0;
                    }), block.scope.$destroy());
                    for (index = 0, length = collectionKeys.length; length > index; index++) {
                        if (key = collection === collectionKeys ? index : collectionKeys[index], value = collection[key], 
                        block = nextBlockOrder[index], nextBlockOrder[index - 1] && (previousNode = getBlockEnd(nextBlockOrder[index - 1])), 
                        block.scope) {
                            childScope = block.scope, nextNode = previousNode;
                            do nextNode = nextNode.nextSibling; while (nextNode && nextNode[NG_REMOVED]);
                            getBlockStart(block) != nextNode && $animate.move(getBlockElements(block.clone), null, jqLite(previousNode)), 
                            previousNode = getBlockEnd(block);
                        } else childScope = $scope.$new();
                        childScope[valueIdentifier] = value, keyIdentifier && (childScope[keyIdentifier] = key), 
                        childScope.$index = index, childScope.$first = 0 === index, childScope.$last = index === arrayLength - 1, 
                        childScope.$middle = !(childScope.$first || childScope.$last), childScope.$odd = !(childScope.$even = 0 === (1 & index)), 
                        block.scope || $transclude(childScope, function(clone) {
                            clone[clone.length++] = document.createComment(" end ngRepeat: " + expression + " "), 
                            $animate.enter(clone, null, jqLite(previousNode)), previousNode = clone, block.scope = childScope, 
                            block.clone = clone, nextBlockMap[block.id] = block;
                        });
                    }
                    lastBlockMap = nextBlockMap;
                });
            }
        };
    } ], ngShowDirective = [ "$animate", function($animate) {
        return function(scope, element, attr) {
            scope.$watch(attr.ngShow, function(value) {
                $animate[toBoolean(value) ? "removeClass" : "addClass"](element, "ng-hide");
            });
        };
    } ], ngHideDirective = [ "$animate", function($animate) {
        return function(scope, element, attr) {
            scope.$watch(attr.ngHide, function(value) {
                $animate[toBoolean(value) ? "addClass" : "removeClass"](element, "ng-hide");
            });
        };
    } ], ngStyleDirective = ngDirective(function(scope, element, attr) {
        scope.$watch(attr.ngStyle, function(newStyles, oldStyles) {
            oldStyles && newStyles !== oldStyles && forEach(oldStyles, function(val, style) {
                element.css(style, "");
            }), newStyles && element.css(newStyles);
        }, !0);
    }), ngSwitchDirective = [ "$animate", function($animate) {
        return {
            restrict: "EA",
            require: "ngSwitch",
            controller: [ "$scope", function() {
                this.cases = {};
            } ],
            link: function(scope, element, attr, ngSwitchController) {
                var watchExpr = attr.ngSwitch || attr.on, selectedTranscludes = [], selectedElements = [], previousElements = [], selectedScopes = [];
                scope.$watch(watchExpr, function(value) {
                    var i, ii;
                    for (i = 0, ii = previousElements.length; ii > i; ++i) previousElements[i].remove();
                    for (previousElements.length = 0, i = 0, ii = selectedScopes.length; ii > i; ++i) {
                        var selected = selectedElements[i];
                        selectedScopes[i].$destroy(), previousElements[i] = selected, $animate.leave(selected, function() {
                            previousElements.splice(i, 1);
                        });
                    }
                    selectedElements.length = 0, selectedScopes.length = 0, (selectedTranscludes = ngSwitchController.cases["!" + value] || ngSwitchController.cases["?"]) && (scope.$eval(attr.change), 
                    forEach(selectedTranscludes, function(selectedTransclude) {
                        var selectedScope = scope.$new();
                        selectedScopes.push(selectedScope), selectedTransclude.transclude(selectedScope, function(caseElement) {
                            var anchor = selectedTransclude.element;
                            selectedElements.push(caseElement), $animate.enter(caseElement, anchor.parent(), anchor);
                        });
                    }));
                });
            }
        };
    } ], ngSwitchWhenDirective = ngDirective({
        transclude: "element",
        priority: 800,
        require: "^ngSwitch",
        link: function(scope, element, attrs, ctrl, $transclude) {
            ctrl.cases["!" + attrs.ngSwitchWhen] = ctrl.cases["!" + attrs.ngSwitchWhen] || [], 
            ctrl.cases["!" + attrs.ngSwitchWhen].push({
                transclude: $transclude,
                element: element
            });
        }
    }), ngSwitchDefaultDirective = ngDirective({
        transclude: "element",
        priority: 800,
        require: "^ngSwitch",
        link: function(scope, element, attr, ctrl, $transclude) {
            ctrl.cases["?"] = ctrl.cases["?"] || [], ctrl.cases["?"].push({
                transclude: $transclude,
                element: element
            });
        }
    }), ngTranscludeDirective = ngDirective({
        link: function($scope, $element, $attrs, controller, $transclude) {
            if (!$transclude) throw minErr("ngTransclude")("orphan", "Illegal use of ngTransclude directive in the template! No parent directive that requires a transclusion found. Element: {0}", startingTag($element));
            $transclude(function(clone) {
                $element.empty(), $element.append(clone);
            });
        }
    }), scriptDirective = [ "$templateCache", function($templateCache) {
        return {
            restrict: "E",
            terminal: !0,
            compile: function(element, attr) {
                if ("text/ng-template" == attr.type) {
                    var templateUrl = attr.id, text = element[0].text;
                    $templateCache.put(templateUrl, text);
                }
            }
        };
    } ], ngOptionsMinErr = minErr("ngOptions"), ngOptionsDirective = valueFn({
        terminal: !0
    }), selectDirective = [ "$compile", "$parse", function($compile, $parse) {
        var NG_OPTIONS_REGEXP = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/, nullModelCtrl = {
            $setViewValue: noop
        };
        return {
            restrict: "E",
            require: [ "select", "?ngModel" ],
            controller: [ "$element", "$scope", "$attrs", function($element, $scope, $attrs) {
                var nullOption, unknownOption, self = this, optionsMap = {}, ngModelCtrl = nullModelCtrl;
                self.databound = $attrs.ngModel, self.init = function(ngModelCtrl_, nullOption_, unknownOption_) {
                    ngModelCtrl = ngModelCtrl_, nullOption = nullOption_, unknownOption = unknownOption_;
                }, self.addOption = function(value) {
                    assertNotHasOwnProperty(value, '"option value"'), optionsMap[value] = !0, ngModelCtrl.$viewValue == value && ($element.val(value), 
                    unknownOption.parent() && unknownOption.remove());
                }, self.removeOption = function(value) {
                    this.hasOption(value) && (delete optionsMap[value], ngModelCtrl.$viewValue == value && this.renderUnknownOption(value));
                }, self.renderUnknownOption = function(val) {
                    var unknownVal = "? " + hashKey(val) + " ?";
                    unknownOption.val(unknownVal), $element.prepend(unknownOption), $element.val(unknownVal), 
                    unknownOption.prop("selected", !0);
                }, self.hasOption = function(value) {
                    return optionsMap.hasOwnProperty(value);
                }, $scope.$on("$destroy", function() {
                    self.renderUnknownOption = noop;
                });
            } ],
            link: function(scope, element, attr, ctrls) {
                function setupAsSingle(scope, selectElement, ngModelCtrl, selectCtrl) {
                    ngModelCtrl.$render = function() {
                        var viewValue = ngModelCtrl.$viewValue;
                        selectCtrl.hasOption(viewValue) ? (unknownOption.parent() && unknownOption.remove(), 
                        selectElement.val(viewValue), "" === viewValue && emptyOption.prop("selected", !0)) : isUndefined(viewValue) && emptyOption ? selectElement.val("") : selectCtrl.renderUnknownOption(viewValue);
                    }, selectElement.on("change", function() {
                        scope.$apply(function() {
                            unknownOption.parent() && unknownOption.remove(), ngModelCtrl.$setViewValue(selectElement.val());
                        });
                    });
                }
                function setupAsMultiple(scope, selectElement, ctrl) {
                    var lastView;
                    ctrl.$render = function() {
                        var items = new HashMap(ctrl.$viewValue);
                        forEach(selectElement.find("option"), function(option) {
                            option.selected = isDefined(items.get(option.value));
                        });
                    }, scope.$watch(function() {
                        equals(lastView, ctrl.$viewValue) || (lastView = shallowCopy(ctrl.$viewValue), ctrl.$render());
                    }), selectElement.on("change", function() {
                        scope.$apply(function() {
                            var array = [];
                            forEach(selectElement.find("option"), function(option) {
                                option.selected && array.push(option.value);
                            }), ctrl.$setViewValue(array);
                        });
                    });
                }
                function setupAsOptions(scope, selectElement, ctrl) {
                    function getSelectedSet() {
                        var selectedSet = !1;
                        if (multiple) {
                            var modelValue = ctrl.$modelValue;
                            if (trackFn && isArray(modelValue)) {
                                selectedSet = new HashMap([]);
                                for (var locals = {}, trackIndex = 0; trackIndex < modelValue.length; trackIndex++) locals[valueName] = modelValue[trackIndex], 
                                selectedSet.put(trackFn(scope, locals), modelValue[trackIndex]);
                            } else selectedSet = new HashMap(modelValue);
                        }
                        return selectedSet;
                    }
                    function render() {
                        var optionGroupName, optionGroup, option, existingParent, existingOptions, existingOption, key, groupLength, length, groupIndex, index, selected, lastElement, element, label, optionGroups = {
                            "": []
                        }, optionGroupNames = [ "" ], modelValue = ctrl.$modelValue, values = valuesFn(scope) || [], keys = keyName ? sortedKeys(values) : values, locals = {}, selectedSet = getSelectedSet();
                        for (index = 0; length = keys.length, length > index; index++) {
                            if (key = index, keyName) {
                                if (key = keys[index], "$" === key.charAt(0)) continue;
                                locals[keyName] = key;
                            }
                            if (locals[valueName] = values[key], optionGroupName = groupByFn(scope, locals) || "", 
                            (optionGroup = optionGroups[optionGroupName]) || (optionGroup = optionGroups[optionGroupName] = [], 
                            optionGroupNames.push(optionGroupName)), multiple) selected = isDefined(selectedSet.remove(trackFn ? trackFn(scope, locals) : valueFn(scope, locals))); else {
                                if (trackFn) {
                                    var modelCast = {};
                                    modelCast[valueName] = modelValue, selected = trackFn(scope, modelCast) === trackFn(scope, locals);
                                } else selected = modelValue === valueFn(scope, locals);
                                selectedSet = selectedSet || selected;
                            }
                            label = displayFn(scope, locals), label = isDefined(label) ? label : "", optionGroup.push({
                                id: trackFn ? trackFn(scope, locals) : keyName ? keys[index] : index,
                                label: label,
                                selected: selected
                            });
                        }
                        for (multiple || (nullOption || null === modelValue ? optionGroups[""].unshift({
                            id: "",
                            label: "",
                            selected: !selectedSet
                        }) : selectedSet || optionGroups[""].unshift({
                            id: "?",
                            label: "",
                            selected: !0
                        })), groupIndex = 0, groupLength = optionGroupNames.length; groupLength > groupIndex; groupIndex++) {
                            for (optionGroupName = optionGroupNames[groupIndex], optionGroup = optionGroups[optionGroupName], 
                            optionGroupsCache.length <= groupIndex ? (existingParent = {
                                element: optGroupTemplate.clone().attr("label", optionGroupName),
                                label: optionGroup.label
                            }, existingOptions = [ existingParent ], optionGroupsCache.push(existingOptions), 
                            selectElement.append(existingParent.element)) : (existingOptions = optionGroupsCache[groupIndex], 
                            existingParent = existingOptions[0], existingParent.label != optionGroupName && existingParent.element.attr("label", existingParent.label = optionGroupName)), 
                            lastElement = null, index = 0, length = optionGroup.length; length > index; index++) option = optionGroup[index], 
                            (existingOption = existingOptions[index + 1]) ? (lastElement = existingOption.element, 
                            existingOption.label !== option.label && (lastElement.text(existingOption.label = option.label), 
                            lastElement.prop("label", existingOption.label)), existingOption.id !== option.id && lastElement.val(existingOption.id = option.id), 
                            lastElement[0].selected !== option.selected && (lastElement.prop("selected", existingOption.selected = option.selected), 
                            msie && lastElement.prop("selected", existingOption.selected))) : ("" === option.id && nullOption ? element = nullOption : (element = optionTemplate.clone()).val(option.id).prop("selected", option.selected).attr("selected", option.selected).prop("label", option.label).text(option.label), 
                            existingOptions.push(existingOption = {
                                element: element,
                                label: option.label,
                                id: option.id,
                                selected: option.selected
                            }), selectCtrl.addOption(option.label, element), lastElement ? lastElement.after(element) : existingParent.element.append(element), 
                            lastElement = element);
                            for (index++; existingOptions.length > index; ) option = existingOptions.pop(), 
                            selectCtrl.removeOption(option.label), option.element.remove();
                        }
                        for (;optionGroupsCache.length > groupIndex; ) optionGroupsCache.pop()[0].element.remove();
                    }
                    var match;
                    if (!(match = optionsExp.match(NG_OPTIONS_REGEXP))) throw ngOptionsMinErr("iexp", "Expected expression in form of '_select_ (as _label_)? for (_key_,)?_value_ in _collection_' but got '{0}'. Element: {1}", optionsExp, startingTag(selectElement));
                    var displayFn = $parse(match[2] || match[1]), valueName = match[4] || match[6], keyName = match[5], groupByFn = $parse(match[3] || ""), valueFn = $parse(match[2] ? match[1] : valueName), valuesFn = $parse(match[7]), track = match[8], trackFn = track ? $parse(match[8]) : null, optionGroupsCache = [ [ {
                        element: selectElement,
                        label: ""
                    } ] ];
                    nullOption && ($compile(nullOption)(scope), nullOption.removeClass("ng-scope"), 
                    nullOption.remove()), selectElement.empty(), selectElement.on("change", function() {
                        scope.$apply(function() {
                            var optionGroup, key, value, optionElement, index, groupIndex, length, groupLength, trackIndex, collection = valuesFn(scope) || [], locals = {};
                            if (multiple) {
                                for (value = [], groupIndex = 0, groupLength = optionGroupsCache.length; groupLength > groupIndex; groupIndex++) for (optionGroup = optionGroupsCache[groupIndex], 
                                index = 1, length = optionGroup.length; length > index; index++) if ((optionElement = optionGroup[index].element)[0].selected) {
                                    if (key = optionElement.val(), keyName && (locals[keyName] = key), trackFn) for (trackIndex = 0; trackIndex < collection.length && (locals[valueName] = collection[trackIndex], 
                                    trackFn(scope, locals) != key); trackIndex++) ; else locals[valueName] = collection[key];
                                    value.push(valueFn(scope, locals));
                                }
                            } else if (key = selectElement.val(), "?" == key) value = undefined; else if ("" === key) value = null; else if (trackFn) {
                                for (trackIndex = 0; trackIndex < collection.length; trackIndex++) if (locals[valueName] = collection[trackIndex], 
                                trackFn(scope, locals) == key) {
                                    value = valueFn(scope, locals);
                                    break;
                                }
                            } else locals[valueName] = collection[key], keyName && (locals[keyName] = key), 
                            value = valueFn(scope, locals);
                            ctrl.$setViewValue(value), render();
                        });
                    }), ctrl.$render = render, scope.$watchCollection(valuesFn, render), scope.$watchCollection(function() {
                        var locals = {}, values = valuesFn(scope);
                        if (values) {
                            for (var toDisplay = new Array(values.length), i = 0, ii = values.length; ii > i; i++) locals[valueName] = values[i], 
                            toDisplay[i] = displayFn(scope, locals);
                            return toDisplay;
                        }
                    }, render), multiple && scope.$watchCollection(function() {
                        return ctrl.$modelValue;
                    }, render);
                }
                if (ctrls[1]) {
                    for (var emptyOption, selectCtrl = ctrls[0], ngModelCtrl = ctrls[1], multiple = attr.multiple, optionsExp = attr.ngOptions, nullOption = !1, optionTemplate = jqLite(document.createElement("option")), optGroupTemplate = jqLite(document.createElement("optgroup")), unknownOption = optionTemplate.clone(), i = 0, children = element.children(), ii = children.length; ii > i; i++) if ("" === children[i].value) {
                        emptyOption = nullOption = children.eq(i);
                        break;
                    }
                    selectCtrl.init(ngModelCtrl, nullOption, unknownOption), multiple && (ngModelCtrl.$isEmpty = function(value) {
                        return !value || 0 === value.length;
                    }), optionsExp ? setupAsOptions(scope, element, ngModelCtrl) : multiple ? setupAsMultiple(scope, element, ngModelCtrl) : setupAsSingle(scope, element, ngModelCtrl, selectCtrl);
                }
            }
        };
    } ], optionDirective = [ "$interpolate", function($interpolate) {
        var nullSelectCtrl = {
            addOption: noop,
            removeOption: noop
        };
        return {
            restrict: "E",
            priority: 100,
            compile: function(element, attr) {
                if (isUndefined(attr.value)) {
                    var interpolateFn = $interpolate(element.text(), !0);
                    interpolateFn || attr.$set("value", element.text());
                }
                return function(scope, element, attr) {
                    var selectCtrlName = "$selectController", parent = element.parent(), selectCtrl = parent.data(selectCtrlName) || parent.parent().data(selectCtrlName);
                    selectCtrl && selectCtrl.databound ? element.prop("selected", !1) : selectCtrl = nullSelectCtrl, 
                    interpolateFn ? scope.$watch(interpolateFn, function(newVal, oldVal) {
                        attr.$set("value", newVal), newVal !== oldVal && selectCtrl.removeOption(oldVal), 
                        selectCtrl.addOption(newVal);
                    }) : selectCtrl.addOption(attr.value), element.on("$destroy", function() {
                        selectCtrl.removeOption(attr.value);
                    });
                };
            }
        };
    } ], styleDirective = valueFn({
        restrict: "E",
        terminal: !0
    });
    return window.angular.bootstrap ? void console.log("WARNING: Tried to load angular more than once.") : (bindJQuery(), 
    publishExternalAPI(angular), void jqLite(document).ready(function() {
        angularInit(document, bootstrap);
    }));
}(window, document), !window.angular.$$csp() && window.angular.element(document).find("head").prepend('<style type="text/css">@charset "UTF-8";[ng\\:cloak],[ng-cloak],[data-ng-cloak],[x-ng-cloak],.ng-cloak,.x-ng-cloak,.ng-hide{display:none !important;}ng\\:form{display:block;}.ng-animate-block-transitions{transition:0s all!important;-webkit-transition:0s all!important;}.ng-hide-add-active,.ng-hide-remove{display:block!important;}</style>'), 
/**
 * State-based routing for AngularJS
 * @version v0.2.11
 * @link http://angular-ui.github.com/
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */
"undefined" != typeof module && "undefined" != typeof exports && module.exports === exports && (module.exports = "ui.router"), 
function(window, angular, undefined) {
    "use strict";
    function inherit(parent, extra) {
        return extend(new (extend(function() {}, {
            prototype: parent
        }))(), extra);
    }
    function merge(dst) {
        return forEach(arguments, function(obj) {
            obj !== dst && forEach(obj, function(value, key) {
                dst.hasOwnProperty(key) || (dst[key] = value);
            });
        }), dst;
    }
    function ancestors(first, second) {
        var path = [];
        for (var n in first.path) {
            if (first.path[n] !== second.path[n]) break;
            path.push(first.path[n]);
        }
        return path;
    }
    function objectKeys(object) {
        if (Object.keys) return Object.keys(object);
        var result = [];
        return angular.forEach(object, function(val, key) {
            result.push(key);
        }), result;
    }
    function arraySearch(array, value) {
        if (Array.prototype.indexOf) return array.indexOf(value, Number(arguments[2]) || 0);
        var len = array.length >>> 0, from = Number(arguments[2]) || 0;
        for (from = 0 > from ? Math.ceil(from) : Math.floor(from), 0 > from && (from += len); len > from; from++) if (from in array && array[from] === value) return from;
        return -1;
    }
    function inheritParams(currentParams, newParams, $current, $to) {
        var parentParams, parents = ancestors($current, $to), inherited = {}, inheritList = [];
        for (var i in parents) if (parents[i].params && (parentParams = objectKeys(parents[i].params), 
        parentParams.length)) for (var j in parentParams) arraySearch(inheritList, parentParams[j]) >= 0 || (inheritList.push(parentParams[j]), 
        inherited[parentParams[j]] = currentParams[parentParams[j]]);
        return extend({}, inherited, newParams);
    }
    function equalForKeys(a, b, keys) {
        if (!keys) {
            keys = [];
            for (var n in a) keys.push(n);
        }
        for (var i = 0; i < keys.length; i++) {
            var k = keys[i];
            if (a[k] != b[k]) return !1;
        }
        return !0;
    }
    function filterByKeys(keys, values) {
        var filtered = {};
        return forEach(keys, function(name) {
            filtered[name] = values[name];
        }), filtered;
    }
    function $Resolve($q, $injector) {
        var VISIT_IN_PROGRESS = 1, VISIT_DONE = 2, NOTHING = {}, NO_DEPENDENCIES = [], NO_LOCALS = NOTHING, NO_PARENT = extend($q.when(NOTHING), {
            $$promises: NOTHING,
            $$values: NOTHING
        });
        this.study = function(invocables) {
            function visit(value, key) {
                if (visited[key] !== VISIT_DONE) {
                    if (cycle.push(key), visited[key] === VISIT_IN_PROGRESS) throw cycle.splice(0, cycle.indexOf(key)), 
                    new Error("Cyclic dependency: " + cycle.join(" -> "));
                    if (visited[key] = VISIT_IN_PROGRESS, isString(value)) plan.push(key, [ function() {
                        return $injector.get(value);
                    } ], NO_DEPENDENCIES); else {
                        var params = $injector.annotate(value);
                        forEach(params, function(param) {
                            param !== key && invocables.hasOwnProperty(param) && visit(invocables[param], param);
                        }), plan.push(key, value, params);
                    }
                    cycle.pop(), visited[key] = VISIT_DONE;
                }
            }
            function isResolve(value) {
                return isObject(value) && value.then && value.$$promises;
            }
            if (!isObject(invocables)) throw new Error("'invocables' must be an object");
            var plan = [], cycle = [], visited = {};
            return forEach(invocables, visit), invocables = cycle = visited = null, function(locals, parent, self) {
                function done() {
                    --wait || (merged || merge(values, parent.$$values), result.$$values = values, result.$$promises = !0, 
                    delete result.$$inheritedValues, resolution.resolve(values));
                }
                function fail(reason) {
                    result.$$failure = reason, resolution.reject(reason);
                }
                function invoke(key, invocable, params) {
                    function onfailure(reason) {
                        invocation.reject(reason), fail(reason);
                    }
                    function proceed() {
                        if (!isDefined(result.$$failure)) try {
                            invocation.resolve($injector.invoke(invocable, self, values)), invocation.promise.then(function(result) {
                                values[key] = result, done();
                            }, onfailure);
                        } catch (e) {
                            onfailure(e);
                        }
                    }
                    var invocation = $q.defer(), waitParams = 0;
                    forEach(params, function(dep) {
                        promises.hasOwnProperty(dep) && !locals.hasOwnProperty(dep) && (waitParams++, promises[dep].then(function(result) {
                            values[dep] = result, --waitParams || proceed();
                        }, onfailure));
                    }), waitParams || proceed(), promises[key] = invocation.promise;
                }
                if (isResolve(locals) && self === undefined && (self = parent, parent = locals, 
                locals = null), locals) {
                    if (!isObject(locals)) throw new Error("'locals' must be an object");
                } else locals = NO_LOCALS;
                if (parent) {
                    if (!isResolve(parent)) throw new Error("'parent' must be a promise returned by $resolve.resolve()");
                } else parent = NO_PARENT;
                var resolution = $q.defer(), result = resolution.promise, promises = result.$$promises = {}, values = extend({}, locals), wait = 1 + plan.length / 3, merged = !1;
                if (isDefined(parent.$$failure)) return fail(parent.$$failure), result;
                parent.$$inheritedValues && merge(values, parent.$$inheritedValues), parent.$$values ? (merged = merge(values, parent.$$values), 
                result.$$inheritedValues = parent.$$values, done()) : (parent.$$inheritedValues && (result.$$inheritedValues = parent.$$inheritedValues), 
                extend(promises, parent.$$promises), parent.then(done, fail));
                for (var i = 0, ii = plan.length; ii > i; i += 3) locals.hasOwnProperty(plan[i]) ? done() : invoke(plan[i], plan[i + 1], plan[i + 2]);
                return result;
            };
        }, this.resolve = function(invocables, locals, parent, self) {
            return this.study(invocables)(locals, parent, self);
        };
    }
    function $TemplateFactory($http, $templateCache, $injector) {
        this.fromConfig = function(config, params, locals) {
            return isDefined(config.template) ? this.fromString(config.template, params) : isDefined(config.templateUrl) ? this.fromUrl(config.templateUrl, params) : isDefined(config.templateProvider) ? this.fromProvider(config.templateProvider, params, locals) : null;
        }, this.fromString = function(template, params) {
            return isFunction(template) ? template(params) : template;
        }, this.fromUrl = function(url, params) {
            return isFunction(url) && (url = url(params)), null == url ? null : $http.get(url, {
                cache: $templateCache
            }).then(function(response) {
                return response.data;
            });
        }, this.fromProvider = function(provider, params, locals) {
            return $injector.invoke(provider, null, locals || {
                params: params
            });
        };
    }
    function UrlMatcher(pattern, config) {
        function $value(value) {
            return isDefined(value) ? this.type.decode(value) : $UrlMatcherFactory.$$getDefaultValue(this);
        }
        function addParameter(id, type, config) {
            if (!/^\w+(-+\w+)*$/.test(id)) throw new Error("Invalid parameter name '" + id + "' in pattern '" + pattern + "'");
            if (params[id]) throw new Error("Duplicate parameter name '" + id + "' in pattern '" + pattern + "'");
            params[id] = extend({
                type: type || new Type(),
                $value: $value
            }, config);
        }
        function quoteRegExp(string, pattern, isOptional) {
            var result = string.replace(/[\\\[\]\^$*+?.()|{}]/g, "\\$&");
            if (!pattern) return result;
            var flag = isOptional ? "?" : "";
            return result + flag + "(" + pattern + ")" + flag;
        }
        function paramConfig(param) {
            if (!config.params || !config.params[param]) return {};
            var cfg = config.params[param];
            return isObject(cfg) ? cfg : {
                value: cfg
            };
        }
        config = angular.isObject(config) ? config : {};
        var m, placeholder = /([:*])(\w+)|\{(\w+)(?:\:((?:[^{}\\]+|\\.|\{(?:[^{}\\]+|\\.)*\})+))?\}/g, compiled = "^", last = 0, segments = this.segments = [], params = this.params = {};
        this.source = pattern;
        for (var id, regexp, segment, type, cfg; (m = placeholder.exec(pattern)) && (id = m[2] || m[3], 
        regexp = m[4] || ("*" == m[1] ? ".*" : "[^/]*"), segment = pattern.substring(last, m.index), 
        type = this.$types[regexp] || new Type({
            pattern: new RegExp(regexp)
        }), cfg = paramConfig(id), !(segment.indexOf("?") >= 0)); ) compiled += quoteRegExp(segment, type.$subPattern(), isDefined(cfg.value)), 
        addParameter(id, type, cfg), segments.push(segment), last = placeholder.lastIndex;
        segment = pattern.substring(last);
        var i = segment.indexOf("?");
        if (i >= 0) {
            var search = this.sourceSearch = segment.substring(i);
            segment = segment.substring(0, i), this.sourcePath = pattern.substring(0, last + i), 
            forEach(search.substring(1).split(/[&?]/), function(key) {
                addParameter(key, null, paramConfig(key));
            });
        } else this.sourcePath = pattern, this.sourceSearch = "";
        compiled += quoteRegExp(segment) + (config.strict === !1 ? "/?" : "") + "$", segments.push(segment), 
        this.regexp = new RegExp(compiled, config.caseInsensitive ? "i" : undefined), this.prefix = segments[0];
    }
    function Type(config) {
        extend(this, config);
    }
    function $UrlMatcherFactory() {
        function getDefaultConfig() {
            return {
                strict: isStrictMode,
                caseInsensitive: isCaseInsensitive
            };
        }
        function isInjectable(value) {
            return isFunction(value) || isArray(value) && isFunction(value[value.length - 1]);
        }
        function flushTypeQueue() {
            forEach(typeQueue, function(type) {
                if (UrlMatcher.prototype.$types[type.name]) throw new Error("A type named '" + type.name + "' has already been defined.");
                var def = new Type(isInjectable(type.def) ? injector.invoke(type.def) : type.def);
                UrlMatcher.prototype.$types[type.name] = def;
            });
        }
        var injector, isCaseInsensitive = !1, isStrictMode = !0, enqueue = !0, typeQueue = [], defaultTypes = {
            "int": {
                decode: function(val) {
                    return parseInt(val, 10);
                },
                is: function(val) {
                    return isDefined(val) ? this.decode(val.toString()) === val : !1;
                },
                pattern: /\d+/
            },
            bool: {
                encode: function(val) {
                    return val ? 1 : 0;
                },
                decode: function(val) {
                    return 0 === parseInt(val, 10) ? !1 : !0;
                },
                is: function(val) {
                    return val === !0 || val === !1;
                },
                pattern: /0|1/
            },
            string: {
                pattern: /[^\/]*/
            },
            date: {
                equals: function(a, b) {
                    return a.toISOString() === b.toISOString();
                },
                decode: function(val) {
                    return new Date(val);
                },
                encode: function(val) {
                    return [ val.getFullYear(), ("0" + (val.getMonth() + 1)).slice(-2), ("0" + val.getDate()).slice(-2) ].join("-");
                },
                pattern: /[0-9]{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[1-2][0-9]|3[0-1])/
            }
        };
        $UrlMatcherFactory.$$getDefaultValue = function(config) {
            if (!isInjectable(config.value)) return config.value;
            if (!injector) throw new Error("Injectable functions cannot be called at configuration time");
            return injector.invoke(config.value);
        }, this.caseInsensitive = function(value) {
            isCaseInsensitive = value;
        }, this.strictMode = function(value) {
            isStrictMode = value;
        }, this.compile = function(pattern, config) {
            return new UrlMatcher(pattern, extend(getDefaultConfig(), config));
        }, this.isMatcher = function(o) {
            if (!isObject(o)) return !1;
            var result = !0;
            return forEach(UrlMatcher.prototype, function(val, name) {
                isFunction(val) && (result = result && isDefined(o[name]) && isFunction(o[name]));
            }), result;
        }, this.type = function(name, def) {
            return isDefined(def) ? (typeQueue.push({
                name: name,
                def: def
            }), enqueue || flushTypeQueue(), this) : UrlMatcher.prototype.$types[name];
        }, this.$get = [ "$injector", function($injector) {
            return injector = $injector, enqueue = !1, UrlMatcher.prototype.$types = {}, flushTypeQueue(), 
            forEach(defaultTypes, function(type, name) {
                UrlMatcher.prototype.$types[name] || (UrlMatcher.prototype.$types[name] = new Type(type));
            }), this;
        } ];
    }
    function $UrlRouterProvider($locationProvider, $urlMatcherFactory) {
        function regExpPrefix(re) {
            var prefix = /^\^((?:\\[^a-zA-Z0-9]|[^\\\[\]\^$*+?.()|{}]+)*)/.exec(re.source);
            return null != prefix ? prefix[1].replace(/\\(.)/g, "$1") : "";
        }
        function interpolate(pattern, match) {
            return pattern.replace(/\$(\$|\d{1,2})/, function(m, what) {
                return match["$" === what ? 0 : Number(what)];
            });
        }
        function handleIfMatch($injector, handler, match) {
            if (!match) return !1;
            var result = $injector.invoke(handler, handler, {
                $match: match
            });
            return isDefined(result) ? result : !0;
        }
        function $get($location, $rootScope, $injector, $browser) {
            function appendBasePath(url, isHtml5, absolute) {
                return "/" === baseHref ? url : isHtml5 ? baseHref.slice(0, -1) + url : absolute ? baseHref.slice(1) + url : url;
            }
            function update(evt) {
                function check(rule) {
                    var handled = rule($injector, $location);
                    return handled ? (isString(handled) && $location.replace().url(handled), !0) : !1;
                }
                if (!evt || !evt.defaultPrevented) {
                    var i, n = rules.length;
                    for (i = 0; n > i; i++) if (check(rules[i])) return;
                    otherwise && check(otherwise);
                }
            }
            function listen() {
                return listener = listener || $rootScope.$on("$locationChangeSuccess", update);
            }
            var baseHref = $browser.baseHref(), location = $location.url();
            return interceptDeferred || listen(), {
                sync: function() {
                    update();
                },
                listen: function() {
                    return listen();
                },
                update: function(read) {
                    return read ? void (location = $location.url()) : void ($location.url() !== location && ($location.url(location), 
                    $location.replace()));
                },
                push: function(urlMatcher, params, options) {
                    $location.url(urlMatcher.format(params || {})), options && options.replace && $location.replace();
                },
                href: function(urlMatcher, params, options) {
                    if (!urlMatcher.validates(params)) return null;
                    var isHtml5 = $locationProvider.html5Mode(), url = urlMatcher.format(params);
                    if (options = options || {}, isHtml5 || null === url || (url = "#" + $locationProvider.hashPrefix() + url), 
                    url = appendBasePath(url, isHtml5, options.absolute), !options.absolute || !url) return url;
                    var slash = !isHtml5 && url ? "/" : "", port = $location.port();
                    return port = 80 === port || 443 === port ? "" : ":" + port, [ $location.protocol(), "://", $location.host(), port, slash, url ].join("");
                }
            };
        }
        var listener, rules = [], otherwise = null, interceptDeferred = !1;
        this.rule = function(rule) {
            if (!isFunction(rule)) throw new Error("'rule' must be a function");
            return rules.push(rule), this;
        }, this.otherwise = function(rule) {
            if (isString(rule)) {
                var redirect = rule;
                rule = function() {
                    return redirect;
                };
            } else if (!isFunction(rule)) throw new Error("'rule' must be a function");
            return otherwise = rule, this;
        }, this.when = function(what, handler) {
            var redirect, handlerIsString = isString(handler);
            if (isString(what) && (what = $urlMatcherFactory.compile(what)), !handlerIsString && !isFunction(handler) && !isArray(handler)) throw new Error("invalid 'handler' in when()");
            var strategies = {
                matcher: function(what, handler) {
                    return handlerIsString && (redirect = $urlMatcherFactory.compile(handler), handler = [ "$match", function($match) {
                        return redirect.format($match);
                    } ]), extend(function($injector, $location) {
                        return handleIfMatch($injector, handler, what.exec($location.path(), $location.search()));
                    }, {
                        prefix: isString(what.prefix) ? what.prefix : ""
                    });
                },
                regex: function(what, handler) {
                    if (what.global || what.sticky) throw new Error("when() RegExp must not be global or sticky");
                    return handlerIsString && (redirect = handler, handler = [ "$match", function($match) {
                        return interpolate(redirect, $match);
                    } ]), extend(function($injector, $location) {
                        return handleIfMatch($injector, handler, what.exec($location.path()));
                    }, {
                        prefix: regExpPrefix(what)
                    });
                }
            }, check = {
                matcher: $urlMatcherFactory.isMatcher(what),
                regex: what instanceof RegExp
            };
            for (var n in check) if (check[n]) return this.rule(strategies[n](what, handler));
            throw new Error("invalid 'what' in when()");
        }, this.deferIntercept = function(defer) {
            defer === undefined && (defer = !0), interceptDeferred = defer;
        }, this.$get = $get, $get.$inject = [ "$location", "$rootScope", "$injector", "$browser" ];
    }
    function $StateProvider($urlRouterProvider, $urlMatcherFactory) {
        function isRelative(stateName) {
            return 0 === stateName.indexOf(".") || 0 === stateName.indexOf("^");
        }
        function findState(stateOrName, base) {
            if (!stateOrName) return undefined;
            var isStr = isString(stateOrName), name = isStr ? stateOrName : stateOrName.name, path = isRelative(name);
            if (path) {
                if (!base) throw new Error("No reference point given for path '" + name + "'");
                for (var rel = name.split("."), i = 0, pathLength = rel.length, current = base; pathLength > i; i++) if ("" !== rel[i] || 0 !== i) {
                    if ("^" !== rel[i]) break;
                    if (!current.parent) throw new Error("Path '" + name + "' not valid for state '" + base.name + "'");
                    current = current.parent;
                } else current = base;
                rel = rel.slice(i).join("."), name = current.name + (current.name && rel ? "." : "") + rel;
            }
            var state = states[name];
            return !state || !isStr && (isStr || state !== stateOrName && state.self !== stateOrName) ? undefined : state;
        }
        function queueState(parentName, state) {
            queue[parentName] || (queue[parentName] = []), queue[parentName].push(state);
        }
        function registerState(state) {
            state = inherit(state, {
                self: state,
                resolve: state.resolve || {},
                toString: function() {
                    return this.name;
                }
            });
            var name = state.name;
            if (!isString(name) || name.indexOf("@") >= 0) throw new Error("State must have a valid name");
            if (states.hasOwnProperty(name)) throw new Error("State '" + name + "'' is already defined");
            var parentName = -1 !== name.indexOf(".") ? name.substring(0, name.lastIndexOf(".")) : isString(state.parent) ? state.parent : "";
            if (parentName && !states[parentName]) return queueState(parentName, state.self);
            for (var key in stateBuilder) isFunction(stateBuilder[key]) && (state[key] = stateBuilder[key](state, stateBuilder.$delegates[key]));
            if (states[name] = state, !state[abstractKey] && state.url && $urlRouterProvider.when(state.url, [ "$match", "$stateParams", function($match, $stateParams) {
                $state.$current.navigable == state && equalForKeys($match, $stateParams) || $state.transitionTo(state, $match, {
                    location: !1
                });
            } ]), queue[name]) for (var i = 0; i < queue[name].length; i++) registerState(queue[name][i]);
            return state;
        }
        function isGlob(text) {
            return text.indexOf("*") > -1;
        }
        function doesStateMatchGlob(glob) {
            var globSegments = glob.split("."), segments = $state.$current.name.split(".");
            if ("**" === globSegments[0] && (segments = segments.slice(segments.indexOf(globSegments[1])), 
            segments.unshift("**")), "**" === globSegments[globSegments.length - 1] && (segments.splice(segments.indexOf(globSegments[globSegments.length - 2]) + 1, Number.MAX_VALUE), 
            segments.push("**")), globSegments.length != segments.length) return !1;
            for (var i = 0, l = globSegments.length; l > i; i++) "*" === globSegments[i] && (segments[i] = "*");
            return segments.join("") === globSegments.join("");
        }
        function decorator(name, func) {
            return isString(name) && !isDefined(func) ? stateBuilder[name] : isFunction(func) && isString(name) ? (stateBuilder[name] && !stateBuilder.$delegates[name] && (stateBuilder.$delegates[name] = stateBuilder[name]), 
            stateBuilder[name] = func, this) : this;
        }
        function state(name, definition) {
            return isObject(name) ? definition = name : definition.name = name, registerState(definition), 
            this;
        }
        function $get($rootScope, $q, $view, $injector, $resolve, $stateParams, $urlRouter) {
            function handleRedirect(redirect, state, params, options) {
                var evt = $rootScope.$broadcast("$stateNotFound", redirect, state, params);
                if (evt.defaultPrevented) return $urlRouter.update(), TransitionAborted;
                if (!evt.retry) return null;
                if (options.$retry) return $urlRouter.update(), TransitionFailed;
                var retryTransition = $state.transition = $q.when(evt.retry);
                return retryTransition.then(function() {
                    return retryTransition !== $state.transition ? TransitionSuperseded : (redirect.options.$retry = !0, 
                    $state.transitionTo(redirect.to, redirect.toParams, redirect.options));
                }, function() {
                    return TransitionAborted;
                }), $urlRouter.update(), retryTransition;
            }
            function resolveState(state, params, paramsAreFiltered, inherited, dst) {
                var $stateParams = paramsAreFiltered ? params : filterByKeys(objectKeys(state.params), params), locals = {
                    $stateParams: $stateParams
                };
                dst.resolve = $resolve.resolve(state.resolve, locals, dst.resolve, state);
                var promises = [ dst.resolve.then(function(globals) {
                    dst.globals = globals;
                }) ];
                return inherited && promises.push(inherited), forEach(state.views, function(view, name) {
                    var injectables = view.resolve && view.resolve !== state.resolve ? view.resolve : {};
                    injectables.$template = [ function() {
                        return $view.load(name, {
                            view: view,
                            locals: locals,
                            params: $stateParams
                        }) || "";
                    } ], promises.push($resolve.resolve(injectables, locals, dst.resolve, state).then(function(result) {
                        if (isFunction(view.controllerProvider) || isArray(view.controllerProvider)) {
                            var injectLocals = angular.extend({}, injectables, locals);
                            result.$$controller = $injector.invoke(view.controllerProvider, null, injectLocals);
                        } else result.$$controller = view.controller;
                        result.$$state = state, result.$$controllerAs = view.controllerAs, dst[name] = result;
                    }));
                }), $q.all(promises).then(function(values) {
                    return dst;
                });
            }
            var TransitionSuperseded = $q.reject(new Error("transition superseded")), TransitionPrevented = $q.reject(new Error("transition prevented")), TransitionAborted = $q.reject(new Error("transition aborted")), TransitionFailed = $q.reject(new Error("transition failed"));
            return root.locals = {
                resolve: null,
                globals: {
                    $stateParams: {}
                }
            }, $state = {
                params: {},
                current: root.self,
                $current: root,
                transition: null
            }, $state.reload = function() {
                $state.transitionTo($state.current, $stateParams, {
                    reload: !0,
                    inherit: !1,
                    notify: !1
                });
            }, $state.go = function(to, params, options) {
                return $state.transitionTo(to, params, extend({
                    inherit: !0,
                    relative: $state.$current
                }, options));
            }, $state.transitionTo = function(to, toParams, options) {
                toParams = toParams || {}, options = extend({
                    location: !0,
                    inherit: !1,
                    relative: null,
                    notify: !0,
                    reload: !1,
                    $retry: !1
                }, options || {});
                var evt, from = $state.$current, fromParams = $state.params, fromPath = from.path, toState = findState(to, options.relative);
                if (!isDefined(toState)) {
                    var redirect = {
                        to: to,
                        toParams: toParams,
                        options: options
                    }, redirectResult = handleRedirect(redirect, from.self, fromParams, options);
                    if (redirectResult) return redirectResult;
                    if (to = redirect.to, toParams = redirect.toParams, options = redirect.options, 
                    toState = findState(to, options.relative), !isDefined(toState)) {
                        if (!options.relative) throw new Error("No such state '" + to + "'");
                        throw new Error("Could not resolve '" + to + "' from state '" + options.relative + "'");
                    }
                }
                if (toState[abstractKey]) throw new Error("Cannot transition to abstract state '" + to + "'");
                options.inherit && (toParams = inheritParams($stateParams, toParams || {}, $state.$current, toState)), 
                to = toState;
                var toPath = to.path, keep = 0, state = toPath[keep], locals = root.locals, toLocals = [];
                if (!options.reload) for (;state && state === fromPath[keep] && equalForKeys(toParams, fromParams, state.ownParams); ) locals = toLocals[keep] = state.locals, 
                keep++, state = toPath[keep];
                if (shouldTriggerReload(to, from, locals, options)) return to.self.reloadOnSearch !== !1 && $urlRouter.update(), 
                $state.transition = null, $q.when($state.current);
                if (toParams = filterByKeys(objectKeys(to.params), toParams || {}), options.notify && $rootScope.$broadcast("$stateChangeStart", to.self, toParams, from.self, fromParams).defaultPrevented) return $urlRouter.update(), 
                TransitionPrevented;
                for (var resolved = $q.when(locals), l = keep; l < toPath.length; l++, state = toPath[l]) locals = toLocals[l] = inherit(locals), 
                resolved = resolveState(state, toParams, state === to, resolved, locals);
                var transition = $state.transition = resolved.then(function() {
                    var l, entering, exiting;
                    if ($state.transition !== transition) return TransitionSuperseded;
                    for (l = fromPath.length - 1; l >= keep; l--) exiting = fromPath[l], exiting.self.onExit && $injector.invoke(exiting.self.onExit, exiting.self, exiting.locals.globals), 
                    exiting.locals = null;
                    for (l = keep; l < toPath.length; l++) entering = toPath[l], entering.locals = toLocals[l], 
                    entering.self.onEnter && $injector.invoke(entering.self.onEnter, entering.self, entering.locals.globals);
                    return $state.transition !== transition ? TransitionSuperseded : ($state.$current = to, 
                    $state.current = to.self, $state.params = toParams, copy($state.params, $stateParams), 
                    $state.transition = null, options.location && to.navigable && $urlRouter.push(to.navigable.url, to.navigable.locals.globals.$stateParams, {
                        replace: "replace" === options.location
                    }), options.notify && $rootScope.$broadcast("$stateChangeSuccess", to.self, toParams, from.self, fromParams), 
                    $urlRouter.update(!0), $state.current);
                }, function(error) {
                    return $state.transition !== transition ? TransitionSuperseded : ($state.transition = null, 
                    evt = $rootScope.$broadcast("$stateChangeError", to.self, toParams, from.self, fromParams, error), 
                    evt.defaultPrevented || $urlRouter.update(), $q.reject(error));
                });
                return transition;
            }, $state.is = function(stateOrName, params) {
                var state = findState(stateOrName);
                return isDefined(state) ? $state.$current !== state ? !1 : isDefined(params) && null !== params ? angular.equals($stateParams, params) : !0 : undefined;
            }, $state.includes = function(stateOrName, params) {
                if (isString(stateOrName) && isGlob(stateOrName)) {
                    if (!doesStateMatchGlob(stateOrName)) return !1;
                    stateOrName = $state.$current.name;
                }
                var state = findState(stateOrName);
                return isDefined(state) ? isDefined($state.$current.includes[state.name]) ? equalForKeys(params, $stateParams) : !1 : undefined;
            }, $state.href = function(stateOrName, params, options) {
                options = extend({
                    lossy: !0,
                    inherit: !0,
                    absolute: !1,
                    relative: $state.$current
                }, options || {});
                var state = findState(stateOrName, options.relative);
                if (!isDefined(state)) return null;
                options.inherit && (params = inheritParams($stateParams, params || {}, $state.$current, state));
                var nav = state && options.lossy ? state.navigable : state;
                return nav && nav.url ? $urlRouter.href(nav.url, filterByKeys(objectKeys(state.params), params || {}), {
                    absolute: options.absolute
                }) : null;
            }, $state.get = function(stateOrName, context) {
                if (0 === arguments.length) return objectKeys(states).map(function(name) {
                    return states[name].self;
                });
                var state = findState(stateOrName, context);
                return state && state.self ? state.self : null;
            }, $state;
        }
        function shouldTriggerReload(to, from, locals, options) {
            return to !== from || (locals !== from.locals || options.reload) && to.self.reloadOnSearch !== !1 ? void 0 : !0;
        }
        var root, $state, states = {}, queue = {}, abstractKey = "abstract", stateBuilder = {
            parent: function(state) {
                if (isDefined(state.parent) && state.parent) return findState(state.parent);
                var compositeName = /^(.+)\.[^.]+$/.exec(state.name);
                return compositeName ? findState(compositeName[1]) : root;
            },
            data: function(state) {
                return state.parent && state.parent.data && (state.data = state.self.data = extend({}, state.parent.data, state.data)), 
                state.data;
            },
            url: function(state) {
                var url = state.url, config = {
                    params: state.params || {}
                };
                if (isString(url)) return "^" == url.charAt(0) ? $urlMatcherFactory.compile(url.substring(1), config) : (state.parent.navigable || root).url.concat(url, config);
                if (!url || $urlMatcherFactory.isMatcher(url)) return url;
                throw new Error("Invalid url '" + url + "' in state '" + state + "'");
            },
            navigable: function(state) {
                return state.url ? state : state.parent ? state.parent.navigable : null;
            },
            params: function(state) {
                return state.params ? state.params : state.url ? state.url.params : state.parent.params;
            },
            views: function(state) {
                var views = {};
                return forEach(isDefined(state.views) ? state.views : {
                    "": state
                }, function(view, name) {
                    name.indexOf("@") < 0 && (name += "@" + state.parent.name), views[name] = view;
                }), views;
            },
            ownParams: function(state) {
                if (state.params = state.params || {}, !state.parent) return objectKeys(state.params);
                var paramNames = {};
                forEach(state.params, function(v, k) {
                    paramNames[k] = !0;
                }), forEach(state.parent.params, function(v, k) {
                    if (!paramNames[k]) throw new Error("Missing required parameter '" + k + "' in state '" + state.name + "'");
                    paramNames[k] = !1;
                });
                var ownParams = [];
                return forEach(paramNames, function(own, p) {
                    own && ownParams.push(p);
                }), ownParams;
            },
            path: function(state) {
                return state.parent ? state.parent.path.concat(state) : [];
            },
            includes: function(state) {
                var includes = state.parent ? extend({}, state.parent.includes) : {};
                return includes[state.name] = !0, includes;
            },
            $delegates: {}
        };
        root = registerState({
            name: "",
            url: "^",
            views: null,
            "abstract": !0
        }), root.navigable = null, this.decorator = decorator, this.state = state, this.$get = $get, 
        $get.$inject = [ "$rootScope", "$q", "$view", "$injector", "$resolve", "$stateParams", "$urlRouter" ];
    }
    function $ViewProvider() {
        function $get($rootScope, $templateFactory) {
            return {
                load: function(name, options) {
                    var result, defaults = {
                        template: null,
                        controller: null,
                        view: null,
                        locals: null,
                        notify: !0,
                        async: !0,
                        params: {}
                    };
                    return options = extend(defaults, options), options.view && (result = $templateFactory.fromConfig(options.view, options.params, options.locals)), 
                    result && options.notify && $rootScope.$broadcast("$viewContentLoading", options), 
                    result;
                }
            };
        }
        this.$get = $get, $get.$inject = [ "$rootScope", "$templateFactory" ];
    }
    function $ViewScrollProvider() {
        var useAnchorScroll = !1;
        this.useAnchorScroll = function() {
            useAnchorScroll = !0;
        }, this.$get = [ "$anchorScroll", "$timeout", function($anchorScroll, $timeout) {
            return useAnchorScroll ? $anchorScroll : function($element) {
                $timeout(function() {
                    $element[0].scrollIntoView();
                }, 0, !1);
            };
        } ];
    }
    function $ViewDirective($state, $injector, $uiViewScroll) {
        function getService() {
            return $injector.has ? function(service) {
                return $injector.has(service) ? $injector.get(service) : null;
            } : function(service) {
                try {
                    return $injector.get(service);
                } catch (e) {
                    return null;
                }
            };
        }
        function getRenderer(attrs, scope) {
            var statics = function() {
                return {
                    enter: function(element, target, cb) {
                        target.after(element), cb();
                    },
                    leave: function(element, cb) {
                        element.remove(), cb();
                    }
                };
            };
            if ($animate) return {
                enter: function(element, target, cb) {
                    $animate.enter(element, null, target, cb);
                },
                leave: function(element, cb) {
                    $animate.leave(element, cb);
                }
            };
            if ($animator) {
                var animate = $animator && $animator(scope, attrs);
                return {
                    enter: function(element, target, cb) {
                        animate.enter(element, null, target), cb();
                    },
                    leave: function(element, cb) {
                        animate.leave(element), cb();
                    }
                };
            }
            return statics();
        }
        var service = getService(), $animator = service("$animator"), $animate = service("$animate"), directive = {
            restrict: "ECA",
            terminal: !0,
            priority: 400,
            transclude: "element",
            compile: function(tElement, tAttrs, $transclude) {
                return function(scope, $element, attrs) {
                    function cleanupLastView() {
                        previousEl && (previousEl.remove(), previousEl = null), currentScope && (currentScope.$destroy(), 
                        currentScope = null), currentEl && (renderer.leave(currentEl, function() {
                            previousEl = null;
                        }), previousEl = currentEl, currentEl = null);
                    }
                    function updateView(firstTime) {
                        var newScope, name = getUiViewName(attrs, $element.inheritedData("$uiView")), previousLocals = name && $state.$current && $state.$current.locals[name];
                        if (firstTime || previousLocals !== latestLocals) {
                            newScope = scope.$new(), latestLocals = $state.$current.locals[name];
                            var clone = $transclude(newScope, function(clone) {
                                renderer.enter(clone, $element, function() {
                                    (angular.isDefined(autoScrollExp) && !autoScrollExp || scope.$eval(autoScrollExp)) && $uiViewScroll(clone);
                                }), cleanupLastView();
                            });
                            currentEl = clone, currentScope = newScope, currentScope.$emit("$viewContentLoaded"), 
                            currentScope.$eval(onloadExp);
                        }
                    }
                    var previousEl, currentEl, currentScope, latestLocals, onloadExp = attrs.onload || "", autoScrollExp = attrs.autoscroll, renderer = getRenderer(attrs, scope);
                    scope.$on("$stateChangeSuccess", function() {
                        updateView(!1);
                    }), scope.$on("$viewContentLoading", function() {
                        updateView(!1);
                    }), updateView(!0);
                };
            }
        };
        return directive;
    }
    function $ViewDirectiveFill($compile, $controller, $state) {
        return {
            restrict: "ECA",
            priority: -400,
            compile: function(tElement) {
                var initial = tElement.html();
                return function(scope, $element, attrs) {
                    var current = $state.$current, name = getUiViewName(attrs, $element.inheritedData("$uiView")), locals = current && current.locals[name];
                    if (locals) {
                        $element.data("$uiView", {
                            name: name,
                            state: locals.$$state
                        }), $element.html(locals.$template ? locals.$template : initial);
                        var link = $compile($element.contents());
                        if (locals.$$controller) {
                            locals.$scope = scope;
                            var controller = $controller(locals.$$controller, locals);
                            locals.$$controllerAs && (scope[locals.$$controllerAs] = controller), $element.data("$ngControllerController", controller), 
                            $element.children().data("$ngControllerController", controller);
                        }
                        link(scope);
                    }
                };
            }
        };
    }
    function getUiViewName(attrs, inherited) {
        var name = attrs.uiView || attrs.name || "";
        return name.indexOf("@") >= 0 ? name : name + "@" + (inherited ? inherited.state.name : "");
    }
    function parseStateRef(ref, current) {
        var parsed, preparsed = ref.match(/^\s*({[^}]*})\s*$/);
        if (preparsed && (ref = current + "(" + preparsed[1] + ")"), parsed = ref.replace(/\n/g, " ").match(/^([^(]+?)\s*(\((.*)\))?$/), 
        !parsed || 4 !== parsed.length) throw new Error("Invalid state ref '" + ref + "'");
        return {
            state: parsed[1],
            paramExpr: parsed[3] || null
        };
    }
    function stateContext(el) {
        var stateData = el.parent().inheritedData("$uiView");
        return stateData && stateData.state && stateData.state.name ? stateData.state : void 0;
    }
    function $StateRefDirective($state, $timeout) {
        var allowedOptions = [ "location", "inherit", "reload" ];
        return {
            restrict: "A",
            require: [ "?^uiSrefActive", "?^uiSrefActiveEq" ],
            link: function(scope, element, attrs, uiSrefActive) {
                var ref = parseStateRef(attrs.uiSref, $state.current.name), params = null, base = stateContext(element) || $state.$current, isForm = "FORM" === element[0].nodeName, attr = isForm ? "action" : "href", nav = !0, options = {
                    relative: base,
                    inherit: !0
                }, optionsOverride = scope.$eval(attrs.uiSrefOpts) || {};
                angular.forEach(allowedOptions, function(option) {
                    option in optionsOverride && (options[option] = optionsOverride[option]);
                });
                var update = function(newVal) {
                    if (newVal && (params = newVal), nav) {
                        var newHref = $state.href(ref.state, params, options), activeDirective = uiSrefActive[1] || uiSrefActive[0];
                        return activeDirective && activeDirective.$$setStateInfo(ref.state, params), null === newHref ? (nav = !1, 
                        !1) : void (element[0][attr] = newHref);
                    }
                };
                ref.paramExpr && (scope.$watch(ref.paramExpr, function(newVal, oldVal) {
                    newVal !== params && update(newVal);
                }, !0), params = scope.$eval(ref.paramExpr)), update(), isForm || element.bind("click", function(e) {
                    var button = e.which || e.button;
                    if (!(button > 1 || e.ctrlKey || e.metaKey || e.shiftKey || element.attr("target"))) {
                        var transition = $timeout(function() {
                            $state.go(ref.state, params, options);
                        });
                        e.preventDefault(), e.preventDefault = function() {
                            $timeout.cancel(transition);
                        };
                    }
                });
            }
        };
    }
    function $StateRefActiveDirective($state, $stateParams, $interpolate) {
        return {
            restrict: "A",
            controller: [ "$scope", "$element", "$attrs", function($scope, $element, $attrs) {
                function update() {
                    isMatch() ? $element.addClass(activeClass) : $element.removeClass(activeClass);
                }
                function isMatch() {
                    return "undefined" != typeof $attrs.uiSrefActiveEq ? $state.$current.self === state && matchesParams() : $state.includes(state.name) && matchesParams();
                }
                function matchesParams() {
                    return !params || equalForKeys(params, $stateParams);
                }
                var state, params, activeClass;
                activeClass = $interpolate($attrs.uiSrefActiveEq || $attrs.uiSrefActive || "", !1)($scope), 
                this.$$setStateInfo = function(newState, newParams) {
                    state = $state.get(newState, stateContext($element)), params = newParams, update();
                }, $scope.$on("$stateChangeSuccess", update);
            } ]
        };
    }
    function $IsStateFilter($state) {
        return function(state) {
            return $state.is(state);
        };
    }
    function $IncludedByStateFilter($state) {
        return function(state) {
            return $state.includes(state);
        };
    }
    var isDefined = angular.isDefined, isFunction = angular.isFunction, isString = angular.isString, isObject = angular.isObject, isArray = angular.isArray, forEach = angular.forEach, extend = angular.extend, copy = angular.copy;
    angular.module("ui.router.util", [ "ng" ]), angular.module("ui.router.router", [ "ui.router.util" ]), 
    angular.module("ui.router.state", [ "ui.router.router", "ui.router.util" ]), angular.module("ui.router", [ "ui.router.state" ]), 
    angular.module("ui.router.compat", [ "ui.router" ]), $Resolve.$inject = [ "$q", "$injector" ], 
    angular.module("ui.router.util").service("$resolve", $Resolve), $TemplateFactory.$inject = [ "$http", "$templateCache", "$injector" ], 
    angular.module("ui.router.util").service("$templateFactory", $TemplateFactory), 
    UrlMatcher.prototype.concat = function(pattern, config) {
        return new UrlMatcher(this.sourcePath + pattern + this.sourceSearch, config);
    }, UrlMatcher.prototype.toString = function() {
        return this.source;
    }, UrlMatcher.prototype.exec = function(path, searchParams) {
        var m = this.regexp.exec(path);
        if (!m) return null;
        searchParams = searchParams || {};
        var i, cfg, param, params = this.parameters(), nTotal = params.length, nPath = this.segments.length - 1, values = {};
        if (nPath !== m.length - 1) throw new Error("Unbalanced capture group in route '" + this.source + "'");
        for (i = 0; nPath > i; i++) param = params[i], cfg = this.params[param], values[param] = cfg.$value(m[i + 1]);
        for (;nTotal > i; i++) param = params[i], cfg = this.params[param], values[param] = cfg.$value(searchParams[param]);
        return values;
    }, UrlMatcher.prototype.parameters = function(param) {
        return isDefined(param) ? this.params[param] || null : objectKeys(this.params);
    }, UrlMatcher.prototype.validates = function(params) {
        var isOptional, cfg, result = !0, self = this;
        return forEach(params, function(val, key) {
            self.params[key] && (cfg = self.params[key], isOptional = !val && isDefined(cfg.value), 
            result = result && (isOptional || cfg.type.is(val)));
        }), result;
    }, UrlMatcher.prototype.format = function(values) {
        var segments = this.segments, params = this.parameters();
        if (!values) return segments.join("").replace("//", "/");
        var i, search, value, param, cfg, array, nPath = segments.length - 1, nTotal = params.length, result = segments[0];
        if (!this.validates(values)) return null;
        for (i = 0; nPath > i; i++) param = params[i], value = values[param], cfg = this.params[param], 
        (isDefined(value) || "/" !== segments[i] && "/" !== segments[i + 1]) && (null != value && (result += encodeURIComponent(cfg.type.encode(value))), 
        result += segments[i + 1]);
        for (;nTotal > i; i++) param = params[i], value = values[param], null != value && (array = isArray(value), 
        array && (value = value.map(encodeURIComponent).join("&" + param + "=")), result += (search ? "&" : "?") + param + "=" + (array ? value : encodeURIComponent(value)), 
        search = !0);
        return result;
    }, UrlMatcher.prototype.$types = {}, Type.prototype.is = function(val, key) {
        return !0;
    }, Type.prototype.encode = function(val, key) {
        return val;
    }, Type.prototype.decode = function(val, key) {
        return val;
    }, Type.prototype.equals = function(a, b) {
        return a == b;
    }, Type.prototype.$subPattern = function() {
        var sub = this.pattern.toString();
        return sub.substr(1, sub.length - 2);
    }, Type.prototype.pattern = /.*/, angular.module("ui.router.util").provider("$urlMatcherFactory", $UrlMatcherFactory), 
    $UrlRouterProvider.$inject = [ "$locationProvider", "$urlMatcherFactoryProvider" ], 
    angular.module("ui.router.router").provider("$urlRouter", $UrlRouterProvider), $StateProvider.$inject = [ "$urlRouterProvider", "$urlMatcherFactoryProvider" ], 
    angular.module("ui.router.state").value("$stateParams", {}).provider("$state", $StateProvider), 
    $ViewProvider.$inject = [], angular.module("ui.router.state").provider("$view", $ViewProvider), 
    angular.module("ui.router.state").provider("$uiViewScroll", $ViewScrollProvider), 
    $ViewDirective.$inject = [ "$state", "$injector", "$uiViewScroll" ], $ViewDirectiveFill.$inject = [ "$compile", "$controller", "$state" ], 
    angular.module("ui.router.state").directive("uiView", $ViewDirective), angular.module("ui.router.state").directive("uiView", $ViewDirectiveFill), 
    $StateRefDirective.$inject = [ "$state", "$timeout" ], $StateRefActiveDirective.$inject = [ "$state", "$stateParams", "$interpolate" ], 
    angular.module("ui.router.state").directive("uiSref", $StateRefDirective).directive("uiSrefActive", $StateRefActiveDirective).directive("uiSrefActiveEq", $StateRefActiveDirective), 
    $IsStateFilter.$inject = [ "$state" ], $IncludedByStateFilter.$inject = [ "$state" ], 
    angular.module("ui.router.state").filter("isState", $IsStateFilter).filter("includedByState", $IncludedByStateFilter);
}(window, window.angular), /**
 * @license AngularJS v1.3.13
 * (c) 2010-2014 Google, Inc. http://angularjs.org
 * License: MIT
 */
function(window, angular, undefined) {
    "use strict";
    function isValidDottedPath(path) {
        return null != path && "" !== path && "hasOwnProperty" !== path && MEMBER_NAME_REGEX.test("." + path);
    }
    function lookupDottedPath(obj, path) {
        if (!isValidDottedPath(path)) throw $resourceMinErr("badmember", 'Dotted member path "@{0}" is invalid.', path);
        for (var keys = path.split("."), i = 0, ii = keys.length; ii > i && obj !== undefined; i++) {
            var key = keys[i];
            obj = null !== obj ? obj[key] : undefined;
        }
        return obj;
    }
    function shallowClearAndCopy(src, dst) {
        dst = dst || {}, angular.forEach(dst, function(value, key) {
            delete dst[key];
        });
        for (var key in src) !src.hasOwnProperty(key) || "$" === key.charAt(0) && "$" === key.charAt(1) || (dst[key] = src[key]);
        return dst;
    }
    var $resourceMinErr = angular.$$minErr("$resource"), MEMBER_NAME_REGEX = /^(\.[a-zA-Z_$][0-9a-zA-Z_$]*)+$/;
    angular.module("ngResource", [ "ng" ]).provider("$resource", function() {
        var provider = this;
        this.defaults = {
            stripTrailingSlashes: !0,
            actions: {
                get: {
                    method: "GET"
                },
                save: {
                    method: "POST"
                },
                query: {
                    method: "GET",
                    isArray: !0
                },
                remove: {
                    method: "DELETE"
                },
                "delete": {
                    method: "DELETE"
                }
            }
        }, this.$get = [ "$http", "$q", function($http, $q) {
            function encodeUriSegment(val) {
                return encodeUriQuery(val, !0).replace(/%26/gi, "&").replace(/%3D/gi, "=").replace(/%2B/gi, "+");
            }
            function encodeUriQuery(val, pctEncodeSpaces) {
                return encodeURIComponent(val).replace(/%40/gi, "@").replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, pctEncodeSpaces ? "%20" : "+");
            }
            function Route(template, defaults) {
                this.template = template, this.defaults = extend({}, provider.defaults, defaults), 
                this.urlParams = {};
            }
            function resourceFactory(url, paramDefaults, actions, options) {
                function extractParams(data, actionParams) {
                    var ids = {};
                    return actionParams = extend({}, paramDefaults, actionParams), forEach(actionParams, function(value, key) {
                        isFunction(value) && (value = value()), ids[key] = value && value.charAt && "@" == value.charAt(0) ? lookupDottedPath(data, value.substr(1)) : value;
                    }), ids;
                }
                function defaultResponseInterceptor(response) {
                    return response.resource;
                }
                function Resource(value) {
                    shallowClearAndCopy(value || {}, this);
                }
                var route = new Route(url, options);
                return actions = extend({}, provider.defaults.actions, actions), Resource.prototype.toJSON = function() {
                    var data = extend({}, this);
                    return delete data.$promise, delete data.$resolved, data;
                }, forEach(actions, function(action, name) {
                    var hasBody = /^(POST|PUT|PATCH)$/i.test(action.method);
                    Resource[name] = function(a1, a2, a3, a4) {
                        var data, success, error, params = {};
                        switch (arguments.length) {
                          case 4:
                            error = a4, success = a3;

                          case 3:
                          case 2:
                            if (!isFunction(a2)) {
                                params = a1, data = a2, success = a3;
                                break;
                            }
                            if (isFunction(a1)) {
                                success = a1, error = a2;
                                break;
                            }
                            success = a2, error = a3;

                          case 1:
                            isFunction(a1) ? success = a1 : hasBody ? data = a1 : params = a1;
                            break;

                          case 0:
                            break;

                          default:
                            throw $resourceMinErr("badargs", "Expected up to 4 arguments [params, data, success, error], got {0} arguments", arguments.length);
                        }
                        var isInstanceCall = this instanceof Resource, value = isInstanceCall ? data : action.isArray ? [] : new Resource(data), httpConfig = {}, responseInterceptor = action.interceptor && action.interceptor.response || defaultResponseInterceptor, responseErrorInterceptor = action.interceptor && action.interceptor.responseError || undefined;
                        forEach(action, function(value, key) {
                            "params" != key && "isArray" != key && "interceptor" != key && (httpConfig[key] = copy(value));
                        }), hasBody && (httpConfig.data = data), route.setUrlParams(httpConfig, extend({}, extractParams(data, action.params || {}), params), action.url);
                        var promise = $http(httpConfig).then(function(response) {
                            var data = response.data, promise = value.$promise;
                            if (data) {
                                if (angular.isArray(data) !== !!action.isArray) throw $resourceMinErr("badcfg", "Error in resource configuration for action `{0}`. Expected response to contain an {1} but got an {2}", name, action.isArray ? "array" : "object", angular.isArray(data) ? "array" : "object");
                                action.isArray ? (value.length = 0, forEach(data, function(item) {
                                    "object" == typeof item ? value.push(new Resource(item)) : value.push(item);
                                })) : (shallowClearAndCopy(data, value), value.$promise = promise);
                            }
                            return value.$resolved = !0, response.resource = value, response;
                        }, function(response) {
                            return value.$resolved = !0, (error || noop)(response), $q.reject(response);
                        });
                        return promise = promise.then(function(response) {
                            var value = responseInterceptor(response);
                            return (success || noop)(value, response.headers), value;
                        }, responseErrorInterceptor), isInstanceCall ? promise : (value.$promise = promise, 
                        value.$resolved = !1, value);
                    }, Resource.prototype["$" + name] = function(params, success, error) {
                        isFunction(params) && (error = success, success = params, params = {});
                        var result = Resource[name].call(this, params, this, success, error);
                        return result.$promise || result;
                    };
                }), Resource.bind = function(additionalParamDefaults) {
                    return resourceFactory(url, extend({}, paramDefaults, additionalParamDefaults), actions);
                }, Resource;
            }
            var noop = angular.noop, forEach = angular.forEach, extend = angular.extend, copy = angular.copy, isFunction = angular.isFunction;
            return Route.prototype = {
                setUrlParams: function(config, params, actionUrl) {
                    var val, encodedVal, self = this, url = actionUrl || self.template, urlParams = self.urlParams = {};
                    forEach(url.split(/\W/), function(param) {
                        if ("hasOwnProperty" === param) throw $resourceMinErr("badname", "hasOwnProperty is not a valid parameter name.");
                        !new RegExp("^\\d+$").test(param) && param && new RegExp("(^|[^\\\\]):" + param + "(\\W|$)").test(url) && (urlParams[param] = !0);
                    }), url = url.replace(/\\:/g, ":"), params = params || {}, forEach(self.urlParams, function(_, urlParam) {
                        val = params.hasOwnProperty(urlParam) ? params[urlParam] : self.defaults[urlParam], 
                        angular.isDefined(val) && null !== val ? (encodedVal = encodeUriSegment(val), url = url.replace(new RegExp(":" + urlParam + "(\\W|$)", "g"), function(match, p1) {
                            return encodedVal + p1;
                        })) : url = url.replace(new RegExp("(/?):" + urlParam + "(\\W|$)", "g"), function(match, leadingSlashes, tail) {
                            return "/" == tail.charAt(0) ? tail : leadingSlashes + tail;
                        });
                    }), self.defaults.stripTrailingSlashes && (url = url.replace(/\/+$/, "") || "/"), 
                    url = url.replace(/\/\.(?=\w+($|\?))/, "."), config.url = url.replace(/\/\\\./, "/."), 
                    forEach(params, function(value, key) {
                        self.urlParams[key] || (config.params = config.params || {}, config.params[key] = value);
                    });
                }
            }, resourceFactory;
        } ];
    });
}(window, window.angular), /*!
   --------------------------------
   Infinite Scroll
   --------------------------------
   + https://github.com/paulirish/infinite-scroll
   + version 2.1.0
   + Copyright 2011/12 Paul Irish & Luke Shumard
   + Licensed under the MIT license

   + Documentation: http://infinite-scroll.com/
*/
function(factory) {
    "function" == typeof define && define.amd ? define([ "jquery" ], factory) : factory(jQuery);
}(function($, undefined) {
    "use strict";
    $.infinitescroll = function(options, callback, element) {
        this.element = $(element), this._create(options, callback) || (this.failed = !0);
    }, $.infinitescroll.defaults = {
        loading: {
            finished: undefined,
            finishedMsg: "<em>Congratulations, you've reached the end of the internet.</em>",
            img: "data:image/gif;base64,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",
            msg: null,
            msgText: "<em>Loading the next set of posts...</em>",
            selector: null,
            speed: "fast",
            start: undefined
        },
        state: {
            isDuringAjax: !1,
            isInvalidPage: !1,
            isDestroyed: !1,
            isDone: !1,
            isPaused: !1,
            isBeyondMaxPage: !1,
            currPage: 1
        },
        debug: !1,
        behavior: undefined,
        binder: $(window),
        nextSelector: "div.navigation a:first",
        navSelector: "div.navigation",
        contentSelector: null,
        extraScrollPx: 150,
        itemSelector: "div.post",
        animate: !1,
        pathParse: undefined,
        dataType: "html",
        appendCallback: !0,
        bufferPx: 40,
        errorCallback: function() {},
        infid: 0,
        pixelsFromNavToBottom: undefined,
        path: undefined,
        prefill: !1,
        maxPage: undefined
    }, $.infinitescroll.prototype = {
        _binding: function(binding) {
            var instance = this, opts = instance.options;
            return opts.v = "2.0b2.120520", opts.behavior && this["_binding_" + opts.behavior] !== undefined ? void this["_binding_" + opts.behavior].call(this) : "bind" !== binding && "unbind" !== binding ? (this._debug("Binding value  " + binding + " not valid"), 
            !1) : ("unbind" === binding ? this.options.binder.unbind("smartscroll.infscr." + instance.options.infid) : this.options.binder[binding]("smartscroll.infscr." + instance.options.infid, function() {
                instance.scroll();
            }), void this._debug("Binding", binding));
        },
        _create: function(options, callback) {
            var opts = $.extend(!0, {}, $.infinitescroll.defaults, options);
            this.options = opts;
            var $window = $(window), instance = this;
            if (!instance._validate(options)) return !1;
            var path = $(opts.nextSelector).attr("href");
            if (!path) return this._debug("Navigation selector not found"), !1;
            opts.path = opts.path || this._determinepath(path), opts.contentSelector = opts.contentSelector || this.element, 
            opts.loading.selector = opts.loading.selector || opts.contentSelector, opts.loading.msg = opts.loading.msg || $('<div id="infscr-loading"><img alt="Loading..." src="' + opts.loading.img + '" /><div>' + opts.loading.msgText + "</div></div>"), 
            new Image().src = opts.loading.img, opts.pixelsFromNavToBottom === undefined && (opts.pixelsFromNavToBottom = $(document).height() - $(opts.navSelector).offset().top, 
            this._debug("pixelsFromNavToBottom: " + opts.pixelsFromNavToBottom));
            var self = this;
            return opts.loading.start = opts.loading.start || function() {
                $(opts.navSelector).hide(), opts.loading.msg.appendTo(opts.loading.selector).show(opts.loading.speed, $.proxy(function() {
                    this.beginAjax(opts);
                }, self));
            }, opts.loading.finished = opts.loading.finished || function() {
                opts.state.isBeyondMaxPage || opts.loading.msg.fadeOut(opts.loading.speed);
            }, opts.callback = function(instance, data, url) {
                opts.behavior && instance["_callback_" + opts.behavior] !== undefined && instance["_callback_" + opts.behavior].call($(opts.contentSelector)[0], data, url), 
                callback && callback.call($(opts.contentSelector)[0], data, opts, url), opts.prefill && $window.bind("resize.infinite-scroll", instance._prefill);
            }, options.debug && (!Function.prototype.bind || "object" != typeof console && "function" != typeof console || "object" != typeof console.log || [ "log", "info", "warn", "error", "assert", "dir", "clear", "profile", "profileEnd" ].forEach(function(method) {
                console[method] = this.call(console[method], console);
            }, Function.prototype.bind)), this._setup(), opts.prefill && this._prefill(), !0;
        },
        _prefill: function() {
            function needsPrefill() {
                return $(instance.options.contentSelector).height() <= $window.height();
            }
            var instance = this, $window = $(window);
            this._prefill = function() {
                needsPrefill() && instance.scroll(), $window.bind("resize.infinite-scroll", function() {
                    needsPrefill() && ($window.unbind("resize.infinite-scroll"), instance.scroll());
                });
            }, this._prefill();
        },
        _debug: function() {
            !0 === this.options.debug && ("undefined" != typeof console && "function" == typeof console.log ? 1 === Array.prototype.slice.call(arguments).length && "string" == typeof Array.prototype.slice.call(arguments)[0] ? console.log(Array.prototype.slice.call(arguments).toString()) : console.log(Array.prototype.slice.call(arguments)) : Function.prototype.bind || "undefined" == typeof console || "object" != typeof console.log || Function.prototype.call.call(console.log, console, Array.prototype.slice.call(arguments)));
        },
        _determinepath: function(path) {
            var opts = this.options;
            if (opts.behavior && this["_determinepath_" + opts.behavior] !== undefined) return this["_determinepath_" + opts.behavior].call(this, path);
            if (opts.pathParse) return this._debug("pathParse manual"), opts.pathParse(path, this.options.state.currPage + 1);
            if (path.match(/^(.*?)\b2\b(.*?$)/)) path = path.match(/^(.*?)\b2\b(.*?$)/).slice(1); else if (path.match(/^(.*?)2(.*?$)/)) {
                if (path.match(/^(.*?page=)2(\/.*|$)/)) return path = path.match(/^(.*?page=)2(\/.*|$)/).slice(1);
                path = path.match(/^(.*?)2(.*?$)/).slice(1);
            } else {
                if (path.match(/^(.*?page=)1(\/.*|$)/)) return path = path.match(/^(.*?page=)1(\/.*|$)/).slice(1);
                this._debug("Sorry, we couldn't parse your Next (Previous Posts) URL. Verify your the css selector points to the correct A tag. If you still get this error: yell, scream, and kindly ask for help at infinite-scroll.com."), 
                opts.state.isInvalidPage = !0;
            }
            return this._debug("determinePath", path), path;
        },
        _error: function(xhr) {
            var opts = this.options;
            return opts.behavior && this["_error_" + opts.behavior] !== undefined ? void this["_error_" + opts.behavior].call(this, xhr) : ("destroy" !== xhr && "end" !== xhr && (xhr = "unknown"), 
            this._debug("Error", xhr), ("end" === xhr || opts.state.isBeyondMaxPage) && this._showdonemsg(), 
            opts.state.isDone = !0, opts.state.currPage = 1, opts.state.isPaused = !1, opts.state.isBeyondMaxPage = !1, 
            void this._binding("unbind"));
        },
        _loadcallback: function(box, data, url) {
            var frag, opts = this.options, callback = this.options.callback, result = opts.state.isDone ? "done" : opts.appendCallback ? "append" : "no-append";
            if (opts.behavior && this["_loadcallback_" + opts.behavior] !== undefined) return void this["_loadcallback_" + opts.behavior].call(this, box, data);
            switch (result) {
              case "done":
                return this._showdonemsg(), !1;

              case "no-append":
                if ("html" === opts.dataType && (data = "<div>" + data + "</div>", data = $(data).find(opts.itemSelector)), 
                0 === data.length) return this._error("end");
                break;

              case "append":
                var children = box.children();
                if (0 === children.length) return this._error("end");
                for (frag = document.createDocumentFragment(); box[0].firstChild; ) frag.appendChild(box[0].firstChild);
                this._debug("contentSelector", $(opts.contentSelector)[0]), $(opts.contentSelector)[0].appendChild(frag), 
                data = children.get();
            }
            if (opts.loading.finished.call($(opts.contentSelector)[0], opts), opts.animate) {
                var scrollTo = $(window).scrollTop() + $(opts.loading.msg).height() + opts.extraScrollPx + "px";
                $("html,body").animate({
                    scrollTop: scrollTo
                }, 800, function() {
                    opts.state.isDuringAjax = !1;
                });
            }
            opts.animate || (opts.state.isDuringAjax = !1), callback(this, data, url), opts.prefill && this._prefill();
        },
        _nearbottom: function() {
            var opts = this.options, pixelsFromWindowBottomToBottom = 0 + $(document).height() - opts.binder.scrollTop() - $(window).height();
            return opts.behavior && this["_nearbottom_" + opts.behavior] !== undefined ? this["_nearbottom_" + opts.behavior].call(this) : (this._debug("math:", pixelsFromWindowBottomToBottom, opts.pixelsFromNavToBottom), 
            pixelsFromWindowBottomToBottom - opts.bufferPx < opts.pixelsFromNavToBottom);
        },
        _pausing: function(pause) {
            var opts = this.options;
            if (opts.behavior && this["_pausing_" + opts.behavior] !== undefined) return void this["_pausing_" + opts.behavior].call(this, pause);
            switch ("pause" !== pause && "resume" !== pause && null !== pause && this._debug("Invalid argument. Toggling pause value instead"), 
            pause = !pause || "pause" !== pause && "resume" !== pause ? "toggle" : pause) {
              case "pause":
                opts.state.isPaused = !0;
                break;

              case "resume":
                opts.state.isPaused = !1;
                break;

              case "toggle":
                opts.state.isPaused = !opts.state.isPaused;
            }
            return this._debug("Paused", opts.state.isPaused), !1;
        },
        _setup: function() {
            var opts = this.options;
            return opts.behavior && this["_setup_" + opts.behavior] !== undefined ? void this["_setup_" + opts.behavior].call(this) : (this._binding("bind"), 
            !1);
        },
        _showdonemsg: function() {
            var opts = this.options;
            return opts.behavior && this["_showdonemsg_" + opts.behavior] !== undefined ? void this["_showdonemsg_" + opts.behavior].call(this) : (opts.loading.msg.find("img").hide().parent().find("div").html(opts.loading.finishedMsg).animate({
                opacity: 1
            }, 2e3, function() {
                $(this).parent().fadeOut(opts.loading.speed);
            }), void opts.errorCallback.call($(opts.contentSelector)[0], "done"));
        },
        _validate: function(opts) {
            for (var key in opts) if (key.indexOf && key.indexOf("Selector") > -1 && 0 === $(opts[key]).length) return this._debug("Your " + key + " found no elements."), 
            !1;
            return !0;
        },
        bind: function() {
            this._binding("bind");
        },
        destroy: function() {
            return this.options.state.isDestroyed = !0, this.options.loading.finished(), this._error("destroy");
        },
        pause: function() {
            this._pausing("pause");
        },
        resume: function() {
            this._pausing("resume");
        },
        beginAjax: function(opts) {
            var box, desturl, method, condition, instance = this, path = opts.path;
            if (opts.state.currPage++, opts.maxPage !== undefined && opts.state.currPage > opts.maxPage) return opts.state.isBeyondMaxPage = !0, 
            void this.destroy();
            switch (box = $($(opts.contentSelector).is("table, tbody") ? "<tbody/>" : "<div/>"), 
            desturl = "function" == typeof path ? path(opts.state.currPage) : path.join(opts.state.currPage), 
            instance._debug("heading into ajax", desturl), method = "html" === opts.dataType || "json" === opts.dataType ? opts.dataType : "html+callback", 
            opts.appendCallback && "html" === opts.dataType && (method += "+callback"), method) {
              case "html+callback":
                instance._debug("Using HTML via .load() method"), box.load(desturl + " " + opts.itemSelector, undefined, function(responseText) {
                    instance._loadcallback(box, responseText, desturl);
                });
                break;

              case "html":
                instance._debug("Using " + method.toUpperCase() + " via $.ajax() method"), $.ajax({
                    url: desturl,
                    dataType: opts.dataType,
                    complete: function(jqXHR, textStatus) {
                        condition = "undefined" != typeof jqXHR.isResolved ? jqXHR.isResolved() : "success" === textStatus || "notmodified" === textStatus, 
                        condition ? instance._loadcallback(box, jqXHR.responseText, desturl) : instance._error("end");
                    }
                });
                break;

              case "json":
                instance._debug("Using " + method.toUpperCase() + " via $.ajax() method"), $.ajax({
                    dataType: "json",
                    type: "GET",
                    url: desturl,
                    success: function(data, textStatus, jqXHR) {
                        if (condition = "undefined" != typeof jqXHR.isResolved ? jqXHR.isResolved() : "success" === textStatus || "notmodified" === textStatus, 
                        opts.appendCallback) if (opts.template !== undefined) {
                            var theData = opts.template(data);
                            box.append(theData), condition ? instance._loadcallback(box, theData) : instance._error("end");
                        } else instance._debug("template must be defined."), instance._error("end"); else condition ? instance._loadcallback(box, data, desturl) : instance._error("end");
                    },
                    error: function() {
                        instance._debug("JSON ajax request failed."), instance._error("end");
                    }
                });
            }
        },
        retrieve: function(pageNum) {
            pageNum = pageNum || null;
            var instance = this, opts = instance.options;
            return opts.behavior && this["retrieve_" + opts.behavior] !== undefined ? void this["retrieve_" + opts.behavior].call(this, pageNum) : opts.state.isDestroyed ? (this._debug("Instance is destroyed"), 
            !1) : (opts.state.isDuringAjax = !0, void opts.loading.start.call($(opts.contentSelector)[0], opts));
        },
        scroll: function() {
            var opts = this.options, state = opts.state;
            return opts.behavior && this["scroll_" + opts.behavior] !== undefined ? void this["scroll_" + opts.behavior].call(this) : void (state.isDuringAjax || state.isInvalidPage || state.isDone || state.isDestroyed || state.isPaused || this._nearbottom() && this.retrieve());
        },
        toggle: function() {
            this._pausing();
        },
        unbind: function() {
            this._binding("unbind");
        },
        update: function(key) {
            $.isPlainObject(key) && (this.options = $.extend(!0, this.options, key));
        }
    }, $.fn.infinitescroll = function(options, callback) {
        var thisCall = typeof options;
        switch (thisCall) {
          case "string":
            var args = Array.prototype.slice.call(arguments, 1);
            this.each(function() {
                var instance = $.data(this, "infinitescroll");
                return instance && $.isFunction(instance[options]) && "_" !== options.charAt(0) ? void instance[options].apply(instance, args) : !1;
            });
            break;

          case "object":
            this.each(function() {
                var instance = $.data(this, "infinitescroll");
                instance ? instance.update(options) : (instance = new $.infinitescroll(options, callback, this), 
                instance.failed || $.data(this, "infinitescroll", instance));
            });
        }
        return this;
    };
    var scrollTimeout, event = $.event;
    event.special.smartscroll = {
        setup: function() {
            $(this).bind("scroll", event.special.smartscroll.handler);
        },
        teardown: function() {
            $(this).unbind("scroll", event.special.smartscroll.handler);
        },
        handler: function(event, execAsap) {
            var context = this, args = arguments;
            event.type = "smartscroll", scrollTimeout && clearTimeout(scrollTimeout), scrollTimeout = setTimeout(function() {
                $(context).trigger("smartscroll", args);
            }, "execAsap" === execAsap ? 0 : 100);
        }
    }, $.fn.smartscroll = function(fn) {
        return fn ? this.bind("smartscroll", fn) : this.trigger("smartscroll", [ "execAsap" ]);
    };
});

var mod;

mod = angular.module("infinite-scroll", []), mod.value("THROTTLE_MILLISECONDS", null), 
mod.directive("infiniteScroll", [ "$rootScope", "$window", "$interval", "THROTTLE_MILLISECONDS", function($rootScope, $window, $interval, THROTTLE_MILLISECONDS) {
    return {
        scope: {
            infiniteScroll: "&",
            infiniteScrollContainer: "=",
            infiniteScrollDistance: "=",
            infiniteScrollDisabled: "=",
            infiniteScrollUseDocumentBottom: "="
        },
        link: function(scope, elem, attrs) {
            var changeContainer, checkWhenEnabled, container, handleInfiniteScrollContainer, handleInfiniteScrollDisabled, handleInfiniteScrollDistance, handleInfiniteScrollUseDocumentBottom, handler, height, immediateCheck, offsetTop, pageYOffset, scrollDistance, scrollEnabled, throttle, useDocumentBottom, windowElement;
            return windowElement = angular.element($window), scrollDistance = null, scrollEnabled = null, 
            checkWhenEnabled = null, container = null, immediateCheck = !0, useDocumentBottom = !1, 
            height = function(elem) {
                return elem = elem[0] || elem, isNaN(elem.offsetHeight) ? elem.document.documentElement.clientHeight : elem.offsetHeight;
            }, offsetTop = function(elem) {
                return elem[0].getBoundingClientRect && !elem.css("none") ? elem[0].getBoundingClientRect().top + pageYOffset(elem) : void 0;
            }, pageYOffset = function(elem) {
                return elem = elem[0] || elem, isNaN(window.pageYOffset) ? elem.document.documentElement.scrollTop : elem.ownerDocument.defaultView.pageYOffset;
            }, handler = function() {
                var containerBottom, containerTopOffset, elementBottom, remaining, shouldScroll;
                return container === windowElement ? (containerBottom = height(container) + pageYOffset(container[0].document.documentElement), 
                elementBottom = offsetTop(elem) + height(elem)) : (containerBottom = height(container), 
                containerTopOffset = 0, void 0 !== offsetTop(container) && (containerTopOffset = offsetTop(container)), 
                elementBottom = offsetTop(elem) - containerTopOffset + height(elem)), useDocumentBottom && (elementBottom = height((elem[0].ownerDocument || elem[0].document).documentElement)), 
                remaining = elementBottom - containerBottom, shouldScroll = remaining <= height(container) * scrollDistance + 1, 
                shouldScroll ? (checkWhenEnabled = !0, scrollEnabled ? scope.$$phase || $rootScope.$$phase ? scope.infiniteScroll() : scope.$apply(scope.infiniteScroll) : void 0) : checkWhenEnabled = !1;
            }, throttle = function(func, wait) {
                var later, previous, timeout;
                return timeout = null, previous = 0, later = function() {
                    var context;
                    return previous = new Date().getTime(), $interval.cancel(timeout), timeout = null, 
                    func.call(), context = null;
                }, function() {
                    var now, remaining;
                    return now = new Date().getTime(), remaining = wait - (now - previous), 0 >= remaining ? (clearTimeout(timeout), 
                    $interval.cancel(timeout), timeout = null, previous = now, func.call()) : timeout ? void 0 : timeout = $interval(later, remaining, 1);
                };
            }, null != THROTTLE_MILLISECONDS && (handler = throttle(handler, THROTTLE_MILLISECONDS)), 
            scope.$on("$destroy", function() {
                return container.unbind("scroll", handler);
            }), handleInfiniteScrollDistance = function(v) {
                return scrollDistance = parseFloat(v) || 0;
            }, scope.$watch("infiniteScrollDistance", handleInfiniteScrollDistance), handleInfiniteScrollDistance(scope.infiniteScrollDistance), 
            handleInfiniteScrollDisabled = function(v) {
                return scrollEnabled = !v, scrollEnabled && checkWhenEnabled ? (checkWhenEnabled = !1, 
                handler()) : void 0;
            }, scope.$watch("infiniteScrollDisabled", handleInfiniteScrollDisabled), handleInfiniteScrollDisabled(scope.infiniteScrollDisabled), 
            handleInfiniteScrollUseDocumentBottom = function(v) {
                return useDocumentBottom = v;
            }, scope.$watch("infiniteScrollUseDocumentBottom", handleInfiniteScrollUseDocumentBottom), 
            handleInfiniteScrollUseDocumentBottom(scope.infiniteScrollUseDocumentBottom), changeContainer = function(newContainer) {
                return null != container && container.unbind("scroll", handler), container = newContainer, 
                null != newContainer ? container.bind("scroll", handler) : void 0;
            }, changeContainer(windowElement), handleInfiniteScrollContainer = function(newContainer) {
                if (null != newContainer && 0 !== newContainer.length) {
                    if (newContainer instanceof HTMLElement ? newContainer = angular.element(newContainer) : "function" == typeof newContainer.append ? newContainer = angular.element(newContainer[newContainer.length - 1]) : "string" == typeof newContainer && (newContainer = angular.element(document.querySelector(newContainer))), 
                    null != newContainer) return changeContainer(newContainer);
                    throw new Exception("invalid infinite-scroll-container attribute.");
                }
            }, scope.$watch("infiniteScrollContainer", handleInfiniteScrollContainer), handleInfiniteScrollContainer(scope.infiniteScrollContainer || []), 
            null != attrs.infiniteScrollParent && changeContainer(angular.element(elem.parent())), 
            null != attrs.infiniteScrollImmediateCheck && (immediateCheck = scope.$eval(attrs.infiniteScrollImmediateCheck)), 
            $interval(function() {
                return immediateCheck ? handler() : void 0;
            }, 0, 1);
        }
    };
} ]), function(angular, factory) {
    return "function" == typeof define && define.amd ? void define("angular-file-upload", [ "angular" ], function(angular) {
        return factory(angular);
    }) : factory(angular);
}("undefined" == typeof angular ? null : angular, function(angular) {
    var module = angular.module("angularFileUpload", []);
    return module.value("fileUploaderOptions", {
        url: "/",
        alias: "file",
        headers: {},
        queue: [],
        progress: 0,
        autoUpload: !1,
        removeAfterUpload: !1,
        method: "POST",
        filters: [],
        formData: [],
        queueLimit: Number.MAX_VALUE,
        withCredentials: !1
    }).factory("FileUploader", [ "fileUploaderOptions", "$rootScope", "$http", "$window", "$compile", function(fileUploaderOptions, $rootScope, $http, $window, $compile) {
        function FileUploader(options) {
            var settings = angular.copy(fileUploaderOptions);
            angular.extend(this, settings, options, {
                isUploading: !1,
                _nextIndex: 0,
                _failFilterIndex: -1,
                _directives: {
                    select: [],
                    drop: [],
                    over: []
                }
            }), this.filters.unshift({
                name: "queueLimit",
                fn: this._queueLimitFilter
            }), this.filters.unshift({
                name: "folder",
                fn: this._folderFilter
            });
        }
        function FileLikeObject(fileOrInput) {
            var isInput = angular.isElement(fileOrInput), fakePathOrObject = isInput ? fileOrInput.value : fileOrInput, postfix = angular.isString(fakePathOrObject) ? "FakePath" : "Object", method = "_createFrom" + postfix;
            this[method](fakePathOrObject);
        }
        function FileItem(uploader, some, options) {
            var isInput = angular.isElement(some), input = isInput ? angular.element(some) : null, file = isInput ? null : some;
            angular.extend(this, {
                url: uploader.url,
                alias: uploader.alias,
                headers: angular.copy(uploader.headers),
                formData: angular.copy(uploader.formData),
                removeAfterUpload: uploader.removeAfterUpload,
                withCredentials: uploader.withCredentials,
                method: uploader.method
            }, options, {
                uploader: uploader,
                file: new FileUploader.FileLikeObject(some),
                isReady: !1,
                isUploading: !1,
                isUploaded: !1,
                isSuccess: !1,
                isCancel: !1,
                isError: !1,
                progress: 0,
                index: null,
                _file: file,
                _input: input
            }), input && this._replaceNode(input);
        }
        function FileDirective(options) {
            angular.extend(this, options), this.uploader._directives[this.prop].push(this), 
            this._saveLinks(), this.bind();
        }
        function FileSelect(options) {
            FileSelect.super_.apply(this, arguments), this.uploader.isHTML5 || this.element.removeAttr("multiple"), 
            this.element.prop("value", null);
        }
        function FileDrop(options) {
            FileDrop.super_.apply(this, arguments);
        }
        function FileOver(options) {
            FileOver.super_.apply(this, arguments);
        }
        return FileUploader.prototype.isHTML5 = !(!$window.File || !$window.FormData), FileUploader.prototype.addToQueue = function(files, options, filters) {
            var list = this.isArrayLikeObject(files) ? files : [ files ], arrayOfFilters = this._getFilters(filters), count = this.queue.length, addedFileItems = [];
            angular.forEach(list, function(some) {
                var temp = new FileUploader.FileLikeObject(some);
                if (this._isValidFile(temp, arrayOfFilters, options)) {
                    var fileItem = new FileUploader.FileItem(this, some, options);
                    addedFileItems.push(fileItem), this.queue.push(fileItem), this._onAfterAddingFile(fileItem);
                } else {
                    var filter = this.filters[this._failFilterIndex];
                    this._onWhenAddingFileFailed(temp, filter, options);
                }
            }, this), this.queue.length !== count && (this._onAfterAddingAll(addedFileItems), 
            this.progress = this._getTotalProgress()), this._render(), this.autoUpload && this.uploadAll();
        }, FileUploader.prototype.removeFromQueue = function(value) {
            var index = this.getIndexOfItem(value), item = this.queue[index];
            item.isUploading && item.cancel(), this.queue.splice(index, 1), item._destroy(), 
            this.progress = this._getTotalProgress();
        }, FileUploader.prototype.clearQueue = function() {
            for (;this.queue.length; ) this.queue[0].remove();
            this.progress = 0;
        }, FileUploader.prototype.uploadItem = function(value) {
            var index = this.getIndexOfItem(value), item = this.queue[index], transport = this.isHTML5 ? "_xhrTransport" : "_iframeTransport";
            item._prepareToUploading(), this.isUploading || (this.isUploading = !0, this[transport](item));
        }, FileUploader.prototype.cancelItem = function(value) {
            var index = this.getIndexOfItem(value), item = this.queue[index], prop = this.isHTML5 ? "_xhr" : "_form";
            item && item.isUploading && item[prop].abort();
        }, FileUploader.prototype.uploadAll = function() {
            var items = this.getNotUploadedItems().filter(function(item) {
                return !item.isUploading;
            });
            items.length && (angular.forEach(items, function(item) {
                item._prepareToUploading();
            }), items[0].upload());
        }, FileUploader.prototype.cancelAll = function() {
            var items = this.getNotUploadedItems();
            angular.forEach(items, function(item) {
                item.cancel();
            });
        }, FileUploader.prototype.isFile = function(value) {
            var fn = $window.File;
            return fn && value instanceof fn;
        }, FileUploader.prototype.isFileLikeObject = function(value) {
            return value instanceof FileUploader.FileLikeObject;
        }, FileUploader.prototype.isArrayLikeObject = function(value) {
            return angular.isObject(value) && "length" in value;
        }, FileUploader.prototype.getIndexOfItem = function(value) {
            return angular.isNumber(value) ? value : this.queue.indexOf(value);
        }, FileUploader.prototype.getNotUploadedItems = function() {
            return this.queue.filter(function(item) {
                return !item.isUploaded;
            });
        }, FileUploader.prototype.getReadyItems = function() {
            return this.queue.filter(function(item) {
                return item.isReady && !item.isUploading;
            }).sort(function(item1, item2) {
                return item1.index - item2.index;
            });
        }, FileUploader.prototype.destroy = function() {
            angular.forEach(this._directives, function(key) {
                angular.forEach(this._directives[key], function(object) {
                    object.destroy();
                }, this);
            }, this);
        }, FileUploader.prototype.onAfterAddingAll = function(fileItems) {}, FileUploader.prototype.onAfterAddingFile = function(fileItem) {}, 
        FileUploader.prototype.onWhenAddingFileFailed = function(item, filter, options) {}, 
        FileUploader.prototype.onBeforeUploadItem = function(fileItem) {}, FileUploader.prototype.onProgressItem = function(fileItem, progress) {}, 
        FileUploader.prototype.onProgressAll = function(progress) {}, FileUploader.prototype.onSuccessItem = function(item, response, status, headers) {}, 
        FileUploader.prototype.onErrorItem = function(item, response, status, headers) {}, 
        FileUploader.prototype.onCancelItem = function(item, response, status, headers) {}, 
        FileUploader.prototype.onCompleteItem = function(item, response, status, headers) {}, 
        FileUploader.prototype.onCompleteAll = function() {}, FileUploader.prototype._getTotalProgress = function(value) {
            if (this.removeAfterUpload) return value || 0;
            var notUploaded = this.getNotUploadedItems().length, uploaded = notUploaded ? this.queue.length - notUploaded : this.queue.length, ratio = 100 / this.queue.length, current = (value || 0) * ratio / 100;
            return Math.round(uploaded * ratio + current);
        }, FileUploader.prototype._getFilters = function(filters) {
            if (angular.isUndefined(filters)) return this.filters;
            if (angular.isArray(filters)) return filters;
            var names = filters.match(/[^\s,]+/g);
            return this.filters.filter(function(filter) {
                return -1 !== names.indexOf(filter.name);
            }, this);
        }, FileUploader.prototype._render = function() {
            $rootScope.$$phase || $rootScope.$apply();
        }, FileUploader.prototype._folderFilter = function(item) {
            return !(!item.size && !item.type);
        }, FileUploader.prototype._queueLimitFilter = function() {
            return this.queue.length < this.queueLimit;
        }, FileUploader.prototype._isValidFile = function(file, filters, options) {
            return this._failFilterIndex = -1, filters.length ? filters.every(function(filter) {
                return this._failFilterIndex++, filter.fn.call(this, file, options);
            }, this) : !0;
        }, FileUploader.prototype._isSuccessCode = function(status) {
            return status >= 200 && 300 > status || 304 === status;
        }, FileUploader.prototype._transformResponse = function(response, headers) {
            var headersGetter = this._headersGetter(headers);
            return angular.forEach($http.defaults.transformResponse, function(transformFn) {
                response = transformFn(response, headersGetter);
            }), response;
        }, FileUploader.prototype._parseHeaders = function(headers) {
            var key, val, i, parsed = {};
            return headers ? (angular.forEach(headers.split("\n"), function(line) {
                i = line.indexOf(":"), key = line.slice(0, i).trim().toLowerCase(), val = line.slice(i + 1).trim(), 
                key && (parsed[key] = parsed[key] ? parsed[key] + ", " + val : val);
            }), parsed) : parsed;
        }, FileUploader.prototype._headersGetter = function(parsedHeaders) {
            return function(name) {
                return name ? parsedHeaders[name.toLowerCase()] || null : parsedHeaders;
            };
        }, FileUploader.prototype._xhrTransport = function(item) {
            var xhr = item._xhr = new XMLHttpRequest(), form = new FormData(), that = this;
            that._onBeforeUploadItem(item), angular.forEach(item.formData, function(obj) {
                angular.forEach(obj, function(value, key) {
                    form.append(key, value);
                });
            }), form.append(item.alias, item._file, item.file.name), xhr.upload.onprogress = function(event) {
                var progress = Math.round(event.lengthComputable ? 100 * event.loaded / event.total : 0);
                that._onProgressItem(item, progress);
            }, xhr.onload = function() {
                var headers = that._parseHeaders(xhr.getAllResponseHeaders()), response = that._transformResponse(xhr.response, headers), gist = that._isSuccessCode(xhr.status) ? "Success" : "Error", method = "_on" + gist + "Item";
                that[method](item, response, xhr.status, headers), that._onCompleteItem(item, response, xhr.status, headers);
            }, xhr.onerror = function() {
                var headers = that._parseHeaders(xhr.getAllResponseHeaders()), response = that._transformResponse(xhr.response, headers);
                that._onErrorItem(item, response, xhr.status, headers), that._onCompleteItem(item, response, xhr.status, headers);
            }, xhr.onabort = function() {
                var headers = that._parseHeaders(xhr.getAllResponseHeaders()), response = that._transformResponse(xhr.response, headers);
                that._onCancelItem(item, response, xhr.status, headers), that._onCompleteItem(item, response, xhr.status, headers);
            }, xhr.open(item.method, item.url, !0), xhr.withCredentials = item.withCredentials, 
            angular.forEach(item.headers, function(value, name) {
                xhr.setRequestHeader(name, value);
            }), xhr.send(form), this._render();
        }, FileUploader.prototype._iframeTransport = function(item) {
            var form = angular.element('<form style="display: none;" />'), iframe = angular.element('<iframe name="iframeTransport' + Date.now() + '">'), input = item._input, that = this;
            item._form && item._form.replaceWith(input), item._form = form, that._onBeforeUploadItem(item), 
            input.prop("name", item.alias), angular.forEach(item.formData, function(obj) {
                angular.forEach(obj, function(value, key) {
                    var element = angular.element('<input type="hidden" name="' + key + '" />');
                    element.val(value), form.append(element);
                });
            }), form.prop({
                action: item.url,
                method: "POST",
                target: iframe.prop("name"),
                enctype: "multipart/form-data",
                encoding: "multipart/form-data"
            }), iframe.bind("load", function() {
                try {
                    var html = iframe[0].contentDocument.body.innerHTML;
                } catch (e) {}
                var xhr = {
                    response: html,
                    status: 200,
                    dummy: !0
                }, headers = {}, response = that._transformResponse(xhr.response, headers);
                that._onSuccessItem(item, response, xhr.status, headers), that._onCompleteItem(item, response, xhr.status, headers);
            }), form.abort = function() {
                var response, xhr = {
                    status: 0,
                    dummy: !0
                }, headers = {};
                iframe.unbind("load").prop("src", "javascript:false;"), form.replaceWith(input), 
                that._onCancelItem(item, response, xhr.status, headers), that._onCompleteItem(item, response, xhr.status, headers);
            }, input.after(form), form.append(input).append(iframe), form[0].submit(), this._render();
        }, FileUploader.prototype._onWhenAddingFileFailed = function(item, filter, options) {
            this.onWhenAddingFileFailed(item, filter, options);
        }, FileUploader.prototype._onAfterAddingFile = function(item) {
            this.onAfterAddingFile(item);
        }, FileUploader.prototype._onAfterAddingAll = function(items) {
            this.onAfterAddingAll(items);
        }, FileUploader.prototype._onBeforeUploadItem = function(item) {
            item._onBeforeUpload(), this.onBeforeUploadItem(item);
        }, FileUploader.prototype._onProgressItem = function(item, progress) {
            var total = this._getTotalProgress(progress);
            this.progress = total, item._onProgress(progress), this.onProgressItem(item, progress), 
            this.onProgressAll(total), this._render();
        }, FileUploader.prototype._onSuccessItem = function(item, response, status, headers) {
            item._onSuccess(response, status, headers), this.onSuccessItem(item, response, status, headers);
        }, FileUploader.prototype._onErrorItem = function(item, response, status, headers) {
            item._onError(response, status, headers), this.onErrorItem(item, response, status, headers);
        }, FileUploader.prototype._onCancelItem = function(item, response, status, headers) {
            item._onCancel(response, status, headers), this.onCancelItem(item, response, status, headers);
        }, FileUploader.prototype._onCompleteItem = function(item, response, status, headers) {
            item._onComplete(response, status, headers), this.onCompleteItem(item, response, status, headers);
            var nextItem = this.getReadyItems()[0];
            return this.isUploading = !1, angular.isDefined(nextItem) ? void nextItem.upload() : (this.onCompleteAll(), 
            this.progress = this._getTotalProgress(), void this._render());
        }, FileUploader.isFile = FileUploader.prototype.isFile, FileUploader.isFileLikeObject = FileUploader.prototype.isFileLikeObject, 
        FileUploader.isArrayLikeObject = FileUploader.prototype.isArrayLikeObject, FileUploader.isHTML5 = FileUploader.prototype.isHTML5, 
        FileUploader.inherit = function(target, source) {
            target.prototype = Object.create(source.prototype), target.prototype.constructor = target, 
            target.super_ = source;
        }, FileUploader.FileLikeObject = FileLikeObject, FileUploader.FileItem = FileItem, 
        FileUploader.FileDirective = FileDirective, FileUploader.FileSelect = FileSelect, 
        FileUploader.FileDrop = FileDrop, FileUploader.FileOver = FileOver, FileLikeObject.prototype._createFromFakePath = function(path) {
            this.lastModifiedDate = null, this.size = null, this.type = "like/" + path.slice(path.lastIndexOf(".") + 1).toLowerCase(), 
            this.name = path.slice(path.lastIndexOf("/") + path.lastIndexOf("\\") + 2);
        }, FileLikeObject.prototype._createFromObject = function(object) {
            this.lastModifiedDate = angular.copy(object.lastModifiedDate), this.size = object.size, 
            this.type = object.type, this.name = object.name;
        }, FileItem.prototype.upload = function() {
            this.uploader.uploadItem(this);
        }, FileItem.prototype.cancel = function() {
            this.uploader.cancelItem(this);
        }, FileItem.prototype.remove = function() {
            this.uploader.removeFromQueue(this);
        }, FileItem.prototype.onBeforeUpload = function() {}, FileItem.prototype.onProgress = function(progress) {}, 
        FileItem.prototype.onSuccess = function(response, status, headers) {}, FileItem.prototype.onError = function(response, status, headers) {}, 
        FileItem.prototype.onCancel = function(response, status, headers) {}, FileItem.prototype.onComplete = function(response, status, headers) {}, 
        FileItem.prototype._onBeforeUpload = function() {
            this.isReady = !0, this.isUploading = !0, this.isUploaded = !1, this.isSuccess = !1, 
            this.isCancel = !1, this.isError = !1, this.progress = 0, this.onBeforeUpload();
        }, FileItem.prototype._onProgress = function(progress) {
            this.progress = progress, this.onProgress(progress);
        }, FileItem.prototype._onSuccess = function(response, status, headers) {
            this.isReady = !1, this.isUploading = !1, this.isUploaded = !0, this.isSuccess = !0, 
            this.isCancel = !1, this.isError = !1, this.progress = 100, this.index = null, this.onSuccess(response, status, headers);
        }, FileItem.prototype._onError = function(response, status, headers) {
            this.isReady = !1, this.isUploading = !1, this.isUploaded = !0, this.isSuccess = !1, 
            this.isCancel = !1, this.isError = !0, this.progress = 0, this.index = null, this.onError(response, status, headers);
        }, FileItem.prototype._onCancel = function(response, status, headers) {
            this.isReady = !1, this.isUploading = !1, this.isUploaded = !1, this.isSuccess = !1, 
            this.isCancel = !0, this.isError = !1, this.progress = 0, this.index = null, this.onCancel(response, status, headers);
        }, FileItem.prototype._onComplete = function(response, status, headers) {
            this.onComplete(response, status, headers), this.removeAfterUpload && this.remove();
        }, FileItem.prototype._destroy = function() {
            this._input && this._input.remove(), this._form && this._form.remove(), delete this._form, 
            delete this._input;
        }, FileItem.prototype._prepareToUploading = function() {
            this.index = this.index || ++this.uploader._nextIndex, this.isReady = !0;
        }, FileItem.prototype._replaceNode = function(input) {
            var clone = $compile(input.clone())(input.scope());
            clone.prop("value", null), input.css("display", "none"), input.after(clone);
        }, FileDirective.prototype.events = {}, FileDirective.prototype.bind = function() {
            for (var key in this.events) {
                var prop = this.events[key];
                this.element.bind(key, this[prop]);
            }
        }, FileDirective.prototype.unbind = function() {
            for (var key in this.events) this.element.unbind(key, this.events[key]);
        }, FileDirective.prototype.destroy = function() {
            var index = this.uploader._directives[this.prop].indexOf(this);
            this.uploader._directives[this.prop].splice(index, 1), this.unbind();
        }, FileDirective.prototype._saveLinks = function() {
            for (var key in this.events) {
                var prop = this.events[key];
                this[prop] = this[prop].bind(this);
            }
        }, FileUploader.inherit(FileSelect, FileDirective), FileSelect.prototype.events = {
            $destroy: "destroy",
            change: "onChange"
        }, FileSelect.prototype.prop = "select", FileSelect.prototype.getOptions = function() {}, 
        FileSelect.prototype.getFilters = function() {}, FileSelect.prototype.isEmptyAfterSelection = function() {
            return !!this.element.attr("multiple");
        }, FileSelect.prototype.onChange = function() {
            var files = this.uploader.isHTML5 ? this.element[0].files : this.element[0], options = this.getOptions(), filters = this.getFilters();
            this.uploader.isHTML5 || this.destroy(), this.uploader.addToQueue(files, options, filters), 
            this.isEmptyAfterSelection() && this.element.prop("value", null);
        }, FileUploader.inherit(FileDrop, FileDirective), FileDrop.prototype.events = {
            $destroy: "destroy",
            drop: "onDrop",
            dragover: "onDragOver",
            dragleave: "onDragLeave"
        }, FileDrop.prototype.prop = "drop", FileDrop.prototype.getOptions = function() {}, 
        FileDrop.prototype.getFilters = function() {}, FileDrop.prototype.onDrop = function(event) {
            var transfer = this._getTransfer(event);
            if (transfer) {
                var options = this.getOptions(), filters = this.getFilters();
                this._preventAndStop(event), angular.forEach(this.uploader._directives.over, this._removeOverClass, this), 
                this.uploader.addToQueue(transfer.files, options, filters);
            }
        }, FileDrop.prototype.onDragOver = function(event) {
            var transfer = this._getTransfer(event);
            this._haveFiles(transfer.types) && (transfer.dropEffect = "copy", this._preventAndStop(event), 
            angular.forEach(this.uploader._directives.over, this._addOverClass, this));
        }, FileDrop.prototype.onDragLeave = function(event) {
            event.currentTarget === this.element[0] && (this._preventAndStop(event), angular.forEach(this.uploader._directives.over, this._removeOverClass, this));
        }, FileDrop.prototype._getTransfer = function(event) {
            return event.dataTransfer ? event.dataTransfer : event.originalEvent.dataTransfer;
        }, FileDrop.prototype._preventAndStop = function(event) {
            event.preventDefault(), event.stopPropagation();
        }, FileDrop.prototype._haveFiles = function(types) {
            return types ? types.indexOf ? -1 !== types.indexOf("Files") : types.contains ? types.contains("Files") : !1 : !1;
        }, FileDrop.prototype._addOverClass = function(item) {
            item.addOverClass();
        }, FileDrop.prototype._removeOverClass = function(item) {
            item.removeOverClass();
        }, FileUploader.inherit(FileOver, FileDirective), FileOver.prototype.events = {
            $destroy: "destroy"
        }, FileOver.prototype.prop = "over", FileOver.prototype.overClass = "nv-file-over", 
        FileOver.prototype.addOverClass = function() {
            this.element.addClass(this.getOverClass());
        }, FileOver.prototype.removeOverClass = function() {
            this.element.removeClass(this.getOverClass());
        }, FileOver.prototype.getOverClass = function() {
            return this.overClass;
        }, FileUploader;
    } ]).directive("nvFileSelect", [ "$parse", "FileUploader", function($parse, FileUploader) {
        return {
            link: function(scope, element, attributes) {
                var uploader = scope.$eval(attributes.uploader);
                if (!(uploader instanceof FileUploader)) throw new TypeError('"Uploader" must be an instance of FileUploader');
                var object = new FileUploader.FileSelect({
                    uploader: uploader,
                    element: element
                });
                object.getOptions = $parse(attributes.options).bind(object, scope), object.getFilters = function() {
                    return attributes.filters;
                };
            }
        };
    } ]).directive("nvFileDrop", [ "$parse", "FileUploader", function($parse, FileUploader) {
        return {
            link: function(scope, element, attributes) {
                var uploader = scope.$eval(attributes.uploader);
                if (!(uploader instanceof FileUploader)) throw new TypeError('"Uploader" must be an instance of FileUploader');
                if (uploader.isHTML5) {
                    var object = new FileUploader.FileDrop({
                        uploader: uploader,
                        element: element
                    });
                    object.getOptions = $parse(attributes.options).bind(object, scope), object.getFilters = function() {
                        return attributes.filters;
                    };
                }
            }
        };
    } ]).directive("nvFileOver", [ "FileUploader", function(FileUploader) {
        return {
            link: function(scope, element, attributes) {
                var uploader = scope.$eval(attributes.uploader);
                if (!(uploader instanceof FileUploader)) throw new TypeError('"Uploader" must be an instance of FileUploader');
                var object = new FileUploader.FileOver({
                    uploader: uploader,
                    element: element
                });
                object.getOverClass = function() {
                    return attributes.overClass || this.overClass;
                };
            }
        };
    } ]), module;
}), function($) {
    $.Jcrop = function(obj, opt) {
        function px(n) {
            return Math.round(n) + "px";
        }
        function cssClass(cl) {
            return options.baseClass + "-" + cl;
        }
        function supportsColorFade() {
            return $.fx.step.hasOwnProperty("backgroundColor");
        }
        function getPos(obj) {
            var pos = $(obj).offset();
            return [ pos.left, pos.top ];
        }
        function mouseAbs(e) {
            return [ e.pageX - docOffset[0], e.pageY - docOffset[1] ];
        }
        function setOptions(opt) {
            "object" != typeof opt && (opt = {}), options = $.extend(options, opt), $.each([ "onChange", "onSelect", "onRelease", "onDblClick" ], function(i, e) {
                "function" != typeof options[e] && (options[e] = function() {});
            });
        }
        function startDragMode(mode, pos, touch) {
            if (docOffset = getPos($img), Tracker.setCursor("move" === mode ? mode : mode + "-resize"), 
            "move" === mode) return Tracker.activateHandlers(createMover(pos), doneSelect, touch);
            var fc = Coords.getFixed(), opp = oppLockCorner(mode), opc = Coords.getCorner(oppLockCorner(opp));
            Coords.setPressed(Coords.getCorner(opp)), Coords.setCurrent(opc), Tracker.activateHandlers(dragmodeHandler(mode, fc), doneSelect, touch);
        }
        function dragmodeHandler(mode, f) {
            return function(pos) {
                if (options.aspectRatio) switch (mode) {
                  case "e":
                    pos[1] = f.y + 1;
                    break;

                  case "w":
                    pos[1] = f.y + 1;
                    break;

                  case "n":
                    pos[0] = f.x + 1;
                    break;

                  case "s":
                    pos[0] = f.x + 1;
                } else switch (mode) {
                  case "e":
                    pos[1] = f.y2;
                    break;

                  case "w":
                    pos[1] = f.y2;
                    break;

                  case "n":
                    pos[0] = f.x2;
                    break;

                  case "s":
                    pos[0] = f.x2;
                }
                Coords.setCurrent(pos), Selection.update();
            };
        }
        function createMover(pos) {
            var lloc = pos;
            return KeyManager.watchKeys(), function(pos) {
                Coords.moveOffset([ pos[0] - lloc[0], pos[1] - lloc[1] ]), lloc = pos, Selection.update();
            };
        }
        function oppLockCorner(ord) {
            switch (ord) {
              case "n":
                return "sw";

              case "s":
                return "nw";

              case "e":
                return "nw";

              case "w":
                return "ne";

              case "ne":
                return "sw";

              case "nw":
                return "se";

              case "se":
                return "nw";

              case "sw":
                return "ne";
            }
        }
        function createDragger(ord) {
            return function(e) {
                return options.disabled ? !1 : "move" !== ord || options.allowMove ? (docOffset = getPos($img), 
                btndown = !0, startDragMode(ord, mouseAbs(e)), e.stopPropagation(), e.preventDefault(), 
                !1) : !1;
            };
        }
        function presize($obj, w, h) {
            var nw = $obj.width(), nh = $obj.height();
            nw > w && w > 0 && (nw = w, nh = w / $obj.width() * $obj.height()), nh > h && h > 0 && (nh = h, 
            nw = h / $obj.height() * $obj.width()), xscale = $obj.width() / nw, yscale = $obj.height() / nh, 
            $obj.width(nw).height(nh);
        }
        function unscale(c) {
            return {
                x: c.x * xscale,
                y: c.y * yscale,
                x2: c.x2 * xscale,
                y2: c.y2 * yscale,
                w: c.w * xscale,
                h: c.h * yscale
            };
        }
        function doneSelect(pos) {
            var c = Coords.getFixed();
            c.w > options.minSelect[0] && c.h > options.minSelect[1] ? (Selection.enableHandles(), 
            Selection.done()) : Selection.release(), Tracker.setCursor(options.allowSelect ? "crosshair" : "default");
        }
        function newSelection(e) {
            if (options.disabled) return !1;
            if (!options.allowSelect) return !1;
            btndown = !0, docOffset = getPos($img), Selection.disableHandles(), Tracker.setCursor("crosshair");
            var pos = mouseAbs(e);
            return Coords.setPressed(pos), Selection.update(), Tracker.activateHandlers(selectDrag, doneSelect, "touch" === e.type.substring(0, 5)), 
            KeyManager.watchKeys(), e.stopPropagation(), e.preventDefault(), !1;
        }
        function selectDrag(pos) {
            Coords.setCurrent(pos), Selection.update();
        }
        function newTracker() {
            var trk = $("<div></div>").addClass(cssClass("tracker"));
            return is_msie && trk.css({
                opacity: 0,
                backgroundColor: "white"
            }), trk;
        }
        function setClass(cname) {
            $div.removeClass().addClass(cssClass("holder")).addClass(cname);
        }
        function animateTo(a, callback) {
            function queueAnimator() {
                window.setTimeout(animator, interv);
            }
            var x1 = a[0] / xscale, y1 = a[1] / yscale, x2 = a[2] / xscale, y2 = a[3] / yscale;
            if (!animating) {
                var animto = Coords.flipCoords(x1, y1, x2, y2), c = Coords.getFixed(), initcr = [ c.x, c.y, c.x2, c.y2 ], animat = initcr, interv = options.animationDelay, ix1 = animto[0] - initcr[0], iy1 = animto[1] - initcr[1], ix2 = animto[2] - initcr[2], iy2 = animto[3] - initcr[3], pcent = 0, velocity = options.swingSpeed;
                x1 = animat[0], y1 = animat[1], x2 = animat[2], y2 = animat[3], Selection.animMode(!0);
                var animator = function() {
                    return function() {
                        pcent += (100 - pcent) / velocity, animat[0] = Math.round(x1 + pcent / 100 * ix1), 
                        animat[1] = Math.round(y1 + pcent / 100 * iy1), animat[2] = Math.round(x2 + pcent / 100 * ix2), 
                        animat[3] = Math.round(y2 + pcent / 100 * iy2), pcent >= 99.8 && (pcent = 100), 
                        100 > pcent ? (setSelectRaw(animat), queueAnimator()) : (Selection.done(), Selection.animMode(!1), 
                        "function" == typeof callback && callback.call(api));
                    };
                }();
                queueAnimator();
            }
        }
        function setSelect(rect) {
            setSelectRaw([ rect[0] / xscale, rect[1] / yscale, rect[2] / xscale, rect[3] / yscale ]), 
            options.onSelect.call(api, unscale(Coords.getFixed())), Selection.enableHandles();
        }
        function setSelectRaw(l) {
            Coords.setPressed([ l[0], l[1] ]), Coords.setCurrent([ l[2], l[3] ]), Selection.update();
        }
        function tellSelect() {
            return unscale(Coords.getFixed());
        }
        function tellScaled() {
            return Coords.getFixed();
        }
        function setOptionsNew(opt) {
            setOptions(opt), interfaceUpdate();
        }
        function disableCrop() {
            options.disabled = !0, Selection.disableHandles(), Selection.setCursor("default"), 
            Tracker.setCursor("default");
        }
        function enableCrop() {
            options.disabled = !1, interfaceUpdate();
        }
        function cancelCrop() {
            Selection.done(), Tracker.activateHandlers(null, null);
        }
        function destroy() {
            $div.remove(), $origimg.show(), $origimg.css("visibility", "visible"), $(obj).removeData("Jcrop");
        }
        function setImage(src, callback) {
            Selection.release(), disableCrop();
            var img = new Image();
            img.onload = function() {
                var iw = img.width, ih = img.height, bw = options.boxWidth, bh = options.boxHeight;
                $img.width(iw).height(ih), $img.attr("src", src), $img2.attr("src", src), presize($img, bw, bh), 
                boundx = $img.width(), boundy = $img.height(), $img2.width(boundx).height(boundy), 
                $trk.width(boundx + 2 * bound).height(boundy + 2 * bound), $div.width(boundx).height(boundy), 
                Shade.resize(boundx, boundy), enableCrop(), "function" == typeof callback && callback.call(api);
            }, img.src = src;
        }
        function colorChangeMacro($obj, color, now) {
            var mycolor = color || options.bgColor;
            options.bgFade && supportsColorFade() && options.fadeTime && !now ? $obj.animate({
                backgroundColor: mycolor
            }, {
                queue: !1,
                duration: options.fadeTime
            }) : $obj.css("backgroundColor", mycolor);
        }
        function interfaceUpdate(alt) {
            options.allowResize ? alt ? Selection.enableOnly() : Selection.enableHandles() : Selection.disableHandles(), 
            Tracker.setCursor(options.allowSelect ? "crosshair" : "default"), Selection.setCursor(options.allowMove ? "move" : "default"), 
            options.hasOwnProperty("trueSize") && (xscale = options.trueSize[0] / boundx, yscale = options.trueSize[1] / boundy), 
            options.hasOwnProperty("setSelect") && (setSelect(options.setSelect), Selection.done(), 
            delete options.setSelect), Shade.refresh(), options.bgColor != bgcolor && (colorChangeMacro(options.shade ? Shade.getShades() : $div, options.shade ? options.shadeColor || options.bgColor : options.bgColor), 
            bgcolor = options.bgColor), bgopacity != options.bgOpacity && (bgopacity = options.bgOpacity, 
            options.shade ? Shade.refresh() : Selection.setBgOpacity(bgopacity)), xlimit = options.maxSize[0] || 0, 
            ylimit = options.maxSize[1] || 0, xmin = options.minSize[0] || 0, ymin = options.minSize[1] || 0, 
            options.hasOwnProperty("outerImage") && ($img.attr("src", options.outerImage), delete options.outerImage), 
            Selection.refresh();
        }
        var docOffset, options = $.extend({}, $.Jcrop.defaults), _ua = navigator.userAgent.toLowerCase(), is_msie = /msie/.test(_ua), ie6mode = /msie [1-6]\./.test(_ua);
        "object" != typeof obj && (obj = $(obj)[0]), "object" != typeof opt && (opt = {}), 
        setOptions(opt);
        var img_css = {
            border: "none",
            visibility: "visible",
            margin: 0,
            padding: 0,
            position: "absolute",
            top: 0,
            left: 0
        }, $origimg = $(obj), img_mode = !0;
        if ("IMG" == obj.tagName) {
            if (0 != $origimg[0].width && 0 != $origimg[0].height) $origimg.width($origimg[0].width), 
            $origimg.height($origimg[0].height); else {
                var tempImage = new Image();
                tempImage.src = $origimg[0].src, $origimg.width(tempImage.width), $origimg.height(tempImage.height);
            }
            var $img = $origimg.clone().removeAttr("id").css(img_css).show();
            $img.width($origimg.width()), $img.height($origimg.height()), $origimg.after($img).hide();
        } else $img = $origimg.css(img_css).show(), img_mode = !1, null === options.shade && (options.shade = !0);
        presize($img, options.boxWidth, options.boxHeight);
        var boundx = $img.width(), boundy = $img.height(), $div = $("<div />").width(boundx).height(boundy).addClass(cssClass("holder")).css({
            position: "relative",
            backgroundColor: options.bgColor
        }).insertAfter($origimg).append($img);
        options.addClass && $div.addClass(options.addClass);
        var $img2 = $("<div />"), $img_holder = $("<div />").width("100%").height("100%").css({
            zIndex: 310,
            position: "absolute",
            overflow: "hidden"
        }), $hdl_holder = $("<div />").width("100%").height("100%").css("zIndex", 320), $sel = $("<div />").css({
            position: "absolute",
            zIndex: 600
        }).dblclick(function() {
            var c = Coords.getFixed();
            options.onDblClick.call(api, c);
        }).insertBefore($img).append($img_holder, $hdl_holder);
        img_mode && ($img2 = $("<img />").attr("src", $img.attr("src")).css(img_css).width(boundx).height(boundy), 
        $img_holder.append($img2)), ie6mode && $sel.css({
            overflowY: "hidden"
        });
        var xlimit, ylimit, xmin, ymin, xscale, yscale, btndown, animating, shift_down, bound = options.boundary, $trk = newTracker().width(boundx + 2 * bound).height(boundy + 2 * bound).css({
            position: "absolute",
            top: px(-bound),
            left: px(-bound),
            zIndex: 290
        }).mousedown(newSelection), bgcolor = options.bgColor, bgopacity = options.bgOpacity;
        docOffset = getPos($img);
        var Touch = function() {
            function hasTouchSupport() {
                var i, support = {}, events = [ "touchstart", "touchmove", "touchend" ], el = document.createElement("div");
                try {
                    for (i = 0; i < events.length; i++) {
                        var eventName = events[i];
                        eventName = "on" + eventName;
                        var isSupported = eventName in el;
                        isSupported || (el.setAttribute(eventName, "return;"), isSupported = "function" == typeof el[eventName]), 
                        support[events[i]] = isSupported;
                    }
                    return support.touchstart && support.touchend && support.touchmove;
                } catch (err) {
                    return !1;
                }
            }
            function detectSupport() {
                return options.touchSupport === !0 || options.touchSupport === !1 ? options.touchSupport : hasTouchSupport();
            }
            return {
                createDragger: function(ord) {
                    return function(e) {
                        return options.disabled ? !1 : "move" !== ord || options.allowMove ? (docOffset = getPos($img), 
                        btndown = !0, startDragMode(ord, mouseAbs(Touch.cfilter(e)), !0), e.stopPropagation(), 
                        e.preventDefault(), !1) : !1;
                    };
                },
                newSelection: function(e) {
                    return newSelection(Touch.cfilter(e));
                },
                cfilter: function(e) {
                    return e.pageX = e.originalEvent.changedTouches[0].pageX, e.pageY = e.originalEvent.changedTouches[0].pageY, 
                    e;
                },
                isSupported: hasTouchSupport,
                support: detectSupport()
            };
        }(), Coords = function() {
            function setPressed(pos) {
                pos = rebound(pos), x2 = x1 = pos[0], y2 = y1 = pos[1];
            }
            function setCurrent(pos) {
                pos = rebound(pos), ox = pos[0] - x2, oy = pos[1] - y2, x2 = pos[0], y2 = pos[1];
            }
            function getOffset() {
                return [ ox, oy ];
            }
            function moveOffset(offset) {
                var ox = offset[0], oy = offset[1];
                0 > x1 + ox && (ox -= ox + x1), 0 > y1 + oy && (oy -= oy + y1), y2 + oy > boundy && (oy += boundy - (y2 + oy)), 
                x2 + ox > boundx && (ox += boundx - (x2 + ox)), x1 += ox, x2 += ox, y1 += oy, y2 += oy;
            }
            function getCorner(ord) {
                var c = getFixed();
                switch (ord) {
                  case "ne":
                    return [ c.x2, c.y ];

                  case "nw":
                    return [ c.x, c.y ];

                  case "se":
                    return [ c.x2, c.y2 ];

                  case "sw":
                    return [ c.x, c.y2 ];
                }
            }
            function getFixed() {
                if (!options.aspectRatio) return getRect();
                var xx, yy, w, h, aspect = options.aspectRatio, min_x = options.minSize[0] / xscale, max_x = options.maxSize[0] / xscale, max_y = options.maxSize[1] / yscale, rw = x2 - x1, rh = y2 - y1, rwa = Math.abs(rw), rha = Math.abs(rh), real_ratio = rwa / rha;
                return 0 === max_x && (max_x = 10 * boundx), 0 === max_y && (max_y = 10 * boundy), 
                aspect > real_ratio ? (yy = y2, w = rha * aspect, xx = 0 > rw ? x1 - w : w + x1, 
                0 > xx ? (xx = 0, h = Math.abs((xx - x1) / aspect), yy = 0 > rh ? y1 - h : h + y1) : xx > boundx && (xx = boundx, 
                h = Math.abs((xx - x1) / aspect), yy = 0 > rh ? y1 - h : h + y1)) : (xx = x2, h = rwa / aspect, 
                yy = 0 > rh ? y1 - h : y1 + h, 0 > yy ? (yy = 0, w = Math.abs((yy - y1) * aspect), 
                xx = 0 > rw ? x1 - w : w + x1) : yy > boundy && (yy = boundy, w = Math.abs(yy - y1) * aspect, 
                xx = 0 > rw ? x1 - w : w + x1)), xx > x1 ? (min_x > xx - x1 ? xx = x1 + min_x : xx - x1 > max_x && (xx = x1 + max_x), 
                yy = yy > y1 ? y1 + (xx - x1) / aspect : y1 - (xx - x1) / aspect) : x1 > xx && (min_x > x1 - xx ? xx = x1 - min_x : x1 - xx > max_x && (xx = x1 - max_x), 
                yy = yy > y1 ? y1 + (x1 - xx) / aspect : y1 - (x1 - xx) / aspect), 0 > xx ? (x1 -= xx, 
                xx = 0) : xx > boundx && (x1 -= xx - boundx, xx = boundx), 0 > yy ? (y1 -= yy, yy = 0) : yy > boundy && (y1 -= yy - boundy, 
                yy = boundy), makeObj(flipCoords(x1, y1, xx, yy));
            }
            function rebound(p) {
                return p[0] < 0 && (p[0] = 0), p[1] < 0 && (p[1] = 0), p[0] > boundx && (p[0] = boundx), 
                p[1] > boundy && (p[1] = boundy), [ Math.round(p[0]), Math.round(p[1]) ];
            }
            function flipCoords(x1, y1, x2, y2) {
                var xa = x1, xb = x2, ya = y1, yb = y2;
                return x1 > x2 && (xa = x2, xb = x1), y1 > y2 && (ya = y2, yb = y1), [ xa, ya, xb, yb ];
            }
            function getRect() {
                var delta, xsize = x2 - x1, ysize = y2 - y1;
                return xlimit && Math.abs(xsize) > xlimit && (x2 = xsize > 0 ? x1 + xlimit : x1 - xlimit), 
                ylimit && Math.abs(ysize) > ylimit && (y2 = ysize > 0 ? y1 + ylimit : y1 - ylimit), 
                ymin / yscale && Math.abs(ysize) < ymin / yscale && (y2 = ysize > 0 ? y1 + ymin / yscale : y1 - ymin / yscale), 
                xmin / xscale && Math.abs(xsize) < xmin / xscale && (x2 = xsize > 0 ? x1 + xmin / xscale : x1 - xmin / xscale), 
                0 > x1 && (x2 -= x1, x1 -= x1), 0 > y1 && (y2 -= y1, y1 -= y1), 0 > x2 && (x1 -= x2, 
                x2 -= x2), 0 > y2 && (y1 -= y2, y2 -= y2), x2 > boundx && (delta = x2 - boundx, 
                x1 -= delta, x2 -= delta), y2 > boundy && (delta = y2 - boundy, y1 -= delta, y2 -= delta), 
                x1 > boundx && (delta = x1 - boundy, y2 -= delta, y1 -= delta), y1 > boundy && (delta = y1 - boundy, 
                y2 -= delta, y1 -= delta), makeObj(flipCoords(x1, y1, x2, y2));
            }
            function makeObj(a) {
                return {
                    x: a[0],
                    y: a[1],
                    x2: a[2],
                    y2: a[3],
                    w: a[2] - a[0],
                    h: a[3] - a[1]
                };
            }
            var ox, oy, x1 = 0, y1 = 0, x2 = 0, y2 = 0;
            return {
                flipCoords: flipCoords,
                setPressed: setPressed,
                setCurrent: setCurrent,
                getOffset: getOffset,
                moveOffset: moveOffset,
                getCorner: getCorner,
                getFixed: getFixed
            };
        }(), Shade = function() {
            function resizeShades(w, h) {
                shades.left.css({
                    height: px(h)
                }), shades.right.css({
                    height: px(h)
                });
            }
            function updateAuto() {
                return updateShade(Coords.getFixed());
            }
            function updateShade(c) {
                shades.top.css({
                    left: px(c.x),
                    width: px(c.w),
                    height: px(c.y)
                }), shades.bottom.css({
                    top: px(c.y2),
                    left: px(c.x),
                    width: px(c.w),
                    height: px(boundy - c.y2)
                }), shades.right.css({
                    left: px(c.x2),
                    width: px(boundx - c.x2)
                }), shades.left.css({
                    width: px(c.x)
                });
            }
            function createShade() {
                return $("<div />").css({
                    position: "absolute",
                    backgroundColor: options.shadeColor || options.bgColor
                }).appendTo(holder);
            }
            function enableShade() {
                enabled || (enabled = !0, holder.insertBefore($img), updateAuto(), Selection.setBgOpacity(1, 0, 1), 
                $img2.hide(), setBgColor(options.shadeColor || options.bgColor, 1), Selection.isAwake() ? setOpacity(options.bgOpacity, 1) : setOpacity(1, 1));
            }
            function setBgColor(color, now) {
                colorChangeMacro(getShades(), color, now);
            }
            function disableShade() {
                enabled && (holder.remove(), $img2.show(), enabled = !1, Selection.isAwake() ? Selection.setBgOpacity(options.bgOpacity, 1, 1) : (Selection.setBgOpacity(1, 1, 1), 
                Selection.disableHandles()), colorChangeMacro($div, 0, 1));
            }
            function setOpacity(opacity, now) {
                enabled && (options.bgFade && !now ? holder.animate({
                    opacity: 1 - opacity
                }, {
                    queue: !1,
                    duration: options.fadeTime
                }) : holder.css({
                    opacity: 1 - opacity
                }));
            }
            function refreshAll() {
                options.shade ? enableShade() : disableShade(), Selection.isAwake() && setOpacity(options.bgOpacity);
            }
            function getShades() {
                return holder.children();
            }
            var enabled = !1, holder = $("<div />").css({
                position: "absolute",
                zIndex: 240,
                opacity: 0
            }), shades = {
                top: createShade(),
                left: createShade().height(boundy),
                right: createShade().height(boundy),
                bottom: createShade()
            };
            return {
                update: updateAuto,
                updateRaw: updateShade,
                getShades: getShades,
                setBgColor: setBgColor,
                enable: enableShade,
                disable: disableShade,
                resize: resizeShades,
                refresh: refreshAll,
                opacity: setOpacity
            };
        }(), Selection = function() {
            function insertBorder(type) {
                var jq = $("<div />").css({
                    position: "absolute",
                    opacity: options.borderOpacity
                }).addClass(cssClass(type));
                return $img_holder.append(jq), jq;
            }
            function dragDiv(ord, zi) {
                var jq = $("<div />").mousedown(createDragger(ord)).css({
                    cursor: ord + "-resize",
                    position: "absolute",
                    zIndex: zi
                }).addClass("ord-" + ord);
                return Touch.support && jq.bind("touchstart.jcrop", Touch.createDragger(ord)), $hdl_holder.append(jq), 
                jq;
            }
            function insertHandle(ord) {
                var hs = options.handleSize, div = dragDiv(ord, hdep++).css({
                    opacity: options.handleOpacity
                }).addClass(cssClass("handle"));
                return hs && div.width(hs).height(hs), div;
            }
            function insertDragbar(ord) {
                return dragDiv(ord, hdep++).addClass("jcrop-dragbar");
            }
            function createDragbars(li) {
                var i;
                for (i = 0; i < li.length; i++) dragbar[li[i]] = insertDragbar(li[i]);
            }
            function createBorders(li) {
                var cl, i;
                for (i = 0; i < li.length; i++) {
                    switch (li[i]) {
                      case "n":
                        cl = "hline";
                        break;

                      case "s":
                        cl = "hline bottom";
                        break;

                      case "e":
                        cl = "vline right";
                        break;

                      case "w":
                        cl = "vline";
                    }
                    borders[li[i]] = insertBorder(cl);
                }
            }
            function createHandles(li) {
                var i;
                for (i = 0; i < li.length; i++) handle[li[i]] = insertHandle(li[i]);
            }
            function moveto(x, y) {
                options.shade || $img2.css({
                    top: px(-y),
                    left: px(-x)
                }), $sel.css({
                    top: px(y),
                    left: px(x)
                });
            }
            function resize(w, h) {
                $sel.width(Math.round(w)).height(Math.round(h));
            }
            function refresh() {
                var c = Coords.getFixed();
                Coords.setPressed([ c.x, c.y ]), Coords.setCurrent([ c.x2, c.y2 ]), updateVisible();
            }
            function updateVisible(select) {
                return awake ? update(select) : void 0;
            }
            function update(select) {
                var c = Coords.getFixed();
                resize(c.w, c.h), moveto(c.x, c.y), options.shade && Shade.updateRaw(c), awake || show(), 
                select ? options.onSelect.call(api, unscale(c)) : options.onChange.call(api, unscale(c));
            }
            function setBgOpacity(opacity, force, now) {
                (awake || force) && (options.bgFade && !now ? $img.animate({
                    opacity: opacity
                }, {
                    queue: !1,
                    duration: options.fadeTime
                }) : $img.css("opacity", opacity));
            }
            function show() {
                $sel.show(), options.shade ? Shade.opacity(bgopacity) : setBgOpacity(bgopacity, !0), 
                awake = !0;
            }
            function release() {
                disableHandles(), $sel.hide(), options.shade ? Shade.opacity(1) : setBgOpacity(1), 
                awake = !1, options.onRelease.call(api);
            }
            function showHandles() {
                seehandles && $hdl_holder.show();
            }
            function enableHandles() {
                return seehandles = !0, options.allowResize ? ($hdl_holder.show(), !0) : void 0;
            }
            function disableHandles() {
                seehandles = !1, $hdl_holder.hide();
            }
            function animMode(v) {
                v ? (animating = !0, disableHandles()) : (animating = !1, enableHandles());
            }
            function done() {
                animMode(!1), refresh();
            }
            var awake, hdep = 370, borders = {}, handle = {}, dragbar = {}, seehandles = !1;
            options.dragEdges && $.isArray(options.createDragbars) && createDragbars(options.createDragbars), 
            $.isArray(options.createHandles) && createHandles(options.createHandles), options.drawBorders && $.isArray(options.createBorders) && createBorders(options.createBorders), 
            $(document).bind("touchstart.jcrop-ios", function(e) {
                $(e.currentTarget).hasClass("jcrop-tracker") && e.stopPropagation();
            });
            var $track = newTracker().mousedown(createDragger("move")).css({
                cursor: "move",
                position: "absolute",
                zIndex: 360
            });
            return Touch.support && $track.bind("touchstart.jcrop", Touch.createDragger("move")), 
            $img_holder.append($track), disableHandles(), {
                updateVisible: updateVisible,
                update: update,
                release: release,
                refresh: refresh,
                isAwake: function() {
                    return awake;
                },
                setCursor: function(cursor) {
                    $track.css("cursor", cursor);
                },
                enableHandles: enableHandles,
                enableOnly: function() {
                    seehandles = !0;
                },
                showHandles: showHandles,
                disableHandles: disableHandles,
                animMode: animMode,
                setBgOpacity: setBgOpacity,
                done: done
            };
        }(), Tracker = function() {
            function toFront(touch) {
                $trk.css({
                    zIndex: 450
                }), touch ? $(document).bind("touchmove.jcrop", trackTouchMove).bind("touchend.jcrop", trackTouchEnd) : trackDoc && $(document).bind("mousemove.jcrop", trackMove).bind("mouseup.jcrop", trackUp);
            }
            function toBack() {
                $trk.css({
                    zIndex: 290
                }), $(document).unbind(".jcrop");
            }
            function trackMove(e) {
                return onMove(mouseAbs(e)), !1;
            }
            function trackUp(e) {
                return e.preventDefault(), e.stopPropagation(), btndown && (btndown = !1, onDone(mouseAbs(e)), 
                Selection.isAwake() && options.onSelect.call(api, unscale(Coords.getFixed())), toBack(), 
                onMove = function() {}, onDone = function() {}), !1;
            }
            function activateHandlers(move, done, touch) {
                return btndown = !0, onMove = move, onDone = done, toFront(touch), !1;
            }
            function trackTouchMove(e) {
                return onMove(mouseAbs(Touch.cfilter(e))), !1;
            }
            function trackTouchEnd(e) {
                return trackUp(Touch.cfilter(e));
            }
            function setCursor(t) {
                $trk.css("cursor", t);
            }
            var onMove = function() {}, onDone = function() {}, trackDoc = options.trackDocument;
            return trackDoc || $trk.mousemove(trackMove).mouseup(trackUp).mouseout(trackUp), 
            $img.before($trk), {
                activateHandlers: activateHandlers,
                setCursor: setCursor
            };
        }(), KeyManager = function() {
            function watchKeys() {
                options.keySupport && ($keymgr.show(), $keymgr.focus());
            }
            function onBlur(e) {
                $keymgr.hide();
            }
            function doNudge(e, x, y) {
                options.allowMove && (Coords.moveOffset([ x, y ]), Selection.updateVisible(!0)), 
                e.preventDefault(), e.stopPropagation();
            }
            function parseKey(e) {
                if (e.ctrlKey || e.metaKey) return !0;
                shift_down = e.shiftKey ? !0 : !1;
                var nudge = shift_down ? 10 : 1;
                switch (e.keyCode) {
                  case 37:
                    doNudge(e, -nudge, 0);
                    break;

                  case 39:
                    doNudge(e, nudge, 0);
                    break;

                  case 38:
                    doNudge(e, 0, -nudge);
                    break;

                  case 40:
                    doNudge(e, 0, nudge);
                    break;

                  case 27:
                    options.allowSelect && Selection.release();
                    break;

                  case 9:
                    return !0;
                }
                return !1;
            }
            var $keymgr = $('<input type="radio" />').css({
                position: "fixed",
                left: "-120px",
                width: "12px"
            }).addClass("jcrop-keymgr"), $keywrap = $("<div />").css({
                position: "absolute",
                overflow: "hidden"
            }).append($keymgr);
            return options.keySupport && ($keymgr.keydown(parseKey).blur(onBlur), ie6mode || !options.fixedSupport ? ($keymgr.css({
                position: "absolute",
                left: "-20px"
            }), $keywrap.append($keymgr).insertBefore($img)) : $keymgr.insertBefore($img)), 
            {
                watchKeys: watchKeys
            };
        }();
        Touch.support && $trk.bind("touchstart.jcrop", Touch.newSelection), $hdl_holder.hide(), 
        interfaceUpdate(!0);
        var api = {
            setImage: setImage,
            animateTo: animateTo,
            setSelect: setSelect,
            setOptions: setOptionsNew,
            tellSelect: tellSelect,
            tellScaled: tellScaled,
            setClass: setClass,
            disable: disableCrop,
            enable: enableCrop,
            cancel: cancelCrop,
            release: Selection.release,
            destroy: destroy,
            focus: KeyManager.watchKeys,
            getBounds: function() {
                return [ boundx * xscale, boundy * yscale ];
            },
            getWidgetSize: function() {
                return [ boundx, boundy ];
            },
            getScaleFactor: function() {
                return [ xscale, yscale ];
            },
            getOptions: function() {
                return options;
            },
            ui: {
                holder: $div,
                selection: $sel
            }
        };
        return is_msie && $div.bind("selectstart", function() {
            return !1;
        }), $origimg.data("Jcrop", api), api;
    }, $.fn.Jcrop = function(options, callback) {
        var api;
        return this.each(function() {
            if ($(this).data("Jcrop")) {
                if ("api" === options) return $(this).data("Jcrop");
                $(this).data("Jcrop").setOptions(options);
            } else "IMG" == this.tagName ? $.Jcrop.Loader(this, function() {
                $(this).css({
                    display: "block",
                    visibility: "hidden"
                }), api = $.Jcrop(this, options), $.isFunction(callback) && callback.call(api);
            }) : ($(this).css({
                display: "block",
                visibility: "hidden"
            }), api = $.Jcrop(this, options), $.isFunction(callback) && callback.call(api));
        }), this;
    }, $.Jcrop.Loader = function(imgobj, success, error) {
        function completeCheck() {
            img.complete ? ($img.unbind(".jcloader"), $.isFunction(success) && success.call(img)) : window.setTimeout(completeCheck, 50);
        }
        var $img = $(imgobj), img = $img[0];
        $img.bind("load.jcloader", completeCheck).bind("error.jcloader", function(e) {
            $img.unbind(".jcloader"), $.isFunction(error) && error.call(img);
        }), img.complete && $.isFunction(success) && ($img.unbind(".jcloader"), success.call(img));
    }, $.Jcrop.defaults = {
        allowSelect: !0,
        allowMove: !0,
        allowResize: !0,
        trackDocument: !0,
        baseClass: "jcrop",
        addClass: null,
        bgColor: "black",
        bgOpacity: .6,
        bgFade: !1,
        borderOpacity: .4,
        handleOpacity: .5,
        handleSize: null,
        aspectRatio: 0,
        keySupport: !0,
        createHandles: [ "n", "s", "e", "w", "nw", "ne", "se", "sw" ],
        createDragbars: [ "n", "s", "e", "w" ],
        createBorders: [ "n", "s", "e", "w" ],
        drawBorders: !0,
        dragEdges: !0,
        fixedSupport: !0,
        touchSupport: null,
        shade: null,
        boxWidth: 0,
        boxHeight: 0,
        boundary: 2,
        fadeTime: 400,
        animationDelay: 20,
        swingSpeed: 3,
        minSelect: [ 0, 0 ],
        maxSize: [ 0, 0 ],
        minSize: [ 0, 0 ],
        onChange: function() {},
        onSelect: function() {},
        onDblClick: function() {},
        onRelease: function() {}
    };
}(jQuery), !function() {
    "use strict";
    var e = angular.module("ngImgCrop", []);
    e.factory("cropAreaCircle", [ "cropArea", function(e) {
        var t = function() {
            e.apply(this, arguments), this._boxResizeBaseSize = 20, this._boxResizeNormalRatio = .9, 
            this._boxResizeHoverRatio = 1.2, this._iconMoveNormalRatio = .9, this._iconMoveHoverRatio = 1.2, 
            this._boxResizeNormalSize = this._boxResizeBaseSize * this._boxResizeNormalRatio, 
            this._boxResizeHoverSize = this._boxResizeBaseSize * this._boxResizeHoverRatio, 
            this._posDragStartX = 0, this._posDragStartY = 0, this._posResizeStartX = 0, this._posResizeStartY = 0, 
            this._posResizeStartSize = 0, this._boxResizeIsHover = !1, this._areaIsHover = !1, 
            this._boxResizeIsDragging = !1, this._areaIsDragging = !1;
        };
        return t.prototype = new e(), t.prototype._calcCirclePerimeterCoords = function(e) {
            var t = this._size / 2, i = e * (Math.PI / 180), r = this._x + t * Math.cos(i), s = this._y + t * Math.sin(i);
            return [ r, s ];
        }, t.prototype._calcResizeIconCenterCoords = function() {
            return this._calcCirclePerimeterCoords(-45);
        }, t.prototype._isCoordWithinArea = function(e) {
            return Math.sqrt((e[0] - this._x) * (e[0] - this._x) + (e[1] - this._y) * (e[1] - this._y)) < this._size / 2;
        }, t.prototype._isCoordWithinBoxResize = function(e) {
            var t = this._calcResizeIconCenterCoords(), i = this._boxResizeHoverSize / 2;
            return e[0] > t[0] - i && e[0] < t[0] + i && e[1] > t[1] - i && e[1] < t[1] + i;
        }, t.prototype._drawArea = function(e, t, i) {
            e.arc(t[0], t[1], i / 2, 0, 2 * Math.PI);
        }, t.prototype.draw = function() {
            e.prototype.draw.apply(this, arguments), this._cropCanvas.drawIconMove([ this._x, this._y ], this._areaIsHover ? this._iconMoveHoverRatio : this._iconMoveNormalRatio), 
            this._cropCanvas.drawIconResizeBoxNESW(this._calcResizeIconCenterCoords(), this._boxResizeBaseSize, this._boxResizeIsHover ? this._boxResizeHoverRatio : this._boxResizeNormalRatio);
        }, t.prototype.processMouseMove = function(e, t) {
            var i = "default", r = !1;
            if (this._boxResizeIsHover = !1, this._areaIsHover = !1, this._areaIsDragging) this._x = e - this._posDragStartX, 
            this._y = t - this._posDragStartY, this._areaIsHover = !0, i = "move", r = !0, this._events.trigger("area-move"); else if (this._boxResizeIsDragging) {
                i = "nesw-resize";
                var s, o, a;
                o = e - this._posResizeStartX, a = this._posResizeStartY - t, s = o > a ? this._posResizeStartSize + 2 * a : this._posResizeStartSize + 2 * o, 
                this._size = Math.max(this._minSize, s), this._boxResizeIsHover = !0, r = !0, this._events.trigger("area-resize");
            } else this._isCoordWithinBoxResize([ e, t ]) ? (i = "nesw-resize", this._areaIsHover = !1, 
            this._boxResizeIsHover = !0, r = !0) : this._isCoordWithinArea([ e, t ]) && (i = "move", 
            this._areaIsHover = !0, r = !0);
            return this._dontDragOutside(), angular.element(this._ctx.canvas).css({
                cursor: i
            }), r;
        }, t.prototype.processMouseDown = function(e, t) {
            this._isCoordWithinBoxResize([ e, t ]) ? (this._areaIsDragging = !1, this._areaIsHover = !1, 
            this._boxResizeIsDragging = !0, this._boxResizeIsHover = !0, this._posResizeStartX = e, 
            this._posResizeStartY = t, this._posResizeStartSize = this._size, this._events.trigger("area-resize-start")) : this._isCoordWithinArea([ e, t ]) && (this._areaIsDragging = !0, 
            this._areaIsHover = !0, this._boxResizeIsDragging = !1, this._boxResizeIsHover = !1, 
            this._posDragStartX = e - this._x, this._posDragStartY = t - this._y, this._events.trigger("area-move-start"));
        }, t.prototype.processMouseUp = function() {
            this._areaIsDragging && (this._areaIsDragging = !1, this._events.trigger("area-move-end")), 
            this._boxResizeIsDragging && (this._boxResizeIsDragging = !1, this._events.trigger("area-resize-end")), 
            this._areaIsHover = !1, this._boxResizeIsHover = !1, this._posDragStartX = 0, this._posDragStartY = 0;
        }, t;
    } ]), e.factory("cropAreaSquare", [ "cropArea", function(e) {
        var t = function() {
            e.apply(this, arguments), this._resizeCtrlBaseRadius = 10, this._resizeCtrlNormalRatio = .75, 
            this._resizeCtrlHoverRatio = 1, this._iconMoveNormalRatio = .9, this._iconMoveHoverRatio = 1.2, 
            this._resizeCtrlNormalRadius = this._resizeCtrlBaseRadius * this._resizeCtrlNormalRatio, 
            this._resizeCtrlHoverRadius = this._resizeCtrlBaseRadius * this._resizeCtrlHoverRatio, 
            this._posDragStartX = 0, this._posDragStartY = 0, this._posResizeStartX = 0, this._posResizeStartY = 0, 
            this._posResizeStartSize = 0, this._resizeCtrlIsHover = -1, this._areaIsHover = !1, 
            this._resizeCtrlIsDragging = -1, this._areaIsDragging = !1;
        };
        return t.prototype = new e(), t.prototype._calcSquareCorners = function() {
            var e = this._size / 2;
            return [ [ this._x - e, this._y - e ], [ this._x + e, this._y - e ], [ this._x - e, this._y + e ], [ this._x + e, this._y + e ] ];
        }, t.prototype._calcSquareDimensions = function() {
            var e = this._size / 2;
            return {
                left: this._x - e,
                top: this._y - e,
                right: this._x + e,
                bottom: this._y + e
            };
        }, t.prototype._isCoordWithinArea = function(e) {
            var t = this._calcSquareDimensions();
            return e[0] >= t.left && e[0] <= t.right && e[1] >= t.top && e[1] <= t.bottom;
        }, t.prototype._isCoordWithinResizeCtrl = function(e) {
            for (var t = this._calcSquareCorners(), i = -1, r = 0, s = t.length; s > r; r++) {
                var o = t[r];
                if (e[0] > o[0] - this._resizeCtrlHoverRadius && e[0] < o[0] + this._resizeCtrlHoverRadius && e[1] > o[1] - this._resizeCtrlHoverRadius && e[1] < o[1] + this._resizeCtrlHoverRadius) {
                    i = r;
                    break;
                }
            }
            return i;
        }, t.prototype._drawArea = function(e, t, i) {
            var r = i / 2;
            e.rect(t[0] - r, t[1] - r, i, i);
        }, t.prototype.draw = function() {
            e.prototype.draw.apply(this, arguments), this._cropCanvas.drawIconMove([ this._x, this._y ], this._areaIsHover ? this._iconMoveHoverRatio : this._iconMoveNormalRatio);
            for (var t = this._calcSquareCorners(), i = 0, r = t.length; r > i; i++) {
                var s = t[i];
                this._cropCanvas.drawIconResizeCircle(s, this._resizeCtrlBaseRadius, this._resizeCtrlIsHover === i ? this._resizeCtrlHoverRatio : this._resizeCtrlNormalRatio);
            }
        }, t.prototype.processMouseMove = function(e, t) {
            var i = "default", r = !1;
            if (this._resizeCtrlIsHover = -1, this._areaIsHover = !1, this._areaIsDragging) this._x = e - this._posDragStartX, 
            this._y = t - this._posDragStartY, this._areaIsHover = !0, i = "move", r = !0, this._events.trigger("area-move"); else if (this._resizeCtrlIsDragging > -1) {
                var s, o;
                switch (this._resizeCtrlIsDragging) {
                  case 0:
                    s = -1, o = -1, i = "nwse-resize";
                    break;

                  case 1:
                    s = 1, o = -1, i = "nesw-resize";
                    break;

                  case 2:
                    s = -1, o = 1, i = "nesw-resize";
                    break;

                  case 3:
                    s = 1, o = 1, i = "nwse-resize";
                }
                var a, n = (e - this._posResizeStartX) * s, h = (t - this._posResizeStartY) * o;
                a = n > h ? this._posResizeStartSize + h : this._posResizeStartSize + n;
                var c = this._size;
                this._size = Math.max(this._minSize, a);
                var l = (this._size - c) / 2;
                this._x += l * s, this._y += l * o, this._resizeCtrlIsHover = this._resizeCtrlIsDragging, 
                r = !0, this._events.trigger("area-resize");
            } else {
                var u = this._isCoordWithinResizeCtrl([ e, t ]);
                if (u > -1) {
                    switch (u) {
                      case 0:
                        i = "nwse-resize";
                        break;

                      case 1:
                        i = "nesw-resize";
                        break;

                      case 2:
                        i = "nesw-resize";
                        break;

                      case 3:
                        i = "nwse-resize";
                    }
                    this._areaIsHover = !1, this._resizeCtrlIsHover = u, r = !0;
                } else this._isCoordWithinArea([ e, t ]) && (i = "move", this._areaIsHover = !0, 
                r = !0);
            }
            return this._dontDragOutside(), angular.element(this._ctx.canvas).css({
                cursor: i
            }), r;
        }, t.prototype.processMouseDown = function(e, t) {
            var i = this._isCoordWithinResizeCtrl([ e, t ]);
            i > -1 ? (this._areaIsDragging = !1, this._areaIsHover = !1, this._resizeCtrlIsDragging = i, 
            this._resizeCtrlIsHover = i, this._posResizeStartX = e, this._posResizeStartY = t, 
            this._posResizeStartSize = this._size, this._events.trigger("area-resize-start")) : this._isCoordWithinArea([ e, t ]) && (this._areaIsDragging = !0, 
            this._areaIsHover = !0, this._resizeCtrlIsDragging = -1, this._resizeCtrlIsHover = -1, 
            this._posDragStartX = e - this._x, this._posDragStartY = t - this._y, this._events.trigger("area-move-start"));
        }, t.prototype.processMouseUp = function() {
            this._areaIsDragging && (this._areaIsDragging = !1, this._events.trigger("area-move-end")), 
            this._resizeCtrlIsDragging > -1 && (this._resizeCtrlIsDragging = -1, this._events.trigger("area-resize-end")), 
            this._areaIsHover = !1, this._resizeCtrlIsHover = -1, this._posDragStartX = 0, this._posDragStartY = 0;
        }, t;
    } ]), e.factory("cropArea", [ "cropCanvas", function(e) {
        var t = function(t, i) {
            this._ctx = t, this._events = i, this._minSize = 80, this._cropCanvas = new e(t), 
            this._image = new Image(), this._x = 0, this._y = 0, this._size = 200;
        };
        return t.prototype.getImage = function() {
            return this._image;
        }, t.prototype.setImage = function(e) {
            this._image = e;
        }, t.prototype.getX = function() {
            return this._x;
        }, t.prototype.setX = function(e) {
            this._x = e, this._dontDragOutside();
        }, t.prototype.getY = function() {
            return this._y;
        }, t.prototype.setY = function(e) {
            this._y = e, this._dontDragOutside();
        }, t.prototype.getSize = function() {
            return this._size;
        }, t.prototype.setSize = function(e) {
            this._size = Math.max(this._minSize, e), this._dontDragOutside();
        }, t.prototype.getMinSize = function() {
            return this._minSize;
        }, t.prototype.setMinSize = function(e) {
            this._minSize = e, this._size = Math.max(this._minSize, this._size), this._dontDragOutside();
        }, t.prototype._dontDragOutside = function() {
            var e = this._ctx.canvas.height, t = this._ctx.canvas.width;
            this._size > t && (this._size = t), this._size > e && (this._size = e), this._x < this._size / 2 && (this._x = this._size / 2), 
            this._x > t - this._size / 2 && (this._x = t - this._size / 2), this._y < this._size / 2 && (this._y = this._size / 2), 
            this._y > e - this._size / 2 && (this._y = e - this._size / 2);
        }, t.prototype._drawArea = function() {}, t.prototype.draw = function() {
            this._cropCanvas.drawCropArea(this._image, [ this._x, this._y ], this._size, this._drawArea);
        }, t.prototype.processMouseMove = function() {}, t.prototype.processMouseDown = function() {}, 
        t.prototype.processMouseUp = function() {}, t;
    } ]), e.factory("cropCanvas", [ function() {
        var e = [ [ -.5, -2 ], [ -3, -4.5 ], [ -.5, -7 ], [ -7, -7 ], [ -7, -.5 ], [ -4.5, -3 ], [ -2, -.5 ] ], t = [ [ .5, -2 ], [ 3, -4.5 ], [ .5, -7 ], [ 7, -7 ], [ 7, -.5 ], [ 4.5, -3 ], [ 2, -.5 ] ], i = [ [ -.5, 2 ], [ -3, 4.5 ], [ -.5, 7 ], [ -7, 7 ], [ -7, .5 ], [ -4.5, 3 ], [ -2, .5 ] ], r = [ [ .5, 2 ], [ 3, 4.5 ], [ .5, 7 ], [ 7, 7 ], [ 7, .5 ], [ 4.5, 3 ], [ 2, .5 ] ], s = [ [ -1.5, -2.5 ], [ -1.5, -6 ], [ -5, -6 ], [ 0, -11 ], [ 5, -6 ], [ 1.5, -6 ], [ 1.5, -2.5 ] ], o = [ [ -2.5, -1.5 ], [ -6, -1.5 ], [ -6, -5 ], [ -11, 0 ], [ -6, 5 ], [ -6, 1.5 ], [ -2.5, 1.5 ] ], a = [ [ -1.5, 2.5 ], [ -1.5, 6 ], [ -5, 6 ], [ 0, 11 ], [ 5, 6 ], [ 1.5, 6 ], [ 1.5, 2.5 ] ], n = [ [ 2.5, -1.5 ], [ 6, -1.5 ], [ 6, -5 ], [ 11, 0 ], [ 6, 5 ], [ 6, 1.5 ], [ 2.5, 1.5 ] ], h = {
            areaOutline: "#fff",
            resizeBoxStroke: "#fff",
            resizeBoxFill: "#444",
            resizeBoxArrowFill: "#fff",
            resizeCircleStroke: "#fff",
            resizeCircleFill: "#444",
            moveIconFill: "#fff"
        };
        return function(c) {
            var l = function(e, t, i) {
                return [ i * e[0] + t[0], i * e[1] + t[1] ];
            }, u = function(e, t, i, r) {
                c.save(), c.fillStyle = t, c.beginPath();
                var s, o = l(e[0], i, r);
                c.moveTo(o[0], o[1]);
                for (var a in e) a > 0 && (s = l(e[a], i, r), c.lineTo(s[0], s[1]));
                c.lineTo(o[0], o[1]), c.fill(), c.closePath(), c.restore();
            };
            this.drawIconMove = function(e, t) {
                u(s, h.moveIconFill, e, t), u(o, h.moveIconFill, e, t), u(a, h.moveIconFill, e, t), 
                u(n, h.moveIconFill, e, t);
            }, this.drawIconResizeCircle = function(e, t, i) {
                var r = t * i;
                c.save(), c.strokeStyle = h.resizeCircleStroke, c.lineWidth = 2, c.fillStyle = h.resizeCircleFill, 
                c.beginPath(), c.arc(e[0], e[1], r, 0, 2 * Math.PI), c.fill(), c.stroke(), c.closePath(), 
                c.restore();
            }, this.drawIconResizeBoxBase = function(e, t, i) {
                var r = t * i;
                c.save(), c.strokeStyle = h.resizeBoxStroke, c.lineWidth = 2, c.fillStyle = h.resizeBoxFill, 
                c.fillRect(e[0] - r / 2, e[1] - r / 2, r, r), c.strokeRect(e[0] - r / 2, e[1] - r / 2, r, r), 
                c.restore();
            }, this.drawIconResizeBoxNESW = function(e, r, s) {
                this.drawIconResizeBoxBase(e, r, s), u(t, h.resizeBoxArrowFill, e, s), u(i, h.resizeBoxArrowFill, e, s);
            }, this.drawIconResizeBoxNWSE = function(t, i, s) {
                this.drawIconResizeBoxBase(t, i, s), u(e, h.resizeBoxArrowFill, t, s), u(r, h.resizeBoxArrowFill, t, s);
            }, this.drawCropArea = function(e, t, i, r) {
                var s = e.width / c.canvas.width, o = e.height / c.canvas.height, a = t[0] - i / 2, n = t[1] - i / 2;
                c.save(), c.strokeStyle = h.areaOutline, c.lineWidth = 2, c.beginPath(), r(c, t, i), 
                c.stroke(), c.clip(), i > 0 && c.drawImage(e, a * s, n * o, i * s, i * o, a, n, i, i), 
                c.beginPath(), r(c, t, i), c.stroke(), c.clip(), c.restore();
            };
        };
    } ]), e.service("cropEXIF", [ function() {
        function e(e) {
            return !!e.exifdata;
        }
        function t(e, t) {
            t = t || e.match(/^data\:([^\;]+)\;base64,/im)[1] || "", e = e.replace(/^data\:([^\;]+)\;base64,/gim, "");
            for (var i = atob(e), r = i.length, s = new ArrayBuffer(r), o = new Uint8Array(s), a = 0; r > a; a++) o[a] = i.charCodeAt(a);
            return s;
        }
        function i(e, t) {
            var i = new XMLHttpRequest();
            i.open("GET", e, !0), i.responseType = "blob", i.onload = function() {
                (200 == this.status || 0 === this.status) && t(this.response);
            }, i.send();
        }
        function r(e, r) {
            function a(t) {
                var i = s(t), a = o(t);
                e.exifdata = i || {}, e.iptcdata = a || {}, r && r.call(e);
            }
            if (e.src) if (/^data\:/i.test(e.src)) {
                var n = t(e.src);
                a(n);
            } else if (/^blob\:/i.test(e.src)) {
                var h = new FileReader();
                h.onload = function(e) {
                    a(e.target.result);
                }, i(e.src, function(e) {
                    h.readAsArrayBuffer(e);
                });
            } else {
                var c = new XMLHttpRequest();
                c.onload = function() {
                    if (200 != this.status && 0 !== this.status) throw "Could not load image";
                    a(c.response), c = null;
                }, c.open("GET", e.src, !0), c.responseType = "arraybuffer", c.send(null);
            } else if (window.FileReader && (e instanceof window.Blob || e instanceof window.File)) {
                var h = new FileReader();
                h.onload = function(e) {
                    u && console.log("Got file of length " + e.target.result.byteLength), a(e.target.result);
                }, h.readAsArrayBuffer(e);
            }
        }
        function s(e) {
            var t = new DataView(e);
            if (u && console.log("Got file of length " + e.byteLength), 255 != t.getUint8(0) || 216 != t.getUint8(1)) return u && console.log("Not a valid JPEG"), 
            !1;
            for (var i, r = 2, s = e.byteLength; s > r; ) {
                if (255 != t.getUint8(r)) return u && console.log("Not a valid marker at offset " + r + ", found: " + t.getUint8(r)), 
                !1;
                if (i = t.getUint8(r + 1), u && console.log(i), 225 == i) return u && console.log("Found 0xFFE1 marker"), 
                l(t, r + 4, t.getUint16(r + 2) - 2);
                r += 2 + t.getUint16(r + 2);
            }
        }
        function o(e) {
            var t = new DataView(e);
            if (u && console.log("Got file of length " + e.byteLength), 255 != t.getUint8(0) || 216 != t.getUint8(1)) return u && console.log("Not a valid JPEG"), 
            !1;
            for (var i = 2, r = e.byteLength, s = function(e, t) {
                return 56 === e.getUint8(t) && 66 === e.getUint8(t + 1) && 73 === e.getUint8(t + 2) && 77 === e.getUint8(t + 3) && 4 === e.getUint8(t + 4) && 4 === e.getUint8(t + 5);
            }; r > i; ) {
                if (s(t, i)) {
                    var o = t.getUint8(i + 7);
                    o % 2 !== 0 && (o += 1), 0 === o && (o = 4);
                    var n = i + 8 + o, h = t.getUint16(i + 6 + o);
                    return a(e, n, h);
                }
                i++;
            }
        }
        function a(e, t, i) {
            for (var r, s, o, a, n, h = new DataView(e), l = {}, u = t; t + i > u; ) 28 === h.getUint8(u) && 2 === h.getUint8(u + 1) && (a = h.getUint8(u + 2), 
            a in _ && (o = h.getInt16(u + 3), n = o + 5, s = _[a], r = c(h, u + 5, o), l.hasOwnProperty(s) ? l[s] instanceof Array ? l[s].push(r) : l[s] = [ l[s], r ] : l[s] = r)), 
            u++;
            return l;
        }
        function n(e, t, i, r, s) {
            var o, a, n, c = e.getUint16(i, !s), l = {};
            for (n = 0; c > n; n++) o = i + 12 * n + 2, a = r[e.getUint16(o, !s)], !a && u && console.log("Unknown tag: " + e.getUint16(o, !s)), 
            l[a] = h(e, o, t, i, s);
            return l;
        }
        function h(e, t, i, r, s) {
            var o, a, n, h, l, u, g = e.getUint16(t + 2, !s), d = e.getUint32(t + 4, !s), f = e.getUint32(t + 8, !s) + i;
            switch (g) {
              case 1:
              case 7:
                if (1 == d) return e.getUint8(t + 8, !s);
                for (o = d > 4 ? f : t + 8, a = [], h = 0; d > h; h++) a[h] = e.getUint8(o + h);
                return a;

              case 2:
                return o = d > 4 ? f : t + 8, c(e, o, d - 1);

              case 3:
                if (1 == d) return e.getUint16(t + 8, !s);
                for (o = d > 2 ? f : t + 8, a = [], h = 0; d > h; h++) a[h] = e.getUint16(o + 2 * h, !s);
                return a;

              case 4:
                if (1 == d) return e.getUint32(t + 8, !s);
                for (a = [], h = 0; d > h; h++) a[h] = e.getUint32(f + 4 * h, !s);
                return a;

              case 5:
                if (1 == d) return l = e.getUint32(f, !s), u = e.getUint32(f + 4, !s), n = new Number(l / u), 
                n.numerator = l, n.denominator = u, n;
                for (a = [], h = 0; d > h; h++) l = e.getUint32(f + 8 * h, !s), u = e.getUint32(f + 4 + 8 * h, !s), 
                a[h] = new Number(l / u), a[h].numerator = l, a[h].denominator = u;
                return a;

              case 9:
                if (1 == d) return e.getInt32(t + 8, !s);
                for (a = [], h = 0; d > h; h++) a[h] = e.getInt32(f + 4 * h, !s);
                return a;

              case 10:
                if (1 == d) return e.getInt32(f, !s) / e.getInt32(f + 4, !s);
                for (a = [], h = 0; d > h; h++) a[h] = e.getInt32(f + 8 * h, !s) / e.getInt32(f + 4 + 8 * h, !s);
                return a;
            }
        }
        function c(e, t, i) {
            for (var r = "", s = t; t + i > s; s++) r += String.fromCharCode(e.getUint8(s));
            return r;
        }
        function l(e, t) {
            if ("Exif" != c(e, t, 4)) return u && console.log("Not valid EXIF data! " + c(e, t, 4)), 
            !1;
            var i, r, s, o, a, h = t + 6;
            if (18761 == e.getUint16(h)) i = !1; else {
                if (19789 != e.getUint16(h)) return u && console.log("Not valid TIFF data! (no 0x4949 or 0x4D4D)"), 
                !1;
                i = !0;
            }
            if (42 != e.getUint16(h + 2, !i)) return u && console.log("Not valid TIFF data! (no 0x002A)"), 
            !1;
            var l = e.getUint32(h + 4, !i);
            if (8 > l) return u && console.log("Not valid TIFF data! (First offset less than 8)", e.getUint32(h + 4, !i)), 
            !1;
            if (r = n(e, h, h + l, d, i), r.ExifIFDPointer) {
                o = n(e, h, h + r.ExifIFDPointer, g, i);
                for (s in o) {
                    switch (s) {
                      case "LightSource":
                      case "Flash":
                      case "MeteringMode":
                      case "ExposureProgram":
                      case "SensingMethod":
                      case "SceneCaptureType":
                      case "SceneType":
                      case "CustomRendered":
                      case "WhiteBalance":
                      case "GainControl":
                      case "Contrast":
                      case "Saturation":
                      case "Sharpness":
                      case "SubjectDistanceRange":
                      case "FileSource":
                        o[s] = p[s][o[s]];
                        break;

                      case "ExifVersion":
                      case "FlashpixVersion":
                        o[s] = String.fromCharCode(o[s][0], o[s][1], o[s][2], o[s][3]);
                        break;

                      case "ComponentsConfiguration":
                        o[s] = p.Components[o[s][0]] + p.Components[o[s][1]] + p.Components[o[s][2]] + p.Components[o[s][3]];
                    }
                    r[s] = o[s];
                }
            }
            if (r.GPSInfoIFDPointer) {
                a = n(e, h, h + r.GPSInfoIFDPointer, f, i);
                for (s in a) {
                    switch (s) {
                      case "GPSVersionID":
                        a[s] = a[s][0] + "." + a[s][1] + "." + a[s][2] + "." + a[s][3];
                    }
                    r[s] = a[s];
                }
            }
            return r;
        }
        var u = !1, g = this.Tags = {
            36864: "ExifVersion",
            40960: "FlashpixVersion",
            40961: "ColorSpace",
            40962: "PixelXDimension",
            40963: "PixelYDimension",
            37121: "ComponentsConfiguration",
            37122: "CompressedBitsPerPixel",
            37500: "MakerNote",
            37510: "UserComment",
            40964: "RelatedSoundFile",
            36867: "DateTimeOriginal",
            36868: "DateTimeDigitized",
            37520: "SubsecTime",
            37521: "SubsecTimeOriginal",
            37522: "SubsecTimeDigitized",
            33434: "ExposureTime",
            33437: "FNumber",
            34850: "ExposureProgram",
            34852: "SpectralSensitivity",
            34855: "ISOSpeedRatings",
            34856: "OECF",
            37377: "ShutterSpeedValue",
            37378: "ApertureValue",
            37379: "BrightnessValue",
            37380: "ExposureBias",
            37381: "MaxApertureValue",
            37382: "SubjectDistance",
            37383: "MeteringMode",
            37384: "LightSource",
            37385: "Flash",
            37396: "SubjectArea",
            37386: "FocalLength",
            41483: "FlashEnergy",
            41484: "SpatialFrequencyResponse",
            41486: "FocalPlaneXResolution",
            41487: "FocalPlaneYResolution",
            41488: "FocalPlaneResolutionUnit",
            41492: "SubjectLocation",
            41493: "ExposureIndex",
            41495: "SensingMethod",
            41728: "FileSource",
            41729: "SceneType",
            41730: "CFAPattern",
            41985: "CustomRendered",
            41986: "ExposureMode",
            41987: "WhiteBalance",
            41988: "DigitalZoomRation",
            41989: "FocalLengthIn35mmFilm",
            41990: "SceneCaptureType",
            41991: "GainControl",
            41992: "Contrast",
            41993: "Saturation",
            41994: "Sharpness",
            41995: "DeviceSettingDescription",
            41996: "SubjectDistanceRange",
            40965: "InteroperabilityIFDPointer",
            42016: "ImageUniqueID"
        }, d = this.TiffTags = {
            256: "ImageWidth",
            257: "ImageHeight",
            34665: "ExifIFDPointer",
            34853: "GPSInfoIFDPointer",
            40965: "InteroperabilityIFDPointer",
            258: "BitsPerSample",
            259: "Compression",
            262: "PhotometricInterpretation",
            274: "Orientation",
            277: "SamplesPerPixel",
            284: "PlanarConfiguration",
            530: "YCbCrSubSampling",
            531: "YCbCrPositioning",
            282: "XResolution",
            283: "YResolution",
            296: "ResolutionUnit",
            273: "StripOffsets",
            278: "RowsPerStrip",
            279: "StripByteCounts",
            513: "JPEGInterchangeFormat",
            514: "JPEGInterchangeFormatLength",
            301: "TransferFunction",
            318: "WhitePoint",
            319: "PrimaryChromaticities",
            529: "YCbCrCoefficients",
            532: "ReferenceBlackWhite",
            306: "DateTime",
            270: "ImageDescription",
            271: "Make",
            272: "Model",
            305: "Software",
            315: "Artist",
            33432: "Copyright"
        }, f = this.GPSTags = {
            0: "GPSVersionID",
            1: "GPSLatitudeRef",
            2: "GPSLatitude",
            3: "GPSLongitudeRef",
            4: "GPSLongitude",
            5: "GPSAltitudeRef",
            6: "GPSAltitude",
            7: "GPSTimeStamp",
            8: "GPSSatellites",
            9: "GPSStatus",
            10: "GPSMeasureMode",
            11: "GPSDOP",
            12: "GPSSpeedRef",
            13: "GPSSpeed",
            14: "GPSTrackRef",
            15: "GPSTrack",
            16: "GPSImgDirectionRef",
            17: "GPSImgDirection",
            18: "GPSMapDatum",
            19: "GPSDestLatitudeRef",
            20: "GPSDestLatitude",
            21: "GPSDestLongitudeRef",
            22: "GPSDestLongitude",
            23: "GPSDestBearingRef",
            24: "GPSDestBearing",
            25: "GPSDestDistanceRef",
            26: "GPSDestDistance",
            27: "GPSProcessingMethod",
            28: "GPSAreaInformation",
            29: "GPSDateStamp",
            30: "GPSDifferential"
        }, p = this.StringValues = {
            ExposureProgram: {
                0: "Not defined",
                1: "Manual",
                2: "Normal program",
                3: "Aperture priority",
                4: "Shutter priority",
                5: "Creative program",
                6: "Action program",
                7: "Portrait mode",
                8: "Landscape mode"
            },
            MeteringMode: {
                0: "Unknown",
                1: "Average",
                2: "CenterWeightedAverage",
                3: "Spot",
                4: "MultiSpot",
                5: "Pattern",
                6: "Partial",
                255: "Other"
            },
            LightSource: {
                0: "Unknown",
                1: "Daylight",
                2: "Fluorescent",
                3: "Tungsten (incandescent light)",
                4: "Flash",
                9: "Fine weather",
                10: "Cloudy weather",
                11: "Shade",
                12: "Daylight fluorescent (D 5700 - 7100K)",
                13: "Day white fluorescent (N 4600 - 5400K)",
                14: "Cool white fluorescent (W 3900 - 4500K)",
                15: "White fluorescent (WW 3200 - 3700K)",
                17: "Standard light A",
                18: "Standard light B",
                19: "Standard light C",
                20: "D55",
                21: "D65",
                22: "D75",
                23: "D50",
                24: "ISO studio tungsten",
                255: "Other"
            },
            Flash: {
                0: "Flash did not fire",
                1: "Flash fired",
                5: "Strobe return light not detected",
                7: "Strobe return light detected",
                9: "Flash fired, compulsory flash mode",
                13: "Flash fired, compulsory flash mode, return light not detected",
                15: "Flash fired, compulsory flash mode, return light detected",
                16: "Flash did not fire, compulsory flash mode",
                24: "Flash did not fire, auto mode",
                25: "Flash fired, auto mode",
                29: "Flash fired, auto mode, return light not detected",
                31: "Flash fired, auto mode, return light detected",
                32: "No flash function",
                65: "Flash fired, red-eye reduction mode",
                69: "Flash fired, red-eye reduction mode, return light not detected",
                71: "Flash fired, red-eye reduction mode, return light detected",
                73: "Flash fired, compulsory flash mode, red-eye reduction mode",
                77: "Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected",
                79: "Flash fired, compulsory flash mode, red-eye reduction mode, return light detected",
                89: "Flash fired, auto mode, red-eye reduction mode",
                93: "Flash fired, auto mode, return light not detected, red-eye reduction mode",
                95: "Flash fired, auto mode, return light detected, red-eye reduction mode"
            },
            SensingMethod: {
                1: "Not defined",
                2: "One-chip color area sensor",
                3: "Two-chip color area sensor",
                4: "Three-chip color area sensor",
                5: "Color sequential area sensor",
                7: "Trilinear sensor",
                8: "Color sequential linear sensor"
            },
            SceneCaptureType: {
                0: "Standard",
                1: "Landscape",
                2: "Portrait",
                3: "Night scene"
            },
            SceneType: {
                1: "Directly photographed"
            },
            CustomRendered: {
                0: "Normal process",
                1: "Custom process"
            },
            WhiteBalance: {
                0: "Auto white balance",
                1: "Manual white balance"
            },
            GainControl: {
                0: "None",
                1: "Low gain up",
                2: "High gain up",
                3: "Low gain down",
                4: "High gain down"
            },
            Contrast: {
                0: "Normal",
                1: "Soft",
                2: "Hard"
            },
            Saturation: {
                0: "Normal",
                1: "Low saturation",
                2: "High saturation"
            },
            Sharpness: {
                0: "Normal",
                1: "Soft",
                2: "Hard"
            },
            SubjectDistanceRange: {
                0: "Unknown",
                1: "Macro",
                2: "Close view",
                3: "Distant view"
            },
            FileSource: {
                3: "DSC"
            },
            Components: {
                0: "",
                1: "Y",
                2: "Cb",
                3: "Cr",
                4: "R",
                5: "G",
                6: "B"
            }
        }, _ = {
            120: "caption",
            110: "credit",
            25: "keywords",
            55: "dateCreated",
            80: "byline",
            85: "bylineTitle",
            122: "captionWriter",
            105: "headline",
            116: "copyright",
            15: "category"
        };
        this.getData = function(t, i) {
            return (t instanceof Image || t instanceof HTMLImageElement) && !t.complete ? !1 : (e(t) ? i && i.call(t) : r(t, i), 
            !0);
        }, this.getTag = function(t, i) {
            return e(t) ? t.exifdata[i] : void 0;
        }, this.getAllTags = function(t) {
            if (!e(t)) return {};
            var i, r = t.exifdata, s = {};
            for (i in r) r.hasOwnProperty(i) && (s[i] = r[i]);
            return s;
        }, this.pretty = function(t) {
            if (!e(t)) return "";
            var i, r = t.exifdata, s = "";
            for (i in r) r.hasOwnProperty(i) && (s += "object" == typeof r[i] ? r[i] instanceof Number ? i + " : " + r[i] + " [" + r[i].numerator + "/" + r[i].denominator + "]\r\n" : i + " : [" + r[i].length + " values]\r\n" : i + " : " + r[i] + "\r\n");
            return s;
        }, this.readFromBinaryFile = function(e) {
            return s(e);
        };
    } ]), e.factory("cropHost", [ "$document", "cropAreaCircle", "cropAreaSquare", "cropEXIF", function(e, t, i, r) {
        var s = function(e) {
            var t = e.getBoundingClientRect(), i = document.body, r = document.documentElement, s = window.pageYOffset || r.scrollTop || i.scrollTop, o = window.pageXOffset || r.scrollLeft || i.scrollLeft, a = r.clientTop || i.clientTop || 0, n = r.clientLeft || i.clientLeft || 0, h = t.top + s - a, c = t.left + o - n;
            return {
                top: Math.round(h),
                left: Math.round(c)
            };
        };
        return function(o, a, n) {
            function h() {
                c.clearRect(0, 0, c.canvas.width, c.canvas.height), null !== l && (c.drawImage(l, 0, 0, c.canvas.width, c.canvas.height), 
                c.save(), c.fillStyle = "rgba(0, 0, 0, 0.65)", c.fillRect(0, 0, c.canvas.width, c.canvas.height), 
                c.restore(), u.draw());
            }
            var c = null, l = null, u = null, g = [ 100, 100 ], d = [ 300, 300 ], f = 200, p = "image/png", _ = null, m = function() {
                if (null !== l) {
                    u.setImage(l);
                    var e = [ l.width, l.height ], t = l.width / l.height, i = e;
                    i[0] > d[0] ? (i[0] = d[0], i[1] = i[0] / t) : i[0] < g[0] && (i[0] = g[0], i[1] = i[0] / t), 
                    i[1] > d[1] ? (i[1] = d[1], i[0] = i[1] * t) : i[1] < g[1] && (i[1] = g[1], i[0] = i[1] * t), 
                    o.prop("width", i[0]).prop("height", i[1]).css({
                        "margin-left": -i[0] / 2 + "px",
                        "margin-top": -i[1] / 2 + "px"
                    }), u.setX(c.canvas.width / 2), u.setY(c.canvas.height / 2), u.setSize(Math.min(200, c.canvas.width / 2, c.canvas.height / 2));
                } else o.prop("width", 0).prop("height", 0).css({
                    "margin-top": 0
                });
                h();
            }, v = function(e) {
                return angular.isDefined(e.changedTouches) ? e.changedTouches : e.originalEvent.changedTouches;
            }, S = function(e) {
                if (null !== l) {
                    var t, i, r = s(c.canvas);
                    "touchmove" === e.type ? (t = v(e)[0].pageX, i = v(e)[0].pageY) : (t = e.pageX, 
                    i = e.pageY), u.processMouseMove(t - r.left, i - r.top), h();
                }
            }, z = function(e) {
                if (e.preventDefault(), e.stopPropagation(), null !== l) {
                    var t, i, r = s(c.canvas);
                    "touchstart" === e.type ? (t = v(e)[0].pageX, i = v(e)[0].pageY) : (t = e.pageX, 
                    i = e.pageY), u.processMouseDown(t - r.left, i - r.top), h();
                }
            }, I = function(e) {
                if (null !== l) {
                    var t, i, r = s(c.canvas);
                    "touchend" === e.type ? (t = v(e)[0].pageX, i = v(e)[0].pageY) : (t = e.pageX, i = e.pageY), 
                    u.processMouseUp(t - r.left, i - r.top), h();
                }
            };
            this.getResultImageDataURI = function() {
                var e, t;
                return t = angular.element("<canvas></canvas>")[0], e = t.getContext("2d"), t.width = f, 
                t.height = f, null !== l && e.drawImage(l, (u.getX() - u.getSize() / 2) * (l.width / c.canvas.width), (u.getY() - u.getSize() / 2) * (l.height / c.canvas.height), u.getSize() * (l.width / c.canvas.width), u.getSize() * (l.height / c.canvas.height), 0, 0, f, f), 
                null !== _ ? t.toDataURL(p, _) : t.toDataURL(p);
            }, this.setNewImageSource = function(e) {
                if (l = null, m(), n.trigger("image-updated"), e) {
                    var t = new Image();
                    "http" === e.substring(0, 4).toLowerCase() && (t.crossOrigin = "anonymous"), t.onload = function() {
                        n.trigger("load-done"), r.getData(t, function() {
                            var e = r.getTag(t, "Orientation");
                            if ([ 3, 6, 8 ].indexOf(e) > -1) {
                                var i = document.createElement("canvas"), s = i.getContext("2d"), o = t.width, a = t.height, h = 0, c = 0, u = 0;
                                switch (e) {
                                  case 3:
                                    h = -t.width, c = -t.height, u = 180;
                                    break;

                                  case 6:
                                    o = t.height, a = t.width, c = -t.height, u = 90;
                                    break;

                                  case 8:
                                    o = t.height, a = t.width, h = -t.width, u = 270;
                                }
                                i.width = o, i.height = a, s.rotate(u * Math.PI / 180), s.drawImage(t, h, c), l = new Image(), 
                                l.src = i.toDataURL("image/png");
                            } else l = t;
                            m(), n.trigger("image-updated");
                        });
                    }, t.onerror = function() {
                        n.trigger("load-error");
                    }, n.trigger("load-start"), t.src = e;
                }
            }, this.setMaxDimensions = function(e, t) {
                if (d = [ e, t ], null !== l) {
                    var i = c.canvas.width, r = c.canvas.height, s = [ l.width, l.height ], a = l.width / l.height, n = s;
                    n[0] > d[0] ? (n[0] = d[0], n[1] = n[0] / a) : n[0] < g[0] && (n[0] = g[0], n[1] = n[0] / a), 
                    n[1] > d[1] ? (n[1] = d[1], n[0] = n[1] * a) : n[1] < g[1] && (n[1] = g[1], n[0] = n[1] * a), 
                    o.prop("width", n[0]).prop("height", n[1]).css({
                        "margin-left": -n[0] / 2 + "px",
                        "margin-top": -n[1] / 2 + "px"
                    });
                    var f = c.canvas.width / i, p = c.canvas.height / r, _ = Math.min(f, p);
                    u.setX(u.getX() * f), u.setY(u.getY() * p), u.setSize(u.getSize() * _);
                } else o.prop("width", 0).prop("height", 0).css({
                    "margin-top": 0
                });
                h();
            }, this.setAreaMinSize = function(e) {
                e = parseInt(e, 10), isNaN(e) || (u.setMinSize(e), h());
            }, this.setResultImageSize = function(e) {
                e = parseInt(e, 10), isNaN(e) || (f = e);
            }, this.setResultImageFormat = function(e) {
                p = e;
            }, this.setResultImageQuality = function(e) {
                e = parseFloat(e), !isNaN(e) && e >= 0 && 1 >= e && (_ = e);
            }, this.setAreaType = function(e) {
                var r = u.getSize(), s = u.getMinSize(), o = u.getX(), a = u.getY(), g = t;
                "square" === e && (g = i), u = new g(c, n), u.setMinSize(s), u.setSize(r), u.setX(o), 
                u.setY(a), null !== l && u.setImage(l), h();
            }, c = o[0].getContext("2d"), u = new t(c, n), e.on("mousemove", S), o.on("mousedown", z), 
            e.on("mouseup", I), e.on("touchmove", S), o.on("touchstart", z), e.on("touchend", I), 
            this.destroy = function() {
                e.off("mousemove", S), o.off("mousedown", z), e.off("mouseup", S), e.off("touchmove", S), 
                o.off("touchstart", z), e.off("touchend", S), o.remove();
            };
        };
    } ]), e.factory("cropPubSub", [ function() {
        return function() {
            var e = {};
            this.on = function(t, i) {
                return t.split(" ").forEach(function(t) {
                    e[t] || (e[t] = []), e[t].push(i);
                }), this;
            }, this.trigger = function(t, i) {
                return angular.forEach(e[t], function(e) {
                    e.call(null, i);
                }), this;
            };
        };
    } ]), e.directive("imgCrop", [ "$timeout", "cropHost", "cropPubSub", function(e, t, i) {
        return {
            restrict: "E",
            scope: {
                image: "=",
                resultImage: "=",
                changeOnFly: "=",
                areaType: "@",
                areaMinSize: "=",
                resultImageSize: "=",
                resultImageFormat: "@",
                resultImageQuality: "=",
                onChange: "&",
                onLoadBegin: "&",
                onLoadDone: "&",
                onLoadError: "&"
            },
            template: "<canvas></canvas>",
            controller: [ "$scope", function(e) {
                e.events = new i();
            } ],
            link: function(i, r) {
                var s, o = i.events, a = new t(r.find("canvas"), {}, o), n = function(e) {
                    var t = a.getResultImageDataURI();
                    s !== t && (s = t, angular.isDefined(e.resultImage) && (e.resultImage = t), e.onChange({
                        $dataURI: e.resultImage
                    }));
                }, h = function(t) {
                    return function() {
                        e(function() {
                            i.$apply(function(e) {
                                t(e);
                            });
                        });
                    };
                };
                o.on("load-start", h(function(e) {
                    e.onLoadBegin({});
                })).on("load-done", h(function(e) {
                    e.onLoadDone({});
                })).on("load-error", h(function(e) {
                    e.onLoadError({});
                })).on("area-move area-resize", h(function(e) {
                    e.changeOnFly && n(e);
                })).on("area-move-end area-resize-end image-updated", h(function(e) {
                    n(e);
                })), i.$watch("image", function() {
                    a.setNewImageSource(i.image);
                }), i.$watch("areaType", function() {
                    a.setAreaType(i.areaType), n(i);
                }), i.$watch("areaMinSize", function() {
                    a.setAreaMinSize(i.areaMinSize), n(i);
                }), i.$watch("resultImageSize", function() {
                    a.setResultImageSize(i.resultImageSize), n(i);
                }), i.$watch("resultImageFormat", function() {
                    a.setResultImageFormat(i.resultImageFormat), n(i);
                }), i.$watch("resultImageQuality", function() {
                    a.setResultImageQuality(i.resultImageQuality), n(i);
                }), i.$watch(function() {
                    return [ r[0].clientWidth, r[0].clientHeight ];
                }, function(e) {
                    a.setMaxDimensions(e[0], e[1]), n(i);
                }, !0), i.$on("$destroy", function() {
                    a.destroy();
                });
            }
        };
    } ]);
}(), angular.module("xeditable", []).value("editableOptions", {
    theme: "default",
    buttons: "right",
    blurElem: "cancel",
    blurForm: "ignore",
    activate: "focus"
}), angular.module("xeditable").directive("editableBsdate", [ "editableDirectiveFactory", function(editableDirectiveFactory) {
    return editableDirectiveFactory({
        directiveName: "editableBsdate",
        inputTpl: '<input type="text">'
    });
} ]), angular.module("xeditable").directive("editableBstime", [ "editableDirectiveFactory", function(editableDirectiveFactory) {
    return editableDirectiveFactory({
        directiveName: "editableBstime",
        inputTpl: "<timepicker></timepicker>",
        render: function() {
            this.parent.render.call(this);
            var div = angular.element('<div class="well well-small" style="display:inline-block;"></div>');
            div.attr("ng-model", this.inputEl.attr("ng-model")), this.inputEl.removeAttr("ng-model"), 
            this.attrs.eNgChange && (div.attr("ng-change", this.inputEl.attr("ng-change")), 
            this.inputEl.removeAttr("ng-change")), this.inputEl.wrap(div);
        }
    });
} ]), angular.module("xeditable").directive("editableCheckbox", [ "editableDirectiveFactory", function(editableDirectiveFactory) {
    return editableDirectiveFactory({
        directiveName: "editableCheckbox",
        inputTpl: '<input type="checkbox">',
        render: function() {
            this.parent.render.call(this), this.attrs.eTitle && (this.inputEl.wrap("<label></label>"), 
            this.inputEl.after(angular.element("<span></span>").text(this.attrs.eTitle)));
        },
        autosubmit: function() {
            var self = this;
            self.inputEl.bind("change", function() {
                setTimeout(function() {
                    self.scope.$apply(function() {
                        self.scope.$form.$submit();
                    });
                }, 500);
            });
        }
    });
} ]), angular.module("xeditable").directive("editableChecklist", [ "editableDirectiveFactory", "editableNgOptionsParser", function(editableDirectiveFactory, editableNgOptionsParser) {
    return editableDirectiveFactory({
        directiveName: "editableChecklist",
        inputTpl: "<span></span>",
        useCopy: !0,
        render: function() {
            this.parent.render.call(this);
            var parsed = editableNgOptionsParser(this.attrs.eNgOptions), html = '<label ng-repeat="' + parsed.ngRepeat + '"><input type="checkbox" checklist-model="$parent.$data" checklist-value="' + parsed.locals.valueFn + '"><span ng-bind="' + parsed.locals.displayFn + '"></span></label>';
            this.inputEl.removeAttr("ng-model"), this.inputEl.removeAttr("ng-options"), this.inputEl.html(html);
        }
    });
} ]), function() {
    var types = "text|email|tel|number|url|search|color|date|datetime|time|month|week".split("|");
    angular.forEach(types, function(type) {
        var directiveName = "editable" + type.charAt(0).toUpperCase() + type.slice(1);
        angular.module("xeditable").directive(directiveName, [ "editableDirectiveFactory", function(editableDirectiveFactory) {
            return editableDirectiveFactory({
                directiveName: directiveName,
                inputTpl: '<input type="' + type + '">'
            });
        } ]);
    }), angular.module("xeditable").directive("editableRange", [ "editableDirectiveFactory", function(editableDirectiveFactory) {
        return editableDirectiveFactory({
            directiveName: "editableRange",
            inputTpl: '<input type="range" id="range" name="range">',
            render: function() {
                this.parent.render.call(this), this.inputEl.after("<output>{{$data}}</output>");
            }
        });
    } ]);
}(), angular.module("xeditable").directive("editableRadiolist", [ "editableDirectiveFactory", "editableNgOptionsParser", function(editableDirectiveFactory, editableNgOptionsParser) {
    return editableDirectiveFactory({
        directiveName: "editableRadiolist",
        inputTpl: "<span></span>",
        render: function() {
            this.parent.render.call(this);
            var parsed = editableNgOptionsParser(this.attrs.eNgOptions), html = '<label ng-repeat="' + parsed.ngRepeat + '"><input type="radio" ng-model="$parent.$data" value="{{' + parsed.locals.valueFn + '}}"><span ng-bind="' + parsed.locals.displayFn + '"></span></label>';
            this.inputEl.removeAttr("ng-model"), this.inputEl.removeAttr("ng-options"), this.inputEl.html(html);
        },
        autosubmit: function() {
            var self = this;
            self.inputEl.bind("change", function() {
                setTimeout(function() {
                    self.scope.$apply(function() {
                        self.scope.$form.$submit();
                    });
                }, 500);
            });
        }
    });
} ]), angular.module("xeditable").directive("editableSelect", [ "editableDirectiveFactory", function(editableDirectiveFactory) {
    return editableDirectiveFactory({
        directiveName: "editableSelect",
        inputTpl: "<select></select>",
        autosubmit: function() {
            var self = this;
            self.inputEl.bind("change", function() {
                self.scope.$apply(function() {
                    self.scope.$form.$submit();
                });
            });
        }
    });
} ]), angular.module("xeditable").directive("editableTextarea", [ "editableDirectiveFactory", function(editableDirectiveFactory) {
    return editableDirectiveFactory({
        directiveName: "editableTextarea",
        inputTpl: "<textarea></textarea>",
        addListeners: function() {
            var self = this;
            self.parent.addListeners.call(self), self.single && "no" !== self.buttons && self.autosubmit();
        },
        autosubmit: function() {
            var self = this;
            self.inputEl.bind("keydown", function(e) {
                (e.ctrlKey || e.metaKey) && 13 === e.keyCode && self.scope.$apply(function() {
                    self.scope.$form.$submit();
                });
            });
        }
    });
} ]), angular.module("xeditable").factory("editableController", [ "$q", "editableUtils", function($q, editableUtils) {
    function EditableController($scope, $attrs, $element, $parse, editableThemes, editableOptions, $rootScope, $compile, $q) {
        var valueGetter, inWaiting, self = this;
        self.scope = $scope, self.elem = $element, self.attrs = $attrs, self.inputEl = null, 
        self.editorEl = null, self.single = !0, self.error = "", self.theme = editableThemes[editableOptions.theme] || editableThemes["default"], 
        self.parent = {}, self.inputTpl = "", self.directiveName = "", self.useCopy = !1, 
        self.single = null, self.buttons = "right", self.init = function(single) {
            if (self.single = single, self.name = $attrs.eName || $attrs[self.directiveName], 
            !$attrs[self.directiveName]) throw "You should provide value for `" + self.directiveName + "` in editable element!";
            valueGetter = $parse($attrs[self.directiveName]), self.single ? self.buttons = self.attrs.buttons || editableOptions.buttons : self.buttons = "no", 
            $attrs.eName && self.scope.$watch("$data", function(newVal) {
                self.scope.$form.$data[$attrs.eName] = newVal;
            }), $attrs.onshow && (self.onshow = function() {
                return self.catchError($parse($attrs.onshow)($scope));
            }), $attrs.onhide && (self.onhide = function() {
                return $parse($attrs.onhide)($scope);
            }), $attrs.oncancel && (self.oncancel = function() {
                return $parse($attrs.oncancel)($scope);
            }), $attrs.onbeforesave && (self.onbeforesave = function() {
                return self.catchError($parse($attrs.onbeforesave)($scope));
            }), $attrs.onaftersave && (self.onaftersave = function() {
                return self.catchError($parse($attrs.onaftersave)($scope));
            }), $scope.$parent.$watch($attrs[self.directiveName], function(newVal, oldVal) {
                self.handleEmpty();
            });
        }, self.render = function() {
            var theme = self.theme;
            self.inputEl = angular.element(self.inputTpl), self.controlsEl = angular.element(theme.controlsTpl), 
            self.controlsEl.append(self.inputEl), "no" !== self.buttons && (self.buttonsEl = angular.element(theme.buttonsTpl), 
            self.submitEl = angular.element(theme.submitTpl), self.cancelEl = angular.element(theme.cancelTpl), 
            self.buttonsEl.append(self.submitEl).append(self.cancelEl), self.controlsEl.append(self.buttonsEl), 
            self.inputEl.addClass("editable-has-buttons")), self.errorEl = angular.element(theme.errorTpl), 
            self.controlsEl.append(self.errorEl), self.editorEl = angular.element(self.single ? theme.formTpl : theme.noformTpl), 
            self.editorEl.append(self.controlsEl);
            for (var k in $attrs.$attr) if (!(k.length <= 1)) {
                var transferAttr = !1, nextLetter = k.substring(1, 2);
                if ("e" === k.substring(0, 1) && nextLetter === nextLetter.toUpperCase() && (transferAttr = k.substring(1), 
                "Form" !== transferAttr && "NgSubmit" !== transferAttr)) {
                    transferAttr = transferAttr.substring(0, 1).toLowerCase() + editableUtils.camelToDash(transferAttr.substring(1));
                    var attrValue = "" === $attrs[k] ? transferAttr : $attrs[k];
                    self.inputEl.attr(transferAttr, attrValue);
                }
            }
            self.inputEl.addClass("editable-input"), self.inputEl.attr("ng-model", "$data"), 
            self.editorEl.addClass(editableUtils.camelToDash(self.directiveName)), self.single && (self.editorEl.attr("editable-form", "$form"), 
            self.editorEl.attr("blur", self.attrs.blur || ("no" === self.buttons ? "cancel" : editableOptions.blurElem))), 
            angular.isFunction(theme.postrender) && theme.postrender.call(self);
        }, self.setLocalValue = function() {
            self.scope.$data = self.useCopy ? angular.copy(valueGetter($scope.$parent)) : valueGetter($scope.$parent);
        }, self.show = function() {
            return self.setLocalValue(), self.render(), $element.after(self.editorEl), $compile(self.editorEl)($scope), 
            self.addListeners(), $element.addClass("editable-hide"), self.onshow();
        }, self.hide = function() {
            return self.editorEl.remove(), $element.removeClass("editable-hide"), self.onhide();
        }, self.cancel = function() {
            self.oncancel();
        }, self.addListeners = function() {
            self.inputEl.bind("keyup", function(e) {
                if (self.single) switch (e.keyCode) {
                  case 27:
                    self.scope.$apply(function() {
                        self.scope.$form.$cancel();
                    });
                }
            }), self.single && "no" === self.buttons && self.autosubmit(), self.editorEl.bind("click", function(e) {
                1 === e.which && self.scope.$form.$visible && (self.scope.$form._clicked = !0);
            });
        }, self.setWaiting = function(value) {
            value ? (inWaiting = !self.inputEl.attr("disabled") && !self.inputEl.attr("ng-disabled") && !self.inputEl.attr("ng-enabled"), 
            inWaiting && (self.inputEl.attr("disabled", "disabled"), self.buttonsEl && self.buttonsEl.find("button").attr("disabled", "disabled"))) : inWaiting && (self.inputEl.removeAttr("disabled"), 
            self.buttonsEl && self.buttonsEl.find("button").removeAttr("disabled"));
        }, self.activate = function() {
            setTimeout(function() {
                var el = self.inputEl[0];
                "focus" === editableOptions.activate && el.focus && el.focus(), "select" === editableOptions.activate && el.select && el.select();
            }, 0);
        }, self.setError = function(msg) {
            angular.isObject(msg) || ($scope.$error = msg, self.error = msg);
        }, self.catchError = function(result, noPromise) {
            return angular.isObject(result) && noPromise !== !0 ? $q.when(result).then(angular.bind(this, function(r) {
                this.catchError(r, !0);
            }), angular.bind(this, function(r) {
                this.catchError(r, !0);
            })) : noPromise && angular.isObject(result) && result.status && 200 !== result.status && result.data && angular.isString(result.data) ? (this.setError(result.data), 
            result = result.data) : angular.isString(result) && this.setError(result), result;
        }, self.save = function() {
            valueGetter.assign($scope.$parent, angular.copy(self.scope.$data));
        }, self.handleEmpty = function() {
            var val = valueGetter($scope.$parent), isEmpty = null === val || void 0 === val || "" === val || angular.isArray(val) && 0 === val.length;
            $element.toggleClass("editable-empty", isEmpty);
        }, self.autosubmit = angular.noop, self.onshow = angular.noop, self.onhide = angular.noop, 
        self.oncancel = angular.noop, self.onbeforesave = angular.noop, self.onaftersave = angular.noop;
    }
    return EditableController.$inject = [ "$scope", "$attrs", "$element", "$parse", "editableThemes", "editableOptions", "$rootScope", "$compile", "$q" ], 
    EditableController;
} ]), angular.module("xeditable").factory("editableDirectiveFactory", [ "$parse", "$compile", "editableThemes", "$rootScope", "$document", "editableController", "editableFormController", function($parse, $compile, editableThemes, $rootScope, $document, editableController, editableFormController) {
    return function(overwrites) {
        return {
            restrict: "A",
            scope: !0,
            require: [ overwrites.directiveName, "?^form" ],
            controller: editableController,
            link: function(scope, elem, attrs, ctrl) {
                var eFormCtrl, eCtrl = ctrl[0], hasForm = !1;
                if (ctrl[1]) eFormCtrl = ctrl[1], hasForm = !0; else if (attrs.eForm) {
                    var getter = $parse(attrs.eForm)(scope);
                    if (getter) eFormCtrl = getter, hasForm = !0; else for (var i = 0; i < $document[0].forms.length; i++) if ($document[0].forms[i].name === attrs.eForm) {
                        eFormCtrl = null, hasForm = !0;
                        break;
                    }
                }
                if (angular.forEach(overwrites, function(v, k) {
                    void 0 !== eCtrl[k] && (eCtrl.parent[k] = eCtrl[k]);
                }), angular.extend(eCtrl, overwrites), eCtrl.init(!hasForm), scope.$editable = eCtrl, 
                elem.addClass("editable"), hasForm) if (eFormCtrl) {
                    if (scope.$form = eFormCtrl, !scope.$form.$addEditable) throw "Form with editable elements should have `editable-form` attribute.";
                    scope.$form.$addEditable(eCtrl);
                } else $rootScope.$$editableBuffer = $rootScope.$$editableBuffer || {}, $rootScope.$$editableBuffer[attrs.eForm] = $rootScope.$$editableBuffer[attrs.eForm] || [], 
                $rootScope.$$editableBuffer[attrs.eForm].push(eCtrl), scope.$form = null; else scope.$form = editableFormController(), 
                scope.$form.$addEditable(eCtrl), attrs.eForm && (scope.$parent[attrs.eForm] = scope.$form), 
                attrs.eForm || (elem.addClass("editable-click"), elem.bind("click", function(e) {
                    e.preventDefault(), e.editable = eCtrl, scope.$apply(function() {
                        scope.$form.$show();
                    });
                }));
            }
        };
    };
} ]), angular.module("xeditable").factory("editableFormController", [ "$parse", "$document", "$rootScope", "editablePromiseCollection", "editableUtils", function($parse, $document, $rootScope, editablePromiseCollection, editableUtils) {
    var shown = [];
    $document.bind("click", function(e) {
        if (1 === e.which) {
            for (var toCancel = [], toSubmit = [], i = 0; i < shown.length; i++) shown[i]._clicked ? shown[i]._clicked = !1 : shown[i].$waiting || ("cancel" === shown[i]._blur && toCancel.push(shown[i]), 
            "submit" === shown[i]._blur && toSubmit.push(shown[i]));
            (toCancel.length || toSubmit.length) && $rootScope.$apply(function() {
                angular.forEach(toCancel, function(v) {
                    v.$cancel();
                }), angular.forEach(toSubmit, function(v) {
                    v.$submit();
                });
            });
        }
    });
    var base = {
        $addEditable: function(editable) {
            this.$editables.push(editable), editable.elem.bind("$destroy", angular.bind(this, this.$removeEditable, editable)), 
            editable.scope.$form || (editable.scope.$form = this), this.$visible && editable.catchError(editable.show());
        },
        $removeEditable: function(editable) {
            for (var i = 0; i < this.$editables.length; i++) if (this.$editables[i] === editable) return void this.$editables.splice(i, 1);
        },
        $show: function() {
            if (!this.$visible) {
                this.$visible = !0;
                var pc = editablePromiseCollection();
                pc.when(this.$onshow()), this.$setError(null, ""), angular.forEach(this.$editables, function(editable) {
                    pc.when(editable.show());
                }), pc.then({
                    onWait: angular.bind(this, this.$setWaiting),
                    onTrue: angular.bind(this, this.$activate),
                    onFalse: angular.bind(this, this.$activate),
                    onString: angular.bind(this, this.$activate)
                }), setTimeout(angular.bind(this, function() {
                    this._clicked = !1, -1 === editableUtils.indexOf(shown, this) && shown.push(this);
                }), 0);
            }
        },
        $activate: function(name) {
            var i;
            if (this.$editables.length) {
                if (angular.isString(name)) for (i = 0; i < this.$editables.length; i++) if (this.$editables[i].name === name) return void this.$editables[i].activate();
                for (i = 0; i < this.$editables.length; i++) if (this.$editables[i].error) return void this.$editables[i].activate();
                this.$editables[0].activate();
            }
        },
        $hide: function() {
            this.$visible && (this.$visible = !1, this.$onhide(), angular.forEach(this.$editables, function(editable) {
                editable.hide();
            }), editableUtils.arrayRemove(shown, this));
        },
        $cancel: function() {
            this.$visible && (this.$oncancel(), angular.forEach(this.$editables, function(editable) {
                editable.cancel();
            }), this.$hide());
        },
        $setWaiting: function(value) {
            this.$waiting = !!value, angular.forEach(this.$editables, function(editable) {
                editable.setWaiting(!!value);
            });
        },
        $setError: function(name, msg) {
            angular.forEach(this.$editables, function(editable) {
                name && editable.name !== name || editable.setError(msg);
            });
        },
        $submit: function() {
            function checkSelf(childrenTrue) {
                var pc = editablePromiseCollection();
                pc.when(this.$onbeforesave()), pc.then({
                    onWait: angular.bind(this, this.$setWaiting),
                    onTrue: childrenTrue ? angular.bind(this, this.$save) : angular.bind(this, this.$hide),
                    onFalse: angular.bind(this, this.$hide),
                    onString: angular.bind(this, this.$activate)
                });
            }
            if (!this.$waiting) {
                this.$setError(null, "");
                var pc = editablePromiseCollection();
                angular.forEach(this.$editables, function(editable) {
                    pc.when(editable.onbeforesave());
                }), pc.then({
                    onWait: angular.bind(this, this.$setWaiting),
                    onTrue: angular.bind(this, checkSelf, !0),
                    onFalse: angular.bind(this, checkSelf, !1),
                    onString: angular.bind(this, this.$activate)
                });
            }
        },
        $save: function() {
            angular.forEach(this.$editables, function(editable) {
                editable.save();
            });
            var pc = editablePromiseCollection();
            pc.when(this.$onaftersave()), angular.forEach(this.$editables, function(editable) {
                pc.when(editable.onaftersave());
            }), pc.then({
                onWait: angular.bind(this, this.$setWaiting),
                onTrue: angular.bind(this, this.$hide),
                onFalse: angular.bind(this, this.$hide),
                onString: angular.bind(this, this.$activate)
            });
        },
        $onshow: angular.noop,
        $oncancel: angular.noop,
        $onhide: angular.noop,
        $onbeforesave: angular.noop,
        $onaftersave: angular.noop
    };
    return function() {
        return angular.extend({
            $editables: [],
            $visible: !1,
            $waiting: !1,
            $data: {},
            _clicked: !1,
            _blur: null
        }, base);
    };
} ]), angular.module("xeditable").directive("editableForm", [ "$rootScope", "$parse", "editableFormController", "editableOptions", function($rootScope, $parse, editableFormController, editableOptions) {
    return {
        restrict: "A",
        require: [ "form" ],
        compile: function() {
            return {
                pre: function(scope, elem, attrs, ctrl) {
                    var eForm, form = ctrl[0];
                    attrs.editableForm ? scope[attrs.editableForm] && scope[attrs.editableForm].$show ? (eForm = scope[attrs.editableForm], 
                    angular.extend(form, eForm)) : (eForm = editableFormController(), scope[attrs.editableForm] = eForm, 
                    angular.extend(eForm, form)) : (eForm = editableFormController(), angular.extend(form, eForm));
                    var buf = $rootScope.$$editableBuffer, name = form.$name;
                    name && buf && buf[name] && (angular.forEach(buf[name], function(editable) {
                        eForm.$addEditable(editable);
                    }), delete buf[name]);
                },
                post: function(scope, elem, attrs, ctrl) {
                    var eForm;
                    eForm = attrs.editableForm && scope[attrs.editableForm] && scope[attrs.editableForm].$show ? scope[attrs.editableForm] : ctrl[0], 
                    attrs.onshow && (eForm.$onshow = angular.bind(eForm, $parse(attrs.onshow), scope)), 
                    attrs.onhide && (eForm.$onhide = angular.bind(eForm, $parse(attrs.onhide), scope)), 
                    attrs.oncancel && (eForm.$oncancel = angular.bind(eForm, $parse(attrs.oncancel), scope)), 
                    attrs.shown && $parse(attrs.shown)(scope) && eForm.$show(), eForm._blur = attrs.blur || editableOptions.blurForm, 
                    attrs.ngSubmit || attrs.submit || (attrs.onbeforesave && (eForm.$onbeforesave = function() {
                        return $parse(attrs.onbeforesave)(scope, {
                            $data: eForm.$data
                        });
                    }), attrs.onaftersave && (eForm.$onaftersave = function() {
                        return $parse(attrs.onaftersave)(scope, {
                            $data: eForm.$data
                        });
                    }), elem.bind("submit", function(event) {
                        event.preventDefault(), scope.$apply(function() {
                            eForm.$submit();
                        });
                    })), elem.bind("click", function(e) {
                        1 === e.which && eForm.$visible && (eForm._clicked = !0);
                    });
                }
            };
        }
    };
} ]), angular.module("xeditable").factory("editablePromiseCollection", [ "$q", function($q) {
    function promiseCollection() {
        return {
            promises: [],
            hasFalse: !1,
            hasString: !1,
            when: function(result, noPromise) {
                if (result === !1) this.hasFalse = !0; else if (!noPromise && angular.isObject(result)) this.promises.push($q.when(result)); else {
                    if (!angular.isString(result)) return;
                    this.hasString = !0;
                }
            },
            then: function(callbacks) {
                function applyCallback() {
                    self.hasString || self.hasFalse ? !self.hasString && self.hasFalse ? onFalse() : onString() : onTrue();
                }
                callbacks = callbacks || {};
                var onTrue = callbacks.onTrue || angular.noop, onFalse = callbacks.onFalse || angular.noop, onString = callbacks.onString || angular.noop, onWait = callbacks.onWait || angular.noop, self = this;
                this.promises.length ? (onWait(!0), $q.all(this.promises).then(function(results) {
                    onWait(!1), angular.forEach(results, function(result) {
                        self.when(result, !0);
                    }), applyCallback();
                }, function(error) {
                    onWait(!1), onString();
                })) : applyCallback();
            }
        };
    }
    return promiseCollection;
} ]), angular.module("xeditable").factory("editableUtils", [ function() {
    return {
        indexOf: function(array, obj) {
            if (array.indexOf) return array.indexOf(obj);
            for (var i = 0; i < array.length; i++) if (obj === array[i]) return i;
            return -1;
        },
        arrayRemove: function(array, value) {
            var index = this.indexOf(array, value);
            return index >= 0 && array.splice(index, 1), value;
        },
        camelToDash: function(str) {
            var SNAKE_CASE_REGEXP = /[A-Z]/g;
            return str.replace(SNAKE_CASE_REGEXP, function(letter, pos) {
                return (pos ? "-" : "") + letter.toLowerCase();
            });
        },
        dashToCamel: function(str) {
            var SPECIAL_CHARS_REGEXP = /([\:\-\_]+(.))/g, MOZ_HACK_REGEXP = /^moz([A-Z])/;
            return str.replace(SPECIAL_CHARS_REGEXP, function(_, separator, letter, offset) {
                return offset ? letter.toUpperCase() : letter;
            }).replace(MOZ_HACK_REGEXP, "Moz$1");
        }
    };
} ]), angular.module("xeditable").factory("editableNgOptionsParser", [ function() {
    function parser(optionsExp) {
        var match;
        if (!(match = optionsExp.match(NG_OPTIONS_REGEXP))) throw "ng-options parse error";
        var ngRepeat, displayFn = match[2] || match[1], valueName = match[4] || match[6], keyName = match[5], valueFn = (match[3] || "", 
        match[2] ? match[1] : valueName), valuesFn = match[7], track = match[8], trackFn = track ? match[8] : null;
        return void 0 === keyName ? (ngRepeat = valueName + " in " + valuesFn, void 0 !== track && (ngRepeat += " track by " + trackFn)) : ngRepeat = "(" + keyName + ", " + valueName + ") in " + valuesFn, 
        {
            ngRepeat: ngRepeat,
            locals: {
                valueName: valueName,
                keyName: keyName,
                valueFn: valueFn,
                displayFn: displayFn
            }
        };
    }
    var NG_OPTIONS_REGEXP = /^\s*(.*?)(?:\s+as\s+(.*?))?(?:\s+group\s+by\s+(.*))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+(.*?)(?:\s+track\s+by\s+(.*?))?$/;
    return parser;
} ]), angular.module("xeditable").factory("editableThemes", function() {
    var themes = {
        "default": {
            formTpl: '<form class="editable-wrap"></form>',
            noformTpl: '<span class="editable-wrap"></span>',
            controlsTpl: '<span class="editable-controls"></span>',
            inputTpl: "",
            errorTpl: '<div class="editable-error" ng-show="$error" ng-bind="$error"></div>',
            buttonsTpl: '<span class="editable-buttons"></span>',
            submitTpl: '<button type="submit">save</button>',
            cancelTpl: '<button type="button" ng-click="$form.$cancel()">cancel</button>'
        },
        bs2: {
            formTpl: '<form class="form-inline editable-wrap" role="form"></form>',
            noformTpl: '<span class="editable-wrap"></span>',
            controlsTpl: '<div class="editable-controls controls control-group" ng-class="{\'error\': $error}"></div>',
            inputTpl: "",
            errorTpl: '<div class="editable-error help-block" ng-show="$error" ng-bind="$error"></div>',
            buttonsTpl: '<span class="editable-buttons"></span>',
            submitTpl: '<button type="submit" class="btn btn-primary"><span class="icon-ok icon-white"></span></button>',
            cancelTpl: '<button type="button" class="btn" ng-click="$form.$cancel()"><span class="icon-remove"></span></button>'
        },
        bs3: {
            formTpl: '<form class="form-inline editable-wrap" role="form"></form>',
            noformTpl: '<span class="editable-wrap"></span>',
            controlsTpl: '<div class="editable-controls form-group" ng-class="{\'has-error\': $error}"></div>',
            inputTpl: "",
            errorTpl: '<div class="editable-error help-block" ng-show="$error" ng-bind="$error"></div>',
            buttonsTpl: '<span class="editable-buttons"></span>',
            submitTpl: '<button type="submit" class="btn btn-primary"><span class="glyphicon glyphicon-ok"></span></button>',
            cancelTpl: '<button type="button" class="btn btn-default" ng-click="$form.$cancel()"><span class="glyphicon glyphicon-remove"></span></button>',
            buttonsClass: "",
            inputClass: "",
            postrender: function() {
                switch (this.directiveName) {
                  case "editableText":
                  case "editableSelect":
                  case "editableTextarea":
                  case "editableEmail":
                  case "editableTel":
                  case "editableNumber":
                  case "editableUrl":
                  case "editableSearch":
                  case "editableDate":
                  case "editableDatetime":
                  case "editableTime":
                  case "editableMonth":
                  case "editableWeek":
                    if (this.inputEl.addClass("form-control"), this.theme.inputClass) {
                        if (this.inputEl.attr("multiple") && ("input-sm" === this.theme.inputClass || "input-lg" === this.theme.inputClass)) break;
                        this.inputEl.addClass(this.theme.inputClass);
                    }
                }
                this.buttonsEl && this.theme.buttonsClass && this.buttonsEl.find("button").addClass(this.theme.buttonsClass);
            }
        }
    };
    return themes;
}), function(window, angular, undefined) {
    "use strict";
    function jsonStringToDate(string) {
        var match;
        if (match = string.match(R_ISO8061_STR)) {
            var date = new Date(0), tzHour = 0, tzMin = 0;
            return match[9] && (tzHour = int(match[9] + match[10]), tzMin = int(match[9] + match[11])), 
            date.setUTCFullYear(int(match[1]), int(match[2]) - 1, int(match[3])), date.setUTCHours(int(match[4] || 0) - tzHour, int(match[5] || 0) - tzMin, int(match[6] || 0), int(match[7] || 0)), 
            date;
        }
        return string;
    }
    function int(str) {
        return parseInt(str, 10);
    }
    function padNumber(num, digits, trim) {
        var neg = "";
        for (0 > num && (neg = "-", num = -num), num = "" + num; num.length < digits; ) num = "0" + num;
        return trim && (num = num.substr(num.length - digits)), neg + num;
    }
    function createHttpBackendMock($rootScope, $timeout, $delegate, $browser) {
        function createResponse(status, data, headers, statusText) {
            return angular.isFunction(status) ? status : function() {
                return angular.isNumber(status) ? [ status, data, headers, statusText ] : [ 200, status, data, headers ];
            };
        }
        function $httpBackend(method, url, data, callback, headers, timeout, withCredentials) {
            function prettyPrint(data) {
                return angular.isString(data) || angular.isFunction(data) || data instanceof RegExp ? data : angular.toJson(data);
            }
            function wrapResponse(wrapped) {
                function handleResponse() {
                    var response = wrapped.response(method, url, data, headers);
                    xhr.$$respHeaders = response[2], callback(copy(response[0]), copy(response[1]), xhr.getAllResponseHeaders(), copy(response[3] || ""));
                }
                function handleTimeout() {
                    for (var i = 0, ii = responses.length; ii > i; i++) if (responses[i] === handleResponse) {
                        responses.splice(i, 1), callback(-1, undefined, "");
                        break;
                    }
                }
                return !$browser && timeout && (timeout.then ? timeout.then(handleTimeout) : $timeout(handleTimeout, timeout)), 
                handleResponse;
            }
            var xhr = new MockXhr(), expectation = expectations[0], wasExpected = !1;
            if (expectation && expectation.match(method, url)) {
                if (!expectation.matchData(data)) throw new Error("Expected " + expectation + " with different data\nEXPECTED: " + prettyPrint(expectation.data) + "\nGOT:      " + data);
                if (!expectation.matchHeaders(headers)) throw new Error("Expected " + expectation + " with different headers\nEXPECTED: " + prettyPrint(expectation.headers) + "\nGOT:      " + prettyPrint(headers));
                if (expectations.shift(), expectation.response) return void responses.push(wrapResponse(expectation));
                wasExpected = !0;
            }
            for (var definition, i = -1; definition = definitions[++i]; ) if (definition.match(method, url, data, headers || {})) {
                if (definition.response) ($browser ? $browser.defer : responsesPush)(wrapResponse(definition)); else {
                    if (!definition.passThrough) throw new Error("No response defined !");
                    $delegate(method, url, data, callback, headers, timeout, withCredentials);
                }
                return;
            }
            throw wasExpected ? new Error("No response defined !") : new Error("Unexpected request: " + method + " " + url + "\n" + (expectation ? "Expected " + expectation : "No more request expected"));
        }
        function createShortMethods(prefix) {
            angular.forEach([ "GET", "DELETE", "JSONP", "HEAD" ], function(method) {
                $httpBackend[prefix + method] = function(url, headers) {
                    return $httpBackend[prefix](method, url, undefined, headers);
                };
            }), angular.forEach([ "PUT", "POST", "PATCH" ], function(method) {
                $httpBackend[prefix + method] = function(url, data, headers) {
                    return $httpBackend[prefix](method, url, data, headers);
                };
            });
        }
        var definitions = [], expectations = [], responses = [], responsesPush = angular.bind(responses, responses.push), copy = angular.copy;
        return $httpBackend.when = function(method, url, data, headers) {
            var definition = new MockHttpExpectation(method, url, data, headers), chain = {
                respond: function(status, data, headers, statusText) {
                    return definition.passThrough = undefined, definition.response = createResponse(status, data, headers, statusText), 
                    chain;
                }
            };
            return $browser && (chain.passThrough = function() {
                return definition.response = undefined, definition.passThrough = !0, chain;
            }), definitions.push(definition), chain;
        }, createShortMethods("when"), $httpBackend.expect = function(method, url, data, headers) {
            var expectation = new MockHttpExpectation(method, url, data, headers), chain = {
                respond: function(status, data, headers, statusText) {
                    return expectation.response = createResponse(status, data, headers, statusText), 
                    chain;
                }
            };
            return expectations.push(expectation), chain;
        }, createShortMethods("expect"), $httpBackend.flush = function(count, digest) {
            if (digest !== !1 && $rootScope.$digest(), !responses.length) throw new Error("No pending request to flush !");
            if (angular.isDefined(count) && null !== count) for (;count--; ) {
                if (!responses.length) throw new Error("No more pending request to flush !");
                responses.shift()();
            } else for (;responses.length; ) responses.shift()();
            $httpBackend.verifyNoOutstandingExpectation(digest);
        }, $httpBackend.verifyNoOutstandingExpectation = function(digest) {
            if (digest !== !1 && $rootScope.$digest(), expectations.length) throw new Error("Unsatisfied requests: " + expectations.join(", "));
        }, $httpBackend.verifyNoOutstandingRequest = function() {
            if (responses.length) throw new Error("Unflushed requests: " + responses.length);
        }, $httpBackend.resetExpectations = function() {
            expectations.length = 0, responses.length = 0;
        }, $httpBackend;
    }
    function MockHttpExpectation(method, url, data, headers) {
        this.data = data, this.headers = headers, this.match = function(m, u, d, h) {
            return method != m ? !1 : this.matchUrl(u) ? angular.isDefined(d) && !this.matchData(d) ? !1 : angular.isDefined(h) && !this.matchHeaders(h) ? !1 : !0 : !1;
        }, this.matchUrl = function(u) {
            return url ? angular.isFunction(url.test) ? url.test(u) : angular.isFunction(url) ? url(u) : url == u : !0;
        }, this.matchHeaders = function(h) {
            return angular.isUndefined(headers) ? !0 : angular.isFunction(headers) ? headers(h) : angular.equals(headers, h);
        }, this.matchData = function(d) {
            return angular.isUndefined(data) ? !0 : data && angular.isFunction(data.test) ? data.test(d) : data && angular.isFunction(data) ? data(d) : data && !angular.isString(data) ? angular.equals(angular.fromJson(angular.toJson(data)), angular.fromJson(d)) : data == d;
        }, this.toString = function() {
            return method + " " + url;
        };
    }
    function MockXhr() {
        MockXhr.$$lastInstance = this, this.open = function(method, url, async) {
            this.$$method = method, this.$$url = url, this.$$async = async, this.$$reqHeaders = {}, 
            this.$$respHeaders = {};
        }, this.send = function(data) {
            this.$$data = data;
        }, this.setRequestHeader = function(key, value) {
            this.$$reqHeaders[key] = value;
        }, this.getResponseHeader = function(name) {
            var header = this.$$respHeaders[name];
            return header ? header : (name = angular.lowercase(name), (header = this.$$respHeaders[name]) ? header : (header = undefined, 
            angular.forEach(this.$$respHeaders, function(headerVal, headerName) {
                header || angular.lowercase(headerName) != name || (header = headerVal);
            }), header));
        }, this.getAllResponseHeaders = function() {
            var lines = [];
            return angular.forEach(this.$$respHeaders, function(value, key) {
                lines.push(key + ": " + value);
            }), lines.join("\n");
        }, this.abort = angular.noop;
    }
    angular.mock = {}, angular.mock.$BrowserProvider = function() {
        this.$get = function() {
            return new angular.mock.$Browser();
        };
    }, angular.mock.$Browser = function() {
        var self = this;
        this.isMock = !0, self.$$url = "http://server/", self.$$lastUrl = self.$$url, self.pollFns = [], 
        self.$$completeOutstandingRequest = angular.noop, self.$$incOutstandingRequestCount = angular.noop, 
        self.onUrlChange = function(listener) {
            return self.pollFns.push(function() {
                (self.$$lastUrl !== self.$$url || self.$$state !== self.$$lastState) && (self.$$lastUrl = self.$$url, 
                self.$$lastState = self.$$state, listener(self.$$url, self.$$state));
            }), listener;
        }, self.$$checkUrlChange = angular.noop, self.cookieHash = {}, self.lastCookieHash = {}, 
        self.deferredFns = [], self.deferredNextId = 0, self.defer = function(fn, delay) {
            return delay = delay || 0, self.deferredFns.push({
                time: self.defer.now + delay,
                fn: fn,
                id: self.deferredNextId
            }), self.deferredFns.sort(function(a, b) {
                return a.time - b.time;
            }), self.deferredNextId++;
        }, self.defer.now = 0, self.defer.cancel = function(deferId) {
            var fnIndex;
            return angular.forEach(self.deferredFns, function(fn, index) {
                fn.id === deferId && (fnIndex = index);
            }), fnIndex !== undefined ? (self.deferredFns.splice(fnIndex, 1), !0) : !1;
        }, self.defer.flush = function(delay) {
            if (angular.isDefined(delay)) self.defer.now += delay; else {
                if (!self.deferredFns.length) throw new Error("No deferred tasks to be flushed");
                self.defer.now = self.deferredFns[self.deferredFns.length - 1].time;
            }
            for (;self.deferredFns.length && self.deferredFns[0].time <= self.defer.now; ) self.deferredFns.shift().fn();
        }, self.$$baseHref = "/", self.baseHref = function() {
            return this.$$baseHref;
        };
    }, angular.mock.$Browser.prototype = {
        poll: function() {
            angular.forEach(this.pollFns, function(pollFn) {
                pollFn();
            });
        },
        addPollFn: function(pollFn) {
            return this.pollFns.push(pollFn), pollFn;
        },
        url: function(url, replace, state) {
            return angular.isUndefined(state) && (state = null), url ? (this.$$url = url, this.$$state = angular.copy(state), 
            this) : this.$$url;
        },
        state: function() {
            return this.$$state;
        },
        cookies: function(name, value) {
            return name ? void (angular.isUndefined(value) ? delete this.cookieHash[name] : angular.isString(value) && value.length <= 4096 && (this.cookieHash[name] = value)) : (angular.equals(this.cookieHash, this.lastCookieHash) || (this.lastCookieHash = angular.copy(this.cookieHash), 
            this.cookieHash = angular.copy(this.cookieHash)), this.cookieHash);
        },
        notifyWhenNoOutstandingRequests: function(fn) {
            fn();
        }
    }, angular.mock.$ExceptionHandlerProvider = function() {
        var handler;
        this.mode = function(mode) {
            switch (mode) {
              case "log":
              case "rethrow":
                var errors = [];
                handler = function(e) {
                    if (1 == arguments.length ? errors.push(e) : errors.push([].slice.call(arguments, 0)), 
                    "rethrow" === mode) throw e;
                }, handler.errors = errors;
                break;

              default:
                throw new Error("Unknown mode '" + mode + "', only 'log'/'rethrow' modes are allowed!");
            }
        }, this.$get = function() {
            return handler;
        }, this.mode("rethrow");
    }, angular.mock.$LogProvider = function() {
        function concat(array1, array2, index) {
            return array1.concat(Array.prototype.slice.call(array2, index));
        }
        var debug = !0;
        this.debugEnabled = function(flag) {
            return angular.isDefined(flag) ? (debug = flag, this) : debug;
        }, this.$get = function() {
            var $log = {
                log: function() {
                    $log.log.logs.push(concat([], arguments, 0));
                },
                warn: function() {
                    $log.warn.logs.push(concat([], arguments, 0));
                },
                info: function() {
                    $log.info.logs.push(concat([], arguments, 0));
                },
                error: function() {
                    $log.error.logs.push(concat([], arguments, 0));
                },
                debug: function() {
                    debug && $log.debug.logs.push(concat([], arguments, 0));
                }
            };
            return $log.reset = function() {
                $log.log.logs = [], $log.info.logs = [], $log.warn.logs = [], $log.error.logs = [], 
                $log.debug.logs = [];
            }, $log.assertEmpty = function() {
                var errors = [];
                if (angular.forEach([ "error", "warn", "info", "log", "debug" ], function(logLevel) {
                    angular.forEach($log[logLevel].logs, function(log) {
                        angular.forEach(log, function(logItem) {
                            errors.push("MOCK $log (" + logLevel + "): " + String(logItem) + "\n" + (logItem.stack || ""));
                        });
                    });
                }), errors.length) throw errors.unshift("Expected $log to be empty! Either a message was logged unexpectedly, or an expected log message was not checked and removed:"), 
                errors.push(""), new Error(errors.join("\n---------\n"));
            }, $log.reset(), $log;
        };
    }, angular.mock.$IntervalProvider = function() {
        this.$get = [ "$browser", "$rootScope", "$q", "$$q", function($browser, $rootScope, $q, $$q) {
            var repeatFns = [], nextRepeatId = 0, now = 0, $interval = function(fn, delay, count, invokeApply) {
                function tick() {
                    if (deferred.notify(iteration++), count > 0 && iteration >= count) {
                        var fnIndex;
                        deferred.resolve(iteration), angular.forEach(repeatFns, function(fn, index) {
                            fn.id === promise.$$intervalId && (fnIndex = index);
                        }), fnIndex !== undefined && repeatFns.splice(fnIndex, 1);
                    }
                    skipApply ? $browser.defer.flush() : $rootScope.$apply();
                }
                var iteration = 0, skipApply = angular.isDefined(invokeApply) && !invokeApply, deferred = (skipApply ? $$q : $q).defer(), promise = deferred.promise;
                return count = angular.isDefined(count) ? count : 0, promise.then(null, null, fn), 
                promise.$$intervalId = nextRepeatId, repeatFns.push({
                    nextTime: now + delay,
                    delay: delay,
                    fn: tick,
                    id: nextRepeatId,
                    deferred: deferred
                }), repeatFns.sort(function(a, b) {
                    return a.nextTime - b.nextTime;
                }), nextRepeatId++, promise;
            };
            return $interval.cancel = function(promise) {
                if (!promise) return !1;
                var fnIndex;
                return angular.forEach(repeatFns, function(fn, index) {
                    fn.id === promise.$$intervalId && (fnIndex = index);
                }), fnIndex !== undefined ? (repeatFns[fnIndex].deferred.reject("canceled"), repeatFns.splice(fnIndex, 1), 
                !0) : !1;
            }, $interval.flush = function(millis) {
                for (now += millis; repeatFns.length && repeatFns[0].nextTime <= now; ) {
                    var task = repeatFns[0];
                    task.fn(), task.nextTime += task.delay, repeatFns.sort(function(a, b) {
                        return a.nextTime - b.nextTime;
                    });
                }
                return millis;
            }, $interval;
        } ];
    };
    var R_ISO8061_STR = /^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?:\:?(\d\d)(?:\:?(\d\d)(?:\.(\d{3}))?)?)?(Z|([+-])(\d\d):?(\d\d)))?$/;
    if (angular.mock.TzDate = function(offset, timestamp) {
        var self = new Date(0);
        if (angular.isString(timestamp)) {
            var tsStr = timestamp;
            if (self.origDate = jsonStringToDate(timestamp), timestamp = self.origDate.getTime(), 
            isNaN(timestamp)) throw {
                name: "Illegal Argument",
                message: "Arg '" + tsStr + "' passed into TzDate constructor is not a valid date string"
            };
        } else self.origDate = new Date(timestamp);
        var localOffset = new Date(timestamp).getTimezoneOffset();
        self.offsetDiff = 60 * localOffset * 1e3 - 1e3 * offset * 60 * 60, self.date = new Date(timestamp + self.offsetDiff), 
        self.getTime = function() {
            return self.date.getTime() - self.offsetDiff;
        }, self.toLocaleDateString = function() {
            return self.date.toLocaleDateString();
        }, self.getFullYear = function() {
            return self.date.getFullYear();
        }, self.getMonth = function() {
            return self.date.getMonth();
        }, self.getDate = function() {
            return self.date.getDate();
        }, self.getHours = function() {
            return self.date.getHours();
        }, self.getMinutes = function() {
            return self.date.getMinutes();
        }, self.getSeconds = function() {
            return self.date.getSeconds();
        }, self.getMilliseconds = function() {
            return self.date.getMilliseconds();
        }, self.getTimezoneOffset = function() {
            return 60 * offset;
        }, self.getUTCFullYear = function() {
            return self.origDate.getUTCFullYear();
        }, self.getUTCMonth = function() {
            return self.origDate.getUTCMonth();
        }, self.getUTCDate = function() {
            return self.origDate.getUTCDate();
        }, self.getUTCHours = function() {
            return self.origDate.getUTCHours();
        }, self.getUTCMinutes = function() {
            return self.origDate.getUTCMinutes();
        }, self.getUTCSeconds = function() {
            return self.origDate.getUTCSeconds();
        }, self.getUTCMilliseconds = function() {
            return self.origDate.getUTCMilliseconds();
        }, self.getDay = function() {
            return self.date.getDay();
        }, self.toISOString && (self.toISOString = function() {
            return padNumber(self.origDate.getUTCFullYear(), 4) + "-" + padNumber(self.origDate.getUTCMonth() + 1, 2) + "-" + padNumber(self.origDate.getUTCDate(), 2) + "T" + padNumber(self.origDate.getUTCHours(), 2) + ":" + padNumber(self.origDate.getUTCMinutes(), 2) + ":" + padNumber(self.origDate.getUTCSeconds(), 2) + "." + padNumber(self.origDate.getUTCMilliseconds(), 3) + "Z";
        });
        var unimplementedMethods = [ "getUTCDay", "getYear", "setDate", "setFullYear", "setHours", "setMilliseconds", "setMinutes", "setMonth", "setSeconds", "setTime", "setUTCDate", "setUTCFullYear", "setUTCHours", "setUTCMilliseconds", "setUTCMinutes", "setUTCMonth", "setUTCSeconds", "setYear", "toDateString", "toGMTString", "toJSON", "toLocaleFormat", "toLocaleString", "toLocaleTimeString", "toSource", "toString", "toTimeString", "toUTCString", "valueOf" ];
        return angular.forEach(unimplementedMethods, function(methodName) {
            self[methodName] = function() {
                throw new Error("Method '" + methodName + "' is not implemented in the TzDate mock");
            };
        }), self;
    }, angular.mock.TzDate.prototype = Date.prototype, angular.mock.animate = angular.module("ngAnimateMock", [ "ng" ]).config([ "$provide", function($provide) {
        var reflowQueue = [];
        $provide.value("$$animateReflow", function(fn) {
            var index = reflowQueue.length;
            return reflowQueue.push(fn), function() {
                reflowQueue.splice(index, 1);
            };
        }), $provide.decorator("$animate", [ "$delegate", "$$asyncCallback", "$timeout", "$browser", function($delegate, $$asyncCallback, $timeout, $browser) {
            var animate = {
                queue: [],
                cancel: $delegate.cancel,
                enabled: $delegate.enabled,
                triggerCallbackEvents: function() {
                    $$asyncCallback.flush();
                },
                triggerCallbackPromise: function() {
                    $timeout.flush(0);
                },
                triggerCallbacks: function() {
                    this.triggerCallbackEvents(), this.triggerCallbackPromise();
                },
                triggerReflow: function() {
                    angular.forEach(reflowQueue, function(fn) {
                        fn();
                    }), reflowQueue = [];
                }
            };
            return angular.forEach([ "animate", "enter", "leave", "move", "addClass", "removeClass", "setClass" ], function(method) {
                animate[method] = function() {
                    return animate.queue.push({
                        event: method,
                        element: arguments[0],
                        options: arguments[arguments.length - 1],
                        args: arguments
                    }), $delegate[method].apply($delegate, arguments);
                };
            }), animate;
        } ]);
    } ]), angular.mock.dump = function(object) {
        function serialize(object) {
            var out;
            return angular.isElement(object) ? (object = angular.element(object), out = angular.element("<div></div>"), 
            angular.forEach(object, function(element) {
                out.append(angular.element(element).clone());
            }), out = out.html()) : angular.isArray(object) ? (out = [], angular.forEach(object, function(o) {
                out.push(serialize(o));
            }), out = "[ " + out.join(", ") + " ]") : out = angular.isObject(object) ? angular.isFunction(object.$eval) && angular.isFunction(object.$apply) ? serializeScope(object) : object instanceof Error ? object.stack || "" + object.name + ": " + object.message : angular.toJson(object, !0) : String(object), 
            out;
        }
        function serializeScope(scope, offset) {
            offset = offset || "  ";
            var log = [ offset + "Scope(" + scope.$id + "): {" ];
            for (var key in scope) Object.prototype.hasOwnProperty.call(scope, key) && !key.match(/^(\$|this)/) && log.push("  " + key + ": " + angular.toJson(scope[key]));
            for (var child = scope.$$childHead; child; ) log.push(serializeScope(child, offset + "  ")), 
            child = child.$$nextSibling;
            return log.push("}"), log.join("\n" + offset);
        }
        return serialize(object);
    }, angular.mock.$HttpBackendProvider = function() {
        this.$get = [ "$rootScope", "$timeout", createHttpBackendMock ];
    }, angular.mock.$TimeoutDecorator = [ "$delegate", "$browser", function($delegate, $browser) {
        function formatPendingTasksAsString(tasks) {
            var result = [];
            return angular.forEach(tasks, function(task) {
                result.push("{id: " + task.id + ", time: " + task.time + "}");
            }), result.join(", ");
        }
        return $delegate.flush = function(delay) {
            $browser.defer.flush(delay);
        }, $delegate.verifyNoPendingTasks = function() {
            if ($browser.deferredFns.length) throw new Error("Deferred tasks to flush (" + $browser.deferredFns.length + "): " + formatPendingTasksAsString($browser.deferredFns));
        }, $delegate;
    } ], angular.mock.$RAFDecorator = [ "$delegate", function($delegate) {
        var queue = [], rafFn = function(fn) {
            var index = queue.length;
            return queue.push(fn), function() {
                queue.splice(index, 1);
            };
        };
        return rafFn.supported = $delegate.supported, rafFn.flush = function() {
            if (0 === queue.length) throw new Error("No rAF callbacks present");
            for (var length = queue.length, i = 0; length > i; i++) queue[i]();
            queue = [];
        }, rafFn;
    } ], angular.mock.$AsyncCallbackDecorator = [ "$delegate", function($delegate) {
        var callbacks = [], addFn = function(fn) {
            callbacks.push(fn);
        };
        return addFn.flush = function() {
            angular.forEach(callbacks, function(fn) {
                fn();
            }), callbacks = [];
        }, addFn;
    } ], angular.mock.$RootElementProvider = function() {
        this.$get = function() {
            return angular.element("<div ng-app></div>");
        };
    }, angular.module("ngMock", [ "ng" ]).provider({
        $browser: angular.mock.$BrowserProvider,
        $exceptionHandler: angular.mock.$ExceptionHandlerProvider,
        $log: angular.mock.$LogProvider,
        $interval: angular.mock.$IntervalProvider,
        $httpBackend: angular.mock.$HttpBackendProvider,
        $rootElement: angular.mock.$RootElementProvider
    }).config([ "$provide", function($provide) {
        $provide.decorator("$timeout", angular.mock.$TimeoutDecorator), $provide.decorator("$$rAF", angular.mock.$RAFDecorator), 
        $provide.decorator("$$asyncCallback", angular.mock.$AsyncCallbackDecorator), $provide.decorator("$rootScope", angular.mock.$RootScopeDecorator);
    } ]), angular.module("ngMockE2E", [ "ng" ]).config([ "$provide", function($provide) {
        $provide.decorator("$httpBackend", angular.mock.e2e.$httpBackendDecorator);
    } ]), angular.mock.e2e = {}, angular.mock.e2e.$httpBackendDecorator = [ "$rootScope", "$timeout", "$delegate", "$browser", createHttpBackendMock ], 
    angular.mock.$RootScopeDecorator = [ "$delegate", function($delegate) {
        function countChildScopes() {
            for (var currentScope, count = 0, pendingChildHeads = [ this.$$childHead ]; pendingChildHeads.length; ) for (currentScope = pendingChildHeads.shift(); currentScope; ) count += 1, 
            pendingChildHeads.push(currentScope.$$childHead), currentScope = currentScope.$$nextSibling;
            return count;
        }
        function countWatchers() {
            for (var currentScope, count = this.$$watchers ? this.$$watchers.length : 0, pendingChildHeads = [ this.$$childHead ]; pendingChildHeads.length; ) for (currentScope = pendingChildHeads.shift(); currentScope; ) count += currentScope.$$watchers ? currentScope.$$watchers.length : 0, 
            pendingChildHeads.push(currentScope.$$childHead), currentScope = currentScope.$$nextSibling;
            return count;
        }
        var $rootScopePrototype = Object.getPrototypeOf($delegate);
        return $rootScopePrototype.$countChildScopes = countChildScopes, $rootScopePrototype.$countWatchers = countWatchers, 
        $delegate;
    } ], window.jasmine || window.mocha) {
        var currentSpec = null, annotatedFunctions = [], isSpecRunning = function() {
            return !!currentSpec;
        };
        angular.mock.$$annotate = angular.injector.$$annotate, angular.injector.$$annotate = function(fn) {
            return "function" != typeof fn || fn.$inject || annotatedFunctions.push(fn), angular.mock.$$annotate.apply(this, arguments);
        }, (window.beforeEach || window.setup)(function() {
            annotatedFunctions = [], currentSpec = this;
        }), (window.afterEach || window.teardown)(function() {
            var injector = currentSpec.$injector;
            annotatedFunctions.forEach(function(fn) {
                delete fn.$inject;
            }), angular.forEach(currentSpec.$modules, function(module) {
                module && module.$$hashKey && (module.$$hashKey = undefined);
            }), currentSpec.$injector = null, currentSpec.$modules = null, currentSpec = null, 
            injector && (injector.get("$rootElement").off(), injector.get("$browser").pollFns.length = 0), 
            angular.forEach(angular.element.fragments, function(val, key) {
                delete angular.element.fragments[key];
            }), MockXhr.$$lastInstance = null, angular.forEach(angular.callbacks, function(val, key) {
                delete angular.callbacks[key];
            }), angular.callbacks.counter = 0;
        }), window.module = angular.mock.module = function() {
            function workFn() {
                if (currentSpec.$injector) throw new Error("Injector already created, can not register a module!");
                var modules = currentSpec.$modules || (currentSpec.$modules = []);
                angular.forEach(moduleFns, function(module) {
                    angular.isObject(module) && !angular.isArray(module) ? modules.push(function($provide) {
                        angular.forEach(module, function(value, key) {
                            $provide.value(key, value);
                        });
                    }) : modules.push(module);
                });
            }
            var moduleFns = Array.prototype.slice.call(arguments, 0);
            return isSpecRunning() ? workFn() : workFn;
        };
        var ErrorAddingDeclarationLocationStack = function(e, errorForStack) {
            this.message = e.message, this.name = e.name, e.line && (this.line = e.line), e.sourceId && (this.sourceId = e.sourceId), 
            e.stack && errorForStack && (this.stack = e.stack + "\n" + errorForStack.stack), 
            e.stackArray && (this.stackArray = e.stackArray);
        };
        ErrorAddingDeclarationLocationStack.prototype.toString = Error.prototype.toString, 
        window.inject = angular.mock.inject = function() {
            function workFn() {
                var modules = currentSpec.$modules || [], strictDi = !!currentSpec.$injectorStrict;
                modules.unshift("ngMock"), modules.unshift("ng");
                var injector = currentSpec.$injector;
                injector || (strictDi && angular.forEach(modules, function(moduleFn) {
                    "function" == typeof moduleFn && angular.injector.$$annotate(moduleFn);
                }), injector = currentSpec.$injector = angular.injector(modules, strictDi), currentSpec.$injectorStrict = strictDi);
                for (var i = 0, ii = blockFns.length; ii > i; i++) {
                    currentSpec.$injectorStrict && injector.annotate(blockFns[i]);
                    try {
                        injector.invoke(blockFns[i] || angular.noop, this);
                    } catch (e) {
                        if (e.stack && errorForStack) throw new ErrorAddingDeclarationLocationStack(e, errorForStack);
                        throw e;
                    } finally {
                        errorForStack = null;
                    }
                }
            }
            var blockFns = Array.prototype.slice.call(arguments, 0), errorForStack = new Error("Declaration Location");
            return isSpecRunning() ? workFn.call(currentSpec) : workFn;
        }, angular.mock.inject.strictDi = function(value) {
            function workFn() {
                if (value !== currentSpec.$injectorStrict) {
                    if (currentSpec.$injector) throw new Error("Injector already created, can not modify strict annotations");
                    currentSpec.$injectorStrict = value;
                }
            }
            return value = arguments.length ? !!value : !0, isSpecRunning() ? workFn() : workFn;
        };
    }
}(window, window.angular), function(angular) {
    var Jcrop = jQuery.Jcrop;
    angular.module("ngJcrop", []).constant("ngJcroptDefaultConfig", {
        widthLimit: 1e3,
        heightLimit: 1e3,
        jcrop: {
            maxWidth: 300,
            maxHeight: 200
        }
    }).constant("ngJcropTemplate", '<div class="ng-jcrop">    <div class="ng-jcrop-image-wrapper">        <img class="ng-jcrop-image" />   </div>   <div class="ng-jcrop-thumbnail-wrapper" ng-style="previewImgStyle">       <img class="ng-jcrop-thumbnail" />   </div></div>').provider("ngJcropConfig", [ "ngJcroptDefaultConfig", "ngJcropTemplate", function(ngJcroptDefaultConfig, ngJcropTemplate) {
        var config = angular.copy(ngJcroptDefaultConfig);
        return config.template = ngJcropTemplate, {
            setConfig: function(objConfig) {
                angular.extend(config, objConfig);
            },
            setJcropConfig: function(objConfig) {
                angular.extend(config.jcrop, objConfig);
            },
            $get: function() {
                return config;
            }
        };
    } ]).run([ "$window", function($window) {
        if (!$window.jQuery) throw new Error("jQuery isn't included");
        if (!$window.jQuery.Jcrop) throw new Error("Jcrop isn't included");
    } ]).directive("ngJcrop", [ "ngJcropConfig", function(ngJcropConfig) {
        return {
            restrict: "A",
            scope: {
                ngJcrop: "=",
                thumbnail: "=",
                selection: "="
            },
            template: ngJcropConfig.template,
            controller: "JcropController"
        };
    } ]).directive("ngJcropInput", function() {
        return {
            restrict: "A",
            controller: "JcropInputController"
        };
    }).controller("JcropInputController", [ "$rootScope", "$element", "$scope", function($rootScope, $element, $scope) {
        if ("file" !== $element[0].type) throw new Error('ngJcropInput directive must be placed with an input[type="file"]');
        $scope.setImage = function(image) {
            var reader = new FileReader();
            reader.onload = function(ev) {
                $rootScope.$broadcast("JcropChangeSrc", ev.target.result), $element[0].value = "";
            }, reader.readAsDataURL(image);
        }, $element.on("change", function(ev) {
            var image = ev.currentTarget.files[0];
            $scope.setImage(image);
        });
    } ]).controller("JcropController", [ "$scope", "$element", "ngJcropConfig", "$window", function($scope, $element, ngJcropConfig, $window) {
        if (angular.isUndefined($scope.selection)) throw new Error("ngJcrop: attribute `selection` is mandatory");
        if (!angular.isArray($scope.selection) && null !== $scope.selection) throw new Error("ngJcrop: attribute `selection` must be an array");
        $scope.mainImg = null, $scope.imgStyle = {
            width: ngJcropConfig.jcrop.maxWidth,
            height: ngJcropConfig.jcrop.maxHeight
        }, $scope.previewImg = null, $scope.previewImgStyle = {
            width: "100px",
            height: "100px",
            overflow: "hidden",
            "margin-left": "5px"
        }, $scope.jcrop = null, $scope.updateCurrentSizes = function(img) {
            var widthShrinkRatio = img.width / ngJcropConfig.jcrop.maxWidth, heightShrinkRatio = img.height / ngJcropConfig.jcrop.maxHeight, widthConstraining = img.width > ngJcropConfig.jcrop.maxWidth && widthShrinkRatio > heightShrinkRatio, heightConstraining = img.height > ngJcropConfig.jcrop.maxHeight && heightShrinkRatio > widthShrinkRatio;
            widthConstraining ? ($scope.imgStyle.width = ngJcropConfig.jcrop.maxWidth, $scope.imgStyle.height = img.height / widthShrinkRatio) : heightConstraining ? ($scope.imgStyle.height = ngJcropConfig.jcrop.maxHeight, 
            $scope.imgStyle.width = img.width / heightShrinkRatio) : ($scope.imgStyle.height = img.height, 
            $scope.imgStyle.width = img.width);
        }, $scope.setSelection = function(coords) {
            angular.isArray($scope.selection) || ($scope.selection = []), $scope.selection[0] = Math.round(coords.x), 
            $scope.selection[1] = Math.round(coords.y), $scope.selection[2] = Math.round(coords.x2), 
            $scope.selection[3] = Math.round(coords.y2), $scope.selection[4] = Math.round(coords.w), 
            $scope.selection[5] = Math.round(coords.h);
        }, $scope.showPreview = function(coords) {
            if ($scope.selectionWatcher || $scope.$apply(function() {
                $scope.setSelection(coords);
            }), $scope.thumbnail) {
                var rx = 100 / coords.w, ry = 100 / coords.h;
                $scope.previewImg.css({
                    width: Math.round(rx * $scope.imgStyle.width) + "px",
                    maxWidth: Math.round(rx * $scope.imgStyle.width) + "px",
                    height: Math.round(ry * $scope.imgStyle.height) + "px",
                    maxHeight: Math.round(ry * $scope.imgStyle.height) + "px",
                    marginLeft: "-" + Math.round(rx * coords.x) + "px",
                    marginTop: "-" + Math.round(ry * coords.y) + "px"
                });
            }
        }, $scope.onMainImageLoad = function() {
            $scope.mainImg.off("load", $scope.onMainImageLoad), $scope.updateCurrentSizes(jQuery("<img>").attr("src", $scope.mainImg[0].src)[0]), 
            console.log("scope", $scope), console.log("element", $element);
            var config = angular.extend({
                onChange: $scope.showPreview,
                onSelect: $scope.showPreview,
                aspectRatio: 1
            }, ngJcropConfig.jcrop);
            $scope.selection && 6 === $scope.selection.length && (config.setSelect = $scope.selection), 
            $scope.jcrop = Jcrop($scope.mainImg, config);
        }, $scope.destroy = function() {
            $scope.jcrop && ($scope.mainImg && $scope.mainImg.off("load"), $scope.jcrop.destroy(), 
            $scope.jcrop = null);
        }, $scope.init = function(src) {
            $scope.destroy(), $scope.mainImg = jQuery("<img>").addClass("ng-jcrop-image"), $scope.mainImg.on("load", $scope.onMainImageLoad), 
            $scope.mainImg.css({
                maxWidth: ngJcropConfig.jcrop.maxWidth,
                maxHeight: ngJcropConfig.jcrop.maxHeight
            }), $scope.mainImg.attr("src", src), $element.find(".ng-jcrop-image-wrapper").empty().append($scope.mainImg);
            var thumbnailWrapper = $element.find(".ng-jcrop-thumbnail-wrapper");
            $scope.previewImg = $element.find(".ng-jcrop-thumbnail"), $scope.thumbnail ? (thumbnailWrapper.show(), 
            $scope.previewImg.attr("src", src)) : thumbnailWrapper.hide();
        }, $scope.$on("$destroy", $scope.destroy), $scope.$on("JcropChangeSrc", function(ev, src) {
            $scope.$apply(function() {
                $scope.setSelection({
                    x: 0,
                    y: 0,
                    x2: ngJcropConfig.widthLimit,
                    y2: ngJcropConfig.heightLimit,
                    w: ngJcropConfig.widthLimit,
                    h: ngJcropConfig.heightLimit
                }), $scope.ngJcrop = src;
            });
        }), $scope.$watch("ngJcrop", function(newValue, oldValue, scope) {
            scope.init(newValue);
        }), $scope.$watch("thumbnail", function(newValue, oldValue, scope) {
            var src = scope.mainImg.attr("src");
            scope.init(src);
        }), $scope.$watch("selection", function(newValue, oldValue, scope) {
            scope.jcrop && (scope.selectionWatcher = !0, angular.isArray(scope.selection) ? scope.jcrop.setSelect(scope.selection) : scope.jcrop.release(), 
            scope.selectionWatcher = !1);
        });
    } ]);
}(angular), function(angular) {
    var Jcrop = jQuery.Jcrop;
    angular.module("ngJcrop", []).constant("ngJcroptDefaultConfig", {
        widthLimit: 1e3,
        heightLimit: 1e3,
        jcrop: {
            maxWidth: 300,
            maxHeight: 200
        }
    }).constant("ngJcropTemplate", '<div class="ng-jcrop">    <div class="ng-jcrop-image-wrapper">        <img class="ng-jcrop-image" />   </div>   <div class="ng-jcrop-thumbnail-wrapper" ng-style="previewImgStyle">       <img class="ng-jcrop-thumbnail" />   </div></div>').provider("ngJcropConfig", [ "ngJcroptDefaultConfig", "ngJcropTemplate", function(ngJcroptDefaultConfig, ngJcropTemplate) {
        var config = angular.copy(ngJcroptDefaultConfig);
        return config.template = ngJcropTemplate, {
            setConfig: function(objConfig) {
                angular.extend(config, objConfig);
            },
            setJcropConfig: function(objConfig) {
                angular.extend(config.jcrop, objConfig);
            },
            $get: function() {
                return config;
            }
        };
    } ]).run([ "$window", function($window) {
        if (!$window.jQuery) throw new Error("jQuery isn't included");
        if (!$window.jQuery.Jcrop) throw new Error("Jcrop isn't included");
    } ]).directive("ngJcrop", [ "ngJcropConfig", function(ngJcropConfig) {
        return {
            restrict: "A",
            scope: {
                ngJcrop: "=",
                thumbnail: "=",
                selection: "="
            },
            template: ngJcropConfig.template,
            controller: "JcropController"
        };
    } ]).directive("ngJcropInput", function() {
        return {
            restrict: "A",
            controller: "JcropInputController"
        };
    }).controller("JcropInputController", [ "$rootScope", "$element", "$scope", function($rootScope, $element, $scope) {
        if ("file" !== $element[0].type) throw new Error('ngJcropInput directive must be placed with an input[type="file"]');
        $scope.setImage = function(image) {
            var reader = new FileReader();
            reader.onload = function(ev) {
                $rootScope.$broadcast("JcropChangeSrc", ev.target.result), $element[0].value = "";
            }, reader.readAsDataURL(image);
        }, $element.on("change", function(ev) {
            var image = ev.currentTarget.files[0];
            $scope.setImage(image);
        });
    } ]).controller("JcropController", [ "$scope", "$element", "ngJcropConfig", "$window", "$rootScope", function($scope, $element, ngJcropConfig, $window, $rootScope) {
        if (angular.isUndefined($scope.selection)) throw new Error("ngJcrop: attribute `selection` is mandatory");
        if (!angular.isArray($scope.selection) && null !== $scope.selection) throw new Error("ngJcrop: attribute `selection` must be an array");
        $scope.mainImg = null, $scope.imgStyle = {
            width: ngJcropConfig.jcrop.maxWidth,
            height: ngJcropConfig.jcrop.maxHeight
        }, $scope.previewImg = null, $scope.previewImgStyle = {
            width: "100px",
            height: "100px",
            overflow: "hidden",
            "margin-left": "5px"
        }, $scope.jcrop = null, $scope.updateCurrentSizes = function(img) {
            var widthShrinkRatio = img.width / ngJcropConfig.jcrop.maxWidth, heightShrinkRatio = img.height / ngJcropConfig.jcrop.maxHeight, widthConstraining = img.width > ngJcropConfig.jcrop.maxWidth && widthShrinkRatio > heightShrinkRatio, heightConstraining = img.height > ngJcropConfig.jcrop.maxHeight && heightShrinkRatio > widthShrinkRatio;
            widthConstraining ? ($scope.imgStyle.width = ngJcropConfig.jcrop.maxWidth, $scope.imgStyle.height = img.height / widthShrinkRatio) : heightConstraining ? ($scope.imgStyle.height = ngJcropConfig.jcrop.maxHeight, 
            $scope.imgStyle.width = img.width / heightShrinkRatio) : ($scope.imgStyle.height = img.height, 
            $scope.imgStyle.width = img.width);
        }, $scope.setSelection = function(coords) {
            angular.isArray($scope.selection) || ($scope.selection = []), $scope.selection[0] = Math.round(coords.x), 
            $scope.selection[1] = Math.round(coords.y), $scope.selection[2] = Math.round(coords.x2), 
            $scope.selection[3] = Math.round(coords.y2), $scope.selection[4] = Math.round(coords.w), 
            $scope.selection[5] = Math.round(coords.h);
        }, $scope.showPreview = function(coords) {
            if ($scope.selectionWatcher || $scope.$apply(function() {
                $scope.setSelection(coords);
            }), $scope.thumbnail) {
                var rx = 100 / coords.w, ry = 100 / coords.h;
                $scope.previewImg.css({
                    width: Math.round(rx * $scope.imgStyle.width) + "px",
                    maxWidth: Math.round(rx * $scope.imgStyle.width) + "px",
                    height: Math.round(ry * $scope.imgStyle.height) + "px",
                    maxHeight: Math.round(ry * $scope.imgStyle.height) + "px",
                    marginLeft: "-" + Math.round(rx * coords.x) + "px",
                    marginTop: "-" + Math.round(ry * coords.y) + "px"
                });
            }
        }, $scope.onMainImageLoad = function() {
            $scope.mainImg.off("load", $scope.onMainImageLoad), $scope.updateCurrentSizes(jQuery("<img>").attr("src", $scope.mainImg[0].src)[0]);
            var ratio = void 0 != $rootScope.settings[$rootScope.activeField].cropRatio && "free" != $rootScope.settings[$rootScope.activeField].cropRatio ? eval($rootScope.settings[$rootScope.activeField].cropRatio) : void 0, config = angular.extend({
                onChange: $scope.showPreview,
                onSelect: $scope.showPreview,
                aspectRatio: ratio
            }, ngJcropConfig.jcrop);
            $scope.selection && 6 === $scope.selection.length && (config.setSelect = $scope.selection), 
            $scope.jcrop = Jcrop($scope.mainImg, config);
        }, $scope.destroy = function() {
            $scope.jcrop && ($scope.mainImg && $scope.mainImg.off("load"), $scope.jcrop.destroy(), 
            $scope.jcrop = null);
        }, $scope.init = function(src) {
            $scope.destroy(), $scope.mainImg = jQuery("<img>").addClass("ng-jcrop-image"), $scope.mainImg.on("load", $scope.onMainImageLoad), 
            $scope.mainImg.css({
                maxWidth: ngJcropConfig.jcrop.maxWidth,
                maxHeight: ngJcropConfig.jcrop.maxHeight
            }), $scope.mainImg.attr("src", src), $element.find(".ng-jcrop-image-wrapper").empty().append($scope.mainImg);
            var thumbnailWrapper = $element.find(".ng-jcrop-thumbnail-wrapper");
            $scope.previewImg = $element.find(".ng-jcrop-thumbnail"), $scope.thumbnail ? (thumbnailWrapper.show(), 
            $scope.previewImg.attr("src", src)) : thumbnailWrapper.hide();
        }, $scope.$on("$destroy", $scope.destroy), $scope.$on("JcropChangeSrc", function(ev, src) {
            $scope.$apply(function() {
                $scope.setSelection({
                    x: 0,
                    y: 0,
                    x2: ngJcropConfig.widthLimit,
                    y2: ngJcropConfig.heightLimit,
                    w: ngJcropConfig.widthLimit,
                    h: ngJcropConfig.heightLimit
                }), $scope.ngJcrop = src;
            });
        }), $scope.$watch("ngJcrop", function(newValue, oldValue, scope) {
            scope.init(newValue);
        }), $scope.$watch("thumbnail", function(newValue, oldValue, scope) {
            var src = scope.mainImg.attr("src");
            scope.init(src);
        }), $scope.$watch("selection", function(newValue, oldValue, scope) {
            scope.jcrop && (scope.selectionWatcher = !0, angular.isArray(scope.selection) ? scope.jcrop.setSelect(scope.selection) : scope.jcrop.release(), 
            scope.selectionWatcher = !1);
        });
    } ]);
}(angular);