<?php
/**
 * @file
 * Animals settings form for the block configuration page.
 */

function _animals_settings_form() {
  $rows = count(_animals_explode(_animals_get('data')));
  if ($rows < 10) $rows = 10;
  $form = array(
    'animals_resetOnAjax' => array(
      '#title' => t('Reset on AJAX Load'),
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => _animals_get('resetOnAjax'),
      '#description' => t('Check this box to have the widget reset if reloaded on dynamic websites.')
      ),
    'animals_overrideCSS' => array(
      '#title' => t('Override CSS'),
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => _animals_get('overrideCSS'),
      '#description' => t('Check this box to use the colors below. Otherwise the default or theme CSS will be used.')
      ),
    'animals_transparent' => array(
      '#title' => t('Transparent Background'),
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => _animals_get('transparent'),
      '#description' => t('Draw with a transparent background. (Ignored if Override CSS is OFF.)')
      ),
    'animals_backgroundColor' => array(
      '#title' => t('Background Color'),
      '#type' => 'textfield',
      '#size' => 10,
      '#element_validate' => array('animals_color_validate'),
      '#default_value' => _animals_get('backgroundColor'),
      '#description' => t('Background color of the widget. (Ignored if Override CSS is OFF.)')
      ),
    'animals_textColor' => array(
      '#title' => t('Animal Text Color'),
      '#type' => 'textfield',
      '#size' => 10,
      '#element_validate' => array('animals_color_validate'),
      '#default_value' => _animals_get('textColor'),
      '#description' => t('Base text color. (Ignored if Override CSS is OFF.)')
      ),
    'animals_countColor' => array(
      '#title' => t('Counter Text Color'),
      '#type' => 'textfield',
      '#size' => 10,
      '#element_validate' => array('animals_color_validate'),
      '#default_value' => _animals_get('countColor'),
      '#description' => t('Counter color. (Ignored if Override CSS is OFF.)')
      ),
    'animals_includeCaption' => array(
      '#title' => t('Show Caption'),
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => _animals_get('includeCaption'),
      '#description' => t('Include the informational caption. The "Get This Counter" link cannot be hidden.')
      ),
    'animals_updateInterval' => array(
      '#title' => t('Update Interval (ms)'),
      '#type' => 'textfield',
      '#default_value' => _animals_get('updateInterval'),
      '#required' => 1,
      '#size' => 10,
      '#maxlength' => 4,
      '#element_validate' => array('animals_interval_validate'),
      '#description' => t('Milliseconds between updates. Must be 100 or greater.')
      ),
    'animals_data' => array(
      '#title' => t('Animals Data'),
      '#type' => 'textarea',
      '#rows' => $rows,
      '#cols' => 40,
      '#default_value' => _animals_get('data'),
      '#required' => 1,
      '#element_validate' => array('animals_data_validate'),
      '#description' => t('Animals data to use. Please don\'t use invalid data here!')
      ),
  );

  if (module_exists('colorpicker')) {
    $form['animals_backgroundColor']['#type'] = 'colorpicker_textfield';
    $form['animals_backgroundColor']['#colorpicker'] = 'color_picker';
    $form['animals_textColor']['#type'] = 'colorpicker_textfield';
    $form['animals_textColor']['#colorpicker'] = 'color_picker';
    $form['animals_countColor']['#type'] = 'colorpicker_textfield';
    $form['animals_countColor']['#colorpicker'] = 'color_picker';
    $form['animals_color_picker'] = array(
      '#type' => 'colorpicker',
      '#description' => t('Enter a color in RGB format.')
    );
  }

  return $form;
}

/**
 * Element Validators
 */
function animals_data_validate($element) {
  foreach (_animals_explode($element['#value']) as $animal) {
    if ($animal = trim($animal)) {
      list($k, $v) = explode('|', $animal);
      $k = trim($k); $v = 1 * trim($v);
      if (!preg_match('/^[a-z ]+$/i', $k)) {
        form_set_error($element['#name'], t('Animal names must consist of letters and spaces only.'));
        break;
      }
      if (!preg_match('/^\d{7,13}$/i', $v) || $v < 1000000) {
        form_set_error($element['#name'], t('Animal kill count values should be 1,000,000 or higher.'));
        break;
      }
    }
  }
}
function animals_interval_validate($element) {
  $v =& $element['#value'];
  if (!preg_match('/^\d+$/i', $v) || $v < 100) {
    form_set_error($element['#name'], t('!val must be a number greater than 100', array('!val' => $v)));
  }
}
function animals_color_validate($element) {
  if (!preg_match('/^#(?:(?:[a-f\d]{3}){1,2})$/i', $element['#value'])) {
    form_set_error($element['#name'], t('!val is not a valid hex color', array('!val' => $element['#value'])));
  }
}

