<?php
/**
 * @file
 * Animals block code.
 */

/**
 * _animals_get_block
 * Return the block contents
 */
function _animals_get_block() {
  $settings = array();
  foreach(_animals_get() as $k) {
    $settings[$k] = _animals_get($k);
  }

  // rework the data...
  $animals = $settings['data'];
  $data = array();
  foreach (_animals_explode($animals) as $line) {
    list($name, $rate) = explode('|', $line);
    $data[] = array(trim($name), trim($rate));
  }
  $settings['data'] = $data;

  // expose settings as Drupal.settings.animals
  drupal_add_js(array('animals' => $settings), 'setting');

  $mod = drupal_get_path('module', 'animals');
  drupal_add_css("$mod/animals.css");
  drupal_add_js("$mod/animals.js");

  if ($settings['overrideCSS']) {
    $bg = $settings['transparent'] ? 'transparent' : $settings['backgroundColor'];
    $counterRule = " style=\"color:$settings[countColor]\"";
    $divRules = " style=\"background-color:$bg;color:$settings[textColor]\"";
  }

  $x = 1;
  $divs = '';
  foreach (_animals_explode($animals) as $animal) {
    list($k, $v) = explode('|', $animal);
    $animal_bits[$k] = $v;
    $even = $x % 2 ? ' odd' : ' even';
    $divs .= <<<HTML
<div class="ak$x$even">
  <span class="counter"$counterRule></span>
  <span class="animal"></span>
</div>
HTML;
    $x++;
  }

  $out = "<div class=\"animals-killed\"$divRules>$divs</div>";
  if ($settings['includeCaption']) {
    $url1 = 'http://www.abolitionistapproach.com/media/pdf/2007-glipha-stats.pdf';
    $url2 = 'http://kids.fao.org/glipha/';
    $text1 = t('Number of animals killed in the world by the meat, dairy, and egg industries since you opened this webpage. This does not include the billions of fish and other aquatic animals killed annually.');
    $text2 = t(
      'Based on <a title="Read Global Livestock Production and Health Atlas Statistics" href="!url1">2007 statistics</a> from the Food and Agriculture Organization of the United Nations\' <a title="Visit Global Livestock Production and Health Atlas Website" href="!url2">Global Livestock Production and Health Atlas</a>.',
      array('!url1' => $url1, '!url2' => $url2)
    );
    $out .= "<p>$text1</p><p>$text2</p>";
  }
  $out .= '<p><a title="Get this counter at BeAutomated.com" href="http://www.beautomated.com/counter">Get this counter &raquo;</a></p>';

  return $out;
}
