/**
 * @file
 * Animals Killed Counter behavior for Drupal 6
 * Updated this script to be AJAX-friendly.
 */
Drupal.behaviors.animals = function(context) {
  AnimalsKilledWidget.init(context, Drupal.settings.animals);
};

var AnimalsKilledWidget = (function($){

  var $target, data, interval, akse = 0, aksy = 365.256366 * 24 * 60 * 60;

  function akInitWidget(settings) {
    data = settings.data;
    interval = settings.updateInterval;
    for (var i = 0; i < data.length; i++) {
      $target.find('.ak'+(i+1)+'>.animal').html(data[i][0]);
    }

    if (settings.resetOnAjax * 1) akse = 0;

    // start the timer only once
    if (typeof window.akCounterTimer == 'undefined') {
      akRunCounter();
    }
  }

  function akRunCounter() {
    // keep updating as long as the target exists
    if ($target.length) {
      window.akCounterTimer = setTimeout(akRunCounter, interval);
      for (var i = 0; i < data.length; i++) {
        var $span = $target.find('.ak'+(i+1)+'>.counter');
        $span.html(akAddCommas(Math.floor(data[i][1]/aksy*akse)));
      }
      akse += interval/1000.0;
    }
    else {
      window.akCounterTimer = undefined;
    }
  }

  function akAddCommas(sValue) {
    sValue = '' + sValue;
    var sRegExp = new RegExp('(-?[0-9]+)([0-9]{3})');
    while (sRegExp.test(sValue)) {
      sValue = sValue.replace(sRegExp, '$1,$2');
    }
    return sValue;
  }

  return {
    init: function(context,settings) {
      $target = $(context).find('.animals-killed:first');
      if ($target.length) {
        akInitWidget(settings);
      }
    }
  };

})(jQuery);
