/**
 * @file
 * Attaches the animated scroll to functionality.
 */

(function ($, Drupal) {

  "use strict";

  Drupal.behaviors.animatedScrollTo = {
    attach: function (context, drupalSettings) {

      // Check if the context is the initial page load and if a hash is present in the URL.
      if (context === document && window.location.hash) {

        // Define some standard default settings.
        var speed = 600;
        var pause = 3000;
        var correction = 0;
        var easing = 'swing';

        // Override the standard default settings with the user default settings.
        if (drupalSettings.animated_scroll_to && drupalSettings.animated_scroll_to.default_settings) {
          speed = drupalSettings.animated_scroll_to.default_settings.default_speed;
          pause = drupalSettings.animated_scroll_to.default_settings.default_pause;
          correction = drupalSettings.animated_scroll_to.default_settings.default_correction;
          easing = drupalSettings.animated_scroll_to.default_settings.default_easing;
        }

        // Make sure the browser starts at the top of the page.
        scroll(0,0);

        // Get the string with hashes from the URL and make an array of it.
        var hashes = window.location.hash.split('#');
        // Removes the first item from the array, because it will always be empty.
        hashes.shift();

        // Loop through the hashes, to start the animated scroll.
        hashes.forEach(function (hash, index) {

          // Create the element selector from the hash.
          var selector = '#' + hash;

          // Check if the element exists. If not, we will skip it in the animation.
          if ($(selector).length > 0) {

            // Get the position of the element from the top.
            var elementPosition = $(selector).offset().top;

            // Check if the element has an correction/offset on the top.
            var elementSpeed = ($(selector).data('scroll-speed')) ? $(selector).data('scroll-speed') : speed;
            var elementPause = ($(selector).data('scroll-pause')) ? $(selector).data('scroll-pause') : pause;
            var elementCorrection = ($(selector).data('scroll-correction')) ? $(selector).data('scroll-correction') : correction;
            var elementEasing = ($(selector).data('scroll-easing')) ? $(selector).data('scroll-easing') : easing;

            // Calculating the position to scroll to.
            var scrollToPosition = elementPosition - elementCorrection;

            // Trigger the scroll on the html/body element.
            // It's wrapped in a setTimeout function for when there are multiple elements.
            setTimeout(function () {
              $('html, body').stop().animate({
                scrollTop: scrollToPosition + 'px'
              }, elementSpeed, elementEasing);
            }, elementPause * index);
          }
        });
      }

    }
  };

})(jQuery, Drupal, drupalSettings);
