<?php

/**
 * @file
 * Contains Drupal\animated_scroll_to\Form\AnimatedScrollToForm.
 */

namespace Drupal\animated_scroll_to\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class AnimatedScrollToForm extends ConfigFormBase {

	/**
	 * {@inheritdoc}
	 */
	protected function getEditableConfigNames() {
		return [
			'animated_scroll_to.settings',
		];
	}

	/**
	 * {@inheritdoc}
	 */
	public function getFormId() {
		return 'animated_scroll_to_settings_form';
	}

	/**
	 * {@inheritdoc}
	 */
	public function buildForm(array $form, FormStateInterface $form_state) {
		$config = $this->config('animated_scroll_to.settings');

		// Create a field for the default speed in milliseconds.
		$form['default_speed'] = [
			'#type' => 'number',
			'#title' => $this->t('Default animation speed'),
			'#description' => $this->t('The default animation speed (in milliseconds) which is used if data-scroll-speed is not set on the element.'),
			'#default_value' => ($config->get('default_speed')) ? $config->get('default_speed') : 600,
		];

		// Create a field for the default pause in milliseconds.
		$form['default_pause'] = [
			'#type' => 'number',
			'#title' => $this->t('Default animation pause'),
			'#description' => $this->t('The default animation pause (in milliseconds) which is used if data-scroll-pause is not set on the element.'),
			'#default_value' => ($config->get('default_pause')) ? $config->get('default_pause') : 3000,
		];

		// Create a field for the default correction in pixels.
		$form['default_correction'] = [
			'#type' => 'number',
			'#title' => $this->t('Default scroll correction'),
			'#description' => $this->t('The default scroll correction (in pixels) which is used if data-scroll-correction is not set on the element.'),
			'#default_value' => ($config->get('default_correction')) ? $config->get('default_correction') : 0,
		];

		// Create a field for the default animation.
		$form['default_easing'] = [
			'#type' => 'select',
			'#title' => $this->t('Default animation easing'),
			'#description' => $this->t('The default animation easing which is used if data-scroll-easing is not set on the element.'),
			'#default_value' => ($config->get('default_easing')) ? $config->get('default_easing') : 'swing',
			'#options' => [
				'swing' => 'Swing',
				'linear' => 'Linear',
			],
		];

		return parent::buildForm($form, $form_state);
	}

	/**
	 * {@inheritdoc}
	 */
	public function submitForm(array &$form, FormStateInterface $form_state) {
		parent::submitForm($form, $form_state);

		// Get the clean form values (only the data of the fields in the buildForm).
		$form_values = $form_state->cleanValues()->getValues();

		// Loop through each field and set the value in the config.
		foreach ($form_values as $key => $value) {
			$this->config('animated_scroll_to.settings')
				->set($key, $form_state->getValue($key))
				->save();
		}
	}
}
