<?php

namespace Drupal\annotations\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Language\Language;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the annotation edit forms.
 *
 * @ingroup annotations
 */
class AnnotationsForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $type = NULL) {
    /* @var $entity \Drupal\annotations\Entity\Annotations */
    $form = parent::buildForm($form, $form_state);
    $entity = $this->entity;

    if(!is_null($type)) {
      $entity->setType($type);
    }

    $form['langcode'] = [
      '#title' => $this->t('Language'),
      '#type' => 'language_select',
      '#default_value' => $entity->getUntranslated()->language()->getId(),
      '#languages' => Language::STATE_ALL,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $form_state->setRedirect('entity.annotations.collection');
    $entity = $this->getEntity();
    $entity->save();
  }

}
